# bundle-pgxexample - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **bundle-pgxexample**

## Example Bundle: bundle-pgxexample

Bundle bundle-pgxexample of type transaction

-------

Entry 1 - fullUrl = http://example.org/fhir/DiagnosticReport/pgx-report

Resource DiagnosticReport:

> 

Profile: [Genomic Report](StructureDefinition-genomic-report.md)

## Genetic analysis report (Genetics ) 

| | |
| :--- | :--- |
| Subject | Anonymous Patient (no stated gender), DoB Unknown |
| When For | 2016 |
| Reported | 2018-03-06 00:00:00-0500 |
| Performer | [Organization Some lab](Organization-ExampleLab.md) |

**Report Details**

* **Code**: [Therapeutic Implication](Bundle-bundle-pgxexample.md#Observation_med-impact-pgx-example)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2018
* **Code**: [genotype display name](Bundle-bundle-pgxexample.md#Observation_genotype-pgx-example)
  * **Value**: CYP2C9 *4/*35B
  * **Flags**: Final
  * **When For**: 2018
* **Code**: [Haplotype Name](Bundle-bundle-pgxexample.md#Observation_haplotype-1-pgx-example)
  * **Value**: CYP2C9 *35B
  * **Flags**: Final
  * **When For**: 2018
* **Code**: [Haplotype Name](Bundle-bundle-pgxexample.md#Observation_haplotype-2-pgx-example)
  * **Value**: CYP2C9 *4
  * **Flags**: Final
  * **When For**: 2018
* **Code**: [Genetic variant assessment](Bundle-bundle-pgxexample.md#Observation_variant-1-pgx-example)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2018
* **Code**: [Genetic variant assessment](Bundle-bundle-pgxexample.md#Observation_variant-2-pgx-example)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2018


Request:

```
POST DiagnosticReport

```

-------

Entry 2 - fullUrl = http://example.org/fhir/Patient/ExamplePatient

Resource Patient:

> This would contain patient identifiers, demographics, etc.

Request:

```
POST Patient

```

-------

Entry 3 - fullUrl = http://example.org/fhir/Specimen/ExampleSpecimen

Resource Specimen:

> **subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)

Request:

```
POST Specimen

```

-------

Entry 4 - fullUrl = http://example.org/fhir/Organization/ExampleLab

Resource Organization:

> **name**: Some lab

Request:

```
POST Organization

```

-------

Entry 5 - fullUrl = http://example.org/fhir/ServiceRequest/pgx-request

Resource ServiceRequest:

> **status**: Active**intent**: Original Order

### Codes

| | |
| :--- | :--- |
| - | **Concept** |
| * | Genetic analysis report |

**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Worried about family planning |


Request:

```
POST ServiceRequest

```

-------

Entry 6 - fullUrl = http://example.org/fhir/Observation/med-impact-pgx-example

Resource Observation:

> 

Profile: [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)

**status**: Final**category**:Laboratory,Genetics**code**:Therapeutic Implication**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2018**issued**: 2018-03-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**derivedFrom**:[Observation genotype display name](Bundle-bundle-pgxexample.md#Observation_genotype-pgx-example)
> **component****code**:Therapeutic Implication**value**:Rapid metabolizer

> **component****code**:Medication assessed**value**:mercaptopurine

Request:

```
POST Observation

```

-------

Entry 7 - fullUrl = http://example.org/fhir/Observation/genotype-pgx-example

Resource Observation:

> 

Profile: [Genotype](StructureDefinition-genotype.md)

**status**: Final**category**:Laboratory,Genetics**code**:genotype display name**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2018**issued**: 2018-03-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**value**:CYP2C9 *4/*35B**specimen**:[Specimen](Specimen-ExampleSpecimen.md)**derivedFrom**:
* [Observation Haplotype Name](Bundle-bundle-pgxexample.md#Observation_haplotype-1-pgx-example)
* [Observation Haplotype Name](Bundle-bundle-pgxexample.md#Observation_haplotype-2-pgx-example)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied ID | CYP2C9 |


Request:

```
POST Observation

```

-------

Entry 8 - fullUrl = http://example.org/fhir/Observation/haplotype-1-pgx-example

Resource Observation:

> 

Profile: [Haplotype](StructureDefinition-haplotype.md)

**status**: Final**category**:Laboratory,Genetics**code**:Haplotype Name**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2018**issued**: 2018-03-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**value**:CYP2C9 *35B**specimen**:[Specimen](Specimen-ExampleSpecimen.md)**derivedFrom**:[Observation Genetic variant assessment](Bundle-bundle-pgxexample.md#Observation_variant-1-pgx-example)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied ID | CYP2C9 |


Request:

```
POST Observation

```

-------

Entry 9 - fullUrl = http://example.org/fhir/Observation/haplotype-2-pgx-example

Resource Observation:

> 

Profile: [Haplotype](StructureDefinition-haplotype.md)

**status**: Final**category**:Laboratory,Genetics**code**:Haplotype Name**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2018**issued**: 2018-03-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**value**:CYP2C9 *4**specimen**:[Specimen](Specimen-ExampleSpecimen.md)**derivedFrom**:[Observation Genetic variant assessment](Bundle-bundle-pgxexample.md#Observation_variant-2-pgx-example)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied ID | CYP2C9 |


Request:

```
POST Observation

```

-------

Entry 10 - fullUrl = http://example.org/fhir/Observation/variant-1-pgx-example

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2018**issued**: 2018-03-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**value**:Present**specimen**:[Specimen](Specimen-ExampleSpecimen.md)
> **component****code**:Gene studied ID**value**:CYP2C9

> **component****code**:Discrete genetic variant**value**:rs12345

> **component****code**:Ref nucleotide**value**: T

> **component****code**:Alt allele**value**: G

> **component****code**:Genomic allele start-end**value**: 55227976-55227977

Request:

```
POST Observation

```

-------

Entry 11 - fullUrl = http://example.org/fhir/Observation/variant-2-pgx-example

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2018**issued**: 2018-03-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**value**:Present**specimen**:[Specimen](Specimen-ExampleSpecimen.md)
> **component****code**:Gene studied ID**value**:CYP2C9

> **component****code**:Genomic reference sequence ID**value**:NG_007726.3

> **component****code**:Discrete genetic variant**value**:rs233455

> **component****code**:Ref nucleotide**value**: T

> **component****code**:Alt allele**value**: G

> **component****code**:Genomic allele start-end**value**: 55227978-55227979

Request:

```
POST Observation

```

-------

Entry 12 - fullUrl = http://example.org/fhir/Task/med-usage-impact-task-pgx-example

Resource Task:

> 

Profile: [Medication Recommendation](StructureDefinition-medication-recommendation.md)

**status**: Requested**intent**: Proposal**code**:Any Increase does Recommendation Text from the provider**description**: Any Increase does Recommendation Text from the provider**focus**:[MedicationStatement: status = recorded](Bundle-bundle-pgxexample.md#MedicationStatement_current-med-example)**for**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)

### Reasons

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Observation Therapeutic Implication](Bundle-bundle-pgxexample.md#Observation_med-impact-pgx-example) |


Request:

```
POST Task

```

-------

Entry 13 - fullUrl = http://example.org/fhir/MedicationStatement/current-med-example

Resource MedicationStatement:

> **status**: Recorded

### Medications

| | |
| :--- | :--- |
| - | **Concept** |
| * | mercaptopurine |

**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)

Request:

```
POST MedicationStatement

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "bundle-pgxexample",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "http://example.org/fhir/DiagnosticReport/pgx-report",
      "resource" : {
        "resourceType" : "DiagnosticReport",
        "id" : "pgx-report",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DiagnosticReport_pgx-report\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DiagnosticReport pgx-report</b></p><a name=\"pgx-report\"> </a><a name=\"hcpgx-report\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-genomic-report.html\">Genomic Report</a></p></div><h2><span title=\"Codes:{http://loinc.org 51969-4}\">Genetic analysis report</span> (<span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span>) </h2><table class=\"grid\"><tr><td>Subject</td><td>Anonymous Patient (no stated gender), DoB Unknown</td></tr><tr><td>When For</td><td>2016</td></tr><tr><td>Reported</td><td>2018-03-06 00:00:00-0500</td></tr><tr><td>Performer</td><td> <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></td></tr></table><p><b>Report Details</b></p><table class=\"grid\"><tr><td><b>Code</b></td><td><b>Value</b></td><td><b>Flags</b></td><td><b>When For</b></td></tr><tr><td><a href=\"Bundle-bundle-pgxexample.html#Observation_med-impact-pgx-example\"><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></a></td><td/><td>Final</td><td>2018</td></tr><tr><td><a href=\"Bundle-bundle-pgxexample.html#Observation_genotype-pgx-example\"><span title=\"Codes:{http://loinc.org 84413-4}\">genotype display name</span></a></td><td><span title=\"Codes:{http://www.pharmvar.org CYP2C9}\">CYP2C9 *4/*35B</span></td><td>Final</td><td>2018</td></tr><tr><td><a href=\"Bundle-bundle-pgxexample.html#Observation_haplotype-1-pgx-example\"><span title=\"Codes:{http://loinc.org 84414-2}\">Haplotype Name</span></a></td><td><span title=\"Codes:{http://www.pharmvar.org CYP2C9}\">CYP2C9 *35B</span></td><td>Final</td><td>2018</td></tr><tr><td><a href=\"Bundle-bundle-pgxexample.html#Observation_haplotype-2-pgx-example\"><span title=\"Codes:{http://loinc.org 84414-2}\">Haplotype Name</span></a></td><td><span title=\"Codes:{http://www.pharmvar.org CYP2C9}\">CYP2C9 *4</span></td><td>Final</td><td>2018</td></tr><tr><td><a href=\"Bundle-bundle-pgxexample.html#Observation_variant-1-pgx-example\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2018</td></tr><tr><td><a href=\"Bundle-bundle-pgxexample.html#Observation_variant-2-pgx-example\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2018</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/recommended-action",
            "valueReference" : {
              "reference" : "Task/med-usage-impact-task-pgx-example"
            }
          }
        ],
        "basedOn" : [
          {
            "reference" : "ServiceRequest/pgx-request"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "51969-4"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2016",
        "issued" : "2018-03-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "result" : [
          {
            "reference" : "Observation/med-impact-pgx-example",
            "display" : "genetics impact for medication metabolism accessment"
          },
          {
            "reference" : "Observation/genotype-pgx-example"
          },
          {
            "reference" : "Observation/haplotype-1-pgx-example"
          },
          {
            "reference" : "Observation/haplotype-2-pgx-example"
          },
          {
            "reference" : "Observation/variant-1-pgx-example"
          },
          {
            "reference" : "Observation/variant-2-pgx-example"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "DiagnosticReport"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Patient/ExamplePatient",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "ExamplePatient",
        "text" : {
          "status" : "additional",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_ExamplePatient\"> </a>This would contain patient identifiers, demographics, etc.</div>"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Patient"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Specimen/ExampleSpecimen",
      "resource" : {
        "resourceType" : "Specimen",
        "id" : "ExampleSpecimen",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Specimen_ExampleSpecimen\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Specimen ExampleSpecimen</b></p><a name=\"ExampleSpecimen\"> </a><a name=\"hcExampleSpecimen\"> </a><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p></div>"
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Specimen"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Organization/ExampleLab",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "ExampleLab",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_ExampleLab\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization ExampleLab</b></p><a name=\"ExampleLab\"> </a><a name=\"hcExampleLab\"> </a><p><b>name</b>: Some lab</p></div>"
        },
        "name" : "Some lab"
      },
      "request" : {
        "method" : "POST",
        "url" : "Organization"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/ServiceRequest/pgx-request",
      "resource" : {
        "resourceType" : "ServiceRequest",
        "id" : "pgx-request",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ServiceRequest_pgx-request\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ServiceRequest pgx-request</b></p><a name=\"pgx-request\"> </a><a name=\"hcpgx-request\"> </a><p><b>status</b>: Active</p><p><b>intent</b>: Original Order</p><h3>Codes</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 51969-4}\">Genetic analysis report</span></td></tr></table><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><h3>Reasons</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:\">Worried about family planning</span></td></tr></table></div>"
        },
        "status" : "active",
        "intent" : "original-order",
        "code" : {
          "concept" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "51969-4"
              }
            ]
          }
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "reason" : [
          {
            "concept" : {
              "text" : "Worried about family planning"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "ServiceRequest"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/med-impact-pgx-example",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "med-impact-pgx-example",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_med-impact-pgx-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation med-impact-pgx-example</b></p><a name=\"med-impact-pgx-example\"> </a><a name=\"hcmed-impact-pgx-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-therapeutic-implication.html\">Therapeutic Implication</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2018</p><p><b>issued</b>: 2018-03-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-bundle-pgxexample.html#Observation_genotype-pgx-example\">Observation genotype display name</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA25390-8}\">Rapid metabolizer</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51963-7}\">Medication assessed</span></p><p><b>value</b>: <span title=\"Codes:{http://www.nlm.nih.gov/research/umls/rxnorm 103}\">mercaptopurine</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "therapeutic-implication",
              "display" : "Therapeutic Implication"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2018",
        "issued" : "2018-03-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "derivedFrom" : [
          {
            "reference" : "Observation/genotype-pgx-example"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "therapeutic-implication"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA25390-8",
                  "display" : "Rapid metabolizer"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51963-7",
                  "display" : "Medication assessed"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
                  "code" : "103",
                  "display" : "mercaptopurine"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/genotype-pgx-example",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "genotype-pgx-example",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_genotype-pgx-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation genotype-pgx-example</b></p><a name=\"genotype-pgx-example\"> </a><a name=\"hcgenotype-pgx-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-genotype.html\">Genotype</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84413-4}\">genotype display name</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2018</p><p><b>issued</b>: 2018-03-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>value</b>: <span title=\"Codes:{http://www.pharmvar.org CYP2C9}\">CYP2C9 *4/*35B</span></p><p><b>specimen</b>: <a href=\"Specimen-ExampleSpecimen.html\">Specimen</a></p><p><b>derivedFrom</b>: </p><ul><li><a href=\"Bundle-bundle-pgxexample.html#Observation_haplotype-1-pgx-example\">Observation Haplotype Name</a></li><li><a href=\"Bundle-bundle-pgxexample.html#Observation_haplotype-2-pgx-example\">Observation Haplotype Name</a></li></ul><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied ID</span></td><td><span title=\"Codes:{http://www.genenames.org HGNC:2623}\">CYP2C9</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84413-4",
              "display" : "genotype display name"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2018",
        "issued" : "2018-03-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.pharmvar.org",
              "code" : "CYP2C9",
              "display" : "CYP2C9 *4/*35B"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/ExampleSpecimen"
        },
        "derivedFrom" : [
          {
            "reference" : "Observation/haplotype-1-pgx-example"
          },
          {
            "reference" : "Observation/haplotype-2-pgx-example"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied ID"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:2623",
                  "display" : "CYP2C9"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/haplotype-1-pgx-example",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "haplotype-1-pgx-example",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_haplotype-1-pgx-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation haplotype-1-pgx-example</b></p><a name=\"haplotype-1-pgx-example\"> </a><a name=\"hchaplotype-1-pgx-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-haplotype.html\">Haplotype</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84414-2}\">Haplotype Name</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2018</p><p><b>issued</b>: 2018-03-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>value</b>: <span title=\"Codes:{http://www.pharmvar.org CYP2C9}\">CYP2C9 *35B</span></p><p><b>specimen</b>: <a href=\"Specimen-ExampleSpecimen.html\">Specimen</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-bundle-pgxexample.html#Observation_variant-1-pgx-example\">Observation Genetic variant assessment</a></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied ID</span></td><td><span title=\"Codes:{http://www.genenames.org HGNC:2623}\">CYP2C9</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84414-2",
              "display" : "Haplotype Name"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2018",
        "issued" : "2018-03-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.pharmvar.org",
              "code" : "CYP2C9",
              "display" : "CYP2C9 *35B"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/ExampleSpecimen"
        },
        "derivedFrom" : [
          {
            "reference" : "Observation/variant-1-pgx-example"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied ID"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:2623",
                  "display" : "CYP2C9"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/haplotype-2-pgx-example",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "haplotype-2-pgx-example",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_haplotype-2-pgx-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation haplotype-2-pgx-example</b></p><a name=\"haplotype-2-pgx-example\"> </a><a name=\"hchaplotype-2-pgx-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-haplotype.html\">Haplotype</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84414-2}\">Haplotype Name</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2018</p><p><b>issued</b>: 2018-03-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>value</b>: <span title=\"Codes:{http://www.pharmvar.org CYP2C9}\">CYP2C9 *4</span></p><p><b>specimen</b>: <a href=\"Specimen-ExampleSpecimen.html\">Specimen</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-bundle-pgxexample.html#Observation_variant-2-pgx-example\">Observation Genetic variant assessment</a></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied ID</span></td><td><span title=\"Codes:{http://www.genenames.org HGNC:2623}\">CYP2C9</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84414-2",
              "display" : "Haplotype Name"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2018",
        "issued" : "2018-03-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.pharmvar.org",
              "code" : "CYP2C9",
              "display" : "CYP2C9 *4"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/ExampleSpecimen"
        },
        "derivedFrom" : [
          {
            "reference" : "Observation/variant-2-pgx-example"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied ID"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:2623",
                  "display" : "CYP2C9"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/variant-1-pgx-example",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "variant-1-pgx-example",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_variant-1-pgx-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation variant-1-pgx-example</b></p><a name=\"variant-1-pgx-example\"> </a><a name=\"hcvariant-1-pgx-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2018</p><p><b>issued</b>: 2018-03-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>specimen</b>: <a href=\"Specimen-ExampleSpecimen.html\">Specimen</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied ID</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:2623}\">CYP2C9</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81252-9}\">Discrete genetic variant</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/projects/SNP rs12345}\">rs12345</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Ref nucleotide</span></p><p><b>value</b>: T</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69551-0}\">Alt allele</span></p><p><b>value</b>: G</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81254-5}\">Genomic allele start-end</span></p><p><b>value</b>: 55227976-55227977</p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2018",
        "issued" : "2018-03-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/ExampleSpecimen"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied ID"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:2623",
                  "display" : "CYP2C9"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81252-9"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/projects/SNP",
                  "code" : "rs12345"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Ref nucleotide"
                }
              ]
            },
            "valueString" : "T"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69551-0",
                  "display" : "Alt allele"
                }
              ]
            },
            "valueString" : "G"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81254-5"
                }
              ]
            },
            "valueRange" : {
              "low" : {
                "value" : 55227976
              },
              "high" : {
                "value" : 55227977
              }
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/variant-2-pgx-example",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "variant-2-pgx-example",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_variant-2-pgx-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation variant-2-pgx-example</b></p><a name=\"variant-2-pgx-example\"> </a><a name=\"hcvariant-2-pgx-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2018</p><p><b>issued</b>: 2018-03-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>specimen</b>: <a href=\"Specimen-ExampleSpecimen.html\">Specimen</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied ID</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:2623}\">CYP2C9</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48013-7}\">Genomic reference sequence ID</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NG_007726.3}\">NG_007726.3</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81252-9}\">Discrete genetic variant</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/projects/SNP rs233455}\">rs233455</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Ref nucleotide</span></p><p><b>value</b>: T</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69551-0}\">Alt allele</span></p><p><b>value</b>: G</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81254-5}\">Genomic allele start-end</span></p><p><b>value</b>: 55227978-55227979</p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2018",
        "issued" : "2018-03-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/ExampleSpecimen"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied ID"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:2623",
                  "display" : "CYP2C9"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48013-7",
                  "display" : "Genomic reference sequence ID"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NG_007726.3"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81252-9"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/projects/SNP",
                  "code" : "rs233455"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Ref nucleotide"
                }
              ]
            },
            "valueString" : "T"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69551-0",
                  "display" : "Alt allele"
                }
              ]
            },
            "valueString" : "G"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81254-5"
                }
              ]
            },
            "valueRange" : {
              "low" : {
                "value" : 55227978
              },
              "high" : {
                "value" : 55227979
              }
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Task/med-usage-impact-task-pgx-example",
      "resource" : {
        "resourceType" : "Task",
        "id" : "med-usage-impact-task-pgx-example",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/medication-recommendation"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Task_med-usage-impact-task-pgx-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Task med-usage-impact-task-pgx-example</b></p><a name=\"med-usage-impact-task-pgx-example\"> </a><a name=\"hcmed-usage-impact-task-pgx-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-medication-recommendation.html\">Medication Recommendation</a></p></div><p><b>status</b>: Requested</p><p><b>intent</b>: proposal</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org LA26423-6}\">Any Increase does Recommendation Text from the provider</span></p><p><b>description</b>: </p><div><p>Any Increase does Recommendation Text from the provider</p>\n</div><p><b>focus</b>: <a href=\"Bundle-bundle-pgxexample.html#MedicationStatement_current-med-example\">MedicationStatement: status = recorded</a></p><p><b>for</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><h3>Reasons</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Reference</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Bundle-bundle-pgxexample.html#Observation_med-impact-pgx-example\">Observation Therapeutic Implication</a></td></tr></table></div>"
        },
        "status" : "requested",
        "intent" : "proposal",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26423-6",
              "display" : "Increase dose"
            }
          ],
          "text" : "Any Increase does Recommendation Text from the provider"
        },
        "description" : "Any Increase does Recommendation Text from the provider",
        "focus" : {
          "reference" : "MedicationStatement/current-med-example"
        },
        "for" : {
          "reference" : "Patient/ExamplePatient"
        },
        "reason" : [
          {
            "reference" : {
              "reference" : "Observation/med-impact-pgx-example"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Task"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/MedicationStatement/current-med-example",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "current-med-example",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_current-med-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement current-med-example</b></p><a name=\"current-med-example\"> </a><a name=\"hccurrent-med-example\"> </a><p><b>status</b>: Recorded</p><h3>Medications</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://www.nlm.nih.gov/research/umls/rxnorm 103}\">mercaptopurine</span></td></tr></table><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p></div>"
        },
        "status" : "recorded",
        "medication" : {
          "concept" : {
            "coding" : [
              {
                "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
                "code" : "103",
                "display" : "mercaptopurine"
              }
            ]
          }
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "MedicationStatement"
      }
    }
  ]
}

```
