# bundle-oncologyexamples-r4-withGrouping - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **bundle-oncologyexamples-r4-withGrouping**

## Example Bundle: bundle-oncologyexamples-r4-withGrouping

Bundle bundle-oncologyexamples-r4-withGrouping of type transaction

-------

Entry 1 - fullUrl = urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d

Resource Patient:

> Carrot John Mr Male, DoB: 1962-12-31 ( 1007)
-------

Request:

```
POST Patient

```

-------

Entry 2 - fullUrl = urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef

Resource Practitioner:

> **identifier**: 4654765876**name**: Akerman Philip Prof**address**: Castro Valley CA

Request:

```
POST Practitioner

```

-------

Entry 3 - fullUrl = urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d

Resource Specimen:

> **identifier**: 076e1948-2217-11e9-94d8-12e241dc1f66**status**: Available**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)

### Collections

| | |
| :--- | :--- |
| - | **Collector** |
| * | [Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef) |


Request:

```
POST Specimen

```

-------

Entry 4 - fullUrl = urn:uuid:40e85eda-4d31-4bd2-a5a0-c39d63f9824f

Resource Observation:

> 

Profile: [Molecular Biomarker](StructureDefinition-molecular-biomarker.md)

**status**: Final**category**:Laboratory,Biomarker Category,Genetics**code**:Mutations/Megabase [# Ratio] in Tumor**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)**effective**: 2023-05-01**performer**:[Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef)**value**: 25 somatic variants per megabase of sequenced DNA(Details: UCUM code1/1000000 = '1/1000000')**specimen**:[Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Biomarker Category | molecular sequence adjacent category |


Request:

```
POST Observation

```

-------

Entry 5 - fullUrl = urn:uuid:64b91716-6431-41bd-8fd4-7ac99bebdee9

Resource Observation:

> 

Profile: [Molecular Biomarker](StructureDefinition-molecular-biomarker.md)

**status**: Final**category**:Laboratory,Biomarker Category,Genetics**code**:Microsatellite instability [Interpretation] in Cancer specimen Qualitative**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)**effective**: 2023-05-01**performer**:[Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef)**value**:Stable**specimen**:[Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Biomarker Category | molecular sequence adjacent category |


Request:

```
POST Observation

```

-------

Entry 6 - fullUrl = urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12d

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)**effective**: 2023-05-01**performer**:[Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef)**value**:Present**method**:Sequencing**specimen**:[Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d)
> **component****code**:Genomic DNA change (gHGVS)**value**:NC_000009.12:g.5073770G>T

> **component****code**:Amino acid change (pHGVS)**value**:NP_004963.1:p.Val617Phe

> **component****code**:Genomic source class**value**:Germline

> **component****code**:Gene studied ID**value**:JAK2

Request:

```
POST Observation

```

-------

Entry 7 - fullUrl = urn:uuid:772de7d7-e1bd-4183-bdb5-cea8eda317cd

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)**effective**: 2023-05-01**performer**:[Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef)**value**:Present**method**:Sequencing**specimen**:[Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d)
> **component****code**:Genomic DNA change (gHGVS)**value**:NC_000004.11:g.55972974T>A

> **component****code**:Amino acid change (pHGVS)**value**:NP_002244.1:p.Gln472His

> **component****code**:Genomic source class**value**:Germline

> **component****code**:Gene studied ID**value**:KDR

Request:

```
POST Observation

```

-------

Entry 8 - fullUrl = urn:uuid:b33eb7ec-d83e-49d2-b0f3-729d024ebe01

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)**effective**: 2023-05-01**performer**:[Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef)**value**:Present**method**:Sequencing**specimen**:[Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d)
> **component****code**:Genomic DNA change (gHGVS)**value**:NC_000002.12:g.211713666_211713668del

> **component****code**:Genomic source class**value**:Germline

> **component****code**:Gene studied ID**value**:ERBB4

Request:

```
POST Observation

```

-------

Entry 9 - fullUrl = urn:uuid:1bf9642d-fd1c-4819-8c5d-44fae4bad524

Resource Observation:

> 

Profile: [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)

**status**: Final**category**:Laboratory,Genetics**code**:Therapeutic Implication**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)**effective**: 2023-05-01**performer**:[Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef)**method**:Computational analysis**specimen**:[Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d)**derivedFrom**:[Observation Genetic variant assessment](Bundle-bundle-complexVariant-nonHGVS.md#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d)
> **component****code**:Therapeutic Implication**value**:Responsive

> **component****code**:Level of evidence**value**:Very strong evidence pathogenic

> **component****code**:Associated phenotype**value**:Polycythemia vera (PV)

> **component****Medication Assessed reference to a FHIR resource**:[MedicationKnowledge Ruxolitinib](#hcbundle-oncologyexamples-r4-withGrouping/Inline-Instance-for-oncologyexamples-r4-withGrouping-9/Inline-MedicationKnowledgeRuxolitinib)**code**:Medication assessed [ID]**value**:Ruxolitinib

-------

> **code**:Ruxolitinib**status**: Active

Request:

```
POST Observation

```

-------

Entry 10 - fullUrl = urn:uuid:1301943b-55db-4adf-8355-3635f7268a1b

Resource Observation:

> 

Profile: [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)

**status**: Final**category**:Laboratory,Genetics**code**:Therapeutic Implication**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)**effective**: 2023-05-01**performer**:[Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef)**method**:Computational analysis**specimen**:[Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d)**derivedFrom**:[Observation Genetic variant assessment](Bundle-bundle-complexVariant-nonHGVS.md#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d)
> **component****code**:Therapeutic Implication**value**:Responsive

> **component****code**:Level of Evidence**value**:Very strong evidence pathogenic

> **component****code**:Associated phenotype**value**:Polycythemia vera (PV)

> **component****code**:Medication assessed**value**:AT9283

Request:

```
POST Observation

```

-------

Entry 11 - fullUrl = urn:uuid:05713d1c-0df5-46d5-a5a9-2085eef56c20

Resource Observation:

> 

Profile: [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)

**status**: Final**category**:Laboratory,Genetics**code**:Therapeutic Implication**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)**effective**: 2023-05-01**performer**:[Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef)**method**:Computational analysis**specimen**:[Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d)**derivedFrom**:[Observation Genetic variant assessment](Bundle-bundle-complexVariant-nonHGVS.md#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d)
> **component****code**:Therapeutic Implication**value**:Responsive

> **component****code**:Level of Evidence**value**:Very strong evidence pathogenic

> **component****code**:Associated phenotype**value**:Polycythemia vera (PV)

> **component****code**:Medication assessed**value**:SNX-5422

Request:

```
POST Observation

```

-------

Entry 12 - fullUrl = urn:uuid:294f1401-e2eb-4df1-b6d2-09e1b7a6eca4

Resource Observation:

> 

Profile: [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)

**status**: Final**category**:Laboratory,Genetics**code**:Therapeutic Implication**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)**effective**: 2023-05-01**performer**:[Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef)**method**:Computational analysis**specimen**:[Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d)**derivedFrom**:[Observation Genetic variant assessment](Bundle-bundle-complexVariant-nonHGVS.md#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d)
> **component****code**:Therapeutic Implication**value**:Responsive

> **component****code**:Level of Evidence**value**:Very strong evidence pathogenic

> **component****code**:Associated phenotype**value**:Polycythemia vera (PV)

> **component****code**:Medication assessed**value**:TG02

Request:

```
POST Observation

```

-------

Entry 13 - fullUrl = urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12f

Resource Observation:

> **status**: Final**category**:Laboratory,Genetics**code**:Group**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)**effective**: 2023-05-01**performer**:[Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef)**hasMember**:
* [SNV analysis for JAK2 variant](Bundle-bundle-complexVariant-nonHGVS.md#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d)
* [SNV analysis for KDR variant](Bundle-bundle-oncologyexamples-r4-withGrouping.md#urn-uuid-772de7d7-e1bd-4183-bdb5-cea8eda317cd)
* [SNV analysis for ERBB4 variant](Bundle-bundle-oncologyexamples-r4-withGrouping.md#urn-uuid-b33eb7ec-d83e-49d2-b0f3-729d024ebe01)
* [TMB value analysis](Bundle-bundle-oncology-diagnostic.md#urn-uuid-40e85eda-4d31-4bd2-a5a0-c39d63f9824f)
* [MSI status analysis](Bundle-bundle-oncologyexamples-r4-withGrouping.md#urn-uuid-64b91716-6431-41bd-8fd4-7ac99bebdee9)

Request:

```
POST Observation

```

-------

Entry 14 - fullUrl = urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12e

Resource Observation:

> **status**: Final**category**:Laboratory,Genetics**code**:Group**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)**effective**: 2023-05-01**performer**:[Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef)**hasMember**:
* [Therapy match result 1](Bundle-bundle-oncology-diagnostic.md#urn-uuid-1bf9642d-fd1c-4819-8c5d-44fae4bad524)
* [Therapy match result 2](Bundle-bundle-oncologyexamples-r4-withGrouping.md#urn-uuid-1301943b-55db-4adf-8355-3635f7268a1b)
* [Therapy match result 3](Bundle-bundle-oncologyexamples-r4-withGrouping.md#urn-uuid-05713d1c-0df5-46d5-a5a9-2085eef56c20)
* [Therapy match result 4](Bundle-bundle-oncologyexamples-r4-withGrouping.md#urn-uuid-294f1401-e2eb-4df1-b6d2-09e1b7a6eca4)

Request:

```
POST Observation

```

-------

Entry 15 - fullUrl = urn:uuid:ad7a499b-a43b-4cc8-bf46-cac62d9ecae5

Resource DiagnosticReport:

> 

Profile: [Genomic Report](StructureDefinition-genomic-report.md)

## Genetic analysis report (Genetics ) 

| | |
| :--- | :--- |
| Subject | Carrot John Mr Male, DoB: 1962-12-31 ( 1007) |
| Performer | [Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef) |

**Report Details**

* **Code**: [Group](Bundle-bundle-oncologyexamples-r4-withGrouping.md#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12f)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2023-05-01
  * **Reported**: 
* **Code**: [Genetic variant assessment](Bundle-bundle-complexVariant-nonHGVS.md#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2019-03-05
  * **Reported**: 2019-03-05 16:04:44+0000
* **Code**: [Genetic variant assessment](Bundle-bundle-oncologyexamples-r4-withGrouping.md#urn-uuid-772de7d7-e1bd-4183-bdb5-cea8eda317cd)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2023-05-01
  * **Reported**: 
* **Code**: [Genetic variant assessment](Bundle-bundle-oncologyexamples-r4-withGrouping.md#urn-uuid-b33eb7ec-d83e-49d2-b0f3-729d024ebe01)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2023-05-01
  * **Reported**: 
* **Code**: [Mutations/Megabase [# Ratio] in Tumor](Bundle-bundle-oncology-diagnostic.md#urn-uuid-40e85eda-4d31-4bd2-a5a0-c39d63f9824f)
  * **Value**: 25 Mutations/Megabase(Details: UCUM code1/1000000 = '1/1000000')
  * **Flags**: Final
  * **When For**: 2019-03-05
  * **Reported**: 
* **Code**: [Microsatellite instability [Interpretation] in Cancer specimen Qualitative](Bundle-bundle-oncologyexamples-r4-withGrouping.md#urn-uuid-64b91716-6431-41bd-8fd4-7ac99bebdee9)
  * **Value**: Stable
  * **Flags**: Final
  * **When For**: 2023-05-01
  * **Reported**: 
* **Code**: [Genetic variant assessment](Bundle-bundle-complexVariant-nonHGVS.md#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12e)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2019-03-05
  * **Reported**: 2019-03-05 16:04:44+0000
* **Code**: [Diagnostic Implication](Bundle-bundle-oncology-diagnostic.md#urn-uuid-1bf9642d-fd1c-4819-8c5d-44fae4bad524)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2019-03-05
  * **Reported**: 
* **Code**: [Therapeutic Implication](Bundle-bundle-oncologyexamples-r4-withGrouping.md#urn-uuid-1301943b-55db-4adf-8355-3635f7268a1b)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2023-05-01
  * **Reported**: 
* **Code**: [Therapeutic Implication](Bundle-bundle-oncologyexamples-r4-withGrouping.md#urn-uuid-05713d1c-0df5-46d5-a5a9-2085eef56c20)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2023-05-01
  * **Reported**: 
* **Code**: [Therapeutic Implication](Bundle-bundle-oncologyexamples-r4-withGrouping.md#urn-uuid-294f1401-e2eb-4df1-b6d2-09e1b7a6eca4)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2023-05-01
  * **Reported**: 


Request:

```
POST DiagnosticReport

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "bundle-oncologyexamples-r4-withGrouping",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "Inline-Instance-for-oncologyexamples-r4-withGrouping-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_Inline-Instance-for-oncologyexamples-r4-withGrouping-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient Inline-Instance-for-oncologyexamples-r4-withGrouping-1</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-1\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-1\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Patient Links\">Links:</td><td colspan=\"3\"><ul><li>General Practitioner: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></li></ul></td></tr></table></div>"
        },
        "identifier" : [
          {
            "value" : "1007"
          }
        ],
        "name" : [
          {
            "given" : ["Carrot", "John", "Mr"]
          }
        ],
        "gender" : "male",
        "birthDate" : "1962-12-31",
        "generalPractitioner" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Patient"
      }
    },
    {
      "fullUrl" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "Inline-Instance-for-oncologyexamples-r4-withGrouping-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_Inline-Instance-for-oncologyexamples-r4-withGrouping-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner Inline-Instance-for-oncologyexamples-r4-withGrouping-2</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-2\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-2\"> </a><p><b>identifier</b>: 4654765876</p><p><b>name</b>: Akerman Philip Prof </p><p><b>address</b>: Castro Valley CA </p></div>"
        },
        "identifier" : [
          {
            "value" : "4654765876"
          }
        ],
        "name" : [
          {
            "given" : ["Akerman", "Philip", "Prof"]
          }
        ],
        "address" : [
          {
            "city" : "Castro Valley",
            "state" : "CA"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Practitioner"
      }
    },
    {
      "fullUrl" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d",
      "resource" : {
        "resourceType" : "Specimen",
        "id" : "Inline-Instance-for-oncologyexamples-r4-withGrouping-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Specimen_Inline-Instance-for-oncologyexamples-r4-withGrouping-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Specimen Inline-Instance-for-oncologyexamples-r4-withGrouping-3</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-3\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-3\"> </a><p><b>identifier</b>: 076e1948-2217-11e9-94d8-12e241dc1f66</p><p><b>status</b>: Available</p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><h3>Collections</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Collector</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></td></tr></table></div>"
        },
        "identifier" : [
          {
            "value" : "076e1948-2217-11e9-94d8-12e241dc1f66"
          }
        ],
        "status" : "available",
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "collection" : {
          "collector" : {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Specimen"
      }
    },
    {
      "fullUrl" : "urn:uuid:40e85eda-4d31-4bd2-a5a0-c39d63f9824f",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncologyexamples-r4-withGrouping-4",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-biomarker"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncologyexamples-r4-withGrouping-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncologyexamples-r4-withGrouping-4</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-4\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-4\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-molecular-biomarker.html\">Molecular Biomarker</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs biomarker-category}\">Biomarker Category</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 94076-7}\">Mutations/Megabase [# Ratio] in Tumor</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><p><b>effective</b>: 2023-05-01</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></p><p><b>value</b>: 25 somatic variants per megabase of sequenced DNA<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1/1000000 = '1/1000000')</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d\">Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available</a></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs biomarker-category}\">Biomarker Category</span></td><td><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/molecular-biomarker-ontology-cs molgen}\">molecular sequence adjacent category</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                "code" : "biomarker-category"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "94076-7",
              "display" : "Mutations/Megabase [# Ratio] in Tumor"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "effectiveDateTime" : "2023-05-01",
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "valueQuantity" : {
          "value" : 25,
          "unit" : "somatic variants per megabase of sequenced DNA",
          "system" : "http://unitsofmeasure.org",
          "code" : "1/1000000"
        },
        "specimen" : {
          "reference" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "biomarker-category"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/molecular-biomarker-ontology-cs",
                  "code" : "molgen",
                  "display" : "molecular sequence adjacent category"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:64b91716-6431-41bd-8fd4-7ac99bebdee9",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncologyexamples-r4-withGrouping-5",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-biomarker"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncologyexamples-r4-withGrouping-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncologyexamples-r4-withGrouping-5</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-5\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-5\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-molecular-biomarker.html\">Molecular Biomarker</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs biomarker-category}\">Biomarker Category</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81695-9}\">Microsatellite instability [Interpretation] in Cancer specimen Qualitative</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><p><b>effective</b>: 2023-05-01</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14122-8}\">Stable</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d\">Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available</a></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs biomarker-category}\">Biomarker Category</span></td><td><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/molecular-biomarker-ontology-cs molgen}\">molecular sequence adjacent category</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                "code" : "biomarker-category"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "81695-9",
              "display" : "Microsatellite instability [Interpretation] in Cancer specimen Qualitative"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "effectiveDateTime" : "2023-05-01",
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA14122-8",
              "display" : "Stable"
            }
          ]
        },
        "specimen" : {
          "reference" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "biomarker-category"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/molecular-biomarker-ontology-cs",
                  "code" : "molgen",
                  "display" : "molecular sequence adjacent category"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12d",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncologyexamples-r4-withGrouping-6",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncologyexamples-r4-withGrouping-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncologyexamples-r4-withGrouping-6</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-6\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-6\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><p><b>effective</b>: 2023-05-01</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d\">Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81290-9}\">Genomic DNA change (gHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NC_000009.12:g.5073770G&gt;T}\">NC_000009.12:g.5073770G&gt;T</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48005-3}\">Amino acid change (pHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NP_004963.1:p.Val617Phe}\">NP_004963.1:p.Val617Phe</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6683-2}\">Germline</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied ID</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org JAK2}\">JAK2</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "effectiveDateTime" : "2023-05-01",
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "reference" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81290-9",
                  "display" : "Genomic DNA change (gHGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NC_000009.12:g.5073770G>T",
                  "display" : "NC_000009.12:g.5073770G>T"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48005-3",
                  "display" : "Amino acid change (pHGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NP_004963.1:p.Val617Phe",
                  "display" : "NP_004963.1:p.Val617Phe"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6683-2",
                  "display" : "Germline"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied ID"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "JAK2",
                  "display" : "JAK2"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:772de7d7-e1bd-4183-bdb5-cea8eda317cd",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncologyexamples-r4-withGrouping-7",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncologyexamples-r4-withGrouping-7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncologyexamples-r4-withGrouping-7</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-7\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-7\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><p><b>effective</b>: 2023-05-01</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d\">Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81290-9}\">Genomic DNA change (gHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NC_000004.11:g.55972974T&gt;A}\">NC_000004.11:g.55972974T&gt;A</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48005-3}\">Amino acid change (pHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NP_002244.1:p.Gln472His}\">NP_002244.1:p.Gln472His</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6683-2}\">Germline</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied ID</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org KDR}\">KDR</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "effectiveDateTime" : "2023-05-01",
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "reference" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81290-9",
                  "display" : "Genomic DNA change (gHGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NC_000004.11:g.55972974T>A",
                  "display" : "NC_000004.11:g.55972974T>A"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48005-3",
                  "display" : "Amino acid change (pHGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NP_002244.1:p.Gln472His",
                  "display" : "NP_002244.1:p.Gln472His"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6683-2",
                  "display" : "Germline"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied ID"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "KDR",
                  "display" : "KDR"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:b33eb7ec-d83e-49d2-b0f3-729d024ebe01",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncologyexamples-r4-withGrouping-8",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncologyexamples-r4-withGrouping-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncologyexamples-r4-withGrouping-8</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-8\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-8\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><p><b>effective</b>: 2023-05-01</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d\">Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81290-9}\">Genomic DNA change (gHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NC_000002.12:g.211713666_211713668del}\">NC_000002.12:g.211713666_211713668del</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6683-2}\">Germline</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied ID</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org ERBB4}\">ERBB4</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "effectiveDateTime" : "2023-05-01",
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "reference" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81290-9",
                  "display" : "Genomic DNA change (gHGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NC_000002.12:g.211713666_211713668del",
                  "display" : "NC_000002.12:g.211713666_211713668del"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6683-2",
                  "display" : "Germline"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied ID"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "ERBB4",
                  "display" : "ERBB4"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:1bf9642d-fd1c-4819-8c5d-44fae4bad524",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncologyexamples-r4-withGrouping-9",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncologyexamples-r4-withGrouping-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncologyexamples-r4-withGrouping-9</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-9\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-9\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-therapeutic-implication.html\">Therapeutic Implication</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><p><b>effective</b>: 2023-05-01</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26811-2}\">Computational analysis</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d\">Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-bundle-complexVariant-nonHGVS.html#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d\">Observation Genetic variant assessment</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6677-4}\">Responsive</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 93044-6}\">Level of evidence</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA30200-2}\">Very strong evidence pathogenic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81259-4}\">Associated phenotype</span></p><p><b>value</b>: <span title=\"Codes:\">Polycythemia vera (PV)</span></p></blockquote><blockquote><p><b>component</b></p><p><b>Medication Assessed reference to a FHIR resource</b>: <a href=\"#hcInline-Instance-for-oncologyexamples-r4-withGrouping-9/Inline-MedicationKnowledgeRuxolitinib\">MedicationKnowledge Ruxolitinib</a></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51963-7}\">Medication assessed [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.nlm.nih.gov/research/umls/rxnorm 1193326}\">Ruxolitinib</span></p></blockquote><hr/><blockquote><p class=\"res-header-id\"><b>Generated Narrative: MedicationKnowledge #Inline-MedicationKnowledgeRuxolitinib</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-9/Inline-MedicationKnowledgeRuxolitinib\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-9/Inline-MedicationKnowledgeRuxolitinib\"> </a><p><b>code</b>: <span title=\"Codes:{http://www.nlm.nih.gov/research/umls/rxnorm 1193326}\">Ruxolitinib</span></p><p><b>status</b>: Active</p></blockquote></div>"
        },
        "contained" : [
          {
            "resourceType" : "MedicationKnowledge",
            "id" : "Inline-MedicationKnowledgeRuxolitinib",
            "code" : {
              "coding" : [
                {
                  "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
                  "code" : "1193326",
                  "display" : "Ruxolitinib"
                }
              ]
            },
            "status" : "active"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "therapeutic-implication",
              "display" : "Therapeutic Implication"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "effectiveDateTime" : "2023-05-01",
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26811-2",
              "display" : "Computational analysis"
            }
          ]
        },
        "specimen" : {
          "reference" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d"
        },
        "derivedFrom" : [
          {
            "reference" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12d"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "therapeutic-implication"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6677-4",
                  "display" : "Responsive"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "93044-6"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA30200-2",
                  "display" : "Very strong evidence pathogenic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81259-4"
                }
              ]
            },
            "valueCodeableConcept" : {
              "text" : "Polycythemia vera (PV)"
            }
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/medication-assessed-reference",
                "valueReference" : {
                  "reference" : "#Inline-MedicationKnowledgeRuxolitinib"
                }
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51963-7"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
                  "code" : "1193326",
                  "display" : "Ruxolitinib"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:1301943b-55db-4adf-8355-3635f7268a1b",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncologyexamples-r4-withGrouping-10",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncologyexamples-r4-withGrouping-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncologyexamples-r4-withGrouping-10</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-10\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-10\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-therapeutic-implication.html\">Therapeutic Implication</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><p><b>effective</b>: 2023-05-01</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26811-2}\">Computational analysis</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d\">Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-bundle-complexVariant-nonHGVS.html#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d\">Observation Genetic variant assessment</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6677-4}\">Responsive</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 93044-6}\">Level of Evidence</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA30200-2}\">Very strong evidence pathogenic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81259-4}\">Associated phenotype</span></p><p><b>value</b>: <span title=\"Codes:\">Polycythemia vera (PV)</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51963-7}\">Medication assessed</span></p><p><b>value</b>: <span title=\"Codes:\">AT9283</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "therapeutic-implication",
              "display" : "Therapeutic Implication"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "effectiveDateTime" : "2023-05-01",
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26811-2",
              "display" : "Computational analysis"
            }
          ]
        },
        "specimen" : {
          "reference" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d"
        },
        "derivedFrom" : [
          {
            "reference" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12d"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "therapeutic-implication"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6677-4",
                  "display" : "Responsive"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "93044-6",
                  "display" : "Level of Evidence"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA30200-2",
                  "display" : "Very strong evidence pathogenic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81259-4"
                }
              ]
            },
            "valueCodeableConcept" : {
              "text" : "Polycythemia vera (PV)"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51963-7",
                  "display" : "Medication assessed"
                }
              ]
            },
            "valueCodeableConcept" : {
              "text" : "AT9283"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:05713d1c-0df5-46d5-a5a9-2085eef56c20",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncologyexamples-r4-withGrouping-11",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncologyexamples-r4-withGrouping-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncologyexamples-r4-withGrouping-11</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-11\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-11\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-therapeutic-implication.html\">Therapeutic Implication</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><p><b>effective</b>: 2023-05-01</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26811-2}\">Computational analysis</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d\">Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-bundle-complexVariant-nonHGVS.html#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d\">Observation Genetic variant assessment</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6677-4}\">Responsive</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 93044-6}\">Level of Evidence</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA30200-2}\">Very strong evidence pathogenic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81259-4}\">Associated phenotype</span></p><p><b>value</b>: <span title=\"Codes:\">Polycythemia vera (PV)</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51963-7}\">Medication assessed</span></p><p><b>value</b>: <span title=\"Codes:\">SNX-5422</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "therapeutic-implication",
              "display" : "Therapeutic Implication"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "effectiveDateTime" : "2023-05-01",
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26811-2",
              "display" : "Computational analysis"
            }
          ]
        },
        "specimen" : {
          "reference" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d"
        },
        "derivedFrom" : [
          {
            "reference" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12d"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "therapeutic-implication"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6677-4",
                  "display" : "Responsive"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "93044-6",
                  "display" : "Level of Evidence"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA30200-2",
                  "display" : "Very strong evidence pathogenic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81259-4"
                }
              ]
            },
            "valueCodeableConcept" : {
              "text" : "Polycythemia vera (PV)"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51963-7",
                  "display" : "Medication assessed"
                }
              ]
            },
            "valueCodeableConcept" : {
              "text" : "SNX-5422"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:294f1401-e2eb-4df1-b6d2-09e1b7a6eca4",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncologyexamples-r4-withGrouping-12",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncologyexamples-r4-withGrouping-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncologyexamples-r4-withGrouping-12</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-12\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-12\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-therapeutic-implication.html\">Therapeutic Implication</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><p><b>effective</b>: 2023-05-01</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26811-2}\">Computational analysis</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d\">Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-bundle-complexVariant-nonHGVS.html#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d\">Observation Genetic variant assessment</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6677-4}\">Responsive</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 93044-6}\">Level of Evidence</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA30200-2}\">Very strong evidence pathogenic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81259-4}\">Associated phenotype</span></p><p><b>value</b>: <span title=\"Codes:\">Polycythemia vera (PV)</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51963-7}\">Medication assessed</span></p><p><b>value</b>: <span title=\"Codes:\">TG02</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "therapeutic-implication",
              "display" : "Therapeutic Implication"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "effectiveDateTime" : "2023-05-01",
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26811-2",
              "display" : "Computational analysis"
            }
          ]
        },
        "specimen" : {
          "reference" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d"
        },
        "derivedFrom" : [
          {
            "reference" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12d"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "therapeutic-implication"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6677-4",
                  "display" : "Responsive"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "93044-6",
                  "display" : "Level of Evidence"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA30200-2",
                  "display" : "Very strong evidence pathogenic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81259-4"
                }
              ]
            },
            "valueCodeableConcept" : {
              "text" : "Polycythemia vera (PV)"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51963-7",
                  "display" : "Medication assessed"
                }
              ]
            },
            "valueCodeableConcept" : {
              "text" : "TG02"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12f",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncologyexamples-r4-withGrouping-13",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncologyexamples-r4-withGrouping-13\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncologyexamples-r4-withGrouping-13</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-13\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-13\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl C43359}\">Group</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><p><b>effective</b>: 2023-05-01</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></p><p><b>hasMember</b>: </p><ul><li><a href=\"Bundle-bundle-complexVariant-nonHGVS.html#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d\">SNV analysis for JAK2 variant</a></li><li><a href=\"Bundle-bundle-oncologyexamples-r4-withGrouping.html#urn-uuid-772de7d7-e1bd-4183-bdb5-cea8eda317cd\">SNV analysis for KDR variant</a></li><li><a href=\"Bundle-bundle-oncologyexamples-r4-withGrouping.html#urn-uuid-b33eb7ec-d83e-49d2-b0f3-729d024ebe01\">SNV analysis for ERBB4 variant</a></li><li><a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-40e85eda-4d31-4bd2-a5a0-c39d63f9824f\">TMB value analysis</a></li><li><a href=\"Bundle-bundle-oncologyexamples-r4-withGrouping.html#urn-uuid-64b91716-6431-41bd-8fd4-7ac99bebdee9\">MSI status analysis</a></li></ul></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl",
              "code" : "C43359",
              "display" : "Group"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "effectiveDateTime" : "2023-05-01",
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "hasMember" : [
          {
            "reference" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12d",
            "display" : "SNV analysis for JAK2 variant"
          },
          {
            "reference" : "urn:uuid:772de7d7-e1bd-4183-bdb5-cea8eda317cd",
            "display" : "SNV analysis for KDR variant"
          },
          {
            "reference" : "urn:uuid:b33eb7ec-d83e-49d2-b0f3-729d024ebe01",
            "display" : "SNV analysis for ERBB4 variant"
          },
          {
            "reference" : "urn:uuid:40e85eda-4d31-4bd2-a5a0-c39d63f9824f",
            "display" : "TMB value analysis"
          },
          {
            "reference" : "urn:uuid:64b91716-6431-41bd-8fd4-7ac99bebdee9",
            "display" : "MSI status analysis"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12e",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncologyexamples-r4-withGrouping-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncologyexamples-r4-withGrouping-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncologyexamples-r4-withGrouping-14</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-14\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-14\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl C43359}\">Group</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><p><b>effective</b>: 2023-05-01</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></p><p><b>hasMember</b>: </p><ul><li><a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-1bf9642d-fd1c-4819-8c5d-44fae4bad524\">Therapy match result 1</a></li><li><a href=\"Bundle-bundle-oncologyexamples-r4-withGrouping.html#urn-uuid-1301943b-55db-4adf-8355-3635f7268a1b\">Therapy match result 2</a></li><li><a href=\"Bundle-bundle-oncologyexamples-r4-withGrouping.html#urn-uuid-05713d1c-0df5-46d5-a5a9-2085eef56c20\">Therapy match result 3</a></li><li><a href=\"Bundle-bundle-oncologyexamples-r4-withGrouping.html#urn-uuid-294f1401-e2eb-4df1-b6d2-09e1b7a6eca4\">Therapy match result 4</a></li></ul></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl",
              "code" : "C43359",
              "display" : "Group"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "effectiveDateTime" : "2023-05-01",
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "hasMember" : [
          {
            "reference" : "urn:uuid:1bf9642d-fd1c-4819-8c5d-44fae4bad524",
            "display" : "Therapy match result 1"
          },
          {
            "reference" : "urn:uuid:1301943b-55db-4adf-8355-3635f7268a1b",
            "display" : "Therapy match result 2"
          },
          {
            "reference" : "urn:uuid:05713d1c-0df5-46d5-a5a9-2085eef56c20",
            "display" : "Therapy match result 3"
          },
          {
            "reference" : "urn:uuid:294f1401-e2eb-4df1-b6d2-09e1b7a6eca4",
            "display" : "Therapy match result 4"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad7a499b-a43b-4cc8-bf46-cac62d9ecae5",
      "resource" : {
        "resourceType" : "DiagnosticReport",
        "id" : "Inline-Instance-for-oncologyexamples-r4-withGrouping-15",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DiagnosticReport_Inline-Instance-for-oncologyexamples-r4-withGrouping-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DiagnosticReport Inline-Instance-for-oncologyexamples-r4-withGrouping-15</b></p><a name=\"Inline-Instance-for-oncologyexamples-r4-withGrouping-15\"> </a><a name=\"hcInline-Instance-for-oncologyexamples-r4-withGrouping-15\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-genomic-report.html\">Genomic Report</a></p></div><h2><span title=\"Codes:{http://loinc.org 51969-4}\">Genetic analysis report</span> (<span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span>) </h2><table class=\"grid\"><tr><td>Subject</td><td>Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</td></tr><tr><td>Performer</td><td> <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></td></tr></table><p><b>Report Details</b></p><table class=\"grid\"><tr><td><b>Code</b></td><td><b>Value</b></td><td><b>Flags</b></td><td><b>When For</b></td><td><b>Reported</b></td></tr><tr><td><a href=\"Bundle-bundle-oncologyexamples-r4-withGrouping.html#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12f\"><span title=\"Codes:{http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl C43359}\">Group</span></a></td><td/><td>Final</td><td>2023-05-01</td><td/></tr><tr><td><a href=\"Bundle-bundle-complexVariant-nonHGVS.html#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2019-03-05</td><td>2019-03-05 16:04:44+0000</td></tr><tr><td><a href=\"Bundle-bundle-oncologyexamples-r4-withGrouping.html#urn-uuid-772de7d7-e1bd-4183-bdb5-cea8eda317cd\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2023-05-01</td><td/></tr><tr><td><a href=\"Bundle-bundle-oncologyexamples-r4-withGrouping.html#urn-uuid-b33eb7ec-d83e-49d2-b0f3-729d024ebe01\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2023-05-01</td><td/></tr><tr><td><a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-40e85eda-4d31-4bd2-a5a0-c39d63f9824f\"><span title=\"Codes:{http://loinc.org 94076-7}\">Mutations/Megabase [# Ratio] in Tumor</span></a></td><td>25 Mutations/Megabase<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1/1000000 = '1/1000000')</span></td><td>Final</td><td>2019-03-05</td><td/></tr><tr><td><a href=\"Bundle-bundle-oncologyexamples-r4-withGrouping.html#urn-uuid-64b91716-6431-41bd-8fd4-7ac99bebdee9\"><span title=\"Codes:{http://loinc.org 81695-9}\">Microsatellite instability [Interpretation] in Cancer specimen Qualitative</span></a></td><td><span title=\"Codes:{http://loinc.org LA14122-8}\">Stable</span></td><td>Final</td><td>2023-05-01</td><td/></tr><tr><td><a href=\"Bundle-bundle-complexVariant-nonHGVS.html#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12e\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2019-03-05</td><td>2019-03-05 16:04:44+0000</td></tr><tr><td><a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-1bf9642d-fd1c-4819-8c5d-44fae4bad524\"><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs diagnostic-implication}\">Diagnostic Implication</span></a></td><td/><td>Final</td><td>2019-03-05</td><td/></tr><tr><td><a href=\"Bundle-bundle-oncologyexamples-r4-withGrouping.html#urn-uuid-1301943b-55db-4adf-8355-3635f7268a1b\"><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></a></td><td/><td>Final</td><td>2023-05-01</td><td/></tr><tr><td><a href=\"Bundle-bundle-oncologyexamples-r4-withGrouping.html#urn-uuid-05713d1c-0df5-46d5-a5a9-2085eef56c20\"><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></a></td><td/><td>Final</td><td>2023-05-01</td><td/></tr><tr><td><a href=\"Bundle-bundle-oncologyexamples-r4-withGrouping.html#urn-uuid-294f1401-e2eb-4df1-b6d2-09e1b7a6eca4\"><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></a></td><td/><td>Final</td><td>2023-05-01</td><td/></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "51969-4"
            }
          ],
          "text" : "Genetic analysis report"
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "specimen" : [
          {
            "reference" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d"
          }
        ],
        "result" : [
          {
            "reference" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12f",
            "display" : "Variants and other biomarker tests"
          },
          {
            "reference" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12d",
            "display" : "SNV analysis for JAK2 variant"
          },
          {
            "reference" : "urn:uuid:772de7d7-e1bd-4183-bdb5-cea8eda317cd",
            "display" : "SNV analysis for KDR variant"
          },
          {
            "reference" : "urn:uuid:b33eb7ec-d83e-49d2-b0f3-729d024ebe01",
            "display" : "SNV analysis for ERBB4 variant"
          },
          {
            "reference" : "urn:uuid:40e85eda-4d31-4bd2-a5a0-c39d63f9824f",
            "display" : "TMB value analysis"
          },
          {
            "reference" : "urn:uuid:64b91716-6431-41bd-8fd4-7ac99bebdee9",
            "display" : "MSI status analysis"
          },
          {
            "reference" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12e",
            "display" : "Therapy Match Results"
          },
          {
            "reference" : "urn:uuid:1bf9642d-fd1c-4819-8c5d-44fae4bad524",
            "display" : "Therapy match result 1"
          },
          {
            "reference" : "urn:uuid:1301943b-55db-4adf-8355-3635f7268a1b",
            "display" : "Therapy match result 2"
          },
          {
            "reference" : "urn:uuid:05713d1c-0df5-46d5-a5a9-2085eef56c20",
            "display" : "Therapy match result 3"
          },
          {
            "reference" : "urn:uuid:294f1401-e2eb-4df1-b6d2-09e1b7a6eca4",
            "display" : "Therapy match result 4"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "DiagnosticReport"
      }
    }
  ]
}

```
