# bundle-compound-heterozygote - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **bundle-compound-heterozygote**

## Example Bundle: bundle-compound-heterozygote

Bundle bundle-compound-heterozygote of type transaction

-------

Entry 1 - fullUrl = urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12d

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[John Storm(official) Male, DoB: 1986-12-31](Bundle-bundle-CYP2C19.md#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeac)**effective**: 2019-03-05**issued**: 2019-03-05 16:04:44+0000**performer**:[Organization aTypingLab Inc](Bundle-bundle-CYP2C19.md#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeab)**value**:Present
> **component****code**:DNA change (c.HGVS)**value**:NM_022787.3:c.769G>A

> **component****code**:Allelic state**value**:Heterozygous

Request:

```
POST Observation

```

-------

Entry 2 - fullUrl = urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12e

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[John Storm(official) Male, DoB: 1986-12-31](Bundle-bundle-CYP2C19.md#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeac)**effective**: 2019-03-05**issued**: 2019-03-05 16:04:44+0000**performer**:[Organization aTypingLab Inc](Bundle-bundle-CYP2C19.md#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeab)**value**:Present
> **component****code**:DNA change (c.HGVS)**value**:NM_022787.3:c.53A>G

> **component****code**:Allelic state**value**:Heterozygous

Request:

```
POST Observation

```

-------

Entry 3 - fullUrl = urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12a

Resource Observation:

> 

Profile: [Genotype](StructureDefinition-genotype.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genotype display name**subject**:[John Storm(official) Male, DoB: 1986-12-31](Bundle-bundle-CYP2C19.md#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeac)**effective**: 2019-03-05**issued**: 2019-03-05 16:04:44+0000**performer**:[Organization aTypingLab Inc](Bundle-bundle-CYP2C19.md#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeab)**value**:NM_022787.3(NMNAT1):c.[53A>G];[769G>A] AND Cone-rod dystrophy**hasMember**:
* [NM_022787.3:c.53A>G](Bundle-bundle-complexVariant-nonHGVS.md#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12e)
* [NM_022787.3:c.769G>A](Bundle-bundle-complexVariant-nonHGVS.md#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d)

Request:

```
POST Observation

```

-------

Entry 4 - fullUrl = urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeab

Resource Organization:

> **name**: aTypingLab Inc**alias**: aTL

### Contacts

| | | |
| :--- | :--- | :--- |
| - | **Telecom** | **Address** |
| * | ph: 1-800-555-1234(Work) | 123 Main St, Sometown, ND 99999(work) |


Request:

```
POST Organization

```

-------

Entry 5 - fullUrl = urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeac

Resource Patient:

> John Storm(official) Male, DoB: 1986-12-31
-------

Request:

```
POST Patient

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "bundle-compound-heterozygote",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12d",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-compound-heterozygote-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-compound-heterozygote-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-compound-heterozygote-1</b></p><a name=\"Inline-Instance-for-compound-heterozygote-1\"> </a><a name=\"hcInline-Instance-for-compound-heterozygote-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeac\">John Storm(official) Male, DoB: 1986-12-31</a></p><p><b>effective</b>: 2019-03-05</p><p><b>issued</b>: 2019-03-05 16:04:44+0000</p><p><b>performer</b>: <a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeab\">Organization aTypingLab Inc</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_022787.3:c.769G&gt;A}\">NM_022787.3:c.769G&gt;A</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 53034-5}\">Allelic state</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6706-1}\">Heterozygous</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeac"
        },
        "effectiveDateTime" : "2019-03-05",
        "issued" : "2019-03-05T16:04:44+00:00",
        "performer" : [
          {
            "reference" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6",
                  "display" : "DNA change (c.HGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_022787.3:c.769G>A",
                  "display" : "NM_022787.3:c.769G>A"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "53034-5",
                  "display" : "Allelic state"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6706-1",
                  "display" : "Heterozygous"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12e",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-compound-heterozygote-2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-compound-heterozygote-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-compound-heterozygote-2</b></p><a name=\"Inline-Instance-for-compound-heterozygote-2\"> </a><a name=\"hcInline-Instance-for-compound-heterozygote-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeac\">John Storm(official) Male, DoB: 1986-12-31</a></p><p><b>effective</b>: 2019-03-05</p><p><b>issued</b>: 2019-03-05 16:04:44+0000</p><p><b>performer</b>: <a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeab\">Organization aTypingLab Inc</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_022787.3:c.53A&gt;G}\">NM_022787.3:c.53A&gt;G</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 53034-5}\">Allelic state</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6706-1}\">Heterozygous</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeac"
        },
        "effectiveDateTime" : "2019-03-05",
        "issued" : "2019-03-05T16:04:44+00:00",
        "performer" : [
          {
            "reference" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6",
                  "display" : "DNA change (c.HGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_022787.3:c.53A>G",
                  "display" : "NM_022787.3:c.53A>G"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "53034-5",
                  "display" : "Allelic state"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6706-1",
                  "display" : "Heterozygous"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12a",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-compound-heterozygote-3",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-compound-heterozygote-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-compound-heterozygote-3</b></p><a name=\"Inline-Instance-for-compound-heterozygote-3\"> </a><a name=\"hcInline-Instance-for-compound-heterozygote-3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-genotype.html\">Genotype</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84413-4}\">Genotype display name</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeac\">John Storm(official) Male, DoB: 1986-12-31</a></p><p><b>effective</b>: 2019-03-05</p><p><b>issued</b>: 2019-03-05 16:04:44+0000</p><p><b>performer</b>: <a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeab\">Organization aTypingLab Inc</a></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/clinvar RCV000664188.1}\">NM_022787.3(NMNAT1):c.[53A&gt;G];[769G&gt;A] AND Cone-rod dystrophy</span></p><p><b>hasMember</b>: </p><ul><li><a href=\"Bundle-bundle-complexVariant-nonHGVS.html#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12e\">NM_022787.3:c.53A&gt;G</a></li><li><a href=\"Bundle-bundle-complexVariant-nonHGVS.html#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d\">NM_022787.3:c.769G&gt;A</a></li></ul></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84413-4"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeac"
        },
        "effectiveDateTime" : "2019-03-05",
        "issued" : "2019-03-05T16:04:44+00:00",
        "performer" : [
          {
            "reference" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.ncbi.nlm.nih.gov/clinvar",
              "code" : "RCV000664188.1",
              "display" : "NM_022787.3(NMNAT1):c.[53A>G];[769G>A] AND Cone-rod dystrophy"
            }
          ]
        },
        "hasMember" : [
          {
            "reference" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12e",
            "display" : "NM_022787.3:c.53A>G"
          },
          {
            "reference" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12d",
            "display" : "NM_022787.3:c.769G>A"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeab",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "performingLab",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_performingLab\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization performingLab</b></p><a name=\"performingLab\"> </a><a name=\"hcperformingLab\"> </a><p><b>name</b>: aTypingLab Inc</p><p><b>alias</b>: aTL</p><h3>Contacts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Telecom</b></td><td><b>Address</b></td></tr><tr><td style=\"display: none\">*</td><td>ph: 1-800-555-1234(Work)</td><td>123 Main St, Sometown, ND 99999(work)</td></tr></table></div>"
        },
        "name" : "aTypingLab Inc",
        "alias" : ["aTL"],
        "contact" : [
          {
            "telecom" : [
              {
                "system" : "phone",
                "value" : "1-800-555-1234",
                "use" : "work",
                "rank" : 1
              }
            ],
            "address" : {
              "use" : "work",
              "type" : "physical",
              "text" : "123 Main St, Sometown, ND 99999",
              "line" : ["123 Main St"],
              "city" : "Sometown",
              "state" : "ND",
              "postalCode" : "99999",
              "country" : "USA"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Organization"
      }
    },
    {
      "fullUrl" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeac",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "patient",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_patient\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient patient</b></p><a name=\"patient\"> </a><a name=\"hcpatient\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">John Storm(official) Male, DoB: 1986-12-31</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><ul><li>ph: 1-800-555-1234(Work)</li><li>123 Main St, Sometown, ND 99999(work)</li></ul></td></tr></table></div>"
        },
        "name" : [
          {
            "use" : "official",
            "text" : "John Storm",
            "family" : "Storm",
            "given" : ["John"]
          },
          {
            "use" : "nickname",
            "text" : "Johnny Storm",
            "family" : "Storm",
            "given" : ["Johnny"]
          },
          {
            "use" : "nickname",
            "text" : "The Human Torch"
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "1-800-555-1234",
            "use" : "work",
            "rank" : 1
          }
        ],
        "gender" : "male",
        "birthDate" : "1986-12-31",
        "address" : [
          {
            "use" : "work",
            "type" : "physical",
            "text" : "123 Main St, Sometown, ND 99999",
            "line" : ["123 Main St"],
            "city" : "Sometown",
            "state" : "ND",
            "postalCode" : "99999",
            "country" : "USA"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Patient"
      }
    }
  ]
}

```
