# bundle-cgexample-withGrouping - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **bundle-cgexample-withGrouping**

## Example Bundle: bundle-cgexample-withGrouping

Bundle bundle-cgexample-withGrouping of type collection

-------

Entry 1 - fullUrl = http://example.org/fhir/DiagnosticReport/report-withGrouping

Resource DiagnosticReport:

> 

Profile: [Genomic Report](StructureDefinition-genomic-report.md)

## Genetic analysis report (Genetics ) 

| | |
| :--- | :--- |
| Subject | Anonymous Patient (no stated gender), DoB Unknown |
| When For | 2016 |
| Reported | 2016-09-06 00:00:00-0500 |
| Performer | [Organization Some lab](Organization-ExampleLab.md) |

**Report Details**

* **Code**: [Genetic variant assessment](Bundle-bundle-cgexample-withGrouping.md#Observation_discrete-variant-1a)
  * **Value**: Present
  * **Flags**: Final
* **Code**: [Diagnostic Implication](Bundle-bundle-cgexample-withGrouping.md#Observation_dis-path-1a)
  * **Value**: 
  * **Flags**: Final
* **Code**: [Genetic variant assessment](Bundle-bundle-cgexample-withGrouping.md#Observation_complex-variant-1a)
  * **Value**: Present
  * **Flags**: Final
* **Code**: [Diagnostic Implication](Bundle-bundle-cgexample-withGrouping.md#Observation_complex-dis-path-1a)
  * **Value**: 
  * **Flags**: Final
* **Code**: [Group](Bundle-bundle-cgexample-withGrouping.md#Observation_pharmPanel-1a)
  * **Value**: 
  * **Flags**: Final
* **Code**: [Haplotype name](Bundle-bundle-cgexample-withGrouping.md#Observation_haplotype-1a)
  * **Value**: *2
  * **Flags**: Final
* **Code**: [Genotype display name](Bundle-bundle-cgexample-withGrouping.md#Observation_genotype-1a)
  * **Value**: CYP2C9 *2/*5
  * **Flags**: Final
* **Code**: [Therapeutic Implication](Bundle-bundle-cgexample-withGrouping.md#Observation_metab-1a)
  * **Value**: 
  * **Flags**: Final
* **Code**: [Therapeutic Implication](Bundle-bundle-cgexample-withGrouping.md#Observation_efficacy-1a)
  * **Value**: 
  * **Flags**: Final

**Coded Conclusions:**
* 
* 

-------

Entry 2 - fullUrl = http://example.org/fhir/Patient/ExamplePatient

Resource Patient:

> This would contain patient identifiers, demographics, etc.

-------

Entry 3 - fullUrl = http://example.org/fhir/Specimen/ExampleSpecimen

Resource Specimen:

> **subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)

-------

Entry 4 - fullUrl = http://example.org/fhir/Organization/ExampleLab

Resource Organization:

> **name**: Some lab

-------

Entry 5 - fullUrl = http://example.org/fhir/ServiceRequest/ExampleServiceRequest

Resource ServiceRequest:

> **status**: Active**intent**: Original Order

### Codes

| | |
| :--- | :--- |
| - | **Concept** |
| * | Genetic analysis report |

**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Worried about family planning |


-------

Entry 6 - fullUrl = http://example.org/fhir/Observation/discrete-variant-1a

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2016**issued**: 2016-09-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**value**:Present**specimen**:[Specimen](Specimen-ExampleSpecimen.md)
> **component****code**:Discrete genetic variant**value**:NM_014049.4(ACAD9):c.1249C>T (p.Arg417Cys)

> **component****code**:Gene studied [ID]**value**:ACAD9

> **component****code**:Transcript reference sequence [ID]**value**:NM_014049.4

> **component****code**:Genomic reference sequence [ID]**value**:NG_017064.1

> **component****code**:Genomic DNA change (gHGVS)**value**:NC_000003.11:g.128625063C>T

> **component****code**:Discrete genetic variant**value**:rs368949613

> **component****code**:DNA change (c.HGVS)**value**:NM_014049.4:c.1249C>T

> **component****code**:Amino acid change (pHGVS)**value**:NP_054768.2:p.Arg417Cys

> **component****code**:DNA change type**value**:Substitution

> **component****code**:Genomic ref allele [ID]**value**: C

> **component****code**:Genomic allele start-end**value**: 31731-31731

> **component****code**:Genomic alt allele [ID]**value**: T

> **component****code**:Cytogenetic (chromosome) location**value**:3q21

> **component****code**:Genomic source class [Type]**value**:Germline

> **component****code**:Allelic state**value**:Heterozygous

> **component****code**:Sample variant allelic frequency [NFr]**value**: 47 %(Details: UCUM code% = '%')

> **component****code**:Allelic read depth**value**: 208 1(Details: UCUM code1 = '1')

> **component****code**:Genomic structural variant copy number**value**: 1 1(Details: UCUM code1 = '1')

> **component****code**:Structural variant outer start and end**value**: 13200589-15592000

> **component****code**:Structural variant inner start and end**value**: 14184616-15581544

-------

Entry 7 - fullUrl = http://example.org/fhir/Observation/dis-path-1a

Resource Observation:

> 

Profile: [Diagnostic Implication](StructureDefinition-diagnostic-implication.md)

**status**: Final**category**:Laboratory,Genetics**code**:Diagnostic Implication**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2016**issued**: 2016-09-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**derivedFrom**:[Observation Genetic variant assessment](Bundle-bundle-cgexample-withGrouping.md#Observation_discrete-variant-1a)
> **component****code**:Genetic variation clinical significance [Imp]**value**:Pathogenic

> **component****code**:Associated phenotype**value**:acyl-CoA dehydrogenase 9 deficiency

-------

Entry 8 - fullUrl = http://example.org/fhir/Observation/complex-variant-1a

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2016**issued**: 2016-09-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**value**:Present**specimen**:[Specimen](Specimen-ExampleSpecimen.md)**hasMember**:
* [Observation Genetic variant assessment](Bundle-bundle-cgexample-withGrouping.md#Observation_complex-component-D-1a)
* [Observation Genetic variant assessment](Bundle-bundle-cgexample-withGrouping.md#Observation_complex-component-E-1a)

-------

Entry 9 - fullUrl = http://example.org/fhir/Observation/complex-dis-path-1a

Resource Observation:

> 

Profile: [Diagnostic Implication](StructureDefinition-diagnostic-implication.md)

**status**: Final**category**:Laboratory,Genetics**code**:Diagnostic Implication**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2016**issued**: 2016-09-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**derivedFrom**:[Observation Genetic variant assessment](Bundle-bundle-cgexample-withGrouping.md#Observation_complex-variant-1a)
> **component****code**:Genetic variation clinical significance [Imp]**value**:Pathogenic

> **component****code**:Associated phenotype**value**:Debrisoquine adverse reaction (disorder)

-------

Entry 10 - fullUrl = http://example.org/fhir/Observation/complex-component-D-1a

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2016**issued**: 2016-09-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**value**:Present**specimen**:[Specimen](Specimen-ExampleSpecimen.md)
> **component****code**:Discrete genetic variant**value**:NM_000106.5(CYP2D6):c.886C>T (p.Arg296Cys)

> **component****code**:Transcript reference sequence [ID]**value**:NM_000106.5

> **component****code**:DNA change (c.HGVS)**value**:NM_000106.5:c.886C>T

> **component****code**:Amino acid change (pHGVS)**value**:NP_000097.3:p.Arg296Cys

> **component****code**:DNA change type**value**:Substitution

-------

Entry 11 - fullUrl = http://example.org/fhir/Observation/complex-component-E-1a

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2016**issued**: 2016-09-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**value**:Present**specimen**:[Specimen](Specimen-ExampleSpecimen.md)
> **component****code**:Discrete genetic variant**value**:NM_000106.5(CYP2D6):c.1457G>C (p.Ser486Thr)

> **component****code**:Transcript reference sequence [ID]**value**:NM_000106.5

> **component****code**:DNA change (c.HGVS)**value**:NM_000106.5:c.1457G>C

-------

Entry 12 - fullUrl = http://example.org/fhir/Observation/pharmPanel-1a

Resource Observation:

> **Recommended Action**:[Task Increase dose](Bundle-bundle-cgexample-withGrouping.md#Task_usage-1a)**status**: Final**category**:Laboratory,Genetics**code**:Group**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2016**issued**: 2016-09-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**hasMember**:
* [Observation Haplotype name](Bundle-bundle-cgexample-withGrouping.md#Observation_haplotype-1a)
* [Observation Genotype display name](Bundle-bundle-cgexample-withGrouping.md#Observation_genotype-1a)
* [Observation Therapeutic Implication](Bundle-bundle-cgexample-withGrouping.md#Observation_metab-1a)
* [Observation Therapeutic Implication](Bundle-bundle-cgexample-withGrouping.md#Observation_efficacy-1a)

-------

Entry 13 - fullUrl = http://example.org/fhir/Observation/haplotype-1a

Resource Observation:

> 

Profile: [Haplotype](StructureDefinition-haplotype.md)

**status**: Final**category**:Laboratory,Genetics**code**:Haplotype name**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2016**issued**: 2016-09-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**value**:*2**specimen**:[Specimen](Specimen-ExampleSpecimen.md)**derivedFrom**:[Observation Genetic variant assessment](Bundle-bundle-cgexample-withGrouping.md#Observation_discrete-variant-1a)

-------

Entry 14 - fullUrl = http://example.org/fhir/Observation/genotype-1a

Resource Observation:

> 

Profile: [Genotype](StructureDefinition-genotype.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genotype display name**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2016**issued**: 2016-09-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**value**:CYP2C9 *2/*5**specimen**:[Specimen](Specimen-ExampleSpecimen.md)**derivedFrom**:[Observation Haplotype name](Bundle-bundle-cgexample-withGrouping.md#Observation_haplotype-1a)
> **component****code**:Gene studied [ID]**value**:CYP2C9

> **component****code**:Gene studied [ID]**value**:VKORC1

-------

Entry 15 - fullUrl = http://example.org/fhir/Observation/metab-1a

Resource Observation:

> 

Profile: [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)

**status**: Final**category**:Laboratory,Genetics**code**:Therapeutic Implication**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2016**issued**: 2016-09-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**derivedFrom**:[Observation Genotype display name](Bundle-bundle-cgexample-withGrouping.md#Observation_genotype-1a)
> **component****code**:Medication assessed [ID]**value**:Warfarin

> **component****code**:Therapeutic Implication**value**:Rapid metabolizer

-------

Entry 16 - fullUrl = http://example.org/fhir/Observation/efficacy-1a

Resource Observation:

> 

Profile: [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)

**status**: Final**category**:Laboratory,Genetics**code**:Therapeutic Implication**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2016**issued**: 2016-09-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**derivedFrom**:[Observation Genotype display name](Bundle-bundle-cgexample-withGrouping.md#Observation_genotype-1a)
> **component****code**:Therapeutic Implication**value**:Resistant

> **component****code**:Medication assessed [ID]**value**:Warfarin

-------

Entry 17 - fullUrl = http://example.org/fhir/Observation/highrisk-1a

Resource Observation:

> 

Profile: [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)

**status**: Final**category**:Laboratory,Genetics**code**:Therapeutic Implication**subject**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**effective**: 2016**issued**: 2016-09-06 00:00:00-0500**performer**:[Organization Some lab](Organization-ExampleLab.md)**derivedFrom**:[Observation Genotype display name](Bundle-bundle-cgexample-withGrouping.md#Observation_genotype-1a)
> **component****code**:Therapeutic Implication**value**:Low risk

> **component****code**:Medication assessed [ID]**value**:Warfarin

-------

Entry 18 - fullUrl = http://example.org/fhir/Task/usage-1a

Resource Task:

> 

Profile: [Medication Recommendation](StructureDefinition-medication-recommendation.md)

**status**: Requested**intent**: Proposal**code**:May need higher dosage than usual.**focus**:[MedicationStatement: status = recorded](MedicationStatement-MedicationStatementWarfarin.md)**for**:[Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)**requester**:[Organization Some lab](Organization-ExampleLab.md)

### Reasons

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Observation Therapeutic Implication](Bundle-bundle-cgexample-withGrouping.md#Observation_metab-1a) |




## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "bundle-cgexample-withGrouping",
  "type" : "collection",
  "entry" : [
    {
      "fullUrl" : "http://example.org/fhir/DiagnosticReport/report-withGrouping",
      "resource" : {
        "resourceType" : "DiagnosticReport",
        "id" : "report-withGrouping",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DiagnosticReport_report-withGrouping\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DiagnosticReport report-withGrouping</b></p><a name=\"report-withGrouping\"> </a><a name=\"hcreport-withGrouping\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-genomic-report.html\">Genomic Report</a></p></div><h2><span title=\"Codes:{http://loinc.org 51969-4}\">Genetic analysis report</span> (<span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span>) </h2><table class=\"grid\"><tr><td>Subject</td><td>Anonymous Patient (no stated gender), DoB Unknown</td></tr><tr><td>When For</td><td>2016</td></tr><tr><td>Reported</td><td>2016-09-06 00:00:00-0500</td></tr><tr><td>Performer</td><td> <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></td></tr></table><p><b>Report Details</b></p><table class=\"grid\"><tr><td><b>Code</b></td><td><b>Value</b></td><td><b>Flags</b></td></tr><tr><td><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_discrete-variant-1a\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td></tr><tr><td><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_dis-path-1a\"><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs diagnostic-implication}\">Diagnostic Implication</span></a></td><td/><td>Final</td></tr><tr><td><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_complex-variant-1a\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td></tr><tr><td><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_complex-dis-path-1a\"><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs diagnostic-implication}\">Diagnostic Implication</span></a></td><td/><td>Final</td></tr><tr><td><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_pharmPanel-1a\"><span title=\"Codes:{http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl C43359}\">Group</span></a></td><td/><td>Final</td></tr><tr><td><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_haplotype-1a\"><span title=\"Codes:{http://loinc.org 84414-2}\">Haplotype name</span></a></td><td><span title=\"Codes:{http://www.ebi.ac.uk/ipd/imgt/hla *2}\">*2</span></td><td>Final</td></tr><tr><td><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_genotype-1a\"><span title=\"Codes:{http://loinc.org 84413-4}\">Genotype display name</span></a></td><td><span title=\"Codes:{http://www.pharmvar.org CYP2C9*2*5&quot;}\">CYP2C9 *2/*5</span></td><td>Final</td></tr><tr><td><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_metab-1a\"><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></a></td><td/><td>Final</td></tr><tr><td><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_efficacy-1a\"><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></a></td><td/><td>Final</td></tr></table><p><b>Coded Conclusions:</b></p><ul><li><span title=\"Codes:{http://loinc.org LA6576-8}\">Positive</span></li><li><span title=\"Codes:{http://snomed.info/sct 10828004}\">Positive</span></li></ul></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/ExampleServiceRequest"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "51969-4",
              "display" : "Genetic analysis report"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2016",
        "issued" : "2016-09-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "result" : [
          {
            "reference" : "Observation/discrete-variant-1a"
          },
          {
            "reference" : "Observation/dis-path-1a"
          },
          {
            "reference" : "Observation/complex-variant-1a"
          },
          {
            "reference" : "Observation/complex-dis-path-1a"
          },
          {
            "reference" : "Observation/pharmPanel-1a"
          },
          {
            "reference" : "Observation/haplotype-1a"
          },
          {
            "reference" : "Observation/genotype-1a"
          },
          {
            "reference" : "Observation/metab-1a"
          },
          {
            "reference" : "Observation/efficacy-1a"
          }
        ],
        "conclusionCode" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6576-8",
                  "display" : "Positive"
                }
              ]
            }
          },
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "10828004",
                  "display" : "Positive"
                }
              ]
            }
          }
        ],
        "presentedForm" : [
          {
            "contentType" : "text/plain",
            "data" : "UHV0IHRoZSByZXBvcnQgdGV4dCBoZXJlIC0gbWltZS1lbmNvZGVk"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Patient/ExamplePatient",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "ExamplePatient",
        "text" : {
          "status" : "additional",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_ExamplePatient\"> </a>This would contain patient identifiers, demographics, etc.</div>"
        }
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Specimen/ExampleSpecimen",
      "resource" : {
        "resourceType" : "Specimen",
        "id" : "ExampleSpecimen",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Specimen_ExampleSpecimen\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Specimen ExampleSpecimen</b></p><a name=\"ExampleSpecimen\"> </a><a name=\"hcExampleSpecimen\"> </a><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p></div>"
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        }
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Organization/ExampleLab",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "ExampleLab",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_ExampleLab\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization ExampleLab</b></p><a name=\"ExampleLab\"> </a><a name=\"hcExampleLab\"> </a><p><b>name</b>: Some lab</p></div>"
        },
        "name" : "Some lab"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/ServiceRequest/ExampleServiceRequest",
      "resource" : {
        "resourceType" : "ServiceRequest",
        "id" : "ExampleServiceRequest",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ServiceRequest_ExampleServiceRequest\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ServiceRequest ExampleServiceRequest</b></p><a name=\"ExampleServiceRequest\"> </a><a name=\"hcExampleServiceRequest\"> </a><p><b>status</b>: Active</p><p><b>intent</b>: Original Order</p><h3>Codes</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 51969-4}\">Genetic analysis report</span></td></tr></table><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><h3>Reasons</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:\">Worried about family planning</span></td></tr></table></div>"
        },
        "status" : "active",
        "intent" : "original-order",
        "code" : {
          "concept" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "51969-4",
                "display" : "Genetic analysis report"
              }
            ]
          }
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "reason" : [
          {
            "concept" : {
              "text" : "Worried about family planning"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/discrete-variant-1a",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "discrete-variant-1a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_discrete-variant-1a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation discrete-variant-1a</b></p><a name=\"discrete-variant-1a\"> </a><a name=\"hcdiscrete-variant-1a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2016</p><p><b>issued</b>: 2016-09-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>specimen</b>: <a href=\"Specimen-ExampleSpecimen.html\">Specimen</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81252-9}\">Discrete genetic variant</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/clinvar 30880}\">NM_014049.4(ACAD9):c.1249C&gt;T (p.Arg417Cys)</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:21497}\">ACAD9</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51958-7}\">Transcript reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NM_014049.4}\">NM_014049.4</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48013-7}\">Genomic reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NG_017064.1}\">NG_017064.1</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81290-9}\">Genomic DNA change (gHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NC_000003.11:g.128625063C&gt;T}\">NC_000003.11:g.128625063C&gt;T</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81252-9}\">Discrete genetic variant</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/projects/SNP rs368949613}\">rs368949613</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_014049.4:c.1249C&gt;T}\">NM_014049.4:c.1249C&gt;T</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48005-3}\">Amino acid change (pHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NP_054768.2:p.Arg417Cys}\">NP_054768.2:p.Arg417Cys</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48019-4}\">DNA change type</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6690-7}\">Substitution</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Genomic ref allele [ID]</span></p><p><b>value</b>: C</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81254-5}\">Genomic allele start-end</span></p><p><b>value</b>: 31731-31731</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69551-0}\">Genomic alt allele [ID]</span></p><p><b>value</b>: T</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48001-2}\">Cytogenetic (chromosome) location</span></p><p><b>value</b>: <span title=\"Codes:\">3q21</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class [Type]</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6683-2}\">Germline</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 53034-5}\">Allelic state</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6706-1}\">Heterozygous</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81258-6}\">Sample variant allelic frequency [NFr]</span></p><p><b>value</b>: 47 %<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code% = '%')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82121-5}\">Allelic read depth</span></p><p><b>value</b>: 208 1<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82155-3}\">Genomic structural variant copy number</span></p><p><b>value</b>: 1 1<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81301-4}\">Structural variant outer start and end</span></p><p><b>value</b>: 13200589-15592000</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81302-2}\">Structural variant inner start and end</span></p><p><b>value</b>: 14184616-15581544</p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2016",
        "issued" : "2016-09-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/ExampleSpecimen"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81252-9",
                  "display" : "Discrete genetic variant"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/clinvar",
                  "code" : "30880",
                  "display" : "NM_014049.4(ACAD9):c.1249C>T (p.Arg417Cys)"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:21497",
                  "display" : "ACAD9"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_014049.4"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48013-7"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NG_017064.1"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81290-9"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NC_000003.11:g.128625063C>T"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81252-9"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/projects/SNP",
                  "code" : "rs368949613"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_014049.4:c.1249C>T"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48005-3"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NP_054768.2:p.Arg417Cys"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48019-4"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6690-7",
                  "display" : "Substitution"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8"
                }
              ]
            },
            "valueString" : "C"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81254-5"
                }
              ]
            },
            "valueRange" : {
              "low" : {
                "value" : 31731
              },
              "high" : {
                "value" : 31731
              }
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69551-0"
                }
              ]
            },
            "valueString" : "T"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48001-2"
                }
              ]
            },
            "valueCodeableConcept" : {
              "text" : "3q21"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6683-2",
                  "display" : "Germline"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "53034-5"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6706-1",
                  "display" : "Heterozygous"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81258-6"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 47,
              "system" : "http://unitsofmeasure.org",
              "code" : "%"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "82121-5"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 208,
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "82155-3"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 1,
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81301-4"
                }
              ]
            },
            "valueRange" : {
              "low" : {
                "value" : 13200589
              },
              "high" : {
                "value" : 15592000
              }
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81302-2"
                }
              ]
            },
            "valueRange" : {
              "low" : {
                "value" : 14184616
              },
              "high" : {
                "value" : 15581544
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/dis-path-1a",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "dis-path-1a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_dis-path-1a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation dis-path-1a</b></p><a name=\"dis-path-1a\"> </a><a name=\"hcdis-path-1a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-diagnostic-implication.html\">Diagnostic Implication</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs diagnostic-implication}\">Diagnostic Implication</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2016</p><p><b>issued</b>: 2016-09-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_discrete-variant-1a\">Observation Genetic variant assessment</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 53037-8}\">Genetic variation clinical significance [Imp]</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6668-3}\">Pathogenic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81259-4}\">Associated phenotype</span></p><p><b>value</b>: <span title=\"Codes:{http://purl.obolibrary.org/obo/mondo.owl MONDO:0012624}\">acyl-CoA dehydrogenase 9 deficiency</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "diagnostic-implication"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2016",
        "issued" : "2016-09-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "derivedFrom" : [
          {
            "reference" : "Observation/discrete-variant-1a"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "53037-8"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6668-3",
                  "display" : "Pathogenic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81259-4"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://purl.obolibrary.org/obo/mondo.owl",
                  "code" : "MONDO:0012624",
                  "display" : "acyl-CoA dehydrogenase 9 deficiency"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/complex-variant-1a",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "complex-variant-1a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_complex-variant-1a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation complex-variant-1a</b></p><a name=\"complex-variant-1a\"> </a><a name=\"hccomplex-variant-1a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2016</p><p><b>issued</b>: 2016-09-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>specimen</b>: <a href=\"Specimen-ExampleSpecimen.html\">Specimen</a></p><p><b>hasMember</b>: </p><ul><li><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_complex-component-D-1a\">Observation Genetic variant assessment</a></li><li><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_complex-component-E-1a\">Observation Genetic variant assessment</a></li></ul></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2016",
        "issued" : "2016-09-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/ExampleSpecimen"
        },
        "hasMember" : [
          {
            "reference" : "Observation/complex-component-D-1a"
          },
          {
            "reference" : "Observation/complex-component-E-1a"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/complex-dis-path-1a",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "complex-dis-path-1a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_complex-dis-path-1a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation complex-dis-path-1a</b></p><a name=\"complex-dis-path-1a\"> </a><a name=\"hccomplex-dis-path-1a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-diagnostic-implication.html\">Diagnostic Implication</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs diagnostic-implication}\">Diagnostic Implication</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2016</p><p><b>issued</b>: 2016-09-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_complex-variant-1a\">Observation Genetic variant assessment</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 53037-8}\">Genetic variation clinical significance [Imp]</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6668-3}\">Pathogenic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81259-4}\">Associated phenotype</span></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 293498008}\">Debrisoquine adverse reaction (disorder)</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "diagnostic-implication"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2016",
        "issued" : "2016-09-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "derivedFrom" : [
          {
            "reference" : "Observation/complex-variant-1a"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "53037-8"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6668-3",
                  "display" : "Pathogenic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81259-4"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "293498008",
                  "display" : "Debrisoquine adverse reaction (disorder)"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/complex-component-D-1a",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "complex-component-D-1a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_complex-component-D-1a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation complex-component-D-1a</b></p><a name=\"complex-component-D-1a\"> </a><a name=\"hccomplex-component-D-1a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2016</p><p><b>issued</b>: 2016-09-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>specimen</b>: <a href=\"Specimen-ExampleSpecimen.html\">Specimen</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81252-9}\">Discrete genetic variant</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/clinvar 31934}\">NM_000106.5(CYP2D6):c.886C&gt;T (p.Arg296Cys)</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51958-7}\">Transcript reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NM_000106.5}\">NM_000106.5</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_000106.5:c.886C&gt;T}\">NM_000106.5:c.886C&gt;T</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48005-3}\">Amino acid change (pHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NP_000097.3:p.Arg296Cys}\">NP_000097.3:p.Arg296Cys</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48019-4}\">DNA change type</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6690-7}\">Substitution</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2016",
        "issued" : "2016-09-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/ExampleSpecimen"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81252-9",
                  "display" : "Discrete genetic variant"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/clinvar",
                  "code" : "31934",
                  "display" : "NM_000106.5(CYP2D6):c.886C>T (p.Arg296Cys)"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_000106.5"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_000106.5:c.886C>T"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48005-3"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NP_000097.3:p.Arg296Cys"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48019-4"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6690-7",
                  "display" : "Substitution"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/complex-component-E-1a",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "complex-component-E-1a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_complex-component-E-1a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation complex-component-E-1a</b></p><a name=\"complex-component-E-1a\"> </a><a name=\"hccomplex-component-E-1a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2016</p><p><b>issued</b>: 2016-09-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>specimen</b>: <a href=\"Specimen-ExampleSpecimen.html\">Specimen</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81252-9}\">Discrete genetic variant</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/clinvar 38486}\">NM_000106.5(CYP2D6):c.1457G&gt;C (p.Ser486Thr)</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51958-7}\">Transcript reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NM_000106.5}\">NM_000106.5</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_000106.5:c.1457G&gt;C}\">NM_000106.5:c.1457G&gt;C</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2016",
        "issued" : "2016-09-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/ExampleSpecimen"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81252-9",
                  "display" : "Discrete genetic variant"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/clinvar",
                  "code" : "38486",
                  "display" : "NM_000106.5(CYP2D6):c.1457G>C (p.Ser486Thr)"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_000106.5"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_000106.5:c.1457G>C"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/pharmPanel-1a",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "pharmPanel-1a",
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_pharmPanel-1a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation pharmPanel-1a</b></p><a name=\"pharmPanel-1a\"> </a><a name=\"hcpharmPanel-1a\"> </a><p><b>Recommended Action</b>: <a href=\"Bundle-bundle-cgexample-withGrouping.html#Task_usage-1a\">Task Increase dose</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl C43359}\">Group</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2016</p><p><b>issued</b>: 2016-09-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>hasMember</b>: </p><ul><li><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_haplotype-1a\">Observation Haplotype name</a></li><li><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_genotype-1a\">Observation Genotype display name</a></li><li><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_metab-1a\">Observation Therapeutic Implication</a></li><li><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_efficacy-1a\">Observation Therapeutic Implication</a></li></ul></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/recommended-action",
            "valueReference" : {
              "reference" : "Task/usage-1a"
            }
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl",
              "code" : "C43359",
              "display" : "Group"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2016",
        "issued" : "2016-09-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "hasMember" : [
          {
            "reference" : "Observation/haplotype-1a"
          },
          {
            "reference" : "Observation/genotype-1a"
          },
          {
            "reference" : "Observation/metab-1a"
          },
          {
            "reference" : "Observation/efficacy-1a"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/haplotype-1a",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "haplotype-1a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_haplotype-1a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation haplotype-1a</b></p><a name=\"haplotype-1a\"> </a><a name=\"hchaplotype-1a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-haplotype.html\">Haplotype</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84414-2}\">Haplotype name</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2016</p><p><b>issued</b>: 2016-09-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>value</b>: <span title=\"Codes:{http://www.ebi.ac.uk/ipd/imgt/hla *2}\">*2</span></p><p><b>specimen</b>: <a href=\"Specimen-ExampleSpecimen.html\">Specimen</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_discrete-variant-1a\">Observation Genetic variant assessment</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84414-2"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2016",
        "issued" : "2016-09-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.ebi.ac.uk/ipd/imgt/hla",
              "code" : "*2"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/ExampleSpecimen"
        },
        "derivedFrom" : [
          {
            "reference" : "Observation/discrete-variant-1a"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/genotype-1a",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "genotype-1a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_genotype-1a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation genotype-1a</b></p><a name=\"genotype-1a\"> </a><a name=\"hcgenotype-1a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-genotype.html\">Genotype</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84413-4}\">Genotype display name</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2016</p><p><b>issued</b>: 2016-09-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>value</b>: <span title=\"Codes:{http://www.pharmvar.org CYP2C9*2*5&quot;}\">CYP2C9 *2/*5</span></p><p><b>specimen</b>: <a href=\"Specimen-ExampleSpecimen.html\">Specimen</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_haplotype-1a\">Observation Haplotype name</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:2623}\">CYP2C9</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:23663}\">VKORC1</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84413-4"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2016",
        "issued" : "2016-09-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.pharmvar.org",
              "code" : "CYP2C9*2*5\"",
              "display" : "CYP2C9 *2/*5"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/ExampleSpecimen"
        },
        "derivedFrom" : [
          {
            "reference" : "Observation/haplotype-1a"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:2623",
                  "display" : "CYP2C9"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:23663",
                  "display" : "VKORC1"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/metab-1a",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "metab-1a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_metab-1a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation metab-1a</b></p><a name=\"metab-1a\"> </a><a name=\"hcmetab-1a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-therapeutic-implication.html\">Therapeutic Implication</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2016</p><p><b>issued</b>: 2016-09-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_genotype-1a\">Observation Genotype display name</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51963-7}\">Medication assessed [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.nlm.nih.gov/research/umls/rxnorm 11289}\">Warfarin</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA25390-8}\">Rapid metabolizer</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "therapeutic-implication"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2016",
        "issued" : "2016-09-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "derivedFrom" : [
          {
            "reference" : "Observation/genotype-1a"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51963-7"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
                  "code" : "11289",
                  "display" : "Warfarin"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "therapeutic-implication"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA25390-8",
                  "display" : "Rapid metabolizer"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/efficacy-1a",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "efficacy-1a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_efficacy-1a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation efficacy-1a</b></p><a name=\"efficacy-1a\"> </a><a name=\"hcefficacy-1a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-therapeutic-implication.html\">Therapeutic Implication</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2016</p><p><b>issued</b>: 2016-09-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_genotype-1a\">Observation Genotype display name</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6676-6}\">Resistant</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51963-7}\">Medication assessed [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.nlm.nih.gov/research/umls/rxnorm 11289}\">Warfarin</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "therapeutic-implication"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2016",
        "issued" : "2016-09-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "derivedFrom" : [
          {
            "reference" : "Observation/genotype-1a"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "therapeutic-implication"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6676-6",
                  "display" : "Resistant"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51963-7"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
                  "code" : "11289",
                  "display" : "Warfarin"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/highrisk-1a",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "highrisk-1a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_highrisk-1a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation highrisk-1a</b></p><a name=\"highrisk-1a\"> </a><a name=\"hchighrisk-1a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-therapeutic-implication.html\">Therapeutic Implication</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>subject</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>effective</b>: 2016</p><p><b>issued</b>: 2016-09-06 00:00:00-0500</p><p><b>performer</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_genotype-1a\">Observation Genotype display name</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs therapeutic-implication}\">Therapeutic Implication</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA19542-2}\">Low risk</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51963-7}\">Medication assessed [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.nlm.nih.gov/research/umls/rxnorm 11289}\">Warfarin</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "therapeutic-implication"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ExamplePatient"
        },
        "effectiveDateTime" : "2016",
        "issued" : "2016-09-06T00:00:00-05:00",
        "performer" : [
          {
            "reference" : "Organization/ExampleLab"
          }
        ],
        "derivedFrom" : [
          {
            "reference" : "Observation/genotype-1a"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "therapeutic-implication"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA19542-2",
                  "display" : "Low risk"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51963-7"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
                  "code" : "11289",
                  "display" : "Warfarin"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Task/usage-1a",
      "resource" : {
        "resourceType" : "Task",
        "id" : "usage-1a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/medication-recommendation"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Task_usage-1a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Task usage-1a</b></p><a name=\"usage-1a\"> </a><a name=\"hcusage-1a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-medication-recommendation.html\">Medication Recommendation</a></p></div><p><b>status</b>: Requested</p><p><b>intent</b>: proposal</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org LA26423-6}\">May need higher dosage than usual.</span></p><p><b>focus</b>: <a href=\"MedicationStatement-MedicationStatementWarfarin.html\">MedicationStatement: status = recorded</a></p><p><b>for</b>: <a href=\"Patient-ExamplePatient.html\">Anonymous Patient (no stated gender), DoB Unknown</a></p><p><b>requester</b>: <a href=\"Organization-ExampleLab.html\">Organization Some lab</a></p><h3>Reasons</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Reference</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Bundle-bundle-cgexample-withGrouping.html#Observation_metab-1a\">Observation Therapeutic Implication</a></td></tr></table></div>"
        },
        "status" : "requested",
        "intent" : "proposal",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26423-6",
              "display" : "Increase dose"
            }
          ],
          "text" : "May need higher dosage than usual."
        },
        "focus" : {
          "reference" : "MedicationStatement/MedicationStatementWarfarin"
        },
        "for" : {
          "reference" : "Patient/ExamplePatient"
        },
        "requester" : {
          "reference" : "Organization/ExampleLab"
        },
        "reason" : [
          {
            "reference" : {
              "reference" : "Observation/metab-1a"
            }
          }
        ]
      }
    }
  ]
}

```
