# bundle-CG-IG-HLA-FullBundle-01 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **bundle-CG-IG-HLA-FullBundle-01**

## Example Bundle: bundle-CG-IG-HLA-FullBundle-01

Bundle bundle-CG-IG-HLA-FullBundle-01 of type transaction

-------

Entry 1 - fullUrl = urn:uuid:13f34265-335c-4853-bc38-0815315edafa

Resource Patient:

> John Storm(official) Male, DoB: 1986-12-31 ( Donor Registration Number (use: usual, period: 2012-11-10 --> (ongoing)))
-------

Request:

```
POST Patient

```

-------

Entry 2 - fullUrl = urn:uuid:e44fbe33-6084-4ae2-a95e-8bc451c63340

Resource Specimen:

> **identifier**:`http://example.org`/123**accessionIdentifier**:`http://example.org`/456**type**:Venous blood specimen**subject**:[John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-13f34265-335c-4853-bc38-0815315edafa)

Request:

```
POST Specimen

```

-------

Entry 3 - fullUrl = urn:uuid:9243cc20-27bd-4f87-ba90-0328ed474950

Resource Organization:

> **name**: aTypingLab Inc**alias**: aTL

### Contacts

| | | |
| :--- | :--- | :--- |
| - | **Telecom** | **Address** |
| * | ph: 1-800-555-1234(Work) | 123 Main St, Sometown, ND 99999(work) |


Request:

```
POST Organization

```

-------

Entry 4 - fullUrl = urn:uuid:00ef18ad-ed04-4b2c-81ee-b69bb243f0d5

Resource Organization:

> **name**: aDonorRegistry**alias**: ADR

### Contacts

| | | |
| :--- | :--- | :--- |
| - | **Telecom** | **Address** |
| * | ph: 1-800-555-6789(Work) | 456 Main St, Anytown ND, 00000(work) |


Request:

```
POST Organization

```

-------

Entry 5 - fullUrl = urn:uuid:99309303-045e-4cf4-90d7-250d7a7476ea

Resource ServiceRequest:

> **status**: Completed**intent**: Order

### Codes

| | |
| :--- | :--- |
| - | **Concept** |
| * | HLA-A+B+C (class I) [Type] |

**subject**:[John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-13f34265-335c-4853-bc38-0815315edafa)**authoredOn**: 2016-11-15**requester**:[aDonorRegistry](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-00ef18ad-ed04-4b2c-81ee-b69bb243f0d5)**performer**:[aTypingLab, Inc](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950)

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | tissue typing for donor registry |


Request:

```
POST ServiceRequest

```

-------

Entry 6 - fullUrl = urn:uuid:b7765bbf-df40-486a-9f2f-404309643de6

Resource Observation:

> 

Profile: [Haplotype](StructureDefinition-haplotype.md)

**status**: Final**category**:Laboratory,Genetics**code**:Haplotype name**subject**:[John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-13f34265-335c-4853-bc38-0815315edafa)**effective**: 2016-12-15**performer**:[aTypingLab, Inc](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950)**value**:HLA-A*01:01:01G**method**:NGS based Class I HLA-A, -B, -C genotyping**specimen**:[buccal swab from John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied [ID] | HLA-A |


Request:

```
POST Observation

```

-------

Entry 7 - fullUrl = urn:uuid:d98d92a7-0e86-4ae5-b036-b7e1bba6ec32

Resource Observation:

> 

Profile: [Haplotype](StructureDefinition-haplotype.md)

**status**: Final**category**:Laboratory,Genetics**code**:Haplotype name**subject**:[John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-13f34265-335c-4853-bc38-0815315edafa)**effective**: 2016-12-15**performer**:[aTypingLab, Inc](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950)**value**:HLA-A*01:02**method**:NGS based Class I HLA-A, -B, -C genotyping**specimen**:[buccal swab from John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied [ID] | HLA-A |


Request:

```
POST Observation

```

-------

Entry 8 - fullUrl = urn:uuid:49a86246-4004-42eb-9bdc-f542f93f9228

Resource Observation:

> 

Profile: [Genotype](StructureDefinition-genotype.md)

**basedOn**:[Class I HLA genotyping for John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-99309303-045e-4cf4-90d7-250d7a7476ea)**status**: Final**category**:Laboratory,Genetics**code**:Genotype display name**subject**:[John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-13f34265-335c-4853-bc38-0815315edafa)**effective**: 2016-12-15**performer**:[aTypingLab, Inc](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950)**value**:hla#3.23.0#HLA-A:01:01G+HLA-A*01:02**method**:NGS based Class I HLA-A, -B, -C genotyping**specimen**:[buccal swab from John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340)**derivedFrom**:
* [HLA-A*01:01:01G, exons 2 and 3](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-b7765bbf-df40-486a-9f2f-404309643de6)
* [HLA-A*01:02, exons 2 and 3](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-d98d92a7-0e86-4ae5-b036-b7e1bba6ec32)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied [ID] | HLA-A |


Request:

```
POST Observation

```

-------

Entry 9 - fullUrl = urn:uuid:e2092243-2970-49d2-a90f-b90d1d49715a

Resource Observation:

> 

Profile: [Haplotype](StructureDefinition-haplotype.md)

**status**: Final**category**:Laboratory,Genetics**code**:Haplotype name**subject**:[John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-13f34265-335c-4853-bc38-0815315edafa)**effective**: 2016-12-15**performer**:[aTypingLab, Inc](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950)**value**:HLA-B*15:01:01G**method**:NGS based Class I HLA-A, -B, -C genotyping**specimen**:[buccal swab from John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied [ID] | HLA-B |


Request:

```
POST Observation

```

-------

Entry 10 - fullUrl = urn:uuid:792be53e-d4fb-4887-a367-815ef6c706e5

Resource Observation:

> 

Profile: [Haplotype](StructureDefinition-haplotype.md)

**status**: Final**category**:Laboratory,Genetics**code**:Haplotype name**subject**:[John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-13f34265-335c-4853-bc38-0815315edafa)**effective**: 2016-12-15**performer**:[aTypingLab, Inc](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950)**value**:HLA-B*57:01:01G**method**:NGS based Class I HLA-A, -B, -C genotyping**specimen**:[buccal swab from John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied [ID] | HLA-B |


Request:

```
POST Observation

```

-------

Entry 11 - fullUrl = urn:uuid:60613a43-c4cb-4502-b3e2-cf9215feaa70

Resource Observation:

> 

Profile: [Genotype](StructureDefinition-genotype.md)

**basedOn**:[Class I HLA genotyping for John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-99309303-045e-4cf4-90d7-250d7a7476ea)**status**: Final**category**:Laboratory,Genetics**code**:Genotype display name**subject**:[John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-13f34265-335c-4853-bc38-0815315edafa)**effective**: 2016-12-15**performer**:[aTypingLab, Inc](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950)**value**:hla#3.23.0#HLA-B*15:01:01G+HLA-B*57:01:01G**method**:NGS based Class I HLA-A, -B, -C genotyping**specimen**:[buccal swab from John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340)**derivedFrom**:
* [HLA-B*15:01:01G, exons 2 and 3](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-e2092243-2970-49d2-a90f-b90d1d49715a)
* [HLA-B*57:01:01G, exons 2 and 3](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-792be53e-d4fb-4887-a367-815ef6c706e5)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied [ID] | HLA-B |


Request:

```
POST Observation

```

-------

Entry 12 - fullUrl = urn:uuid:709c5315-9403-4867-9d82-0b953836665f

Resource Observation:

> 

Profile: [Haplotype](StructureDefinition-haplotype.md)

**status**: Final**category**:Laboratory,Genetics**code**:Haplotype name**subject**:[John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-13f34265-335c-4853-bc38-0815315edafa)**effective**: 2016-12-15**performer**:[aTypingLab, Inc](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950)**value**:HLA-C*01:02:01G**method**:NGS based Class I HLA-A, -B, -C genotyping**specimen**:[buccal swab from John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied [ID] | HLA-C |


Request:

```
POST Observation

```

-------

Entry 13 - fullUrl = urn:uuid:8b2aa21c-1426-4717-8ab0-a84d83df7d47

Resource Observation:

> 

Profile: [Haplotype](StructureDefinition-haplotype.md)

**status**: Final**category**:Laboratory,Genetics**code**:Haplotype name**subject**:[John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-13f34265-335c-4853-bc38-0815315edafa)**effective**: 2016-12-15**performer**:[aTypingLab, Inc](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950)**value**:HLA-C*01:02:01G**method**:NGS based Class I HLA-A, -B, -C genotyping**specimen**:[buccal swab from John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied [ID] | HLA-C |


Request:

```
POST Observation

```

-------

Entry 14 - fullUrl = urn:uuid:0e0a780e-4486-4cd0-bfae-7243c579f208

Resource Observation:

> 

Profile: [Genotype](StructureDefinition-genotype.md)

**basedOn**:[Class I HLA genotyping for John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-99309303-045e-4cf4-90d7-250d7a7476ea)**status**: Final**category**:Laboratory,Genetics**code**:Genotype display name**subject**:[John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-13f34265-335c-4853-bc38-0815315edafa)**effective**: 2016-12-15**performer**:[aTypingLab, Inc](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950)**value**:hla#3.23.0#HLA-C*01:02:01G+HLA-C*03:04:01G**method**:NGS based Class I HLA-A, -B, -C genotyping**specimen**:[buccal swab from John Storm](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340)**derivedFrom**:
* [HLA-C*03:04:01G, exons 2 and 3](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-8b2aa21c-1426-4717-8ab0-a84d83df7d47)
* [HLA-C*01:02:01G, exons 2 and 3](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-709c5315-9403-4867-9d82-0b953836665f)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied [ID] | HLA-C |


Request:

```
POST Observation

```

-------

Entry 15 - fullUrl = urn:uuid:b0a4b18e-94e7-4b1b-8031-c7ae4bdd8db9

Resource DiagnosticReport:

> 

Profile: [Genomic Report](StructureDefinition-genomic-report.md)

## Genetic analysis report (Genetics ) 

| | |
| :--- | :--- |
| Subject | John Storm(official) Male, DoB: 1986-12-31 ( Donor Registration Number (use: usual, period: 2012-11-10 --> (ongoing))) |
| When For | 2016-12-15 |
| Reported | 2016-12-15 14:15:30-0600 |
| Performer | [aTypingLab Inc](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950) |

**Report Details**

* **Code**: [Genotype display name](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-49a86246-4004-42eb-9bdc-f542f93f9228)
  * **Value**: hla#3.23.0#HLA-A:01:01G+HLA-A*01:02
  * **Flags**: Final
* **Code**: [Genotype display name](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-60613a43-c4cb-4502-b3e2-cf9215feaa70)
  * **Value**: hla#3.23.0#HLA-B*15:01:01G+HLA-B*57:01:01G
  * **Flags**: Final
* **Code**: [Genotype display name](Bundle-bundle-CG-IG-HLA-FullBundle-01.md#urn-uuid-0e0a780e-4486-4cd0-bfae-7243c579f208)
  * **Value**: hla#3.23.0#HLA-C*01:02:01G+HLA-C*03:04:01G
  * **Flags**: Final


Request:

```
POST DiagnosticReport

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "bundle-CG-IG-HLA-FullBundle-01",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:13f34265-335c-4853-bc38-0815315edafa",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "CG-IG-HLA-FullBundle-01-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_CG-IG-HLA-FullBundle-01-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient CG-IG-HLA-FullBundle-01-1</b></p><a name=\"CG-IG-HLA-FullBundle-01-1\"> </a><a name=\"hcCG-IG-HLA-FullBundle-01-1\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">John Storm(official) Male, DoB: 1986-12-31 ( Donor Registration Number (use: usual, period: 2012-11-10 --&gt; (ongoing)))</p><hr/></div>"
        },
        "identifier" : [
          {
            "use" : "usual",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "DR"
                }
              ]
            },
            "system" : "http://example.org",
            "value" : "12345",
            "period" : {
              "start" : "2012-11-10"
            },
            "assigner" : {
              "display" : "aDonorRegistry"
            }
          }
        ],
        "name" : [
          {
            "use" : "official",
            "text" : "John Storm",
            "family" : "Storm",
            "given" : ["John"]
          },
          {
            "use" : "nickname",
            "text" : "Johnny Storm",
            "family" : "Storm",
            "given" : ["Johnny"]
          },
          {
            "use" : "nickname",
            "text" : "The Human Torch"
          }
        ],
        "gender" : "male",
        "birthDate" : "1986-12-31"
      },
      "request" : {
        "method" : "POST",
        "url" : "Patient"
      }
    },
    {
      "fullUrl" : "urn:uuid:e44fbe33-6084-4ae2-a95e-8bc451c63340",
      "resource" : {
        "resourceType" : "Specimen",
        "id" : "CG-IG-HLA-FullBundle-01-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Specimen_CG-IG-HLA-FullBundle-01-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Specimen CG-IG-HLA-FullBundle-01-2</b></p><a name=\"CG-IG-HLA-FullBundle-01-2\"> </a><a name=\"hcCG-IG-HLA-FullBundle-01-2\"> </a><p><b>identifier</b>: <code>http://example.org</code>/123</p><p><b>accessionIdentifier</b>: <code>http://example.org</code>/456</p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 122555007}\">Venous blood specimen</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-13f34265-335c-4853-bc38-0815315edafa\">John Storm</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://example.org",
            "value" : "123"
          }
        ],
        "accessionIdentifier" : {
          "system" : "http://example.org",
          "value" : "456"
        },
        "type" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "122555007",
              "display" : "Venous blood specimen"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:13f34265-335c-4853-bc38-0815315edafa",
          "type" : "Patient",
          "display" : "John Storm"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Specimen"
      }
    },
    {
      "fullUrl" : "urn:uuid:9243cc20-27bd-4f87-ba90-0328ed474950",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "CG-IG-HLA-FullBundle-01-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_CG-IG-HLA-FullBundle-01-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization CG-IG-HLA-FullBundle-01-3</b></p><a name=\"CG-IG-HLA-FullBundle-01-3\"> </a><a name=\"hcCG-IG-HLA-FullBundle-01-3\"> </a><p><b>name</b>: aTypingLab Inc</p><p><b>alias</b>: aTL</p><h3>Contacts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Telecom</b></td><td><b>Address</b></td></tr><tr><td style=\"display: none\">*</td><td>ph: 1-800-555-1234(Work)</td><td>123 Main St, Sometown, ND 99999(work)</td></tr></table></div>"
        },
        "name" : "aTypingLab Inc",
        "alias" : ["aTL"],
        "contact" : [
          {
            "telecom" : [
              {
                "system" : "phone",
                "value" : "1-800-555-1234",
                "use" : "work",
                "rank" : 1
              }
            ],
            "address" : {
              "use" : "work",
              "type" : "physical",
              "text" : "123 Main St, Sometown, ND 99999",
              "line" : ["123 Main St"],
              "city" : "Sometown",
              "state" : "ND",
              "postalCode" : "99999",
              "country" : "USA"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Organization"
      }
    },
    {
      "fullUrl" : "urn:uuid:00ef18ad-ed04-4b2c-81ee-b69bb243f0d5",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "CG-IG-HLA-FullBundle-01-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_CG-IG-HLA-FullBundle-01-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization CG-IG-HLA-FullBundle-01-4</b></p><a name=\"CG-IG-HLA-FullBundle-01-4\"> </a><a name=\"hcCG-IG-HLA-FullBundle-01-4\"> </a><p><b>name</b>: aDonorRegistry</p><p><b>alias</b>: ADR</p><h3>Contacts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Telecom</b></td><td><b>Address</b></td></tr><tr><td style=\"display: none\">*</td><td>ph: 1-800-555-6789(Work)</td><td>456 Main St, Anytown ND, 00000(work)</td></tr></table></div>"
        },
        "name" : "aDonorRegistry",
        "alias" : ["ADR"],
        "contact" : [
          {
            "telecom" : [
              {
                "system" : "phone",
                "value" : "1-800-555-6789",
                "use" : "work",
                "rank" : 1
              }
            ],
            "address" : {
              "use" : "work",
              "type" : "physical",
              "text" : "456 Main St, Anytown ND, 00000",
              "line" : ["456 Main St"],
              "city" : "Anytown",
              "state" : "ND",
              "postalCode" : "00000",
              "country" : "USA"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Organization"
      }
    },
    {
      "fullUrl" : "urn:uuid:99309303-045e-4cf4-90d7-250d7a7476ea",
      "resource" : {
        "resourceType" : "ServiceRequest",
        "id" : "CG-IG-HLA-FullBundle-01-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ServiceRequest_CG-IG-HLA-FullBundle-01-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ServiceRequest CG-IG-HLA-FullBundle-01-5</b></p><a name=\"CG-IG-HLA-FullBundle-01-5\"> </a><a name=\"hcCG-IG-HLA-FullBundle-01-5\"> </a><p><b>status</b>: Completed</p><p><b>intent</b>: Order</p><h3>Codes</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 13303-3}\">HLA-A+B+C (class I) [Type]</span></td></tr></table><p><b>subject</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-13f34265-335c-4853-bc38-0815315edafa\">John Storm</a></p><p><b>authoredOn</b>: 2016-11-15</p><p><b>requester</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-00ef18ad-ed04-4b2c-81ee-b69bb243f0d5\">aDonorRegistry</a></p><p><b>performer</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950\">aTypingLab, Inc</a></p><h3>Reasons</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:\">tissue typing for donor registry</span></td></tr></table></div>"
        },
        "status" : "completed",
        "intent" : "order",
        "code" : {
          "concept" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "13303-3",
                "display" : "HLA-A+B+C (class I) [Type]"
              }
            ]
          }
        },
        "subject" : {
          "reference" : "urn:uuid:13f34265-335c-4853-bc38-0815315edafa",
          "type" : "Patient",
          "display" : "John Storm"
        },
        "authoredOn" : "2016-11-15",
        "requester" : {
          "reference" : "urn:uuid:00ef18ad-ed04-4b2c-81ee-b69bb243f0d5",
          "type" : "Organization",
          "display" : "aDonorRegistry"
        },
        "performer" : [
          {
            "reference" : "urn:uuid:9243cc20-27bd-4f87-ba90-0328ed474950",
            "type" : "Organization",
            "display" : "aTypingLab, Inc"
          }
        ],
        "reason" : [
          {
            "concept" : {
              "text" : "tissue typing for donor registry"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "ServiceRequest"
      }
    },
    {
      "fullUrl" : "urn:uuid:b7765bbf-df40-486a-9f2f-404309643de6",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "CG-IG-HLA-FullBundle-01-10",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_CG-IG-HLA-FullBundle-01-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation CG-IG-HLA-FullBundle-01-10</b></p><a name=\"CG-IG-HLA-FullBundle-01-10\"> </a><a name=\"hcCG-IG-HLA-FullBundle-01-10\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-haplotype.html\">Haplotype</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84414-2}\">Haplotype name</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-13f34265-335c-4853-bc38-0815315edafa\">John Storm</a></p><p><b>effective</b>: 2016-12-15</p><p><b>performer</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950\">aTypingLab, Inc</a></p><p><b>value</b>: <span title=\"Codes:{http://www.ebi.ac.uk/ipd/imgt/hla HLA-A*01:01:01G}\">HLA-A*01:01:01G</span></p><p><b>method</b>: <span title=\"Codes:{https://www.ncbi.nlm.nih.gov/gtr GTR000000000.0}\">NGS based Class I HLA-A, -B, -C genotyping</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340\">buccal swab from John Storm</a></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></td><td><span title=\"Codes:{http://www.genenames.org HGNC:4931}\">HLA-A</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84414-2",
              "display" : "Haplotype name"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:13f34265-335c-4853-bc38-0815315edafa",
          "type" : "Patient",
          "display" : "John Storm"
        },
        "effectiveDateTime" : "2016-12-15",
        "performer" : [
          {
            "reference" : "urn:uuid:9243cc20-27bd-4f87-ba90-0328ed474950",
            "display" : "aTypingLab, Inc"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.ebi.ac.uk/ipd/imgt/hla",
              "version" : "3.23",
              "code" : "HLA-A*01:01:01G",
              "display" : "HLA-A*01:01:01G"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "https://www.ncbi.nlm.nih.gov/gtr",
              "code" : "GTR000000000.0"
            }
          ],
          "text" : "NGS based Class I HLA-A, -B, -C genotyping"
        },
        "specimen" : {
          "reference" : "urn:uuid:e44fbe33-6084-4ae2-a95e-8bc451c63340",
          "display" : "buccal swab from John Storm"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:4931",
                  "display" : "HLA-A"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:d98d92a7-0e86-4ae5-b036-b7e1bba6ec32",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "CG-IG-HLA-FullBundle-01-11",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_CG-IG-HLA-FullBundle-01-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation CG-IG-HLA-FullBundle-01-11</b></p><a name=\"CG-IG-HLA-FullBundle-01-11\"> </a><a name=\"hcCG-IG-HLA-FullBundle-01-11\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-haplotype.html\">Haplotype</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84414-2}\">Haplotype name</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-13f34265-335c-4853-bc38-0815315edafa\">John Storm</a></p><p><b>effective</b>: 2016-12-15</p><p><b>performer</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950\">aTypingLab, Inc</a></p><p><b>value</b>: <span title=\"Codes:{http://www.ebi.ac.uk/ipd/imgt/hla HLA-A*01:02}\">HLA-A*01:02</span></p><p><b>method</b>: <span title=\"Codes:{https://www.ncbi.nlm.nih.gov/gtr GTR000000000.0}\">NGS based Class I HLA-A, -B, -C genotyping</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340\">buccal swab from John Storm</a></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></td><td><span title=\"Codes:{http://www.genenames.org HGNC:4931}\">HLA-A</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84414-2",
              "display" : "Haplotype name"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:13f34265-335c-4853-bc38-0815315edafa",
          "type" : "Patient",
          "display" : "John Storm"
        },
        "effectiveDateTime" : "2016-12-15",
        "performer" : [
          {
            "reference" : "urn:uuid:9243cc20-27bd-4f87-ba90-0328ed474950",
            "display" : "aTypingLab, Inc"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.ebi.ac.uk/ipd/imgt/hla",
              "version" : "3.23",
              "code" : "HLA-A*01:02",
              "display" : "HLA-A*01:02"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "https://www.ncbi.nlm.nih.gov/gtr",
              "code" : "GTR000000000.0"
            }
          ],
          "text" : "NGS based Class I HLA-A, -B, -C genotyping"
        },
        "specimen" : {
          "reference" : "urn:uuid:e44fbe33-6084-4ae2-a95e-8bc451c63340",
          "display" : "buccal swab from John Storm"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:4931",
                  "display" : "HLA-A"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:49a86246-4004-42eb-9bdc-f542f93f9228",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "CG-IG-HLA-FullBundle-01-12",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_CG-IG-HLA-FullBundle-01-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation CG-IG-HLA-FullBundle-01-12</b></p><a name=\"CG-IG-HLA-FullBundle-01-12\"> </a><a name=\"hcCG-IG-HLA-FullBundle-01-12\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-genotype.html\">Genotype</a></p></div><p><b>basedOn</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-99309303-045e-4cf4-90d7-250d7a7476ea\">Class I HLA genotyping for John Storm</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84413-4}\">Genotype display name</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-13f34265-335c-4853-bc38-0815315edafa\">John Storm</a></p><p><b>effective</b>: 2016-12-15</p><p><b>performer</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950\">aTypingLab, Inc</a></p><p><b>value</b>: <span title=\"Codes:{http://glstring.org hla#3.23.0#HLA-A:01:01G+HLA-A*01:02}\">hla#3.23.0#HLA-A:01:01G+HLA-A*01:02</span></p><p><b>method</b>: <span title=\"Codes:{https://www.ncbi.nlm.nih.gov/gtr GTR000000000.0}\">NGS based Class I HLA-A, -B, -C genotyping</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340\">buccal swab from John Storm</a></p><p><b>derivedFrom</b>: </p><ul><li><a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-b7765bbf-df40-486a-9f2f-404309643de6\">HLA-A*01:01:01G, exons 2 and 3</a></li><li><a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-d98d92a7-0e86-4ae5-b036-b7e1bba6ec32\">HLA-A*01:02, exons 2 and 3</a></li></ul><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></td><td><span title=\"Codes:{http://www.genenames.org HGNC:4931}\">HLA-A</span></td></tr></table></div>"
        },
        "basedOn" : [
          {
            "reference" : "urn:uuid:99309303-045e-4cf4-90d7-250d7a7476ea",
            "type" : "ServiceRequest",
            "display" : "Class I HLA genotyping for John Storm"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84413-4",
              "display" : "Genotype display name"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:13f34265-335c-4853-bc38-0815315edafa",
          "type" : "Patient",
          "display" : "John Storm"
        },
        "effectiveDateTime" : "2016-12-15",
        "performer" : [
          {
            "reference" : "urn:uuid:9243cc20-27bd-4f87-ba90-0328ed474950",
            "display" : "aTypingLab, Inc"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://glstring.org",
              "version" : "1.0",
              "code" : "hla#3.23.0#HLA-A:01:01G+HLA-A*01:02"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "https://www.ncbi.nlm.nih.gov/gtr",
              "code" : "GTR000000000.0"
            }
          ],
          "text" : "NGS based Class I HLA-A, -B, -C genotyping"
        },
        "specimen" : {
          "reference" : "urn:uuid:e44fbe33-6084-4ae2-a95e-8bc451c63340",
          "display" : "buccal swab from John Storm"
        },
        "derivedFrom" : [
          {
            "reference" : "urn:uuid:b7765bbf-df40-486a-9f2f-404309643de6",
            "type" : "Observation",
            "display" : "HLA-A*01:01:01G, exons 2 and 3"
          },
          {
            "reference" : "urn:uuid:d98d92a7-0e86-4ae5-b036-b7e1bba6ec32",
            "type" : "Observation",
            "display" : "HLA-A*01:02, exons 2 and 3"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:4931",
                  "display" : "HLA-A"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:e2092243-2970-49d2-a90f-b90d1d49715a",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "CG-IG-HLA-FullBundle-01-17",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_CG-IG-HLA-FullBundle-01-17\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation CG-IG-HLA-FullBundle-01-17</b></p><a name=\"CG-IG-HLA-FullBundle-01-17\"> </a><a name=\"hcCG-IG-HLA-FullBundle-01-17\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-haplotype.html\">Haplotype</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84414-2}\">Haplotype name</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-13f34265-335c-4853-bc38-0815315edafa\">John Storm</a></p><p><b>effective</b>: 2016-12-15</p><p><b>performer</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950\">aTypingLab, Inc</a></p><p><b>value</b>: <span title=\"Codes:{http://www.ebi.ac.uk/ipd/imgt/hla HGG00041}\">HLA-B*15:01:01G</span></p><p><b>method</b>: <span title=\"Codes:{https://www.ncbi.nlm.nih.gov/gtr GTR000000000.0}\">NGS based Class I HLA-A, -B, -C genotyping</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340\">buccal swab from John Storm</a></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></td><td><span title=\"Codes:{http://www.genenames.org HGNC:4932}\">HLA-B</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84414-2",
              "display" : "Haplotype name"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:13f34265-335c-4853-bc38-0815315edafa",
          "type" : "Patient",
          "display" : "John Storm"
        },
        "effectiveDateTime" : "2016-12-15",
        "performer" : [
          {
            "reference" : "urn:uuid:9243cc20-27bd-4f87-ba90-0328ed474950",
            "display" : "aTypingLab, Inc"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.ebi.ac.uk/ipd/imgt/hla",
              "version" : "3.23",
              "code" : "HGG00041",
              "display" : "HLA-B*15:01:01G"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "https://www.ncbi.nlm.nih.gov/gtr",
              "code" : "GTR000000000.0"
            }
          ],
          "text" : "NGS based Class I HLA-A, -B, -C genotyping"
        },
        "specimen" : {
          "reference" : "urn:uuid:e44fbe33-6084-4ae2-a95e-8bc451c63340",
          "display" : "buccal swab from John Storm"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:4932",
                  "display" : "HLA-B"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:792be53e-d4fb-4887-a367-815ef6c706e5",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "CG-IG-HLA-FullBundle-01-18",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_CG-IG-HLA-FullBundle-01-18\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation CG-IG-HLA-FullBundle-01-18</b></p><a name=\"CG-IG-HLA-FullBundle-01-18\"> </a><a name=\"hcCG-IG-HLA-FullBundle-01-18\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-haplotype.html\">Haplotype</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84414-2}\">Haplotype name</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-13f34265-335c-4853-bc38-0815315edafa\">John Storm</a></p><p><b>effective</b>: 2016-12-15</p><p><b>performer</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950\">aTypingLab, Inc</a></p><p><b>value</b>: <span title=\"Codes:{http://www.ebi.ac.uk/ipd/imgt/hla HLA-B*57:01:01G}\">HLA-B*57:01:01G</span></p><p><b>method</b>: <span title=\"Codes:{https://www.ncbi.nlm.nih.gov/gtr GTR000000000.0}\">NGS based Class I HLA-A, -B, -C genotyping</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340\">buccal swab from John Storm</a></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></td><td><span title=\"Codes:{http://www.genenames.org HGNC:4932}\">HLA-B</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84414-2",
              "display" : "Haplotype name"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:13f34265-335c-4853-bc38-0815315edafa",
          "type" : "Patient",
          "display" : "John Storm"
        },
        "effectiveDateTime" : "2016-12-15",
        "performer" : [
          {
            "reference" : "urn:uuid:9243cc20-27bd-4f87-ba90-0328ed474950",
            "display" : "aTypingLab, Inc"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.ebi.ac.uk/ipd/imgt/hla",
              "version" : "3.23",
              "code" : "HLA-B*57:01:01G",
              "display" : "HLA-B*57:01:01G"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "https://www.ncbi.nlm.nih.gov/gtr",
              "code" : "GTR000000000.0"
            }
          ],
          "text" : "NGS based Class I HLA-A, -B, -C genotyping"
        },
        "specimen" : {
          "reference" : "urn:uuid:e44fbe33-6084-4ae2-a95e-8bc451c63340",
          "display" : "buccal swab from John Storm"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:4932",
                  "display" : "HLA-B"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:60613a43-c4cb-4502-b3e2-cf9215feaa70",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "CG-IG-HLA-FullBundle-01-19",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_CG-IG-HLA-FullBundle-01-19\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation CG-IG-HLA-FullBundle-01-19</b></p><a name=\"CG-IG-HLA-FullBundle-01-19\"> </a><a name=\"hcCG-IG-HLA-FullBundle-01-19\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-genotype.html\">Genotype</a></p></div><p><b>basedOn</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-99309303-045e-4cf4-90d7-250d7a7476ea\">Class I HLA genotyping for John Storm</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84413-4}\">Genotype display name</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-13f34265-335c-4853-bc38-0815315edafa\">John Storm</a></p><p><b>effective</b>: 2016-12-15</p><p><b>performer</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950\">aTypingLab, Inc</a></p><p><b>value</b>: <span title=\"Codes:{http://glstring.org hla#3.23.0#HLA-B*15:01:01G+HLA-B*57:01:01G}\">hla#3.23.0#HLA-B*15:01:01G+HLA-B*57:01:01G</span></p><p><b>method</b>: <span title=\"Codes:{https://www.ncbi.nlm.nih.gov/gtr GTR000000000.0}\">NGS based Class I HLA-A, -B, -C genotyping</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340\">buccal swab from John Storm</a></p><p><b>derivedFrom</b>: </p><ul><li><a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-e2092243-2970-49d2-a90f-b90d1d49715a\">HLA-B*15:01:01G, exons 2 and 3</a></li><li><a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-792be53e-d4fb-4887-a367-815ef6c706e5\">HLA-B*57:01:01G, exons 2 and 3</a></li></ul><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></td><td><span title=\"Codes:{http://www.genenames.org HGNC:4932}\">HLA-B</span></td></tr></table></div>"
        },
        "basedOn" : [
          {
            "reference" : "urn:uuid:99309303-045e-4cf4-90d7-250d7a7476ea",
            "type" : "ServiceRequest",
            "display" : "Class I HLA genotyping for John Storm"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84413-4",
              "display" : "Genotype display name"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:13f34265-335c-4853-bc38-0815315edafa",
          "type" : "Patient",
          "display" : "John Storm"
        },
        "effectiveDateTime" : "2016-12-15",
        "performer" : [
          {
            "reference" : "urn:uuid:9243cc20-27bd-4f87-ba90-0328ed474950",
            "display" : "aTypingLab, Inc"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://glstring.org",
              "version" : "1.0",
              "code" : "hla#3.23.0#HLA-B*15:01:01G+HLA-B*57:01:01G"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "https://www.ncbi.nlm.nih.gov/gtr",
              "code" : "GTR000000000.0"
            }
          ],
          "text" : "NGS based Class I HLA-A, -B, -C genotyping"
        },
        "specimen" : {
          "reference" : "urn:uuid:e44fbe33-6084-4ae2-a95e-8bc451c63340",
          "display" : "buccal swab from John Storm"
        },
        "derivedFrom" : [
          {
            "reference" : "urn:uuid:e2092243-2970-49d2-a90f-b90d1d49715a",
            "type" : "Observation",
            "display" : "HLA-B*15:01:01G, exons 2 and 3"
          },
          {
            "reference" : "urn:uuid:792be53e-d4fb-4887-a367-815ef6c706e5",
            "type" : "Observation",
            "display" : "HLA-B*57:01:01G, exons 2 and 3"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:4932",
                  "display" : "HLA-B"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:709c5315-9403-4867-9d82-0b953836665f",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "CG-IG-HLA-FullBundle-01-24",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_CG-IG-HLA-FullBundle-01-24\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation CG-IG-HLA-FullBundle-01-24</b></p><a name=\"CG-IG-HLA-FullBundle-01-24\"> </a><a name=\"hcCG-IG-HLA-FullBundle-01-24\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-haplotype.html\">Haplotype</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84414-2}\">Haplotype name</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-13f34265-335c-4853-bc38-0815315edafa\">John Storm</a></p><p><b>effective</b>: 2016-12-15</p><p><b>performer</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950\">aTypingLab, Inc</a></p><p><b>value</b>: <span title=\"Codes:{http://www.ebi.ac.uk/ipd/imgt/hla HLA-C*01:02:01G}\">HLA-C*01:02:01G</span></p><p><b>method</b>: <span title=\"Codes:{https://www.ncbi.nlm.nih.gov/gtr GTR000000000.0}\">NGS based Class I HLA-A, -B, -C genotyping</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340\">buccal swab from John Storm</a></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></td><td><span title=\"Codes:{http://www.genenames.org HGNC:4933}\">HLA-C</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84414-2",
              "display" : "Haplotype name"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:13f34265-335c-4853-bc38-0815315edafa",
          "type" : "Patient",
          "display" : "John Storm"
        },
        "effectiveDateTime" : "2016-12-15",
        "performer" : [
          {
            "reference" : "urn:uuid:9243cc20-27bd-4f87-ba90-0328ed474950",
            "display" : "aTypingLab, Inc"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.ebi.ac.uk/ipd/imgt/hla",
              "version" : "3.23",
              "code" : "HLA-C*01:02:01G",
              "display" : "HLA-C*01:02:01G"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "https://www.ncbi.nlm.nih.gov/gtr",
              "code" : "GTR000000000.0"
            }
          ],
          "text" : "NGS based Class I HLA-A, -B, -C genotyping"
        },
        "specimen" : {
          "reference" : "urn:uuid:e44fbe33-6084-4ae2-a95e-8bc451c63340",
          "display" : "buccal swab from John Storm"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:4933",
                  "display" : "HLA-C"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:8b2aa21c-1426-4717-8ab0-a84d83df7d47",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "CG-IG-HLA-FullBundle-01-25",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_CG-IG-HLA-FullBundle-01-25\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation CG-IG-HLA-FullBundle-01-25</b></p><a name=\"CG-IG-HLA-FullBundle-01-25\"> </a><a name=\"hcCG-IG-HLA-FullBundle-01-25\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-haplotype.html\">Haplotype</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84414-2}\">Haplotype name</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-13f34265-335c-4853-bc38-0815315edafa\">John Storm</a></p><p><b>effective</b>: 2016-12-15</p><p><b>performer</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950\">aTypingLab, Inc</a></p><p><b>value</b>: <span title=\"Codes:{http://www.ebi.ac.uk/ipd/imgt/hla HLA-C*01:02:01G}\">HLA-C*01:02:01G</span></p><p><b>method</b>: <span title=\"Codes:{https://www.ncbi.nlm.nih.gov/gtr GTR000000000.0}\">NGS based Class I HLA-A, -B, -C genotyping</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340\">buccal swab from John Storm</a></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></td><td><span title=\"Codes:{http://www.genenames.org HGNC:4933}\">HLA-C</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84414-2",
              "display" : "Haplotype name"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:13f34265-335c-4853-bc38-0815315edafa",
          "type" : "Patient",
          "display" : "John Storm"
        },
        "effectiveDateTime" : "2016-12-15",
        "performer" : [
          {
            "reference" : "urn:uuid:9243cc20-27bd-4f87-ba90-0328ed474950",
            "display" : "aTypingLab, Inc"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.ebi.ac.uk/ipd/imgt/hla",
              "version" : "3.23",
              "code" : "HLA-C*01:02:01G",
              "display" : "HLA-C*01:02:01G"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "https://www.ncbi.nlm.nih.gov/gtr",
              "code" : "GTR000000000.0"
            }
          ],
          "text" : "NGS based Class I HLA-A, -B, -C genotyping"
        },
        "specimen" : {
          "reference" : "urn:uuid:e44fbe33-6084-4ae2-a95e-8bc451c63340",
          "display" : "buccal swab from John Storm"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:4933",
                  "display" : "HLA-C"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:0e0a780e-4486-4cd0-bfae-7243c579f208",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "CG-IG-HLA-FullBundle-01-26",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_CG-IG-HLA-FullBundle-01-26\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation CG-IG-HLA-FullBundle-01-26</b></p><a name=\"CG-IG-HLA-FullBundle-01-26\"> </a><a name=\"hcCG-IG-HLA-FullBundle-01-26\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-genotype.html\">Genotype</a></p></div><p><b>basedOn</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-99309303-045e-4cf4-90d7-250d7a7476ea\">Class I HLA genotyping for John Storm</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84413-4}\">Genotype display name</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-13f34265-335c-4853-bc38-0815315edafa\">John Storm</a></p><p><b>effective</b>: 2016-12-15</p><p><b>performer</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950\">aTypingLab, Inc</a></p><p><b>value</b>: <span title=\"Codes:{http://glstring.org hla#3.23.0#HLA-C*01:02:01G+HLA-C*03:04:01G}\">hla#3.23.0#HLA-C*01:02:01G+HLA-C*03:04:01G</span></p><p><b>method</b>: <span title=\"Codes:{https://www.ncbi.nlm.nih.gov/gtr GTR000000000.0}\">NGS based Class I HLA-A, -B, -C genotyping</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-e44fbe33-6084-4ae2-a95e-8bc451c63340\">buccal swab from John Storm</a></p><p><b>derivedFrom</b>: </p><ul><li><a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-8b2aa21c-1426-4717-8ab0-a84d83df7d47\">HLA-C*03:04:01G, exons 2 and 3</a></li><li><a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-709c5315-9403-4867-9d82-0b953836665f\">HLA-C*01:02:01G, exons 2 and 3</a></li></ul><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></td><td><span title=\"Codes:{http://www.genenames.org HGNC:4933}\">HLA-C</span></td></tr></table></div>"
        },
        "basedOn" : [
          {
            "reference" : "urn:uuid:99309303-045e-4cf4-90d7-250d7a7476ea",
            "type" : "ServiceRequest",
            "display" : "Class I HLA genotyping for John Storm"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84413-4",
              "display" : "Genotype display name"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:13f34265-335c-4853-bc38-0815315edafa",
          "type" : "Patient",
          "display" : "John Storm"
        },
        "effectiveDateTime" : "2016-12-15",
        "performer" : [
          {
            "reference" : "urn:uuid:9243cc20-27bd-4f87-ba90-0328ed474950",
            "display" : "aTypingLab, Inc"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://glstring.org",
              "version" : "1.0",
              "code" : "hla#3.23.0#HLA-C*01:02:01G+HLA-C*03:04:01G"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "https://www.ncbi.nlm.nih.gov/gtr",
              "code" : "GTR000000000.0"
            }
          ],
          "text" : "NGS based Class I HLA-A, -B, -C genotyping"
        },
        "specimen" : {
          "reference" : "urn:uuid:e44fbe33-6084-4ae2-a95e-8bc451c63340",
          "display" : "buccal swab from John Storm"
        },
        "derivedFrom" : [
          {
            "reference" : "urn:uuid:8b2aa21c-1426-4717-8ab0-a84d83df7d47",
            "type" : "Observation",
            "display" : "HLA-C*03:04:01G, exons 2 and 3"
          },
          {
            "reference" : "urn:uuid:709c5315-9403-4867-9d82-0b953836665f",
            "type" : "Observation",
            "display" : "HLA-C*01:02:01G, exons 2 and 3"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:4933",
                  "display" : "HLA-C"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:b0a4b18e-94e7-4b1b-8031-c7ae4bdd8db9",
      "resource" : {
        "resourceType" : "DiagnosticReport",
        "id" : "CG-IG-HLA-FullBundle-01-27",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DiagnosticReport_CG-IG-HLA-FullBundle-01-27\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DiagnosticReport CG-IG-HLA-FullBundle-01-27</b></p><a name=\"CG-IG-HLA-FullBundle-01-27\"> </a><a name=\"hcCG-IG-HLA-FullBundle-01-27\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-genomic-report.html\">Genomic Report</a></p></div><h2><span title=\"Codes:{http://loinc.org 51969-4}\">Genetic analysis report</span> (<span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span>) </h2><table class=\"grid\"><tr><td>Subject</td><td>John Storm(official) Male, DoB: 1986-12-31 ( Donor Registration Number (use: usual, period: 2012-11-10 --&gt; (ongoing)))</td></tr><tr><td>When For</td><td>2016-12-15</td></tr><tr><td>Reported</td><td>2016-12-15 14:15:30-0600</td></tr><tr><td>Performer</td><td> <a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-9243cc20-27bd-4f87-ba90-0328ed474950\">aTypingLab Inc</a></td></tr></table><p><b>Report Details</b></p><table class=\"grid\"><tr><td><b>Code</b></td><td><b>Value</b></td><td><b>Flags</b></td></tr><tr><td><a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-49a86246-4004-42eb-9bdc-f542f93f9228\"><span title=\"Codes:{http://loinc.org 84413-4}\">Genotype display name</span></a></td><td><span title=\"Codes:{http://glstring.org hla#3.23.0#HLA-A:01:01G+HLA-A*01:02}\">hla#3.23.0#HLA-A:01:01G+HLA-A*01:02</span></td><td>Final</td></tr><tr><td><a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-60613a43-c4cb-4502-b3e2-cf9215feaa70\"><span title=\"Codes:{http://loinc.org 84413-4}\">Genotype display name</span></a></td><td><span title=\"Codes:{http://glstring.org hla#3.23.0#HLA-B*15:01:01G+HLA-B*57:01:01G}\">hla#3.23.0#HLA-B*15:01:01G+HLA-B*57:01:01G</span></td><td>Final</td></tr><tr><td><a href=\"Bundle-bundle-CG-IG-HLA-FullBundle-01.html#urn-uuid-0e0a780e-4486-4cd0-bfae-7243c579f208\"><span title=\"Codes:{http://loinc.org 84413-4}\">Genotype display name</span></a></td><td><span title=\"Codes:{http://glstring.org hla#3.23.0#HLA-C*01:02:01G+HLA-C*03:04:01G}\">hla#3.23.0#HLA-C*01:02:01G+HLA-C*03:04:01G</span></td><td>Final</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/hla-genotyping-results-allele-database",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ebi.ac.uk/ipd/imgt/hla",
                  "version" : "3.23"
                }
              ]
            }
          },
          {
            "extension" : [
              {
                "url" : "text",
                "valueString" : "HLA-A*01:01:01G+HLA-A*01:02^HLA-B*15:01:01G+HLA-B*57:01:01G^HLA-C*01:02:01G+HLA-C*03:04:01G"
              },
              {
                "url" : "url",
                "valueUri" : "https://gl.nmdp.org/imgt-hla/3.23.0/multilocus-unphased-genotype/ex"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/hla-genotyping-results-glstring"
          }
        ],
        "basedOn" : [
          {
            "reference" : "urn:uuid:99309303-045e-4cf4-90d7-250d7a7476ea",
            "type" : "ServiceRequest",
            "display" : "Class I HLA genotyping for John Storm"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE",
                "display" : "Genetics"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "51969-4",
              "display" : "Genetic analysis report"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:13f34265-335c-4853-bc38-0815315edafa",
          "type" : "Patient",
          "display" : "John Storm"
        },
        "effectiveDateTime" : "2016-12-15",
        "issued" : "2016-12-15T14:15:30-06:00",
        "performer" : [
          {
            "reference" : "urn:uuid:9243cc20-27bd-4f87-ba90-0328ed474950",
            "type" : "Organization",
            "display" : "aTypingLab Inc"
          }
        ],
        "specimen" : [
          {
            "reference" : "urn:uuid:e44fbe33-6084-4ae2-a95e-8bc451c63340",
            "display" : "buccal swab from John Storm"
          }
        ],
        "result" : [
          {
            "reference" : "urn:uuid:49a86246-4004-42eb-9bdc-f542f93f9228",
            "type" : "Observation",
            "display" : "HLA-A: HLA-A:01:01:01G+HLA-A*01:02"
          },
          {
            "reference" : "urn:uuid:60613a43-c4cb-4502-b3e2-cf9215feaa70",
            "type" : "Observation",
            "display" : "HLA-B: HLA-B*15:01:01G+HLA-B*57:01:01G"
          },
          {
            "reference" : "urn:uuid:0e0a780e-4486-4cd0-bfae-7243c579f208",
            "type" : "Observation",
            "display" : "HLA-C: HLA-C*01:02:01G+HLA-C*03:04:01G"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "DiagnosticReport"
      }
    }
  ]
}

```
