# Home Page - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* **Home Page**

## Home Page

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/hl7.fhir.uv.genomics-reporting | *Version*:4.0.0-ballot | |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:GenomicsReporting |

### Scope

Genomics is a rapidly evolving area of healthcare that involves complex data structures. There is significant value in sharing this information in a way that is consistent, computable and that can accommodate ongoing evolution of medical science and practice. At present, this implementation guide focuses solely on data structures - what data should be/might be present and how it should be organized. It does not address workflows around how reports are requested, created, approved, routed, delivered, amended, etc.

This guide covers many aspects of genomic data reporting, including:

* Representation of simple discrete variants, structural variants including copy number variants, complex variants as well as gross variations such as extra or missing chromosomes
* Representation of both known variants as well as fully describing de novo variations
* Germline and somatic variations
* Relevance of identified variations from the perspective of disease pathology, pharmacogenomics, transplant suitability (e.g., HLA typing), etc.
* Full and partial DNA sequencing, including whole genome and exome studies

### How to Use this Guide

This implementation guide is organized into a set of sections. All implementers intending to do clinical genomic reporting should read the [General Genomic Reporting](general.md) and the [Variant Reporting](sequencing.md) sections. To understand the key profiles in this IG, as well as their relationship to one another, start with the General Genomics Reporting section. Those new to FHIR should review the Understanding FHIR section below.

The remaining sections provide support for more specialized types of reporting. If your system is involved with genomic reports in a particular area, then read through that section of the implementation guide for further guidance.

| | |
| :--- | :--- |
| [Background](background.md) | Introduces some of the key genomics terms and relationships that should be understood by those implementing this specification. |
| [General Genomic Reporting](general.md) | Overall guidance in using the profiles and transactions defined in this guide. Guidance and examples for the general structure of genomic reports, how to report overall interpretations and how to report genotypes, haplotypes, and different types of variants. |
| [Variant Reporting](sequencing.md) | Guidance on expressing information about variants gleaned from various sequencing approaches including direct sequencing, shotgun sequencing, array-based testing, etc. |
| [Pharmacogenomic Reporting](pharmacogenomics.md) | Guidance and examples related to genomic testing done for the purpose of assessing genomic variations' implication on the use of medications - both for oncology and for general patient treatment. |
| [Somatic Reporting](somatics.md) | Guidance related to genomic testing done on somatic (non-germline) tissues, including assessments of tumors. |
| [Histocompatibility Reporting](histocompatibility.md) | Guidance related to genomic testing done for histocompatibility and immunogenomics assessments, including HLA typing. |

### Guiding principles

This guide adheres to a set of design approaches:

* It is intended to be international in scope and only leverages terminologies which are freely available to all countries.
* It avoids pre-coordinating the type of variant, medication, or other information into the Observation.code as this makes it easier to leverage industry standard terminologies for genomic information (e.g., HGVS) and avoids needing to duplicate this information into observation coding systems such as LOINC.
* It maximizes the use of resources that are in common use by laboratory reporting systems for other clinical areas - specifically [Observation](http://hl7.org/fhir/R5/observation.html) and [DiagnosticReport](http://hl7.org/fhir/R5/diagnosticreport.html). This eases implementation and also reduces the chance of data being lost by systems that might not have been designed to specifically accommodate genomic-related information.
* It minimizes the use of FHIR extensions, also with an objective of reducing the risk of data loss when information is passed to systems that might not explicitly support this implementation guide.
* It uses separate observations for each independently useful assertion. This makes the data discoverable and queryable as seen in the [query guidance](usecases.md). Also review the guidance on the proper usage of [contained](http://hl7.org/fhir/R5/references.html#contained) resources.
* It tries to ensure that data is captured in a manner that's consistent regardless of the type of testing that was done to ensure data can be consistently queried even if captured differently (e.g., variations identified in assay tests are reported in the same manner as those identified through direct sequencing).
* The guide allows for variability in the amount of discrete information captured. Systems are encouraged to populate what discrete elements they can and allows for the possibility of systems populating additional elements as their technical capability and/or time and other resources allow.

Together, these principles should make adoption easier and allow systems to more easily adapt in a compatible way as genomic reporting continues to evolve.

### Previous Specifications

FHIR STU3 included a set of profiles that provided guidance on how to convey genomic orders, results, and observations. Those profiles are superseded by this implementation guide. Guidance for converting from these older profiles is found [here](conversion.md).

### Understanding FHIR

This implementation guide is based on the HL7 [FHIR](http://hl7.org/fhir/R5/index.html) standard. It uses terminology, notations and design principles that are specific to FHIR. Before reading this implementation guide, it's important to be familiar with some of the basic principles of FHIR as well as general guidance on how to read FHIR specifications. Readers who are unfamiliar with FHIR are encouraged to read (or at least skim) the following prior to reading the rest of this implementation guide.

* [FHIR overview](http://hl7.org/fhir/R5/overview.html)
* [Developer's introduction](http://hl7.org/fhir/R5/overview-dev.html)
* (or [Clinical introduction](http://hl7.org/fhir/R5/overview-clinical.html))
* [FHIR data types](http://hl7.org/fhir/R5/datatypes.html)
* [Using codes](http://hl7.org/fhir/R5/terminologies.html)
* [References between resources](http://hl7.org/fhir/R5/references.html)
* [How to read resource & profile definitions](http://hl7.org/fhir/R5/formats.html)
* [Base resource](http://hl7.org/fhir/R5/resource.html)
* [FHIR Validation](http://hl7.org/fhir/R5/validation.html)

It is highly recommended that readers review [Diagnostics Module](http://hl7.org/fhir/R5/diagnostics-module.html) and review the resources that are used as part of this implementation guide, especially [Observation](http://hl7.org/fhir/R5/observation.html), [DiagnosticReport](http://hl7.org/fhir/R5/diagnosticreport.html), and [MolecularSequence](http://hl7.org/fhir/R5/molecularsequence.html).

Importantly, implementers should pay close attention to the considerations in [Associated Observations](http://hl7.org/fhir/R5/diagnosticreport.html#10.3.5.3) and [Observation Grouping](http://hl7.org/fhir/R5/observation.html#obsgrouping) describing proper usage of the relationships `DiagnosticReport.result`, `Observation.hasMember`, and `Observation.derivedFrom`. Consumers of **Genomic diagnostic reports** MUST navigate through all `hasMember` relations, and navigate through `derivedFrom` relationships in order to ensure all clinically relevant information is seen.

Many Observation profiles and components in this guide require sending codes from http://loinc.org. If necessary for implementation (e.g., to map to a local system), equivalent codes from other code systems may **also** be sent, following the [guidance](http://hl7.org/fhir/R5/observation.html#usingcodes) on observation.

Since this Implementation Guide is not targeting a specific country or region, other requirements may be needed for local reporting. Observation instances adhering to other profiles should be built to validate against one of this Implementation Guide's profiles wherever possible. Where incompatibilities may arise, it is most important to align with the codes and values for Observations and their components.

### Extending beyond this Guide

Implementers should use this guide to structure genomics data in an interoperable way. The Clinical Genomics Working Group understands that this guide is not complete, and implementers might identify additional concepts and data elements. Please review this [guidance](general.md#flexibility) for ways to handle those use cases.

### Dependencies



### Global Profiles

*There are no Global profiles defined*

### Cross Version Analysis

### IP Statements

This publication includes IP covered under the following statements.

* Copyrights permitted under terms specified by [Creative Commons Attribution 4.0 International (CC BY 4.0)](https://creativecommons.org/licenses/by/4.0/legalcode) .Consistent with the terms of CC BY 4.0, HL7 is permitted to share, copy and redistribute the material in any medium or format and adapt, remix, transform, and build upon the material for its purposes as long as the CC BY 4.0 license terms are upheld. HL7 must must give appropriate credit, provide a link to the license, and indicate if changes were made. HL7 may do so in any reasonable manner, but not in any way that suggests the licensor endorses HL7 or it's use. And HL7 may not apply legal terms or technological measures that legally restrict others from doing anything the license permits.

* [Mondo Disease Ontology](http://terminology.hl7.org/6.5.0/CodeSystem-MONDO.html): [Bundle/bundle-cgexample](Bundle-bundle-cgexample.md), [Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md) and [Observation/obs-idh-ex](Observation-obs-idh-ex.md)


* Information that is created by or for the US government are within the public domain. Public domain information on the National Library of Medicine (NLM) Web pages may be freely distributed and copied. However, it is requested that in any subsequent use of this work, NLM be given appropriate acknowledgment.NOTE: This site contains resources which incorporate material contributed or licensed by individuals, companies, or organizations that may be protected by U.S. and foreign copyright laws. These include, but are not limited to PubMed Central (PMC) (see PMC Copyright Notice via [https://www.ncbi.nlm.nih.gov/pmc/about/copyright/)](https://www.ncbi.nlm.nih.gov/pmc/about/copyright/)), Bookshelf (see Bookshelf Copyright Notice via [https://www.ncbi.nlm.nih.gov/books/about/copyright/)](https://www.ncbi.nlm.nih.gov/books/about/copyright/)), OMIM (see OMIM Copyright Status via [https://omim.org/help/copyright)](https://omim.org/help/copyright)), and PubChem. All persons reproducing, redistributing, or making commercial use of this information are expected to adhere to the terms and conditions asserted by the copyright holder. Transmission or reproduction of protected items beyond that allowed by fair use ([https://www.copyright.gov/fls/fl102.html)(PDF)](https://www.copyright.gov/fls/fl102.html)(PDF)) as defined in the copyright laws requires the written permission of the copyright owners.For information on NCBI's policies and disclaimers for use, see here [https://www.ncbi.nlm.nih.gov/home/about/policies/](https://www.ncbi.nlm.nih.gov/home/about/policies/).

* [ClinVar Variant ID](http://terminology.hl7.org/6.5.0/CodeSystem-ClinVarV.html): [Bundle/bundle-cgexample](Bundle-bundle-cgexample.md), [Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md)...Show 10 more,[Bundle/bundle-complexVariant-nonHGVS](Bundle-bundle-complexVariant-nonHGVS.md),[Bundle/bundle-compound-heterozygote](Bundle-bundle-compound-heterozygote.md),[Bundle/bundle-oncology-diagnostic](Bundle-bundle-oncology-diagnostic.md),[Observation/GenotypeExample1](Observation-GenotypeExample1.md),[Observation/HaplotypeSet-Clinical-Trial-Example-1of2](Observation-HaplotypeSet-Clinical-Trial-Example-1of2.md),[Observation/HaplotypeSet-Clinical-Trial-Example-2of2](Observation-HaplotypeSet-Clinical-Trial-Example-2of2.md),[Observation/MSH2-del-var](Observation-MSH2-del-var.md),[Observation/NTHL1-snv-var](Observation-NTHL1-snv-var.md),[Observation/Pgx-geno-1001](Observation-Pgx-geno-1001.md)and[Observation/RepeatExpansion](Observation-RepeatExpansion.md)


* It is a condition of HGNC funding from NIH and the Welcome Trust that the nomenclature and information provided is freely available to all. Anyone may use the HGNC data, but we request that they reference the **"HUGO Gene Nomenclature Committee at the European Bioinformatics Institute"** and the website where possible.

* [HUGO Gene Nomenclature Committee Genes](http://terminology.hl7.org/6.5.0/CodeSystem-v3-hgnc.html): [Bundle/bundle-CG-IG-HLA-FullBundle-01](Bundle-bundle-CG-IG-HLA-FullBundle-01.md), [Bundle/bundle-cgexample](Bundle-bundle-cgexample.md)...Show 57 more,[Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md),[Bundle/bundle-oncology-diagnostic](Bundle-bundle-oncology-diagnostic.md),[Bundle/bundle-oncology-report-example](Bundle-bundle-oncology-report-example.md),[Bundle/bundle-oncologyexamples-r4](Bundle-bundle-oncologyexamples-r4.md),[Bundle/bundle-oncologyexamples-r4-withGrouping](Bundle-bundle-oncologyexamples-r4-withGrouping.md),[Bundle/bundle-pgxexample](Bundle-bundle-pgxexample.md),[GenomicFinding](StructureDefinition-finding.md),[HGNCVS](ValueSet-hgnc-vs.md),[MolecularBiomarker](StructureDefinition-molecular-biomarker.md),[Observation/ATR-insertion-var](Observation-ATR-insertion-var.md),[Observation/EGFR-L858R-var](Observation-EGFR-L858R-var.md),[Observation/Genotype-Clinical-Trial-Example-using-haplotypes](Observation-Genotype-Clinical-Trial-Example-using-haplotypes.md),[Observation/GenotypeExample1](Observation-GenotypeExample1.md),[Observation/GenotypeExamplePharmVar](Observation-GenotypeExamplePharmVar.md),[Observation/HER2byImmuneStainExample](Observation-HER2byImmuneStainExample.md),[Observation/HER2byImmunoassayExample](Observation-HER2byImmunoassayExample.md),[Observation/HLA-A-haplotype1](Observation-HLA-A-haplotype1.md),[Observation/HLA-A-haplotype2](Observation-HLA-A-haplotype2.md),[Observation/HLA-B-haplotype1](Observation-HLA-B-haplotype1.md),[Observation/HLA-B-haplotype2](Observation-HLA-B-haplotype2.md),[Observation/HLA-C-haplotype1](Observation-HLA-C-haplotype1.md),[Observation/HLA-C-haplotype2](Observation-HLA-C-haplotype2.md),[Observation/HaplotypeExamplePharmVar01](Observation-HaplotypeExamplePharmVar01.md),[Observation/HaplotypeExamplePharmVar02](Observation-HaplotypeExamplePharmVar02.md),[Observation/HaplotypeSet-Clinical-Trial-Example-1of2](Observation-HaplotypeSet-Clinical-Trial-Example-1of2.md),[Observation/HaplotypeSet-Clinical-Trial-Example-2of2](Observation-HaplotypeSet-Clinical-Trial-Example-2of2.md),[Observation/MSH2-del-var](Observation-MSH2-del-var.md),[Observation/MultipleRepeatExpansions](Observation-MultipleRepeatExpansions.md),[Observation/NOTCH1-uncertain-var](Observation-NOTCH1-uncertain-var.md),[Observation/NTHL1-snv-var](Observation-NTHL1-snv-var.md),[Observation/PDL1Example](Observation-PDL1Example.md),[Observation/Pgx-geno-1001](Observation-Pgx-geno-1001.md),[Observation/Pgx-geno-1002](Observation-Pgx-geno-1002.md),[Observation/Pgx-geno-1003](Observation-Pgx-geno-1003.md),[Observation/Pgx-var-1011](Observation-Pgx-var-1011.md),[Observation/Pgx-var-1012](Observation-Pgx-var-1012.md),[Observation/Pgx-var-1013](Observation-Pgx-var-1013.md),[Observation/Pgx-var-1014](Observation-Pgx-var-1014.md),[Observation/Pgx-var-1015](Observation-Pgx-var-1015.md),[Observation/Pgx-var-1016](Observation-Pgx-var-1016.md),[Observation/Pgx-var-1017](Observation-Pgx-var-1017.md),[Observation/Pgx-var-1018](Observation-Pgx-var-1018.md),[Observation/Pgx-var-1019](Observation-Pgx-var-1019.md),[Observation/Pgx-var-1020](Observation-Pgx-var-1020.md),[Observation/Pgx-var-1021](Observation-Pgx-var-1021.md),[Observation/ROS1-Fusion-var](Observation-ROS1-Fusion-var.md),[Observation/RepeatExpansion](Observation-RepeatExpansion.md),[Observation/SNVexample](Observation-SNVexample.md),[Observation/STAG2-insertion-var](Observation-STAG2-insertion-var.md),[Observation/Variant-Somatic-Clinical-Trial](Observation-Variant-Somatic-Clinical-Trial.md),[Observation/ZFHX3-uncertain-var](Observation-ZFHX3-uncertain-var.md),[Observation/genotype-hla-a-glstring-r4](Observation-genotype-hla-a-glstring-r4.md),[Observation/haplotype-hla-a-1-r4](Observation-haplotype-hla-a-1-r4.md),[Observation/obs1-interact-smn1-smn2](Observation-obs1-interact-smn1-smn2.md),[Observation/obs2-interact-smn1-smn2](Observation-obs2-interact-smn1-smn2.md),[Parameters/FindSubjectHaplotypesOutput](Parameters-FindSubjectHaplotypesOutput.md)and[Parameters/FindSubjectSpecificHaplotypesOutput](Parameters-FindSubjectSpecificHaplotypesOutput.md)
* [HUGO Gene Nomenclature Committee Gene Group](http://terminology.hl7.org/6.5.0/CodeSystem-HGNCGeneGroup.html): [GenomicFinding](StructureDefinition-finding.md), [HGNCVS](ValueSet-hgnc-vs.md) and [MolecularBiomarker](StructureDefinition-molecular-biomarker.md)


* NCBI's Disclaimer and Copyright notice must be evident to users of your service.Information that is created by or for the US government on this site is within the public domain. Public domain information on the National Library of Medicine (NLM) Web pages may be freely distributed and copied. However, it is requested that in any subsequent use of this work, NLM be given appropriate acknowledgment.NOTE: This site contains resources which incorporate material contributed or licensed by individuals, companies, or organizations that may be protected by U.S. and foreign copyright laws. These include, but are not limited to PubMed Central (PMC) (see PMC Copyright Notice at [https://www.ncbi.nlm.nih.gov/pmc/about/copyright/)](https://www.ncbi.nlm.nih.gov/pmc/about/copyright/)), Bookshelf (see Bookshelf Copyright Notice at [https://www.ncbi.nlm.nih.gov/books/about/copyright/)](https://www.ncbi.nlm.nih.gov/books/about/copyright/)), OMIM (see OMIM Copyright Status at [https://omim.org/help/copyright)](https://omim.org/help/copyright)), and PubChem. All persons reproducing, redistributing, or making commercial use of this information are expected to adhere to the terms and conditions asserted by the copyright holder. Transmission or reproduction of protected items beyond that allowed by fair use ([https://www.copyright.gov/fls/fl102.html)(PDF)](https://www.copyright.gov/fls/fl102.html)(PDF)) as defined in the copyright laws requires the written permission of the copyright owners.General copyright, as stated on NCBI's GTR site ([https://www.ncbi.nlm.nih.gov/gtr/)](https://www.ncbi.nlm.nih.gov/gtr/)), is as included in the Copyright Statement.

* [Genetic Testing Registry](http://terminology.hl7.org/6.5.0/CodeSystem-GTR.html): [Bundle/bundle-CG-IG-HLA-FullBundle-01](Bundle-bundle-CG-IG-HLA-FullBundle-01.md)


* See [[https://clinicaltrials.gov/about-site/terms-conditions](https://clinicaltrials.gov/about-site/terms-conditions)](https://clinicaltrials.gov/about-site/terms-conditions) for the Terms and Conditions that apply for use of ClinicalTrials.gov data.

* [ClinicalTrials.gov](http://terminology.hl7.org/6.5.0/CodeSystem-ClinicalTrialsGov.html): [Observation/ROS1-Fusion-therapuTrial](Observation-ROS1-Fusion-therapuTrial.md), [Observation/Therapeutic-Implication-Clinical-Trial-2](Observation-Therapeutic-Implication-Clinical-Trial-2.md) and [Observation/Therapeutic-Implication-Clinical-Trial-Somatic](Observation-Therapeutic-Implication-Clinical-Trial-Somatic.md)


* The HPO vocabularies, annotation files, tools and documentation are freely available. 
* The HPO is copyrighted to protect the integrity of the vocabularies, which means that changes to the HPO vocabularies need to be done by HPO developers. However, anyone can download the HPO and use the ontologies or other HPO files under three conditions:
 
*  That the Human Phenotype Ontology Consortium is acknowledged and [cited](https://hpo.jax.org/app/citation) properly. 
 
* That any HPO Consortium file(s) displayed publicly include the date(s) and/or version number(s) of the relevant HPO file(s).
 
*  That neither the content of the HPO file(s) nor the logical relationships embedded within the HPO file(s) be altered in any way. (Content additions and modifications have to be suggested using our [issue tracker](https://github.com/obophenotype/human-phenotype-ontology/issues) .) 
 
* Users of the HPO should add the following statement to their online presence. This service/product uses the Human Phenotype Ontology (version information). Find out more at [http://www.human-phenotype-ontology.org](http://www.human-phenotype-ontology.org). We request that the HPO logo be included as well.
 

* [Human Phenotype Ontology](http://terminology.hl7.org/6.5.0/CodeSystem-HPO.html): [ConditionInheritanceModeVS](ValueSet-condition-inheritance-mode-vs.md), [DiagnosticImplication](StructureDefinition-diagnostic-implication.md) and [Observation/obs-idh-ex](Observation-obs-idh-ex.md)


* The PharmVar database content is licensed under a [Creative Commons Attribution-ShareAlike 4.0 International license](https://creativecommons.org/licenses/by-sa/4.0/) that allows for the sharing and adaptation of our information with proper attribution.See [[https://www.pharmvar.org/terms-and-conditions](https://www.pharmvar.org/terms-and-conditions)](https://www.pharmvar.org/terms-and-conditions) for Terms and Conditions.

* [Pharmacogene Variation](http://terminology.hl7.org/6.5.0/CodeSystem-PharmVar.html): [Bundle/bundle-cgexample](Bundle-bundle-cgexample.md), [Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md)...Show 4 more,[Bundle/bundle-pgxexample](Bundle-bundle-pgxexample.md),[Observation/HaplotypeExamplePharmVar01](Observation-HaplotypeExamplePharmVar01.md),[Observation/HaplotypeExamplePharmVar02](Observation-HaplotypeExamplePharmVar02.md)and[Parameters/FindSubjectHaplotypesOutput](Parameters-FindSubjectHaplotypesOutput.md)


* The Sequence Ontology: A tool for the unification of genome annotations. Eilbeck K., Lewis S.E., Mungall C.J., Yandell M., Stein L., Durbin R., Ashburner M. [Genome Biology (2005) 6:R44](http://genomebiology.com/2005/6/5/R44) Please also include the version of SO used.Sequence Ontology data and data products are licensed under the [Creative Commons Attribution 4.0 Unported License](https://creativecommons.org/licenses/by/4.0/legalcode) .

* [Sequence Ontology](http://terminology.hl7.org/6.5.0/CodeSystem-SO.html): [Bundle/bundle-oncology-report-example](Bundle-bundle-oncology-report-example.md), [DNAChangeTypeVS](ValueSet-dna-change-type-vs.md)...Show 46 more,[FunctionalEffectVS](ValueSet-functional-effect-vs.md),[GenomicStudy/lungMass](GenomicStudy-lungMass.md),[GenomicStudy/somaticStudy](GenomicStudy-somaticStudy.md),[MolecularConsequence](StructureDefinition-molecular-consequence.md),[MolecularConsequenceVS](ValueSet-molecular-consequence-vs.md),[Observation/ATR-insertion-molc](Observation-ATR-insertion-molc.md),[Observation/ATR-insertion-var](Observation-ATR-insertion-var.md),[Observation/EGFR-L858R-molc](Observation-EGFR-L858R-molc.md),[Observation/EGFR-L858R-var](Observation-EGFR-L858R-var.md),[Observation/ExampleGermlineCNV](Observation-ExampleGermlineCNV.md),[Observation/ExampleGermlineDEL](Observation-ExampleGermlineDEL.md),[Observation/ExampleGermlineINV](Observation-ExampleGermlineINV.md),[Observation/ExampleSomaticCNV](Observation-ExampleSomaticCNV.md),[Observation/ExampleSomaticDEL](Observation-ExampleSomaticDEL.md),[Observation/ExampleSomaticINV](Observation-ExampleSomaticINV.md),[Observation/MSH2-del-molc](Observation-MSH2-del-molc.md),[Observation/MSH2-del-var](Observation-MSH2-del-var.md),[Observation/NOTCH1-uncertain-molc](Observation-NOTCH1-uncertain-molc.md),[Observation/NTHL1-snv-molc](Observation-NTHL1-snv-molc.md),[Observation/NTHL1-snv-var](Observation-NTHL1-snv-var.md),[Observation/Pgx-var-1011](Observation-Pgx-var-1011.md),[Observation/Pgx-var-1012](Observation-Pgx-var-1012.md),[Observation/Pgx-var-1013](Observation-Pgx-var-1013.md),[Observation/Pgx-var-1014](Observation-Pgx-var-1014.md),[Observation/Pgx-var-1015](Observation-Pgx-var-1015.md),[Observation/Pgx-var-1016](Observation-Pgx-var-1016.md),[Observation/Pgx-var-1017](Observation-Pgx-var-1017.md),[Observation/Pgx-var-1018](Observation-Pgx-var-1018.md),[Observation/Pgx-var-1019](Observation-Pgx-var-1019.md),[Observation/Pgx-var-1020](Observation-Pgx-var-1020.md),[Observation/Pgx-var-1021](Observation-Pgx-var-1021.md),[Observation/ROS1-Fusion](Observation-ROS1-Fusion.md),[Observation/STAG2-insertion-molc](Observation-STAG2-insertion-molc.md),[Observation/STAG2-insertion-var](Observation-STAG2-insertion-var.md),[Observation/ZFHX3-uncertain-molc](Observation-ZFHX3-uncertain-molc.md),[Observation/molec-conseq1](Observation-molec-conseq1.md),[Observation/molec-conseq2](Observation-molec-conseq2.md),[Observation/molec-conseq3](Observation-molec-conseq3.md),[Observation/molec-conseq4](Observation-molec-conseq4.md),[Observation/obs1-interact-smn1-smn2](Observation-obs1-interact-smn1-smn2.md),[Observation/obs2-interact-smn1-smn2](Observation-obs2-interact-smn1-smn2.md),[Parameters/FindStudyMetadataOutput](Parameters-FindStudyMetadataOutput.md),[Parameters/FindSubjectMolecConseqOutput](Parameters-FindSubjectMolecConseqOutput.md),[Parameters/FindSubjectStructuralIntersectingVariantsOutput](Parameters-FindSubjectStructuralIntersectingVariantsOutput.md),[Parameters/FindSubjectStructuralSubsumingVariantsOutput](Parameters-FindSubjectStructuralSubsumingVariantsOutput.md)and[Variant](StructureDefinition-variant.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [Bundle/bundle-cgexample](Bundle-bundle-cgexample.md), [Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md)...Show 20 more,[Bundle/bundle-oncology-diagnostic](Bundle-bundle-oncology-diagnostic.md),[Bundle/bundle-oncology-report-example](Bundle-bundle-oncology-report-example.md),[Bundle/bundle-oncologyexamples-r4](Bundle-bundle-oncologyexamples-r4.md),[Bundle/bundle-oncologyexamples-r4-withGrouping](Bundle-bundle-oncologyexamples-r4-withGrouping.md),[Observation/ATR-insertion-var](Observation-ATR-insertion-var.md),[Observation/EGFR-L858R-var](Observation-EGFR-L858R-var.md),[Observation/ExampleGermlineCNV](Observation-ExampleGermlineCNV.md),[Observation/ExampleSomaticCNV](Observation-ExampleSomaticCNV.md),[Observation/ExampleSomaticDEL](Observation-ExampleSomaticDEL.md),[Observation/NOTCH1-uncertain-var](Observation-NOTCH1-uncertain-var.md),[Observation/SNVexample](Observation-SNVexample.md),[Observation/STAG2-insertion-var](Observation-STAG2-insertion-var.md),[Observation/ZFHX3-uncertain-var](Observation-ZFHX3-uncertain-var.md),[Observation/obs1-interact-smn1-smn2](Observation-obs1-interact-smn1-smn2.md),[Observation/obs2-interact-smn1-smn2](Observation-obs2-interact-smn1-smn2.md),[Observation/variant-with-molec-consequences](Observation-variant-with-molec-consequences.md),[Parameters/FindSubjectMolecConseqOutput](Parameters-FindSubjectMolecConseqOutput.md),[Parameters/FindSubjectStructuralSubsumingVariantsOutput](Parameters-FindSubjectStructuralSubsumingVariantsOutput.md),[Parameters/FindSubjectVariantsOutput](Parameters-FindSubjectVariantsOutput.md)and[RiskAssessment/GenRiskDiabetesT2](RiskAssessment-GenRiskDiabetesT2.md)


* The content on the Website including but not limited to the content of ISCN 2020 in whole or in parts, the title, the logo, graphic designs or adverts are the intellectual property of S. Karger AG (Basel) or published with permission from the legal copyright owner. All rights are reserved. Unless otherwise noted, no part of the content on the Website may be translated into other languages, reproduced or utilized in any form or by any means, electronic or mechanical, including photocopying, recording, microcopying, or by any information storage and retrieval system, without permission in writing from Karger.For further information or permission requests please see the explanations under Rights and Permissions ([https://www.karger.com/Services/RightsPermissions)](https://www.karger.com/Services/RightsPermissions)).

* [International System for Human Cytogenomic Nomenclature (ISCN)](http://terminology.hl7.org/6.5.0/CodeSystem-ISCN.html): [Observation/ISCN-CMLExample](Observation-ISCN-CMLExample.md) and [Observation/ISCN-NormalExample](Observation-ISCN-NormalExample.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/bundle-CG-IG-HLA-FullBundle-01](Bundle-bundle-CG-IG-HLA-FullBundle-01.md), [Bundle/bundle-CYP2C19](Bundle-bundle-CYP2C19.md)...Show 156 more,[Bundle/bundle-cgexample](Bundle-bundle-cgexample.md),[Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md),[Bundle/bundle-complexVariant-nonHGVS](Bundle-bundle-complexVariant-nonHGVS.md),[Bundle/bundle-compound-heterozygote](Bundle-bundle-compound-heterozygote.md),[Bundle/bundle-oncology-diagnostic](Bundle-bundle-oncology-diagnostic.md),[Bundle/bundle-oncology-report-example](Bundle-bundle-oncology-report-example.md),[Bundle/bundle-oncologyexamples-r4](Bundle-bundle-oncologyexamples-r4.md),[Bundle/bundle-oncologyexamples-r4-withGrouping](Bundle-bundle-oncologyexamples-r4-withGrouping.md),[Bundle/bundle-pgxexample](Bundle-bundle-pgxexample.md),[Bundle/bundle-sequence-phase-relation-CYP2C19](Bundle-bundle-sequence-phase-relation-CYP2C19.md),[DiagnosticImplication](StructureDefinition-diagnostic-implication.md),[DiagnosticReport/GenomicReportExample01](DiagnosticReport-GenomicReportExample01.md),[DiagnosticReport/PGxGenomicReportEMERGE](DiagnosticReport-PGxGenomicReportEMERGE.md),[DiagnosticReport/PGxGenomicReportEMERGE-withGrouping](DiagnosticReport-PGxGenomicReportEMERGE-withGrouping.md),[DiagnosticReport/diagnosticreport-hla-glstring-r4](DiagnosticReport-diagnosticreport-hla-glstring-r4.md),[DiagnosticReport/somaticReport](DiagnosticReport-somaticReport.md),[GeneticTherapeuticImplicationsVS](ValueSet-genetic-therapeutic-implications-vs.md),[GenomicAnnotation](StructureDefinition-genomic-annotation.md),[GenomicFinding](StructureDefinition-finding.md),[GenomicImplication](StructureDefinition-implication.md),[GenomicReport](StructureDefinition-genomic-report.md),[GenomicStudy/PGXGenomicStudy](GenomicStudy-PGXGenomicStudy.md),[GenomicStudy/genomicstudy-trio2](GenomicStudy-genomicstudy-trio2.md),[GenomicStudy/lungMass](GenomicStudy-lungMass.md),[GenomicStudy/somaticStudy](GenomicStudy-somaticStudy.md),[Genotype](StructureDefinition-genotype.md),[Haplotype](StructureDefinition-haplotype.md),[MolecularBiomarker](StructureDefinition-molecular-biomarker.md),[MolecularBiomarkerCodeVS](ValueSet-molecular-biomarker-code-vs.md),[MolecularConsequence](StructureDefinition-molecular-consequence.md),[Observation/ATR-insertion-molc](Observation-ATR-insertion-molc.md),[Observation/ATR-insertion-significance](Observation-ATR-insertion-significance.md),[Observation/ATR-insertion-var](Observation-ATR-insertion-var.md),[Observation/AnnotationExample](Observation-AnnotationExample.md),[Observation/EGFR-L858R-molc](Observation-EGFR-L858R-molc.md),[Observation/EGFR-L858R-significance](Observation-EGFR-L858R-significance.md),[Observation/EGFR-L858R-therapuDrug1](Observation-EGFR-L858R-therapuDrug1.md),[Observation/EGFR-L858R-therapuDrug2](Observation-EGFR-L858R-therapuDrug2.md),[Observation/EGFR-L858R-var](Observation-EGFR-L858R-var.md),[Observation/ExampleGermlineCNV](Observation-ExampleGermlineCNV.md),[Observation/ExampleGermlineDEL](Observation-ExampleGermlineDEL.md),[Observation/ExampleGermlineINV](Observation-ExampleGermlineINV.md),[Observation/ExampleSomaticCNV](Observation-ExampleSomaticCNV.md),[Observation/ExampleSomaticDEL](Observation-ExampleSomaticDEL.md),[Observation/ExampleSomaticINV](Observation-ExampleSomaticINV.md),[Observation/Genotype-Clinical-Trial-Example-using-haplotypes](Observation-Genotype-Clinical-Trial-Example-using-haplotypes.md),[Observation/GenotypeExample1](Observation-GenotypeExample1.md),[Observation/GenotypeExamplePharmVar](Observation-GenotypeExamplePharmVar.md),[Observation/HER2byImmuneStainExample](Observation-HER2byImmuneStainExample.md),[Observation/HER2byImmunoassayExample](Observation-HER2byImmunoassayExample.md),[Observation/HLA-A-haplotype1](Observation-HLA-A-haplotype1.md),[Observation/HLA-A-haplotype2](Observation-HLA-A-haplotype2.md),[Observation/HLA-B-haplotype1](Observation-HLA-B-haplotype1.md),[Observation/HLA-B-haplotype2](Observation-HLA-B-haplotype2.md),[Observation/HLA-C-haplotype1](Observation-HLA-C-haplotype1.md),[Observation/HLA-C-haplotype2](Observation-HLA-C-haplotype2.md),[Observation/HaplotypeExamplePharmVar01](Observation-HaplotypeExamplePharmVar01.md),[Observation/HaplotypeExamplePharmVar02](Observation-HaplotypeExamplePharmVar02.md),[Observation/HaplotypeSet-Clinical-Trial-Example-1of2](Observation-HaplotypeSet-Clinical-Trial-Example-1of2.md),[Observation/HaplotypeSet-Clinical-Trial-Example-2of2](Observation-HaplotypeSet-Clinical-Trial-Example-2of2.md),[Observation/ISCN-CMLExample](Observation-ISCN-CMLExample.md),[Observation/ISCN-CMLImplication](Observation-ISCN-CMLImplication.md),[Observation/ISCN-NormalExample](Observation-ISCN-NormalExample.md),[Observation/MSH2-del-disease](Observation-MSH2-del-disease.md),[Observation/MSH2-del-molc](Observation-MSH2-del-molc.md),[Observation/MSH2-del-var](Observation-MSH2-del-var.md),[Observation/MSIExample](Observation-MSIExample.md),[Observation/MicrosatelliteInstabilityExample01](Observation-MicrosatelliteInstabilityExample01.md),[Observation/MultipleRepeatExpansions](Observation-MultipleRepeatExpansions.md),[Observation/NOTCH1-significance](Observation-NOTCH1-significance.md),[Observation/NOTCH1-uncertain-molc](Observation-NOTCH1-uncertain-molc.md),[Observation/NOTCH1-uncertain-var](Observation-NOTCH1-uncertain-var.md),[Observation/NTHL1-snv-disease](Observation-NTHL1-snv-disease.md),[Observation/NTHL1-snv-molc](Observation-NTHL1-snv-molc.md),[Observation/NTHL1-snv-var](Observation-NTHL1-snv-var.md),[Observation/PDL1Example](Observation-PDL1Example.md),[Observation/Pgx-geno-1001](Observation-Pgx-geno-1001.md),[Observation/Pgx-geno-1002](Observation-Pgx-geno-1002.md),[Observation/Pgx-geno-1003](Observation-Pgx-geno-1003.md),[Observation/Pgx-var-1011](Observation-Pgx-var-1011.md),[Observation/Pgx-var-1012](Observation-Pgx-var-1012.md),[Observation/Pgx-var-1013](Observation-Pgx-var-1013.md),[Observation/Pgx-var-1014](Observation-Pgx-var-1014.md),[Observation/Pgx-var-1015](Observation-Pgx-var-1015.md),[Observation/Pgx-var-1016](Observation-Pgx-var-1016.md),[Observation/Pgx-var-1017](Observation-Pgx-var-1017.md),[Observation/Pgx-var-1018](Observation-Pgx-var-1018.md),[Observation/Pgx-var-1019](Observation-Pgx-var-1019.md),[Observation/Pgx-var-1020](Observation-Pgx-var-1020.md),[Observation/Pgx-var-1021](Observation-Pgx-var-1021.md),[Observation/PolyGenicDiagnosticImpExample](Observation-PolyGenicDiagnosticImpExample.md),[Observation/ROS1-Fusion-disease](Observation-ROS1-Fusion-disease.md),[Observation/ROS1-Fusion-therapuDrug](Observation-ROS1-Fusion-therapuDrug.md),[Observation/ROS1-Fusion-therapuTrial](Observation-ROS1-Fusion-therapuTrial.md),[Observation/ROS1-Fusion-var](Observation-ROS1-Fusion-var.md),[Observation/RepeatExpansion](Observation-RepeatExpansion.md),[Observation/SNVexample](Observation-SNVexample.md),[Observation/STAG2-insertion-molc](Observation-STAG2-insertion-molc.md),[Observation/STAG2-insertion-significance](Observation-STAG2-insertion-significance.md),[Observation/STAG2-insertion-var](Observation-STAG2-insertion-var.md),[Observation/SequencePhaseRelationExample1](Observation-SequencePhaseRelationExample1.md),[Observation/TMB-therapuDrug](Observation-TMB-therapuDrug.md),[Observation/TMBExample](Observation-TMBExample.md),[Observation/Therapeutic-Implication-Clinical-Trial-Somatic](Observation-Therapeutic-Implication-Clinical-Trial-Somatic.md),[Observation/TherapeuticImplicationExample1](Observation-TherapeuticImplicationExample1.md),[Observation/TumorMutationBurdenExample01](Observation-TumorMutationBurdenExample01.md),[Observation/TxImp01](Observation-TxImp01.md),[Observation/TxImp02](Observation-TxImp02.md),[Observation/TxImp03](Observation-TxImp03.md),[Observation/TxImp04](Observation-TxImp04.md),[Observation/TxImp05](Observation-TxImp05.md),[Observation/TxImp06](Observation-TxImp06.md),[Observation/Variant-Somatic-Clinical-Trial](Observation-Variant-Somatic-Clinical-Trial.md),[Observation/VariantExample](Observation-VariantExample.md),[Observation/VariantExample1](Observation-VariantExample1.md),[Observation/VariantExample2](Observation-VariantExample2.md),[Observation/ZFHX3-significance](Observation-ZFHX3-significance.md),[Observation/ZFHX3-uncertain-molc](Observation-ZFHX3-uncertain-molc.md),[Observation/ZFHX3-uncertain-var](Observation-ZFHX3-uncertain-var.md),[Observation/diagnosticImplication-interact-smn1-smn2](Observation-diagnosticImplication-interact-smn1-smn2.md),[Observation/genotype-hla-a-glstring-r4](Observation-genotype-hla-a-glstring-r4.md),[Observation/haplotype-hla-a-1-r4](Observation-haplotype-hla-a-1-r4.md),[Observation/molec-conseq1](Observation-molec-conseq1.md),[Observation/molec-conseq2](Observation-molec-conseq2.md),[Observation/molec-conseq3](Observation-molec-conseq3.md),[Observation/molec-conseq4](Observation-molec-conseq4.md),[Observation/obs-idh-ex](Observation-obs-idh-ex.md),[Observation/obs1-interact-smn1-smn2](Observation-obs1-interact-smn1-smn2.md),[Observation/obs2-interact-smn1-smn2](Observation-obs2-interact-smn1-smn2.md),[Observation/pop-allele-freq](Observation-pop-allele-freq.md),[Observation/therapuDrug1-interact-smn1-smn2](Observation-therapuDrug1-interact-smn1-smn2.md),[Observation/therapuDrug2-interact-smn1-smn2](Observation-therapuDrug2-interact-smn1-smn2.md),[Observation/therapuDrug3-interact-smn1-smn2](Observation-therapuDrug3-interact-smn1-smn2.md),[Observation/variant-with-molec-consequences](Observation-variant-with-molec-consequences.md),[Parameters/FindStudyMetadataOutput](Parameters-FindStudyMetadataOutput.md),[Parameters/FindSubjectDxImplicationsOutput](Parameters-FindSubjectDxImplicationsOutput.md),[Parameters/FindSubjectHaplotypesOutput](Parameters-FindSubjectHaplotypesOutput.md),[Parameters/FindSubjectMolecConseqOutput](Parameters-FindSubjectMolecConseqOutput.md),[Parameters/FindSubjectSpecificHaplotypesOutput](Parameters-FindSubjectSpecificHaplotypesOutput.md),[Parameters/FindSubjectSpecificVariantsOutput](Parameters-FindSubjectSpecificVariantsOutput.md),[Parameters/FindSubjectStructuralIntersectingVariantsOutput](Parameters-FindSubjectStructuralIntersectingVariantsOutput.md),[Parameters/FindSubjectStructuralSubsumingVariantsOutput](Parameters-FindSubjectStructuralSubsumingVariantsOutput.md),[Parameters/FindSubjectTxImplicationsOutput](Parameters-FindSubjectTxImplicationsOutput.md),[Parameters/FindSubjectVariantsOutput](Parameters-FindSubjectVariantsOutput.md),[SequencePhaseRelationship](StructureDefinition-sequence-phase-relationship.md),[ServiceRequest/ExampleServiceRequest](ServiceRequest-ExampleServiceRequest.md),[ServiceRequest/GenomicServiceRequestExample01](ServiceRequest-GenomicServiceRequestExample01.md),[ServiceRequest/servicerequest-hla-a-r4](ServiceRequest-servicerequest-hla-a-r4.md),[Task/MedicationRecommendationExample1](Task-MedicationRecommendationExample1.md),[Task/PGxRecEx01](Task-PGxRecEx01.md),[Task/PGxRecEx02](Task-PGxRecEx02.md),[Task/PGxRecEx03](Task-PGxRecEx03.md),[Task/PGxRecEx04](Task-PGxRecEx04.md),[Task/PGxRecEx05](Task-PGxRecEx05.md),[TherapeuticImplication](StructureDefinition-therapeutic-implication.md)and[Variant](StructureDefinition-variant.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* SNOMED Clinical Terms&reg; (SNOMED CT&reg;): [Bundle/bundle-CG-IG-HLA-FullBundle-01](Bundle-bundle-CG-IG-HLA-FullBundle-01.md), [Bundle/bundle-cgexample](Bundle-bundle-cgexample.md)...Show 34 more,[Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md),[Device/triodenovo-software](Device-triodenovo-software.md),[GeneticTherapeuticImplicationsVS](ValueSet-genetic-therapeutic-implications-vs.md),[GenomicStudy/lungMass](GenomicStudy-lungMass.md),[GenomicStudy/somaticStudy](GenomicStudy-somaticStudy.md),[Observation/AnnotationExample](Observation-AnnotationExample.md),[Observation/EGFR-L858R-therapuDrug1](Observation-EGFR-L858R-therapuDrug1.md),[Observation/EGFR-L858R-therapuDrug2](Observation-EGFR-L858R-therapuDrug2.md),[Observation/ISCN-CMLImplication](Observation-ISCN-CMLImplication.md),[Observation/MSH2-del-disease](Observation-MSH2-del-disease.md),[Observation/NTHL1-snv-disease](Observation-NTHL1-snv-disease.md),[Observation/PolyGenicDiagnosticImpExample](Observation-PolyGenicDiagnosticImpExample.md),[Observation/ROS1-Fusion-therapuDrug](Observation-ROS1-Fusion-therapuDrug.md),[Observation/ROS1-Fusion-therapuTrial](Observation-ROS1-Fusion-therapuTrial.md),[Observation/TMB-therapuDrug](Observation-TMB-therapuDrug.md),[Observation/Therapeutic-Implication-Clinical-Trial-2](Observation-Therapeutic-Implication-Clinical-Trial-2.md),[Observation/Therapeutic-Implication-Clinical-Trial-Somatic](Observation-Therapeutic-Implication-Clinical-Trial-Somatic.md),[Observation/Variant-Somatic-Clinical-Trial](Observation-Variant-Somatic-Clinical-Trial.md),[Observation/diagnosticImplication-interact-smn1-smn2](Observation-diagnosticImplication-interact-smn1-smn2.md),[Observation/therapuDrug1-interact-smn1-smn2](Observation-therapuDrug1-interact-smn1-smn2.md),[Observation/therapuDrug2-interact-smn1-smn2](Observation-therapuDrug2-interact-smn1-smn2.md),[Observation/therapuDrug3-interact-smn1-smn2](Observation-therapuDrug3-interact-smn1-smn2.md),[Parameters/FindSubjectDxImplicationsOutput](Parameters-FindSubjectDxImplicationsOutput.md),[Procedure/SequencingProcedure](Procedure-SequencingProcedure.md),[RiskAssessment/GenRiskDiabetesT2](RiskAssessment-GenRiskDiabetesT2.md),[ServiceRequest/genomicServiceRequest](ServiceRequest-genomicServiceRequest.md),[ServiceRequest/servicerequest-hla-a-r4](ServiceRequest-servicerequest-hla-a-r4.md),[ServiceRequest/somaticServiceRequest](ServiceRequest-somaticServiceRequest.md),[Specimen/GenomicSpecimenExample02](Specimen-GenomicSpecimenExample02.md),[Specimen/genomicSpecimen](Specimen-genomicSpecimen.md),[Specimen/normalSpecimen](Specimen-normalSpecimen.md),[Specimen/specimen-hla-r4](Specimen-specimen-hla-r4.md),[Specimen/tumorSpecimen](Specimen-tumorSpecimen.md)and[TherapeuticImplication](StructureDefinition-therapeutic-implication.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Observation Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-observation-category.html): [Bundle/bundle-CG-IG-HLA-FullBundle-01](Bundle-bundle-CG-IG-HLA-FullBundle-01.md), [Bundle/bundle-CYP2C19](Bundle-bundle-CYP2C19.md)...Show 140 more,[Bundle/bundle-cgexample](Bundle-bundle-cgexample.md),[Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md),[Bundle/bundle-complexVariant-nonHGVS](Bundle-bundle-complexVariant-nonHGVS.md),[Bundle/bundle-compound-heterozygote](Bundle-bundle-compound-heterozygote.md),[Bundle/bundle-oncology-diagnostic](Bundle-bundle-oncology-diagnostic.md),[Bundle/bundle-oncology-report-example](Bundle-bundle-oncology-report-example.md),[Bundle/bundle-oncologyexamples-r4](Bundle-bundle-oncologyexamples-r4.md),[Bundle/bundle-oncologyexamples-r4-withGrouping](Bundle-bundle-oncologyexamples-r4-withGrouping.md),[Bundle/bundle-pgxexample](Bundle-bundle-pgxexample.md),[Bundle/bundle-sequence-phase-relation-CYP2C19](Bundle-bundle-sequence-phase-relation-CYP2C19.md),[DiagnosticImplication](StructureDefinition-diagnostic-implication.md),[GenomicAnnotation](StructureDefinition-genomic-annotation.md),[GenomicBase](StructureDefinition-genomic-base.md),[GenomicFinding](StructureDefinition-finding.md),[GenomicImplication](StructureDefinition-implication.md),[Genotype](StructureDefinition-genotype.md),[Haplotype](StructureDefinition-haplotype.md),[MolecularBiomarker](StructureDefinition-molecular-biomarker.md),[MolecularConsequence](StructureDefinition-molecular-consequence.md),[Observation/ATR-insertion-molc](Observation-ATR-insertion-molc.md),[Observation/ATR-insertion-significance](Observation-ATR-insertion-significance.md),[Observation/ATR-insertion-var](Observation-ATR-insertion-var.md),[Observation/AnnotationExample](Observation-AnnotationExample.md),[Observation/EGFR-L858R-molc](Observation-EGFR-L858R-molc.md),[Observation/EGFR-L858R-significance](Observation-EGFR-L858R-significance.md),[Observation/EGFR-L858R-therapuDrug1](Observation-EGFR-L858R-therapuDrug1.md),[Observation/EGFR-L858R-therapuDrug2](Observation-EGFR-L858R-therapuDrug2.md),[Observation/EGFR-L858R-var](Observation-EGFR-L858R-var.md),[Observation/ExampleGermlineCNV](Observation-ExampleGermlineCNV.md),[Observation/ExampleGermlineDEL](Observation-ExampleGermlineDEL.md),[Observation/ExampleGermlineINV](Observation-ExampleGermlineINV.md),[Observation/ExampleSomaticCNV](Observation-ExampleSomaticCNV.md),[Observation/ExampleSomaticDEL](Observation-ExampleSomaticDEL.md),[Observation/ExampleSomaticINV](Observation-ExampleSomaticINV.md),[Observation/Genotype-Clinical-Trial-Example-using-haplotypes](Observation-Genotype-Clinical-Trial-Example-using-haplotypes.md),[Observation/GenotypeExample1](Observation-GenotypeExample1.md),[Observation/GenotypeExamplePharmVar](Observation-GenotypeExamplePharmVar.md),[Observation/GrouperEx01](Observation-GrouperEx01.md),[Observation/GrouperEx02](Observation-GrouperEx02.md),[Observation/GrouperEx03](Observation-GrouperEx03.md),[Observation/HER2byImmuneStainExample](Observation-HER2byImmuneStainExample.md),[Observation/HER2byImmunoassayExample](Observation-HER2byImmunoassayExample.md),[Observation/HLA-A-haplotype1](Observation-HLA-A-haplotype1.md),[Observation/HLA-A-haplotype2](Observation-HLA-A-haplotype2.md),[Observation/HLA-B-haplotype1](Observation-HLA-B-haplotype1.md),[Observation/HLA-B-haplotype2](Observation-HLA-B-haplotype2.md),[Observation/HLA-C-haplotype1](Observation-HLA-C-haplotype1.md),[Observation/HLA-C-haplotype2](Observation-HLA-C-haplotype2.md),[Observation/HaplotypeExamplePharmVar01](Observation-HaplotypeExamplePharmVar01.md),[Observation/HaplotypeExamplePharmVar02](Observation-HaplotypeExamplePharmVar02.md),[Observation/HaplotypeSet-Clinical-Trial-Example-1of2](Observation-HaplotypeSet-Clinical-Trial-Example-1of2.md),[Observation/HaplotypeSet-Clinical-Trial-Example-2of2](Observation-HaplotypeSet-Clinical-Trial-Example-2of2.md),[Observation/ISCN-CMLExample](Observation-ISCN-CMLExample.md),[Observation/ISCN-CMLImplication](Observation-ISCN-CMLImplication.md),[Observation/ISCN-NormalExample](Observation-ISCN-NormalExample.md),[Observation/MSH2-del-disease](Observation-MSH2-del-disease.md),[Observation/MSH2-del-molc](Observation-MSH2-del-molc.md),[Observation/MSH2-del-var](Observation-MSH2-del-var.md),[Observation/MSIExample](Observation-MSIExample.md),[Observation/MicrosatelliteInstabilityExample01](Observation-MicrosatelliteInstabilityExample01.md),[Observation/MultipleRepeatExpansions](Observation-MultipleRepeatExpansions.md),[Observation/NOTCH1-significance](Observation-NOTCH1-significance.md),[Observation/NOTCH1-uncertain-molc](Observation-NOTCH1-uncertain-molc.md),[Observation/NOTCH1-uncertain-var](Observation-NOTCH1-uncertain-var.md),[Observation/NTHL1-snv-disease](Observation-NTHL1-snv-disease.md),[Observation/NTHL1-snv-molc](Observation-NTHL1-snv-molc.md),[Observation/NTHL1-snv-var](Observation-NTHL1-snv-var.md),[Observation/PDL1Example](Observation-PDL1Example.md),[Observation/Pgx-geno-1001](Observation-Pgx-geno-1001.md),[Observation/Pgx-geno-1002](Observation-Pgx-geno-1002.md),[Observation/Pgx-geno-1003](Observation-Pgx-geno-1003.md),[Observation/Pgx-var-1011](Observation-Pgx-var-1011.md),[Observation/Pgx-var-1012](Observation-Pgx-var-1012.md),[Observation/Pgx-var-1013](Observation-Pgx-var-1013.md),[Observation/Pgx-var-1014](Observation-Pgx-var-1014.md),[Observation/Pgx-var-1015](Observation-Pgx-var-1015.md),[Observation/Pgx-var-1016](Observation-Pgx-var-1016.md),[Observation/Pgx-var-1017](Observation-Pgx-var-1017.md),[Observation/Pgx-var-1018](Observation-Pgx-var-1018.md),[Observation/Pgx-var-1019](Observation-Pgx-var-1019.md),[Observation/Pgx-var-1020](Observation-Pgx-var-1020.md),[Observation/Pgx-var-1021](Observation-Pgx-var-1021.md),[Observation/PolyGenicDiagnosticImpExample](Observation-PolyGenicDiagnosticImpExample.md),[Observation/ROS1-Fusion](Observation-ROS1-Fusion.md),[Observation/ROS1-Fusion-disease](Observation-ROS1-Fusion-disease.md),[Observation/ROS1-Fusion-therapuDrug](Observation-ROS1-Fusion-therapuDrug.md),[Observation/ROS1-Fusion-therapuTrial](Observation-ROS1-Fusion-therapuTrial.md),[Observation/ROS1-Fusion-var](Observation-ROS1-Fusion-var.md),[Observation/RepeatExpansion](Observation-RepeatExpansion.md),[Observation/SNVexample](Observation-SNVexample.md),[Observation/STAG2-insertion-molc](Observation-STAG2-insertion-molc.md),[Observation/STAG2-insertion-significance](Observation-STAG2-insertion-significance.md),[Observation/STAG2-insertion-var](Observation-STAG2-insertion-var.md),[Observation/SequencePhaseRelationExample1](Observation-SequencePhaseRelationExample1.md),[Observation/TMB-therapuDrug](Observation-TMB-therapuDrug.md),[Observation/TMBExample](Observation-TMBExample.md),[Observation/Therapeutic-Implication-Clinical-Trial-2](Observation-Therapeutic-Implication-Clinical-Trial-2.md),[Observation/Therapeutic-Implication-Clinical-Trial-Somatic](Observation-Therapeutic-Implication-Clinical-Trial-Somatic.md),[Observation/TherapeuticImplicationExample1](Observation-TherapeuticImplicationExample1.md),[Observation/TumorMutationBurdenExample01](Observation-TumorMutationBurdenExample01.md),[Observation/TxImp01](Observation-TxImp01.md),[Observation/TxImp02](Observation-TxImp02.md),[Observation/TxImp03](Observation-TxImp03.md),[Observation/TxImp04](Observation-TxImp04.md),[Observation/TxImp05](Observation-TxImp05.md),[Observation/TxImp06](Observation-TxImp06.md),[Observation/Variant-Somatic-Clinical-Trial](Observation-Variant-Somatic-Clinical-Trial.md),[Observation/VariantExample](Observation-VariantExample.md),[Observation/VariantExample1](Observation-VariantExample1.md),[Observation/VariantExample2](Observation-VariantExample2.md),[Observation/ZFHX3-significance](Observation-ZFHX3-significance.md),[Observation/ZFHX3-uncertain-molc](Observation-ZFHX3-uncertain-molc.md),[Observation/ZFHX3-uncertain-var](Observation-ZFHX3-uncertain-var.md),[Observation/diagnosticImplication-interact-smn1-smn2](Observation-diagnosticImplication-interact-smn1-smn2.md),[Observation/genotype-hla-a-glstring-r4](Observation-genotype-hla-a-glstring-r4.md),[Observation/haplotype-hla-a-1-r4](Observation-haplotype-hla-a-1-r4.md),[Observation/molec-conseq1](Observation-molec-conseq1.md),[Observation/molec-conseq2](Observation-molec-conseq2.md),[Observation/molec-conseq3](Observation-molec-conseq3.md),[Observation/molec-conseq4](Observation-molec-conseq4.md),[Observation/obs-idh-ex](Observation-obs-idh-ex.md),[Observation/obs1-interact-smn1-smn2](Observation-obs1-interact-smn1-smn2.md),[Observation/obs2-interact-smn1-smn2](Observation-obs2-interact-smn1-smn2.md),[Observation/pop-allele-freq](Observation-pop-allele-freq.md),[Observation/therapuDrug1-interact-smn1-smn2](Observation-therapuDrug1-interact-smn1-smn2.md),[Observation/therapuDrug2-interact-smn1-smn2](Observation-therapuDrug2-interact-smn1-smn2.md),[Observation/therapuDrug3-interact-smn1-smn2](Observation-therapuDrug3-interact-smn1-smn2.md),[Observation/variant-with-molec-consequences](Observation-variant-with-molec-consequences.md),[Parameters/FindSubjectDxImplicationsOutput](Parameters-FindSubjectDxImplicationsOutput.md),[Parameters/FindSubjectHaplotypesOutput](Parameters-FindSubjectHaplotypesOutput.md),[Parameters/FindSubjectMolecConseqOutput](Parameters-FindSubjectMolecConseqOutput.md),[Parameters/FindSubjectSpecificHaplotypesOutput](Parameters-FindSubjectSpecificHaplotypesOutput.md),[Parameters/FindSubjectSpecificVariantsOutput](Parameters-FindSubjectSpecificVariantsOutput.md),[Parameters/FindSubjectStructuralIntersectingVariantsOutput](Parameters-FindSubjectStructuralIntersectingVariantsOutput.md),[Parameters/FindSubjectStructuralSubsumingVariantsOutput](Parameters-FindSubjectStructuralSubsumingVariantsOutput.md),[Parameters/FindSubjectTxImplicationsOutput](Parameters-FindSubjectTxImplicationsOutput.md),[Parameters/FindSubjectVariantsOutput](Parameters-FindSubjectVariantsOutput.md),[SequencePhaseRelationship](StructureDefinition-sequence-phase-relationship.md),[TherapeuticImplication](StructureDefinition-therapeutic-implication.md)and[Variant](StructureDefinition-variant.md)
* [Risk Probability](http://terminology.hl7.org/6.5.0/CodeSystem-risk-probability.html): [RiskAssessment/GenRiskDiabetesT2](RiskAssessment-GenRiskDiabetesT2.md)
* [diagnosticServiceSectionId](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0074.html): [Bundle/bundle-CG-IG-HLA-FullBundle-01](Bundle-bundle-CG-IG-HLA-FullBundle-01.md), [Bundle/bundle-CYP2C19](Bundle-bundle-CYP2C19.md)...Show 144 more,[Bundle/bundle-cgexample](Bundle-bundle-cgexample.md),[Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md),[Bundle/bundle-complexVariant-nonHGVS](Bundle-bundle-complexVariant-nonHGVS.md),[Bundle/bundle-compound-heterozygote](Bundle-bundle-compound-heterozygote.md),[Bundle/bundle-oncology-diagnostic](Bundle-bundle-oncology-diagnostic.md),[Bundle/bundle-oncology-report-example](Bundle-bundle-oncology-report-example.md),[Bundle/bundle-oncologyexamples-r4](Bundle-bundle-oncologyexamples-r4.md),[Bundle/bundle-oncologyexamples-r4-withGrouping](Bundle-bundle-oncologyexamples-r4-withGrouping.md),[Bundle/bundle-pgxexample](Bundle-bundle-pgxexample.md),[Bundle/bundle-sequence-phase-relation-CYP2C19](Bundle-bundle-sequence-phase-relation-CYP2C19.md),[DiagnosticImplication](StructureDefinition-diagnostic-implication.md),[DiagnosticReport/GenomicReportExample01](DiagnosticReport-GenomicReportExample01.md),[DiagnosticReport/PGxGenomicReportEMERGE](DiagnosticReport-PGxGenomicReportEMERGE.md),[DiagnosticReport/PGxGenomicReportEMERGE-withGrouping](DiagnosticReport-PGxGenomicReportEMERGE-withGrouping.md),[DiagnosticReport/diagnosticreport-hla-glstring-r4](DiagnosticReport-diagnosticreport-hla-glstring-r4.md),[DiagnosticReport/somaticReport](DiagnosticReport-somaticReport.md),[GenomicAnnotation](StructureDefinition-genomic-annotation.md),[GenomicBase](StructureDefinition-genomic-base.md),[GenomicFinding](StructureDefinition-finding.md),[GenomicImplication](StructureDefinition-implication.md),[GenomicReport](StructureDefinition-genomic-report.md),[Genotype](StructureDefinition-genotype.md),[Haplotype](StructureDefinition-haplotype.md),[MolecularBiomarker](StructureDefinition-molecular-biomarker.md),[MolecularConsequence](StructureDefinition-molecular-consequence.md),[Observation/ATR-insertion-molc](Observation-ATR-insertion-molc.md),[Observation/ATR-insertion-significance](Observation-ATR-insertion-significance.md),[Observation/ATR-insertion-var](Observation-ATR-insertion-var.md),[Observation/AnnotationExample](Observation-AnnotationExample.md),[Observation/EGFR-L858R-molc](Observation-EGFR-L858R-molc.md),[Observation/EGFR-L858R-significance](Observation-EGFR-L858R-significance.md),[Observation/EGFR-L858R-therapuDrug1](Observation-EGFR-L858R-therapuDrug1.md),[Observation/EGFR-L858R-therapuDrug2](Observation-EGFR-L858R-therapuDrug2.md),[Observation/EGFR-L858R-var](Observation-EGFR-L858R-var.md),[Observation/ExampleGermlineCNV](Observation-ExampleGermlineCNV.md),[Observation/ExampleGermlineDEL](Observation-ExampleGermlineDEL.md),[Observation/ExampleGermlineINV](Observation-ExampleGermlineINV.md),[Observation/ExampleSomaticCNV](Observation-ExampleSomaticCNV.md),[Observation/ExampleSomaticDEL](Observation-ExampleSomaticDEL.md),[Observation/ExampleSomaticINV](Observation-ExampleSomaticINV.md),[Observation/Genotype-Clinical-Trial-Example-using-haplotypes](Observation-Genotype-Clinical-Trial-Example-using-haplotypes.md),[Observation/GenotypeExample1](Observation-GenotypeExample1.md),[Observation/GenotypeExamplePharmVar](Observation-GenotypeExamplePharmVar.md),[Observation/GrouperEx01](Observation-GrouperEx01.md),[Observation/GrouperEx02](Observation-GrouperEx02.md),[Observation/GrouperEx03](Observation-GrouperEx03.md),[Observation/HLA-A-haplotype1](Observation-HLA-A-haplotype1.md),[Observation/HLA-A-haplotype2](Observation-HLA-A-haplotype2.md),[Observation/HLA-B-haplotype1](Observation-HLA-B-haplotype1.md),[Observation/HLA-B-haplotype2](Observation-HLA-B-haplotype2.md),[Observation/HLA-C-haplotype1](Observation-HLA-C-haplotype1.md),[Observation/HLA-C-haplotype2](Observation-HLA-C-haplotype2.md),[Observation/HaplotypeExamplePharmVar01](Observation-HaplotypeExamplePharmVar01.md),[Observation/HaplotypeExamplePharmVar02](Observation-HaplotypeExamplePharmVar02.md),[Observation/HaplotypeSet-Clinical-Trial-Example-1of2](Observation-HaplotypeSet-Clinical-Trial-Example-1of2.md),[Observation/HaplotypeSet-Clinical-Trial-Example-2of2](Observation-HaplotypeSet-Clinical-Trial-Example-2of2.md),[Observation/ISCN-CMLExample](Observation-ISCN-CMLExample.md),[Observation/ISCN-CMLImplication](Observation-ISCN-CMLImplication.md),[Observation/ISCN-NormalExample](Observation-ISCN-NormalExample.md),[Observation/MSH2-del-disease](Observation-MSH2-del-disease.md),[Observation/MSH2-del-molc](Observation-MSH2-del-molc.md),[Observation/MSH2-del-var](Observation-MSH2-del-var.md),[Observation/MSIExample](Observation-MSIExample.md),[Observation/MicrosatelliteInstabilityExample01](Observation-MicrosatelliteInstabilityExample01.md),[Observation/MultipleRepeatExpansions](Observation-MultipleRepeatExpansions.md),[Observation/NOTCH1-significance](Observation-NOTCH1-significance.md),[Observation/NOTCH1-uncertain-molc](Observation-NOTCH1-uncertain-molc.md),[Observation/NOTCH1-uncertain-var](Observation-NOTCH1-uncertain-var.md),[Observation/NTHL1-snv-disease](Observation-NTHL1-snv-disease.md),[Observation/NTHL1-snv-molc](Observation-NTHL1-snv-molc.md),[Observation/NTHL1-snv-var](Observation-NTHL1-snv-var.md),[Observation/PDL1Example](Observation-PDL1Example.md),[Observation/Pgx-geno-1001](Observation-Pgx-geno-1001.md),[Observation/Pgx-geno-1002](Observation-Pgx-geno-1002.md),[Observation/Pgx-geno-1003](Observation-Pgx-geno-1003.md),[Observation/Pgx-var-1011](Observation-Pgx-var-1011.md),[Observation/Pgx-var-1012](Observation-Pgx-var-1012.md),[Observation/Pgx-var-1013](Observation-Pgx-var-1013.md),[Observation/Pgx-var-1014](Observation-Pgx-var-1014.md),[Observation/Pgx-var-1015](Observation-Pgx-var-1015.md),[Observation/Pgx-var-1016](Observation-Pgx-var-1016.md),[Observation/Pgx-var-1017](Observation-Pgx-var-1017.md),[Observation/Pgx-var-1018](Observation-Pgx-var-1018.md),[Observation/Pgx-var-1019](Observation-Pgx-var-1019.md),[Observation/Pgx-var-1020](Observation-Pgx-var-1020.md),[Observation/Pgx-var-1021](Observation-Pgx-var-1021.md),[Observation/PolyGenicDiagnosticImpExample](Observation-PolyGenicDiagnosticImpExample.md),[Observation/ROS1-Fusion](Observation-ROS1-Fusion.md),[Observation/ROS1-Fusion-disease](Observation-ROS1-Fusion-disease.md),[Observation/ROS1-Fusion-therapuDrug](Observation-ROS1-Fusion-therapuDrug.md),[Observation/ROS1-Fusion-therapuTrial](Observation-ROS1-Fusion-therapuTrial.md),[Observation/ROS1-Fusion-var](Observation-ROS1-Fusion-var.md),[Observation/RepeatExpansion](Observation-RepeatExpansion.md),[Observation/SNVexample](Observation-SNVexample.md),[Observation/STAG2-insertion-molc](Observation-STAG2-insertion-molc.md),[Observation/STAG2-insertion-significance](Observation-STAG2-insertion-significance.md),[Observation/STAG2-insertion-var](Observation-STAG2-insertion-var.md),[Observation/SequencePhaseRelationExample1](Observation-SequencePhaseRelationExample1.md),[Observation/TMB-therapuDrug](Observation-TMB-therapuDrug.md),[Observation/TMBExample](Observation-TMBExample.md),[Observation/Therapeutic-Implication-Clinical-Trial-2](Observation-Therapeutic-Implication-Clinical-Trial-2.md),[Observation/Therapeutic-Implication-Clinical-Trial-Somatic](Observation-Therapeutic-Implication-Clinical-Trial-Somatic.md),[Observation/TherapeuticImplicationExample1](Observation-TherapeuticImplicationExample1.md),[Observation/TumorMutationBurdenExample01](Observation-TumorMutationBurdenExample01.md),[Observation/TxImp01](Observation-TxImp01.md),[Observation/TxImp02](Observation-TxImp02.md),[Observation/TxImp03](Observation-TxImp03.md),[Observation/TxImp04](Observation-TxImp04.md),[Observation/TxImp05](Observation-TxImp05.md),[Observation/TxImp06](Observation-TxImp06.md),[Observation/Variant-Somatic-Clinical-Trial](Observation-Variant-Somatic-Clinical-Trial.md),[Observation/VariantExample](Observation-VariantExample.md),[Observation/VariantExample1](Observation-VariantExample1.md),[Observation/VariantExample2](Observation-VariantExample2.md),[Observation/ZFHX3-significance](Observation-ZFHX3-significance.md),[Observation/ZFHX3-uncertain-molc](Observation-ZFHX3-uncertain-molc.md),[Observation/ZFHX3-uncertain-var](Observation-ZFHX3-uncertain-var.md),[Observation/diagnosticImplication-interact-smn1-smn2](Observation-diagnosticImplication-interact-smn1-smn2.md),[Observation/genotype-hla-a-glstring-r4](Observation-genotype-hla-a-glstring-r4.md),[Observation/haplotype-hla-a-1-r4](Observation-haplotype-hla-a-1-r4.md),[Observation/molec-conseq1](Observation-molec-conseq1.md),[Observation/molec-conseq2](Observation-molec-conseq2.md),[Observation/molec-conseq3](Observation-molec-conseq3.md),[Observation/molec-conseq4](Observation-molec-conseq4.md),[Observation/obs-idh-ex](Observation-obs-idh-ex.md),[Observation/obs1-interact-smn1-smn2](Observation-obs1-interact-smn1-smn2.md),[Observation/obs2-interact-smn1-smn2](Observation-obs2-interact-smn1-smn2.md),[Observation/pop-allele-freq](Observation-pop-allele-freq.md),[Observation/therapuDrug1-interact-smn1-smn2](Observation-therapuDrug1-interact-smn1-smn2.md),[Observation/therapuDrug2-interact-smn1-smn2](Observation-therapuDrug2-interact-smn1-smn2.md),[Observation/therapuDrug3-interact-smn1-smn2](Observation-therapuDrug3-interact-smn1-smn2.md),[Observation/variant-with-molec-consequences](Observation-variant-with-molec-consequences.md),[Parameters/FindSubjectDxImplicationsOutput](Parameters-FindSubjectDxImplicationsOutput.md),[Parameters/FindSubjectHaplotypesOutput](Parameters-FindSubjectHaplotypesOutput.md),[Parameters/FindSubjectMolecConseqOutput](Parameters-FindSubjectMolecConseqOutput.md),[Parameters/FindSubjectSpecificHaplotypesOutput](Parameters-FindSubjectSpecificHaplotypesOutput.md),[Parameters/FindSubjectSpecificVariantsOutput](Parameters-FindSubjectSpecificVariantsOutput.md),[Parameters/FindSubjectStructuralIntersectingVariantsOutput](Parameters-FindSubjectStructuralIntersectingVariantsOutput.md),[Parameters/FindSubjectStructuralSubsumingVariantsOutput](Parameters-FindSubjectStructuralSubsumingVariantsOutput.md),[Parameters/FindSubjectTxImplicationsOutput](Parameters-FindSubjectTxImplicationsOutput.md),[Parameters/FindSubjectVariantsOutput](Parameters-FindSubjectVariantsOutput.md),[SequencePhaseRelationship](StructureDefinition-sequence-phase-relationship.md),[TherapeuticImplication](StructureDefinition-therapeutic-implication.md)and[Variant](StructureDefinition-variant.md)
* [identifierType](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0203.html): [Bundle/bundle-CG-IG-HLA-FullBundle-01](Bundle-bundle-CG-IG-HLA-FullBundle-01.md), [DiagnosticReport/somaticReport](DiagnosticReport-somaticReport.md)...Show 10 more,[Patient/CGPatientExample01](Patient-CGPatientExample01.md),[Patient/HG00403](Patient-HG00403.md),[Patient/denovoChild](Patient-denovoChild.md),[Patient/denovoFather](Patient-denovoFather.md),[Patient/denovoMother](Patient-denovoMother.md),[Patient/genomicPatient](Patient-genomicPatient.md),[Patient/somaticPatient](Patient-somaticPatient.md),[Practitioner/practitioner02](Practitioner-practitioner02.md),[ServiceRequest/genomicServiceRequest](ServiceRequest-genomicServiceRequest.md)and[ServiceRequest/somaticServiceRequest](ServiceRequest-somaticServiceRequest.md)
* [specimenType](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0487.html): [Bundle/bundle-oncology-report-example](Bundle-bundle-oncology-report-example.md) and [Specimen/GenomicSpecimenExample01](Specimen-GenomicSpecimenExample01.md)
* [Confidentiality](http://terminology.hl7.org/6.5.0/CodeSystem-v3-Confidentiality.html): [DocumentReference/CNVAnalysis-called](DocumentReference-CNVAnalysis-called.md), [DocumentReference/FullGenome-GRCh38](DocumentReference-FullGenome-GRCh38.md)...Show 11 more,[DocumentReference/SimpleVariantAnalysis-called](DocumentReference-SimpleVariantAnalysis-called.md),[DocumentReference/UncallableRegions](DocumentReference-UncallableRegions.md),[DocumentReference/WES-FullSequencedRegion-GRCh38](DocumentReference-WES-FullSequencedRegion-GRCh38.md),[DocumentReference/WES-UncallableRegions-GRCh38](DocumentReference-WES-UncallableRegions-GRCh38.md),[DocumentReference/genomicFileFatherBAM](DocumentReference-genomicFileFatherBAM.md),[DocumentReference/genomicFileMotherBAM](DocumentReference-genomicFileMotherBAM.md),[DocumentReference/genomicFileProbandBAM](DocumentReference-genomicFileProbandBAM.md),[DocumentReference/genomicFileProbandVCF](DocumentReference-genomicFileProbandVCF.md),[DocumentReference/genomicVCFfile-cnv](DocumentReference-genomicVCFfile-cnv.md),[DocumentReference/genomicVCFfile-simple](DocumentReference-genomicVCFfile-simple.md)and[DocumentReference/somaticVCFfile](DocumentReference-somaticVCFfile.md)
* [ParticipationType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html): [GenomicStudy/lungMass](GenomicStudy-lungMass.md)


* Using RxNorm codes of type SAB=RXNORM as this specification describes does not require a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right.

* [RxNorm](http://terminology.hl7.org/6.5.0/CodeSystem-v3-rxNorm.html): [Bundle/bundle-cgexample](Bundle-bundle-cgexample.md), [Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md)...Show 11 more,[Bundle/bundle-oncologyexamples-r4-withGrouping](Bundle-bundle-oncologyexamples-r4-withGrouping.md),[Bundle/bundle-pgxexample](Bundle-bundle-pgxexample.md),[MedicationStatement/MedicationStatementWarfarin](MedicationStatement-MedicationStatementWarfarin.md),[Observation/TherapeuticImplicationExample1](Observation-TherapeuticImplicationExample1.md),[Observation/TxImp01](Observation-TxImp01.md),[Observation/TxImp02](Observation-TxImp02.md),[Observation/TxImp03](Observation-TxImp03.md),[Observation/TxImp04](Observation-TxImp04.md),[Observation/TxImp05](Observation-TxImp05.md),[Observation/TxImp06](Observation-TxImp06.md)and[Parameters/FindSubjectTxImplicationsOutput](Parameters-FindSubjectTxImplicationsOutput.md)


### Appendices

| | |
| :--- | :--- |
| [Appendix A: Relation to v2 reporting](v2.md) | Links to v2 Genetic Variation Model Implementation Guide and v2 Cytogenomic Model Implementation Guide |
| [Appendix B: Clinical Genomics Apps](cgapps.md) | Introduction of the Clinical Genomics Applications (Genomics Advisor, etc) apply for this implementation guide |
| [Appendix C: Domain Analysis Model](domain.md) | A domain analysis model for various use cases in clinical genomics |
| [Appendix D: Query Guidance](usecases.md) | Query guidance based on use-cases from the Domain Analysis Document |
| [Appendix E: External Coding Systems](codings.md) | Reference for publicly available external coding systems |
| [Appendix F: Conversion from FHIR Core STU3](conversion.md) | Notes on since deprecated extensions defined in FHIR Core STU3 |
| [Appendix G: Molecular Sequence](molecularsequence.md) | Notes on the FHIR Resource for representing a Molecular Sequence |
| [Appendix H: Grouping observations](groupingguidance.md) | Guidance on the types of grouping that might be encountered |
| [Appendix I: Glossary](glossary.md) | Table of concepts referenced on Observation profiles |

### Acknowledgments

The Genomics Reporting Implementation Guide is a product of the [HL7 Clinical Genomics Work Group](https://confluence.hl7.org/display/CGW/WorkGroup+Home). The work group welcomes and actively encourages feedback on this guide. Whether you have questions regarding its usage, recommendations for improvement, or identify any issues requiring correction, please don't hesitate to reach out to us! You may propose a change (see link at the bottom of the page), reach out on [Zulip](https://chat.fhir.org/#narrow/stream/179197-genomics) to chat, or email the Work Group at [clingenomics@lists.hl7.org](mailto:clingenomics@lists.hl7.org).

The authors of this guide wish to recognize the following participants who contributed their time and expertise to the continued development of this guide:

| | | |
| :--- | :--- | :--- |
| Srikar Chamala | Childrens Hospital of Los Angeles | CG Co-Chair |
| Willie Chang | Epic | Contributor |
| Bob Dolin | Elimu Informatics | Contributor |
| Bob Freimuth | Mayo Clinic | CG Co-Chair, IM Sub-Group Lead |
| Bret Heale | Intermountain | Contributor |
| Arthur Hermann | Kaiser Permanente | Contributor |
| Jamie Jones | Boston Children's Hospital | CG Co-Chair, Modeling Sub-Group Lead |
| Aly Khalifa | Mayo Clinic | Contributor |
| Anand Kulanthaivel | Clinical Architecture | Contributor |
| Lloyd McKenzie | Dogwood Consulting | Contributor |
| Mullai Murugan | Baylor College of Medicine | Contributor |
| JD Nolen | Children's Mercy Hospital | Contributor |
| Kevin Power | Children's Mercy Hospital | Contributor |
| Joel Schneider | NMDP/CIBMTR | Contributor |
| May Terry | MITRE Corporation | CG Co-Chair |
| Michael Watkins | University of Chicago | CG Co-Chair |
| Patrick Werner | MOLIT Institut | CG Co-Chair |



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.uv.genomics-reporting",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/hl7.fhir.uv.genomics-reporting",
  "version" : "4.0.0-ballot",
  "name" : "GenomicsReporting",
  "title" : "Genomics Reporting Implementation Guide",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Guidelines for reporting of clinical genomics results using HL7 FHIR.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.uv.genomics-reporting",
  "license" : "CC0-1.0",
  "fhirVersion" : ["6.0.0-ballot3"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r5",
      "version" : "6.5.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r5",
      "version" : "5.2.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r5#0.8.0"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/annotation-code"
        },
        "name" : "Annotation Code",
        "description" : "Codifies the content of an Annotation",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/AnnotationExample"
        },
        "name" : "AnnotationExample",
        "description" : "Example of a Diagnostic Implication for Familial hypercholesterolemia",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ATR-insertion-molc"
        },
        "name" : "ATR-insertion-molc",
        "description" : "Example Molecular Consequence ATR frameshift",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ATR-insertion-significance"
        },
        "name" : "ATR-insertion-significance",
        "description" : "Example DiagnosticImplication - ATR likely pathogenic",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ATR-insertion-var"
        },
        "name" : "ATR-insertion-var",
        "description" : "Example for ATR insertion",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bundle-CG-IG-HLA-FullBundle-01"
        },
        "name" : "bundle-CG-IG-HLA-FullBundle-01",
        "description" : "Example of a HLA bundle",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bundle-cgexample"
        },
        "name" : "bundle-cgexample",
        "description" : "Example bundle showing a variety of profiles.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bundle-cgexample-withGrouping"
        },
        "name" : "bundle-cgexample-withGrouping",
        "description" : "Example bundle showing a variety of profiles, including how groupings of Observations might be delivered.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bundle-complexVariant-nonHGVS"
        },
        "name" : "bundle-complexVariant-nonHGVS",
        "description" : "Example bundle with compound heterozygous variant, where the specific changes are represented without HGVS.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bundle-compound-heterozygote"
        },
        "name" : "bundle-compound-heterozygote",
        "description" : "Example bundle with compound heterozygous variant, where the specific changes are represented with HGVS.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bundle-CYP2C19"
        },
        "name" : "bundle-CYP2C19",
        "description" : "Example bundle containing CYP2C19 report and variants",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bundle-oncology-diagnostic"
        },
        "name" : "bundle-oncology-diagnostic",
        "description" : "Example of an oncology report, TMB, variants, and implications.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bundle-oncology-report-example"
        },
        "name" : "bundle-oncology-report-example",
        "description" : "Example oncology bundle including report, variants, and other resources.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bundle-oncologyexamples-r4"
        },
        "name" : "bundle-oncologyexamples-r4",
        "description" : "Example bundle with an oncology report with SNVs, TMB, MSI, and therapy matches.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bundle-oncologyexamples-r4-withGrouping"
        },
        "name" : "bundle-oncologyexamples-r4-withGrouping",
        "description" : "Example bundle with an oncology report with SNVs, TMB, MSI, and therapy matches, including some groupings of observations",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bundle-pgxexample"
        },
        "name" : "bundle-pgxexample",
        "description" : "Example bundle with a PGx report and a variety of observations.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/bundle-sequence-phase-relation-CYP2C19"
        },
        "name" : "bundle-sequence-phase-relation-CYP2C19",
        "description" : "Example Sequence Phase Relation showing a report with two variants in cis",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/CGPatientExample01"
        },
        "name" : "CGPatientExample01",
        "description" : "Example for Patient. Supports references to subject for multiple genomics reporting profile conforming instances.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/clinvar-evidence-level-custom-cs"
        },
        "name" : "ClinVar Evidence Level Example Codes",
        "description" : "ClinVar contains examples of evidence level concepts that are not conflated with clinical significance. These can be found on  ClinVar https://www.ncbi.nlm.nih.gov/clinvar/docs/review_status/ . These examples are informational only, for copyright information contact the relevant source.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/CNVAnalysis-called"
        },
        "name" : "CNVAnalysis-called",
        "description" : "CNVAnalysis_called: A sample Document Reference instance representing a BED file that may be used as input or output of a genomic analysis pipeline.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/coded-annotation"
        },
        "name" : "Coded Annotation",
        "description" : "Annotation DataType with added CodeableConcept extension element",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/coded-annotation-types-cs"
        },
        "name" : "Coded Annotation Type Codes",
        "description" : "Code System for specific types of coded annotations",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/coded-annotation-types-vs"
        },
        "name" : "Coded Annotation Types",
        "description" : "Value Set for specific types of coded annotations",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/condition-inheritance-mode-vs"
        },
        "name" : "Condition Inheritance Patterns",
        "description" : "Value Set for specific transmission patterns of a condition in a pedigree",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/denovoChild"
        },
        "name" : "denovoChild",
        "description" : "Child of a trio",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/denovoFather"
        },
        "name" : "denovoFather",
        "description" : "Father of a trio",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/denovoMother"
        },
        "name" : "denovoMother",
        "description" : "Mother of a trio",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/diagnostic-implication"
        },
        "name" : "Diagnostic Implication",
        "description" : "Observation stating a diagnostic annotation (e.g. disease risk) on one or more genotype/haplotype/variant/biomarker observations.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/diagnosticImplication-interact-smn1-smn2"
        },
        "name" : "diagnosticImplication-interact-smn1-smn2",
        "description" : "Diagnostic Implication for SMN1/SMN2 CNV example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DiagnosticReport"
          }
        ],
        "reference" : {
          "reference" : "DiagnosticReport/diagnosticreport-hla-glstring-r4"
        },
        "name" : "diagnosticreport-hla-glstring-r4",
        "description" : "Example GenomicReport including an HLA glstring",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/dna-change-type-vs"
        },
        "name" : "DNA Change Type",
        "description" : "DNA Change Type of a variant.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/dna-change-type-map"
        },
        "name" : "DNA Change Type Map",
        "description" : "Mapping from http://loinc.org ValueSet for DNA Change Type to http://www.sequenceontology.org codes",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/EGFR-L858R-molc"
        },
        "name" : "EGFR-L858R-molc",
        "description" : "Example Molecular Consequence EGFR L858R missense_variant",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/EGFR-L858R-significance"
        },
        "name" : "EGFR-L858R-significance",
        "description" : "Example DiagnosticImplication - EGFR pathogenic",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/EGFR-L858R-therapuDrug1"
        },
        "name" : "EGFR-L858R-therapuDrug1",
        "description" : "Example of EGFR-L858R Therapeutic Implication for drug treatment 1",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/EGFR-L858R-therapuDrug2"
        },
        "name" : "EGFR-L858R-therapuDrug2",
        "description" : "Example of EGFR-L858R Therapeutic Implication for drug treatment 2",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/EGFR-L858R-var"
        },
        "name" : "EGFR-L858R-var",
        "description" : "Example for EGFR L858R",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/eMERGEServiceRequest"
        },
        "name" : "eMERGEServiceRequest",
        "description" : "Example PGx Service Request",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/evidence-level-example-vs"
        },
        "name" : "Evidence Level Examples",
        "description" : "Example sources of values for Evidence Level",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ExampleGermlineCNV"
        },
        "name" : "ExampleGermlineCNV",
        "description" : "Example for germline CNV",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ExampleGermlineDEL"
        },
        "name" : "ExampleGermlineDEL",
        "description" : "Example for germline DEL",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ExampleGermlineINV"
        },
        "name" : "ExampleGermlineINV",
        "description" : "Example for germline INV",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/ExampleLab"
        },
        "name" : "ExampleLab",
        "description" : "Organization (lab) example",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/ExampleOrg"
        },
        "name" : "ExampleOrg",
        "description" : "Example Org",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/ExamplePatient"
        },
        "name" : "ExamplePatient",
        "description" : "Patient example",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/ExampleServiceRequest"
        },
        "name" : "ExampleServiceRequest",
        "description" : "ServiceRequest (order) example",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ExampleSomaticCNV"
        },
        "name" : "ExampleSomaticCNV",
        "description" : "Example for somatic CNV",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ExampleSomaticDEL"
        },
        "name" : "ExampleSomaticDEL",
        "description" : "Example for somatic DEL",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ExampleSomaticINV"
        },
        "name" : "ExampleSomaticINV",
        "description" : "Example for somatic INV",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/ExampleSpecimen"
        },
        "name" : "ExampleSpecimen",
        "description" : "Specimen example",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-population-dx-implications"
        },
        "name" : "Find Population Diagnostic Implications",
        "description" : "Retrieve count or list of patients having diagnostic implications.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-population-molecular-consequences"
        },
        "name" : "Find Population Molecular Consequences",
        "description" : "Retrieve count or list of patients having molecular consequences.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-population-specific-haplotypes"
        },
        "name" : "Find Population Specific Haplotypes",
        "description" : "Retrieve count or list of patients having specified genotypes/haplotypes.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-population-specific-variants"
        },
        "name" : "Find Population Specific Variants",
        "description" : "Retrieve count or list of patients having specified variants.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-population-structural-intersecting-variants"
        },
        "name" : "Find Population Structural Intersecting Variants",
        "description" : "Retrieve count or list of patients having structural intersecting variants in specified regions.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-population-structural-subsuming-variants"
        },
        "name" : "Find Population Structural Subsuming Variants",
        "description" : "Retrieve count or list of patients having structural subsuming variants in specified regions.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-population-tx-implications"
        },
        "name" : "Find Population Treatment Implications",
        "description" : "Retrieve count or list of patients having therapeutic implications.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-study-metadata"
        },
        "name" : "Find Study Metadata",
        "description" : "Retrieve metadata about sequencing studies performed on a subject.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-subject-dx-implications"
        },
        "name" : "Find Subject Diagnostic Implications",
        "description" : "Retrieves genetic diagnostic implications for variants.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-subject-haplotypes"
        },
        "name" : "Find Subject Haplotypes",
        "description" : "Retrieve haplotypes/genotypes for specified genes.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-subject-molecular-consequences"
        },
        "name" : "Find Subject Molecular Consequences",
        "description" : "Retrieves molecular consequences of a DNA variant.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-subject-specific-haplotypes"
        },
        "name" : "Find Subject Specific Haplotypes",
        "description" : "See if specified haplotypes/genotypes are present.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-subject-specific-variants"
        },
        "name" : "Find Subject Specific Variants",
        "description" : "Determine if specified simple variants are present.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-subject-structural-intersecting-variants"
        },
        "name" : "Find Subject Structural Intersecting Variants",
        "description" : "Determine if structural variants are present that overlap range(s).",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-subject-structural-subsuming-variants"
        },
        "name" : "Find Subject Structural Subsuming Variants",
        "description" : "Determine if structural variants are present that fully subsume a range.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-subject-tx-implications"
        },
        "name" : "Find Subject Treatment Implications",
        "description" : "Retrieves genetic therapeutic implications for variants/haplotypes/genotypes.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/find-subject-variants"
        },
        "name" : "Find Subject Variants",
        "description" : "Determine if simple variants are present that overlap range(s).",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindALLPopulationSpecificVariantsOutput"
        },
        "name" : "FindALLPopulationSpecificVariantsOutput",
        "description" : "Example Output of 'FindPopulationSpecificVariants' Operation, based on 'AND' logic",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindANYPopulationSpecificVariantsOutput"
        },
        "name" : "FindANYPopulationSpecificVariantsOutput",
        "description" : "Example Output of 'FindPopulationSpecificVariants' Operation, based on 'OR' logic",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindPopulationDxImplicationsOutput"
        },
        "name" : "FindPopulationDxImplicationsOutput",
        "description" : "Example Output of 'FindPopulationDxImplications' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindPopulationMolecConseqOutput"
        },
        "name" : "FindPopulationMolecConseqOutput",
        "description" : "Example Output of 'FindPopulationMolecConseq' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindPopulationSpecificHaplotypesOutput"
        },
        "name" : "FindPopulationSpecificHaplotypesOutput",
        "description" : "Example Output of 'FindPopulationSpecificHaplotypes' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindPopulationStructuralIntersectingVariantsOutput"
        },
        "name" : "FindPopulationStructuralIntersectingVariantsOutput",
        "description" : "Example Output of 'FindPopulationStructuralIntersectingVariants' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindPopulationStructuralSubsumingVariantsOutput"
        },
        "name" : "FindPopulationStructuralSubsumingVariantsOutput",
        "description" : "Example Output of 'FindPopulationStructuralSubsumingVariants' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindPopulationTxImplicationsOutput"
        },
        "name" : "FindPopulationTxImplicationsOutput",
        "description" : "Example Output of 'FindPopulationTxImplications' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindStudyMetadataOutput"
        },
        "name" : "FindStudyMetadataOutput",
        "description" : "Example Output of 'FindStudyMetadata' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindSubjectDxImplicationsOutput"
        },
        "name" : "FindSubjectDxImplicationsOutput",
        "description" : "Example Output of 'FindSubjectDxImplications' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindSubjectHaplotypesOutput"
        },
        "name" : "FindSubjectHaplotypesOutput",
        "description" : "Example Output of 'FindSubjectHaplotypes' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindSubjectMolecConseqOutput"
        },
        "name" : "FindSubjectMolecConseqOutput",
        "description" : "Example Output of 'FindSubjectMolecConseq' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindSubjectSpecificHaplotypesOutput"
        },
        "name" : "FindSubjectSpecificHaplotypesOutput",
        "description" : "Example Output of 'FindSubjectSpecificHaplotypes' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindSubjectSpecificVariantsOutput"
        },
        "name" : "FindSubjectSpecificVariantsOutput",
        "description" : "Example Output of 'FindSubjectSpecificVariants' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindSubjectStructuralIntersectingVariantsOutput"
        },
        "name" : "FindSubjectStructuralIntersectingVariantsOutput",
        "description" : "Example Output of 'FindSubjectStructuralIntersectingVariants' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindSubjectStructuralSubsumingVariantsOutput"
        },
        "name" : "FindSubjectStructuralSubsumingVariantsOutput",
        "description" : "Example Output of 'FindSubjectStructuralSubsumingVariants' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindSubjectTxImplicationsOutput"
        },
        "name" : "FindSubjectTxImplicationsOutput",
        "description" : "Example Output of 'FindSubjectTxImplications' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/FindSubjectVariantsOutput"
        },
        "name" : "FindSubjectVariantsOutput",
        "description" : "Example Output of 'Find Subject Variants' Operation",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/followup-recommendation"
        },
        "name" : "Followup Recommendation",
        "description" : "Task proposing a follow-up that is recommended based on the implications of genomic findings.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/FullGenome-GRCh38"
        },
        "name" : "FullGenome-GRCh38",
        "description" : "Example for Genomic Data File FullGenome-GRCh38",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/functional-effect-vs"
        },
        "name" : "Functional Effect Value Set",
        "description" : "The effect of a variant on downstream biological products or pathways.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/genetic-therapeutic-implications-vs"
        },
        "name" : "Genetic Therapeutic Implications",
        "description" : "Value Set for terms that describe a predicted ramification based on the presence of associated molecular finding(s).",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/genomic-annotation"
        },
        "name" : "Genomic Annotation",
        "description" : "Profile for communicating miscellaneous genomic annotations that are neither Diagnostic Implications, Therapeutic Implications, nor Molecular Consequences.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/genomic-base"
        },
        "name" : "Genomic Base",
        "description" : "Base profile that defines characteristics shared by all genetic observations.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/genomic-data-file"
        },
        "name" : "Genomic Data File",
        "description" : "A profile of DocumentReference used to represent a genomics file.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/finding"
        },
        "name" : "Genomic Finding",
        "description" : "Properties common to genetic findings whose results are expressed as computable discrete elements (e.g. genotypes, haplotypes, variants, etc.).",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/implication"
        },
        "name" : "Genomic Implication",
        "description" : "Properties common to genomic implications expressed as computable discrete elements.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/genomic-report"
        },
        "name" : "Genomic Report",
        "description" : "Genomic profile of DiagnosticReport.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/genomic-report-note"
        },
        "name" : "Genomic Report Note",
        "description" : "Adds codified notes to a report to capture additional content",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/genomic-risk-assessment"
        },
        "name" : "Genomic Risk Assessment",
        "description" : "RiskAssessment delivered as part of a genomics report or observation",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/genomicFileFatherBAM"
        },
        "name" : "genomicFileFatherBAM",
        "description" : "A sample Document Reference instance representing a generic genomic file that may ber used as input or output of a genomic analysis pipeline",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/genomicFileMotherBAM"
        },
        "name" : "genomicFileMotherBAM",
        "description" : "A sample Document Reference instance representing a generic genomic file that may ber used as input or output of a genomic analysis pipeline",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/genomicFileProbandBAM"
        },
        "name" : "genomicFileProbandBAM",
        "description" : "A sample Document Reference instance representing a generic genomic file that may ber used as input or output of a genomic analysis pipeline",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/genomicFileProbandVCF"
        },
        "name" : "genomicFileProbandVCF",
        "description" : "A sample Document Reference instance representing a generic genomic file that may ber used as input or output of a genomic analysis pipeline",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/genomicPatient"
        },
        "name" : "genomicPatient",
        "description" : "Example patient",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DiagnosticReport"
          }
        ],
        "reference" : {
          "reference" : "DiagnosticReport/GenomicReportExample01"
        },
        "name" : "GenomicReportExample01",
        "description" : "Example of a Report carrying a Genotype, Therapeutic Implication, and Medication Recommendation",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/genomicServiceRequest"
        },
        "name" : "genomicServiceRequest",
        "description" : "Example of Molecular genetic test",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/GenomicServiceRequestExample01"
        },
        "name" : "GenomicServiceRequestExample01",
        "description" : "Example for Service Request",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/genomicSpecimen"
        },
        "name" : "genomicSpecimen",
        "description" : "Example of lung specimen obtained by biopsy",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/GenomicSpecimenExample01"
        },
        "name" : "GenomicSpecimenExample01",
        "description" : "Example for Genomic Specimen",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/GenomicSpecimenExample02"
        },
        "name" : "GenomicSpecimenExample02",
        "description" : "Example for Genomic Specimen from Buccal Swab",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "GenomicStudy"
          }
        ],
        "reference" : {
          "reference" : "GenomicStudy/genomicstudy-trio2"
        },
        "name" : "genomicstudy-trio2",
        "description" : "GenomicStudy example of a trio analysis",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/genomicVCFfile-cnv"
        },
        "name" : "genomicVCFfile-cnv",
        "description" : "genomicVCFfile_cnv: A sample Document Reference instance representing a VCF file that may be used as input or output of a genomic analysis pipeline.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/genomicVCFfile-simple"
        },
        "name" : "genomicVCFfile-simple",
        "description" : "genomicVCFfile_simple: A sample Document Reference instance representing a VCF file that may be used as input or output of a genomic analysis pipeline.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/genotype"
        },
        "name" : "Genotype",
        "description" : "Assertion of a particular genotype on the basis of one or more variants or haplotypes.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Genotype-Clinical-Trial-Example-using-haplotypes"
        },
        "name" : "Genotype-Clinical-Trial-Example-using-haplotypes",
        "description" : "Example of a Genotype. A complete haplotype set defines a genotype. In this example the gneotype is dervied from  observations of the underlying haplotypes.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/genotype-hla-a-glstring-r4"
        },
        "name" : "genotype-hla-a-glstring-r4",
        "description" : "Genotype example: Sequence-based typing of HLA-A",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/GenotypeExample1"
        },
        "name" : "GenotypeExample1",
        "description" : "Example of a Genotype, Medication Recommendation, and MedicationStatement",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/GenotypeExamplePharmVar"
        },
        "name" : "GenotypeExamplePharmVar",
        "description" : "Example of a Genotype using Pharmvar Haplotypes",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "RiskAssessment"
          }
        ],
        "reference" : {
          "reference" : "RiskAssessment/GenRiskDiabetesT2"
        },
        "name" : "GenRiskDiabetesT2",
        "description" : "Polygenic Risk Score example",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/GrouperEx01"
        },
        "name" : "GrouperEx01",
        "description" : "Generic grouping of Therapeutic Implication observations",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/GrouperEx02"
        },
        "name" : "GrouperEx02",
        "description" : "Generic grouping of Genotype observations",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/GrouperEx03"
        },
        "name" : "GrouperEx03",
        "description" : "Generic grouping of Regions Studied and Variant observations",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/haplotype"
        },
        "name" : "Haplotype",
        "description" : "Assertion of a particular haplotype on the basis of one or more variants.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/haplotype-hla-a-1-r4"
        },
        "name" : "haplotype-hla-a-1-r4",
        "description" : "Example Haplotype Sequence-based typing of HLA-A",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/HaplotypeExamplePharmVar01"
        },
        "name" : "HaplotypeExamplePharmVar01",
        "description" : "Example of a Haplotype using PharmVar",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/HaplotypeExamplePharmVar02"
        },
        "name" : "HaplotypeExamplePharmVar02",
        "description" : "Example of a Haplotype using PharmVar",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/HaplotypeSet-Clinical-Trial-Example-1of2"
        },
        "name" : "HaplotypeSet-Clinical-Trial-Example-1of2",
        "description" : "Example of a Haplotype as part of a Haplotype Set (1 of 2). A complete haplotype set defines a genotype.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/HaplotypeSet-Clinical-Trial-Example-2of2"
        },
        "name" : "HaplotypeSet-Clinical-Trial-Example-2of2",
        "description" : "Example of a Haplotype as part of a Haplotype Set (2 of 2). A complete haplotype set defines a genotype.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/HER2byImmuneStainExample"
        },
        "name" : "HER2byImmuneStainExample",
        "description" : "Example for HER2 by immune stain",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-biomarker"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/HER2byImmunoassayExample"
        },
        "name" : "HER2byImmunoassayExample",
        "description" : "Example for HER2 by immunoassay",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-biomarker"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/HG00403"
        },
        "name" : "HG00403",
        "description" : "Example for Patient. Supports references to subject for multiple genomics reporting profile conforming instances.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/HLA-A-haplotype1"
        },
        "name" : "HLA-A-haplotype1",
        "description" : "Example for HLA-A-haplotype1",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/HLA-A-haplotype2"
        },
        "name" : "HLA-A-haplotype2",
        "description" : "Example for HLA-A-haplotype2",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/HLA-B-haplotype1"
        },
        "name" : "HLA-B-haplotype1",
        "description" : "Example for HLA-B-haplotype1",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/HLA-B-haplotype2"
        },
        "name" : "HLA-B-haplotype2",
        "description" : "Example for HLA-B-haplotype2",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/HLA-C-haplotype1"
        },
        "name" : "HLA-C-haplotype1",
        "description" : "Example for HLA-C-haplotype1",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/HLA-C-haplotype2"
        },
        "name" : "HLA-C-haplotype2",
        "description" : "Example for HLA-C-haplotype2",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hgnc-vs"
        },
        "name" : "HUGO Gene Nomenclature Committee Gene Names (HGNC)",
        "description" : "This value set includes all HGNC Codes, which includes multiple code systems. In this guide, Gene IDs from HGNC are used as CodeableConcepts, which must be sent with the HGNC gene ID including the prefix 'HGNC:' as the code and the HGNC 'gene symbol' as display. CAUTION: HGNC also indexes gene groups by numeric ID (without a prefix), and older systems may send HGNC gene IDs without the prefix, so care must be taken to confirm alignment. We have separately included the genegroup code system to draw attention to this ambiguity and potential error.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hgvs-vs"
        },
        "name" : "Human Genome Variation Society (HGVS) Nomenclature",
        "description" : "HGVS-nomenclature is used to report and exchange information regarding variants found in DNA, RNA and protein sequences and serves as an international standard. (source: varnomen.hgvs.org)",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ISCN-CMLExample"
        },
        "name" : "ISCN-CMLExample",
        "description" : "Basic example for karyotype Variant expressed in ISCN",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ISCN-CMLImplication"
        },
        "name" : "ISCN-CMLImplication",
        "description" : "Basic example of a Diagnostic Implication for CML",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ISCN-NormalExample"
        },
        "name" : "ISCN-NormalExample",
        "description" : "Normal example for karyotype Variant expressed in ISCN",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/knowledge-base-cs"
        },
        "name" : "Knowledge Base Codes",
        "description" : "This example code systems provides examples on how to properly display the knowledge base version number. Version numbers should always be followed by the letter v and calendar dates are displayed Month Day Year. For clarity the month SHALL be written in full.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/knowledge-base-version-vs"
        },
        "name" : "Knowledge Base Version Codes",
        "description" : "Value set for example terms to display the knowledge base version used to calculate and/or obtain data",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/knowledgebase-ancestry-group"
        },
        "name" : "KnowledgebaseAncestryGroup",
        "description" : "Used to identify the sample ancestry group using terms obtained from the knowledgebase",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "GenomicStudy"
          }
        ],
        "reference" : {
          "reference" : "GenomicStudy/lungMass"
        },
        "name" : "lungMass",
        "description" : "Example of solid tumor whole exome sequencing panel",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medication-assessed-reference"
        },
        "name" : "Medication Assessed reference to a FHIR resource",
        "description" : "Used to reference a specific medication that was assessed (e.g. a FHIR Medication or a FHIR MedicationKnowledge).",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medication-recommendation"
        },
        "name" : "Medication Recommendation",
        "description" : "Task proposing medication recommendations based on the implications of genomic findings.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/MedicationRecommendationExample1"
        },
        "name" : "MedicationRecommendationExample1",
        "description" : "Example of a Medication Recommendation",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/medication-recommendation"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MedicationStatementWarfarin"
        },
        "name" : "MedicationStatementWarfarin",
        "description" : "MedicationStatement for Warfarin",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/MicrosatelliteInstabilityExample01"
        },
        "name" : "MicrosatelliteInstabilityExample01",
        "description" : "Example for MSI",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-biomarker"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/molec-conseq1"
        },
        "name" : "molec-conseq1",
        "description" : "Example Molecular Consequence that includes Loss of Function prediction",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/molec-conseq2"
        },
        "name" : "molec-conseq2",
        "description" : "Example Molecular Consequence",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/molec-conseq3"
        },
        "name" : "molec-conseq3",
        "description" : "Example Molecular Consequence",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/molec-conseq4"
        },
        "name" : "molec-conseq4",
        "description" : "Example Molecular Consequence",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/molecular-biomarker"
        },
        "name" : "Molecular Biomarker",
        "description" : "This profile is used to represent laboratory measurements of human inherent substances such as gene products, antigens and antibodies, and complex chemicals that result from post-translational processing of multi-gene products.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/molecular-biomarker-category-vs"
        },
        "name" : "Molecular Biomarker Categories",
        "description" : "This value set is drawn from the Molecular Biomarker Ontology code system, which provides codes that characterize a molecular biomarker.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/molecular-biomarker-code-vs"
        },
        "name" : "Molecular Biomarker Codes",
        "description" : "Value Set for terms that can be used as Biomarkers.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/molecular-biomarker-ontology-cs"
        },
        "name" : "Molecular Biomarker Ontology Codes",
        "description" : "This (experimental) code system provides for a draft categorization of biomarkers along several axes. Based on ballot feedback, the committee anticipates significant revisions.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/molecular-consequence"
        },
        "name" : "Molecular Consequence",
        "description" : "Profile for communicating the calculated or observed effect of a DNA variant, generally on its downstream transcript and, if applicable, ensuing protein sequence. Molecular consequences may also apply to DNA, such as intergenic regions where there are no transcripts (e.g. 'regulatory_region_variant'). Component 'feature-consequence' categorizes the structural implications of a variant (e.g. the variant disrupts a regulatory region, the variant is an inframe insertion), whereas component 'functional-effect' categorizes how the variant affects overall function (e.g. is predicted to result in loss of gene function).",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/molecular-consequence-vs"
        },
        "name" : "Molecular Consequence Value Set",
        "description" : "The calculated or observed effect of a variant on its downstream transcript and, if applicable, ensuing protein sequence.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/MSH2-del-disease"
        },
        "name" : "MSH2-del-disease",
        "description" : "Example DiagnosticImplication - MSH2 deletion Hereditary cancer-predisposing syndrome",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/MSH2-del-molc"
        },
        "name" : "MSH2-del-molc",
        "description" : "Example Molecular Consequence MSH2 frameshift",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/MSH2-del-var"
        },
        "name" : "MSH2-del-var",
        "description" : "Example for MSH2 deletion",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/MSIExample"
        },
        "name" : "MSIExample",
        "description" : "Example for MSI",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-biomarker"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/MultipleRepeatExpansions"
        },
        "name" : "MultipleRepeatExpansions",
        "description" : "Repeat Expansion Variant with multiple motifs",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/normalSpecimen"
        },
        "name" : "normalSpecimen",
        "description" : "Example for normal specimen",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/NOTCH1-significance"
        },
        "name" : "NOTCH1-significance",
        "description" : "Example DiagnosticImplication - NOTCH1 uncertain significance",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/NOTCH1-uncertain-molc"
        },
        "name" : "NOTCH1-uncertain-molc",
        "description" : "Example Molecular Consequence NOTCH1 missense_variant",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/NOTCH1-uncertain-var"
        },
        "name" : "NOTCH1-uncertain-var",
        "description" : "Example for NOTCH1 uncertain",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/NTHL1-snv-disease"
        },
        "name" : "NTHL1-snv-disease",
        "description" : "Example DiagnosticImplication - NTHL1 SNV Hereditary cancer-predisposing syndrome",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/NTHL1-snv-molc"
        },
        "name" : "NTHL1-snv-molc",
        "description" : "Example Molecular Consequence NTHL1 SNV variant with nonsense codon",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/NTHL1-snv-var"
        },
        "name" : "NTHL1-snv-var",
        "description" : "Example for NTHL1 SNV",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs-idh-ex"
        },
        "name" : "obs-idh-ex",
        "description" : "Example DiagnosticImplication - Pathogenic for CF",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs1-interact-smn1-smn2"
        },
        "name" : "obs1-interact-smn1-smn2",
        "description" : "SMN1 CNV companion for SMN1/SMN2 CNV example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/obs2-interact-smn1-smn2"
        },
        "name" : "obs2-interact-smn1-smn2",
        "description" : "SMN2 CNV companion for SMN1/SMN2 CNV example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/orderingPractitioner"
        },
        "name" : "orderingPractitioner",
        "description" : "Example of an ordering provider",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/pathologistPractitioner"
        },
        "name" : "pathologistPractitioner",
        "description" : "Example of a pathologist",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/PDL1Example"
        },
        "name" : "PDL1Example",
        "description" : "Example for PD-L1",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-biomarker"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/performingOrganization"
        },
        "name" : "performingOrganization",
        "description" : "Example of a Pathology lab",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Pgx-geno-1001"
        },
        "name" : "Pgx-geno-1001",
        "description" : "Example of a Genotype from eMERGE",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Pgx-geno-1002"
        },
        "name" : "Pgx-geno-1002",
        "description" : "Example of a Genotype from eMERGE",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Pgx-geno-1003"
        },
        "name" : "Pgx-geno-1003",
        "description" : "Example of a Genotype from eMERGE",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Pgx-var-1011"
        },
        "name" : "Pgx-var-1011",
        "description" : "Example variant 1011",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Pgx-var-1012"
        },
        "name" : "Pgx-var-1012",
        "description" : "Example variant 1012",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Pgx-var-1013"
        },
        "name" : "Pgx-var-1013",
        "description" : "Example variant 1013",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Pgx-var-1014"
        },
        "name" : "Pgx-var-1014",
        "description" : "Example variant 1014",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Pgx-var-1015"
        },
        "name" : "Pgx-var-1015",
        "description" : "Example variant 1015",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Pgx-var-1016"
        },
        "name" : "Pgx-var-1016",
        "description" : "Example variant 1016",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Pgx-var-1017"
        },
        "name" : "Pgx-var-1017",
        "description" : "Example variant 1017",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Pgx-var-1018"
        },
        "name" : "Pgx-var-1018",
        "description" : "Example variant 1018",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Pgx-var-1019"
        },
        "name" : "Pgx-var-1019",
        "description" : "Example variant 1019",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Pgx-var-1020"
        },
        "name" : "Pgx-var-1020",
        "description" : "Example variant 1020",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Pgx-var-1021"
        },
        "name" : "Pgx-var-1021",
        "description" : "Example variant 1021",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DiagnosticReport"
          }
        ],
        "reference" : {
          "reference" : "DiagnosticReport/PGxGenomicReportEMERGE"
        },
        "name" : "PGxGenomicReportEMERGE",
        "description" : "Example of a Report carrying multiple Therapeutic Implications, Genotypes, and Variants",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DiagnosticReport"
          }
        ],
        "reference" : {
          "reference" : "DiagnosticReport/PGxGenomicReportEMERGE-withGrouping"
        },
        "name" : "PGxGenomicReportEMERGE-withGrouping",
        "description" : "Example of a Report carrying multiple Therapeutic Implications, Genotypes, and Variants",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "GenomicStudy"
          }
        ],
        "reference" : {
          "reference" : "GenomicStudy/PGXGenomicStudy"
        },
        "name" : "PGXGenomicStudy",
        "description" : "Example of PGX sequencing panel",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/PGxRecEx01"
        },
        "name" : "PGxRecEx01",
        "description" : "Example of a Medication Recommendation for alternatives to clopidogrel",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/followup-recommendation"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/PGxRecEx02"
        },
        "name" : "PGxRecEx02",
        "description" : "Example of a Medication Recommendation for alternatives to voriconazole",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/followup-recommendation"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/PGxRecEx03"
        },
        "name" : "PGxRecEx03",
        "description" : "Example of a Medication Recommendation for decreasing dosage for citalopram",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/followup-recommendation"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/PGxRecEx04"
        },
        "name" : "PGxRecEx04",
        "description" : "Example of a Medication Recommendation for decreasing dosage for escitalopram",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/followup-recommendation"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/PGxRecEx05"
        },
        "name" : "PGxRecEx05",
        "description" : "Example of a Medication Recommendation for decreasing dosage for amitriptyline",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/followup-recommendation"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/pharmgkb-evidence-level-custom-cs"
        },
        "name" : "PharmGKB Evidence Level Example Codes",
        "description" : "PharmGKB contains examples of evidence level concepts that are not conflated with clinical significance. These can be found on PharmGKB https://www.pharmgkb.org/page/clinAnnLevels. These examples are informational only, for copyright information contact the relevant source.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/PolyGenicDiagnosticImpExample"
        },
        "name" : "PolyGenicDiagnosticImpExample",
        "description" : "Example of a Diagnostic Implication for Diabetes Type 2 with a polygenic risk score.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/pop-allele-freq"
        },
        "name" : "pop-allele-freq",
        "description" : "Example genomic annotation showing a population allele frequency",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-annotation"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/practitioner02"
        },
        "name" : "practitioner02",
        "description" : "Example practitioner",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/recommended-action"
        },
        "name" : "Recommended Action",
        "description" : "References a proposed action that is recommended based on the results of the diagnostic report.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/repeat-motif-order"
        },
        "name" : "Repeat Motif Order",
        "description" : "Use to group and order repeat expansion motifs.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/RepeatExpansion"
        },
        "name" : "RepeatExpansion",
        "description" : "Repeat Expansion Variant",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ROS1-Fusion"
        },
        "name" : "ROS1-Fusion",
        "description" : "Example Molecular Consequence ROS1 Fusion",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ROS1-Fusion-disease"
        },
        "name" : "ROS1-Fusion-disease",
        "description" : "Example DiagnosticImplication - ROS1 disease",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ROS1-Fusion-therapuDrug"
        },
        "name" : "ROS1-Fusion-therapuDrug",
        "description" : "Example of ROS1 Fusion Therapeutic Implication for drug treatment",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ROS1-Fusion-therapuTrial"
        },
        "name" : "ROS1-Fusion-therapuTrial",
        "description" : "Example of ROS1 Fusion Therapeutic Implication for Clinical Trial",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ROS1-Fusion-var"
        },
        "name" : "ROS1-Fusion-var",
        "description" : "Example for ROS1 Fusion but as typically reported in PDF, without necessarily declaring a particular fusion partner",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/sequence-phase-relationship"
        },
        "name" : "Sequence Phase Relationship",
        "description" : "Indicates whether two entities are in Cis (same strand) or Trans (opposite strand) relationship to each other.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/sequence-phase-relationship-cs"
        },
        "name" : "Sequence Phase Relationship Codes",
        "description" : "Code System for specific types of relationships",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/sequence-phase-relationship-vs"
        },
        "name" : "Sequence Phase Relationships",
        "description" : "Value Set for specific types of relationships",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SequencePhaseRelationExample1"
        },
        "name" : "SequencePhaseRelationExample1",
        "description" : "Example for sequence phase relation.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/sequence-phase-relationship"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/SequencingProcedure"
        },
        "name" : "SequencingProcedure",
        "description" : "Very simple producure representing a genomic study's protocol",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/servicerequest-hla-a-r4"
        },
        "name" : "servicerequest-hla-a-r4",
        "description" : "Example ServiceRequest for genomics",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/SimpleVariantAnalysis-called"
        },
        "name" : "SimpleVariantAnalysis-called",
        "description" : "SimpleVariantAnalysis_called: A sample Document Reference instance representing a BED file that may be used as input or output of a genomic analysis pipeline.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SNVexample"
        },
        "name" : "SNVexample",
        "description" : "Example Variant",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/somaticPatient"
        },
        "name" : "somaticPatient",
        "description" : "Somatic example Patient",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DiagnosticReport"
          }
        ],
        "reference" : {
          "reference" : "DiagnosticReport/somaticReport"
        },
        "name" : "somaticReport",
        "description" : "Example somatic GenomicReport",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/somaticServiceRequest"
        },
        "name" : "somaticServiceRequest",
        "description" : "Example for Somatic Testing Request",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "GenomicStudy"
          }
        ],
        "reference" : {
          "reference" : "GenomicStudy/somaticStudy"
        },
        "name" : "somaticStudy",
        "description" : "Example for somatic genetic study",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/somaticVCFfile"
        },
        "name" : "somaticVCFfile",
        "description" : "Example for Genomic Data File somaticVCFfile",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/specimen-hla-r4"
        },
        "name" : "specimen-hla-r4",
        "description" : "Example HLA specimen",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/STAG2-insertion-molc"
        },
        "name" : "STAG2-insertion-molc",
        "description" : "Example Molecular Consequence STAG2 frameshift",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/STAG2-insertion-significance"
        },
        "name" : "STAG2-insertion-significance",
        "description" : "Example DiagnosticImplication - STAG2 likely pathogenic",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/STAG2-insertion-var"
        },
        "name" : "STAG2-insertion-var",
        "description" : "Example for STAG2 insertion",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/supervisorPractitioner"
        },
        "name" : "supervisorPractitioner",
        "description" : "Example of a supervisor",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/therapeutic-implication"
        },
        "name" : "Therapeutic Implication",
        "description" : "Observation stating a therapeutic annotation (e.g. drug susceptibility, clinical trial eligibility) on one or more genotype/haplotype/variant/biomarker observations.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Therapeutic-Implication-Clinical-Trial-2"
        },
        "name" : "Therapeutic-Implication-Clinical-Trial-2",
        "description" : "Example of a Therapeutic Implication for Carbamazepine",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Therapeutic-Implication-Clinical-Trial-Somatic"
        },
        "name" : "Therapeutic-Implication-Clinical-Trial-Somatic",
        "description" : "Example of a Therapeutic Implication for Clinical Trial",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/TherapeuticImplicationExample1"
        },
        "name" : "TherapeuticImplicationExample1",
        "description" : "Example of a Therapeutic Implication for Carbamazepine",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/therapuDrug1-interact-smn1-smn2"
        },
        "name" : "therapuDrug1-interact-smn1-smn2",
        "description" : "Antisense Oligonucelotide example of Therapeutic Implication for SMN1/SMN2 CNV example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/therapuDrug2-interact-smn1-smn2"
        },
        "name" : "therapuDrug2-interact-smn1-smn2",
        "description" : "Transgene example of Therapeutic Implication for SMN1/SMN2 CNV example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/therapuDrug3-interact-smn1-smn2"
        },
        "name" : "therapuDrug3-interact-smn1-smn2",
        "description" : "Small molecule example of Therapeutic Implication for SMN1/SMN2 CNV example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/therapy-assessed-reference"
        },
        "name" : "Therapy Assessed reference to a FHIR resource",
        "description" : "Used to reference a specific therapy that was assessed (e.g. a FHIR ResearchStudy, a FHIR CarePlan, or a FHIR PlanDefinition).",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/TMB-therapuDrug"
        },
        "name" : "TMB-therapuDrug",
        "description" : "Example of high TMB Therapeutic Implication for drug treatment",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/TMBExample"
        },
        "name" : "TMBExample",
        "description" : "Example for Tumor Mutation Burden",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-biomarker"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/tbd-codes-cs"
        },
        "name" : "To Be Determined Codes",
        "description" : "These codes are 'TBD' codes, meaning they are important concepts but codes have not been identifed in available code systems. The CG WG anticpates these codes maturing over time. We may remove some codes as we refine the concepts, or identify suitable replacement codes from other code systems. As we approach normative and these concepts are validated, for codes that remain, we plan to request formal LOINC codes to replace these temporary codes.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/tbd-codes-vs"
        },
        "name" : "To Be Determined Value Set",
        "description" : "Value Set for codes yet to be defined in LOINC",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/triodenovo-software"
        },
        "name" : "triodenovo-software",
        "description" : "Triodenovo Software",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/TumorMutationBurdenExample01"
        },
        "name" : "TumorMutationBurdenExample01",
        "description" : "Example for Tumor Mutation Burden",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-biomarker"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/tumorSpecimen"
        },
        "name" : "tumorSpecimen",
        "description" : "Example for tumor specimen",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/TxImp01"
        },
        "name" : "TxImp01",
        "description" : "Example of a Therapeutic Implication from eMERGE",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/TxImp02"
        },
        "name" : "TxImp02",
        "description" : "Example of a Therapeutic Implication from eMERGE",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/TxImp03"
        },
        "name" : "TxImp03",
        "description" : "Example of a Therapeutic Implication from eMERGE",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/TxImp04"
        },
        "name" : "TxImp04",
        "description" : "Example of a Therapeutic Implication from eMERGE",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/TxImp05"
        },
        "name" : "TxImp05",
        "description" : "Example of a Therapeutic Implication from eMERGE",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/TxImp06"
        },
        "name" : "TxImp06",
        "description" : "Example of a Therapeutic Implication from eMERGE",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/UncallableRegions"
        },
        "name" : "UncallableRegions",
        "description" : "Representing a BED file that represents uncallable regions",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/variant"
        },
        "name" : "Variant",
        "description" : "Details about a set of changes in the tested sample compared to a reference sequence.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/variant-confidence-status-vs"
        },
        "name" : "Variant Confidence Status",
        "description" : "A code that classifies the confidence for calling this variant.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/variant-confidence-status-cs"
        },
        "name" : "Variant Confidence Status Codes",
        "description" : "A code that represents the confidence of a true positive variant call.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Variant-Somatic-Clinical-Trial"
        },
        "name" : "Variant-Somatic-Clinical-Trial",
        "description" : "Example for Somatic Variant and Clinical Trial",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/variant-with-molec-consequences"
        },
        "name" : "variant-with-molec-consequences",
        "description" : "Variant with molecular consequences",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/VariantExample"
        },
        "name" : "VariantExample",
        "description" : "Example for Variant NM_004448.4(ERBB2):c.2264_2278del",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/VariantExample1"
        },
        "name" : "VariantExample1",
        "description" : "Example for Variant given by HGVS",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/VariantExample2"
        },
        "name" : "VariantExample2",
        "description" : "Example for genomic Variant given by VCF columns",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/WES-FullSequencedRegion-GRCh38"
        },
        "name" : "WES-FullSequencedRegion-GRCh38",
        "description" : "WES_FullSequencedRegion_GRCh38: A sample Document Reference instance representing a BED file that may be used as input or output of a genomic analysis pipeline.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/WES-UncallableRegions-GRCh38"
        },
        "name" : "WES-UncallableRegions-GRCh38",
        "description" : "Example for Genomic Data File WES-UncallableRegions-GRCh38",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ZFHX3-significance"
        },
        "name" : "ZFHX3-significance",
        "description" : "Example DiagnosticImplication - ZFHX3 uncertain significance",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ZFHX3-uncertain-molc"
        },
        "name" : "ZFHX3-uncertain-molc",
        "description" : "Example Molecular Consequence ZFHX3 missense_variant",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ZFHX3-uncertain-var"
        },
        "name" : "ZFHX3-uncertain-var",
        "description" : "Example for ZFHX3 uncertain",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
        ]
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "informative"
        }
      ],
      "sourceUrl" : "toc.html",
      "name" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "index.html",
          "name" : "index.html",
          "title" : "Home Page",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "background.html",
          "name" : "background.html",
          "title" : "Genomic Background",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "general.html",
          "name" : "general.html",
          "title" : "General Genomic Reporting",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "artifacts.html",
          "name" : "artifacts.html",
          "title" : "Artifact List",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "sequencing.html",
          "name" : "sequencing.html",
          "title" : "Variant Reporting",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "pharmacogenomics.html",
          "name" : "pharmacogenomics.html",
          "title" : "Pharmacogenomic Reporting",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "somatics.html",
          "name" : "somatics.html",
          "title" : "Somatic Reporting",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "histocompatibility.html",
          "name" : "histocompatibility.html",
          "title" : "Histocompatibility and Immunogenetic Reporting",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "operations.html",
          "name" : "operations.html",
          "title" : "Genomic Operations",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "downloads.html",
          "name" : "downloads.html",
          "title" : "Useful Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "v2.html",
          "name" : "v2.html",
          "title" : "Appendix A: Relation to v2 reporting",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "cgapps.html",
          "name" : "cgapps.html",
          "title" : "Appendix B: Clinical Genomic Apps",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "domain.html",
          "name" : "domain.html",
          "title" : "Appendix C: HL7 Domain Analysis Model",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "usecases.html",
          "name" : "usecases.html",
          "title" : "Appendix D: Query Guidance",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "codings.html",
          "name" : "codings.html",
          "title" : "Appendix E: External Coding Systems",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "conversion.html",
          "name" : "conversion.html",
          "title" : "Appendix F: Conversion from FHIR Core STU3",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "molecularsequence.html",
          "name" : "molecularsequence.html",
          "title" : "Appendix G: Molecular Sequence",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "groupingguidance.html",
          "name" : "groupingguidance.html",
          "title" : "Appendix H: Grouping Guidance",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "glossary.html",
          "name" : "glossary.html",
          "title" : "Appendix I: Glossary",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            }
          ],
          "sourceUrl" : "changes.html",
          "name" : "changes.html",
          "title" : "Change Log",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "copyrightyear"
        },
        "value" : "2025+"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "releaselabel"
        },
        "value" : "STU 4 ballot"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-publisher"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-version"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "shownav"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "special-url"
        },
        "value" : "http://terminology.hl7.org/CodeSystem/sequence-phase-relationship-cs"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "special-url"
        },
        "value" : "http://terminology.hl7.org/CodeSystem/variant-confidence-status-cs"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "special-url"
        },
        "value" : "https://www.ncbi.nlm.nih.gov/gtr"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "pin-canonicals"
        },
        "value" : "pin-multiples"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-history"
        },
        "value" : "http://hl7.org/fhir/uv/genomics-reporting/history.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "autoload-resources"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/capabilities"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/examples"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/extensions"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/models"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/operations"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/profiles"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/vocabulary"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/maps"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/testing"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/history"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "fsh-generated/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "template/config"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "input/images"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "template/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "input/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-qa"
        },
        "value" : "temp/qa"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-temp"
        },
        "value" : "temp/pages"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-output"
        },
        "value" : "output"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-tx-cache"
        },
        "value" : "input-cache/txcache"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-suppressed-warnings"
        },
        "value" : "input/ignoreWarnings.txt"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-html"
        },
        "value" : "template-page.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-md"
        },
        "value" : "template-page-md.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-contact"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-context"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-copyright"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-jurisdiction"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-license"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-wg"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "active-tables"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "fmm-definition"
        },
        "value" : "http://hl7.org/fhir/versions.html#maturity"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "propagate-status"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "excludelogbinaryformat"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "tabbed-snapshots"
        },
        "value" : "true"
      }
    ]
  }
}

```
