# Appendix C: HL7 Domain Analysis Model - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* **Appendix C: HL7 Domain Analysis Model**

## Appendix C: HL7 Domain Analysis Model

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

The HL7 Domain Analysis Model: Clinical Genomics features use cases key to personalized genomic medicine and translational research, including more typical scenarios for testing of a person's inherited or germline genome, cancer genomics/ tumor profiling, early childhood developmental delay, neonatal testing, and newborn screening. The focus is on use cases that can be found in practice at some locations clinically today. In addition, each use case may include several alternative scenarios and workflows that are shown for comparison.

The HL7 Domain Analysis Model: Clinical Sequencing cataloged the breadth of genetic/genomic testing use cases and clinical scenarios with focus on clinical sequencing, drawing use cases from a number of stakeholders. It discussed current challenges and lessons learned, and raises questions to consider for future implementations. While this document discusses the use of new technology (e.g., Next Generation Sequencing or NGS), it must be remembered that the vast majority of clinical genetic testing is still performed on testing platforms that were in use years ago, and it is the goal of the Clinical Genomics Work Group to facilitate interoperability of genetic/genomic data, independent of specific genetic testing platforms or methodologies. Following the Clinical Sequencing Domain Analysis Model: Clinical Sequencing, this document is part of an effort to develop a Clinical Genomics Domain Analysis Model (CG DAM) by expanding the use cases.

* [HL7 Domain Analysis Model: Clinical Genomics, Release1](http://www.hl7.org/implement/standards/product_brief.cfm?product_id=479)

