# Molecular Biomarker Codes - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Molecular Biomarker Codes**

## ValueSet: Molecular Biomarker Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/ValueSet/molecular-biomarker-code-vs | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:MolecularBiomarkerCodeVS |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc. This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement. | | |

 
Value Set for terms that can be used as Biomarkers. 

 **References** 

* [Molecular Biomarker](StructureDefinition-molecular-biomarker.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "molecular-biomarker-code-vs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/molecular-biomarker-code-vs",
  "version" : "4.0.0-ballot",
  "name" : "MolecularBiomarkerCodeVS",
  "title" : "Molecular Biomarker Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Value Set for terms that can be used as Biomarkers.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.\nThis value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement.",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "85337-4",
            "display" : "Estrogen receptor Ag Immune stain Ql (Breast cancer specimen)"
          },
          {
            "code" : "72382-5",
            "display" : "HER2 IA Qn (Tiss)"
          },
          {
            "code" : "77637-7",
            "display" : "HLA-A and B and C (class I) IgG panel IA [Identifier]"
          },
          {
            "code" : "40557-1",
            "display" : "Progesterone receptor Ag Immune stain Ql (Tiss)"
          },
          {
            "code" : "85147-7",
            "display" : "PD-L1 by clone 22C3 Immune stain Doc (Tiss)"
          },
          {
            "code" : "59025-7",
            "display" : "Neutrophil Ab FC Qn (S)"
          },
          {
            "code" : "59003-4",
            "display" : "Lactoferrin Ab IA Qn (S)"
          },
          {
            "code" : "10495-0",
            "display" : "Insulin Ag Immune stain Ql (Tiss)"
          },
          {
            "code" : "16550-6",
            "display" : "Carbohydrates Nom (U)"
          },
          {
            "code" : "2569-2",
            "display" : "Lipids (S) [Mass/Vol]"
          },
          {
            "code" : "4551-8",
            "display" : "Hemoglobin A2 (Bld) [Mass fraction]"
          },
          {
            "code" : "19195-7",
            "display" : "Prostate specific Ag Qn"
          },
          {
            "code" : "64083-9",
            "display" : "MGMT gene methylation score Molgen (Tiss) [Ratio]"
          },
          {
            "code" : "62862-8",
            "display" : "Microsatellite instability Immune stain Ql (Tiss)"
          },
          {
            "code" : "81704-9",
            "display" : "Microsatellite instability marker D17S250 Ql (Cancer specimen)"
          },
          {
            "code" : "94077-5",
            "display" : "Tumor mutation burden Ql (Tumor) [Interp]"
          }
        ]
      },
      {
        "system" : "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl",
        "concept" : [
          {
            "code" : "C120465",
            "display" : "Homologous Recombination Repair Deficiency"
          }
        ]
      }
    ]
  }
}

```
