# PGxRecEx04 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **PGxRecEx04**

## Example Task: PGxRecEx04

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Followup Recommendation](StructureDefinition-followup-recommendation.md)

**status**: Requested

**intent**: proposal

**code**: Decrease dose

**description**: 

For escitalopram, a 50% reduction in starting dose is recommended with therapeutic drug monitoring to guide dose adjustment or select an alternate drug not predominantly metabolized by CYP2C19. Refer to current guidelines for dosage and recommendations at https://cpicpgx.org/guidelines/guideline-for-selective-serotonin-reuptake-inhibitors-and-cyp2d6-and-cyp2c19/. If CYP2D6 genotyping is available, refer to the current guidelines for dosing recommendations.

**for**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

### Reasons

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Poor metabolizer](Observation-TxImp04.md) |



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "PGxRecEx04",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/followup-recommendation"
    ]
  },
  "status" : "requested",
  "intent" : "proposal",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA26422-8",
        "display" : "Decrease dose"
      }
    ]
  },
  "description" : "For escitalopram, a 50% reduction in starting dose is recommended with therapeutic drug monitoring to guide dose adjustment or select an alternate drug not predominantly metabolized by CYP2C19. Refer to current guidelines for dosage and recommendations at https://cpicpgx.org/guidelines/guideline-for-selective-serotonin-reuptake-inhibitors-and-cyp2d6-and-cyp2c19/. If CYP2D6 genotyping is available, refer to the current guidelines for dosing recommendations.",
  "for" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "reason" : [
    {
      "reference" : {
        "reference" : "Observation/TxImp04",
        "display" : "Poor metabolizer"
      }
    }
  ]
}

```
