# PGxRecEx02 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **PGxRecEx02**

## Example Task: PGxRecEx02

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Followup Recommendation](StructureDefinition-followup-recommendation.md)

**status**: Requested

**intent**: proposal

**code**: Consider alternative medication

**description**: 

voriconazole - An alternative agent that is not dependent on CYP2C19 metabolism such as isavuconazole, liposomal amphotericin B, or posaconazole is recommended as primary therapy in lieu of voriconazole. A lower than standard dosage of voriconazole with careful therapeutic drug monitoring is another alternative. Refer to current guidelines for dosage and recommendations at https://cpicpgx.org/guidelines/guideline-for-voriconazole-and-cyp2c19/.

**for**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

### Reasons

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Poor metabolizer](Observation-TxImp02.md) |



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "PGxRecEx02",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/followup-recommendation"
    ]
  },
  "status" : "requested",
  "intent" : "proposal",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA26421-0",
        "display" : "Consider alternative medication"
      }
    ]
  },
  "description" : "voriconazole - An alternative agent that is not dependent on CYP2C19 metabolism such as isavuconazole, liposomal amphotericin B, or posaconazole is recommended as primary therapy in lieu of voriconazole. A lower than standard dosage of voriconazole with careful therapeutic drug monitoring is another alternative. Refer to current guidelines for dosage and recommendations at https://cpicpgx.org/guidelines/guideline-for-voriconazole-and-cyp2c19/.",
  "for" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "reason" : [
    {
      "reference" : {
        "reference" : "Observation/TxImp02",
        "display" : "Poor metabolizer"
      }
    }
  ]
}

```
