# MedicationRecommendationExample1 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **MedicationRecommendationExample1**

## Example Task: MedicationRecommendationExample1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Medication Recommendation](StructureDefinition-medication-recommendation.md)

**status**: Requested

**intent**: proposal

**code**: Consider alternative medication

**description**: 

Patients positive for this allele should not be treated with CBZ, unless the benefits clearly outweigh the risk. Therapy should be discontinued immediately if symptoms of SJS or TEN develop. Alternative medication should be used as first line therapy. Consideration in the choice for alternative medications should be given to potential cross-reactivity with structurally similar aromatic antiepileptic drugs such as oxcarbazepine, phenytoin, fosphenytoin and lamotrigine, which can also moderately increase risk for SJS/TEN in association with HLA-B*15:02 positivity.

**for**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

### Reasons

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Observation Therapeutic Implication](Observation-TherapeuticImplicationExample1.md) |



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "MedicationRecommendationExample1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/medication-recommendation"
    ]
  },
  "status" : "requested",
  "intent" : "proposal",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA26421-0"
      }
    ]
  },
  "description" : "Patients positive for this allele should not be treated with CBZ, unless the benefits clearly outweigh the risk. Therapy should be discontinued immediately if symptoms of SJS or TEN develop. Alternative medication should be used as first line therapy. Consideration in the choice for alternative medications should be given to potential cross-reactivity with structurally similar aromatic antiepileptic drugs such as oxcarbazepine, phenytoin, fosphenytoin and lamotrigine, which can also moderately increase risk for SJS/TEN in association with HLA-B*15:02 positivity.",
  "for" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "reason" : [
    {
      "reference" : {
        "reference" : "Observation/TherapeuticImplicationExample1"
      }
    }
  ]
}

```
