# Variant - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Variant**

## Resource Profile: Variant 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:Variant |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc. | | |

 
Details about a set of changes in the tested sample compared to a reference sequence. 

### Scope and Usage

This profile allows a full description of the variant found using properties from a variety of testing approaches and allowing for a variety of descriptive mechanisms. Labs are encouraged to populate what properties they know. In future versions of this implementation guide, HL7 may provide additional guidance on what properties should be sent in which situations and may subdivide **Variant** into multiple sub-profiles with more specific purpose.

### Other Guidance

See [Variant Reporting](sequencing.md) for details on use.

A variety of annotations (see [variant implications](StructureDefinition-implication.md)) can be applied to identified variants, such as: (1) predicted molecular consequences (e.g. a prediction that a variant leads to loss of gene function); (2) diagnostic implications (e.g. presence of a variant indicates increased risk for breast cancer); (3) therapeutic implications (e.g. presence of a somatic variant is associated with sensitivity to a particular drug or eligibility into a clinical trial).

Most human genes are transcribed into multiple transcripts. The molecular consequences profile can be used to indicate transcript-specific predicted consequences, for one or more transcripts. In the Variant instance itself, one can also indicate a representative transcript-level HGVS and/or protein HGVS.

If implementers have additional variant annotations, the Variant profile is defined to allow flexibility. See the section on [flexibility](general.md#flexibility) for additional guidancem, especially the guidance for the Open Slicing allowed on `Observation.component`.

#### Note on Molecular Consequence in STU2

The [STU2 Variant](https://hl7.org/fhir/uv/genomics-reporting/STU2/StructureDefinition-variant.html) profile contained the component slice `molecular-consequence`, which is no longer present in this profile. The functionality to communicate predicted molecular consequences has been moved to the [Molecular Consequence](StructureDefinition-molecular-consequence.md) profile. For those that have already implemented the STU2 solution and are in a transition, [open slicing](general.md#open-slicing) allows components above and beyond those specified in the Implementation Guide and therefore the STU2 method of communicating molecular consequence will not cause conformance errors. This approach should be used carefully and only during a transition period to ensure full compatibility with other systems that implement the full features of this guide.

**Usages:**

* Refer to this Profile: [Genomic Report](StructureDefinition-genomic-report.md), [Genotype](StructureDefinition-genotype.md), [Haplotype](StructureDefinition-haplotype.md), [Genomic Implication](StructureDefinition-implication.md)...Show 2 more,[Molecular Biomarker](StructureDefinition-molecular-biomarker.md)and[Sequence Phase Relationship](StructureDefinition-sequence-phase-relationship.md)
* Examples for this Profile: [Observation/ATR-insertion-var](Observation-ATR-insertion-var.md), [Observation/EGFR-L858R-var](Observation-EGFR-L858R-var.md), [Observation/ExampleGermlineCNV](Observation-ExampleGermlineCNV.md), [Observation/ExampleGermlineDEL](Observation-ExampleGermlineDEL.md)...Show 33 more,[Observation/ExampleGermlineINV](Observation-ExampleGermlineINV.md),[Observation/ExampleSomaticCNV](Observation-ExampleSomaticCNV.md),[Observation/ExampleSomaticDEL](Observation-ExampleSomaticDEL.md),[Observation/ExampleSomaticINV](Observation-ExampleSomaticINV.md),[Observation/ISCN-CMLExample](Observation-ISCN-CMLExample.md),[Observation/ISCN-NormalExample](Observation-ISCN-NormalExample.md),[Observation/MSH2-del-var](Observation-MSH2-del-var.md),[Observation/MultipleRepeatExpansions](Observation-MultipleRepeatExpansions.md),[Observation/NOTCH1-uncertain-var](Observation-NOTCH1-uncertain-var.md),[Observation/NTHL1-snv-var](Observation-NTHL1-snv-var.md),[Observation/Pgx-var-1011](Observation-Pgx-var-1011.md),[Observation/Pgx-var-1012](Observation-Pgx-var-1012.md),[Observation/Pgx-var-1013](Observation-Pgx-var-1013.md),[Observation/Pgx-var-1014](Observation-Pgx-var-1014.md),[Observation/Pgx-var-1015](Observation-Pgx-var-1015.md),[Observation/Pgx-var-1016](Observation-Pgx-var-1016.md),[Observation/Pgx-var-1017](Observation-Pgx-var-1017.md),[Observation/Pgx-var-1018](Observation-Pgx-var-1018.md),[Observation/Pgx-var-1019](Observation-Pgx-var-1019.md),[Observation/Pgx-var-1020](Observation-Pgx-var-1020.md),[Observation/Pgx-var-1021](Observation-Pgx-var-1021.md),[Observation/ROS1-Fusion-var](Observation-ROS1-Fusion-var.md),[Observation/RepeatExpansion](Observation-RepeatExpansion.md),[Observation/SNVexample](Observation-SNVexample.md),[Observation/STAG2-insertion-var](Observation-STAG2-insertion-var.md),[Observation/Variant-Somatic-Clinical-Trial](Observation-Variant-Somatic-Clinical-Trial.md),[Observation/VariantExample](Observation-VariantExample.md),[Observation/VariantExample1](Observation-VariantExample1.md),[Observation/VariantExample2](Observation-VariantExample2.md),[Observation/ZFHX3-uncertain-var](Observation-ZFHX3-uncertain-var.md),[Observation/obs1-interact-smn1-smn2](Observation-obs1-interact-smn1-smn2.md),[Observation/obs2-interact-smn1-smn2](Observation-obs2-interact-smn1-smn2.md)and[Observation/variant-with-molec-consequences](Observation-variant-with-molec-consequences.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/variant)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-variant.csv), [Excel](StructureDefinition-variant.xlsx), [Schematron](StructureDefinition-variant.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "variant",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant",
  "version" : "4.0.0-ballot",
  "name" : "Variant",
  "title" : "Variant",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Details about a set of changes in the tested sample compared to a reference sequence.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.",
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/finding",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Variant"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "69548-6",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6"
            }
          ]
        }
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.value[x]:valueCodeableConcept",
        "path" : "Observation.value[x]",
        "sliceName" : "valueCodeableConcept",
        "short" : "Indeterminate | No call | Present | Absent.",
        "definition" : "The presence or absence of the variant described in the components. If not searching for specific variations and merely reporting what's found, the profile's value should be set to 'Present'.",
        "comment" : "See [here](sequencing.html#variant-assessment) for usage guidance.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://loinc.org/vs/LL1971-2"
        }
      },
      {
        "id" : "Observation.method",
        "path" : "Observation.method",
        "short" : "Sequencing | SNP array | PCR | Computational analysis | ...",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://loinc.org/vs/LL4048-6"
        }
      },
      {
        "id" : "Observation.component:representative-coding-hgvs",
        "path" : "Observation.component",
        "sliceName" : "representative-coding-hgvs",
        "short" : "DNA change (c.HGVS)",
        "definition" : "Human Genome Variation Society (HGVS) nomenclature for a single DNA marker. The use of the nomenclature must be extended to describe non-variations (aka. wild types) see samples for wild type examples.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:representative-coding-hgvs.code",
        "path" : "Observation.component.code",
        "short" : "48004-6",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48004-6"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:representative-coding-hgvs.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "A valid HGVS-formatted 'c.' string, e.g. NM_005228.5:c.2369C>T.",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/hgvs-vs"
        }
      },
      {
        "id" : "Observation.component:genomic-hgvs",
        "path" : "Observation.component",
        "sliceName" : "genomic-hgvs",
        "short" : "Genomic (gDNA) Change - gHGVS",
        "definition" : "Description of the genomic (gDNA) sequence change using a valid HGVS-formatted string.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:genomic-hgvs.code",
        "path" : "Observation.component.code",
        "short" : "81290-9",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "81290-9"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:genomic-hgvs.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "A valid HGVS-formatted 'g.' string, e.g. NC_000016.9:g.2124200_2138612dup",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/hgvs-vs"
        }
      },
      {
        "id" : "Observation.component:cytogenomic-nomenclature",
        "path" : "Observation.component",
        "sliceName" : "cytogenomic-nomenclature",
        "short" : "Cytogenomic Nomenclature (ISCN)",
        "definition" : "Fully describes a variant with a single code. Typically a large variant such as a mosaic, abnormal chromosome numbers, etc.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:cytogenomic-nomenclature.code",
        "path" : "Observation.component.code",
        "short" : "81291-7",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "81291-7"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:cytogenomic-nomenclature.value[x]",
        "path" : "Observation.component.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "Binding not yet defined"
        }
      },
      {
        "id" : "Observation.component:genomic-ref-seq",
        "path" : "Observation.component",
        "sliceName" : "genomic-ref-seq",
        "short" : "Genomic Reference Sequence",
        "definition" : "ID of the genomic reference sequence, which includes transcribed and non transcribed stretches",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:genomic-ref-seq.code",
        "path" : "Observation.component.code",
        "short" : "48013-7",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48013-7"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:genomic-ref-seq.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Versioned genomic reference sequence identifier",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "Multiple bindings acceptable (NCBI or LRG)"
        }
      },
      {
        "id" : "Observation.component:representative-protein-ref-seq",
        "path" : "Observation.component",
        "sliceName" : "representative-protein-ref-seq",
        "short" : "Protein Reference Sequence",
        "definition" : "ID of the protein reference sequence, which includes transcribed and non transcribed stretches. It covers the entire protein described.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:representative-protein-ref-seq.code",
        "path" : "Observation.component.code",
        "short" : "protein-ref-seq",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "protein-ref-seq"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:representative-protein-ref-seq.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Versioned protein reference sequence identifier",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "Multiple bindings acceptable (NCBI or LRG)"
        }
      },
      {
        "id" : "Observation.component:representative-transcript-ref-seq",
        "path" : "Observation.component",
        "sliceName" : "representative-transcript-ref-seq",
        "short" : "Reference Transcript",
        "definition" : "NCBI's RefSeq ('NM_...'), Ensembl ('ENST...'), and LRG ('LRG...' plus 't1' to indicate transcript)",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:representative-transcript-ref-seq.code",
        "path" : "Observation.component.code",
        "short" : "51958-7",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "51958-7"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:representative-transcript-ref-seq.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Versioned transcript reference sequence identifier",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "Multiple bindings acceptable (NCBI or LRG)"
        }
      },
      {
        "id" : "Observation.component:exact-start-end",
        "path" : "Observation.component",
        "sliceName" : "exact-start-end",
        "short" : "Exact Start-End",
        "definition" : "The exact integer-based genomic coordinates of the start and end of the variant region.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:exact-start-end.code",
        "path" : "Observation.component.code",
        "short" : "81254-5",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "81254-5"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:exact-start-end.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Range in question. 'High' can be omitted for single nucleotide variants.",
        "type" : [
          {
            "code" : "Range"
          }
        ]
      },
      {
        "id" : "Observation.component:inner-start-end",
        "path" : "Observation.component",
        "sliceName" : "inner-start-end",
        "short" : "Inner Start-End",
        "definition" : "The genomic coordinates of the narrowest genomic range in which the variant might reside. Used when the exact boundaries of the variant are not clear.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:inner-start-end.code",
        "path" : "Observation.component.code",
        "short" : "81302-2",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "81302-2"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:inner-start-end.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Imprecise variant inner-bounding range",
        "type" : [
          {
            "code" : "Range"
          }
        ]
      },
      {
        "id" : "Observation.component:outer-start-end",
        "path" : "Observation.component",
        "sliceName" : "outer-start-end",
        "short" : "Outer Start-End",
        "definition" : "The genomic coordinates of the widest genomic range in which the variant might reside. Used when the exact boundaries of the variant are not clear.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:outer-start-end.code",
        "path" : "Observation.component.code",
        "short" : "81301-4",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "81301-4"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:outer-start-end.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Imprecise variant outer-bounding range",
        "type" : [
          {
            "code" : "Range"
          }
        ]
      },
      {
        "id" : "Observation.component:coordinate-system",
        "path" : "Observation.component",
        "sliceName" : "coordinate-system",
        "short" : "Coordinate System",
        "definition" : "These are different ways of identifying nucleotides or amino acids within a sequence. In the 1-based system, the first unit of the polymer (e.g. the first nucleotide) is counted as number 1. In the 0-based system, the number 0 designates the location before the first nucleotide. Different databases and file types may use different systems.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:coordinate-system.code",
        "path" : "Observation.component.code",
        "short" : "92822-6",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "92822-6"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:coordinate-system.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "0-based interval counting | 0-based character counting | 1-based character counting",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://loinc.org/vs/LL5323-2"
        }
      },
      {
        "id" : "Observation.component:ref-allele",
        "path" : "Observation.component",
        "sliceName" : "ref-allele",
        "short" : "Genomic Ref Allele",
        "definition" : "Reference values ('normal') examined within the Reference Sequence.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:ref-allele.code",
        "path" : "Observation.component.code",
        "short" : "69547-8",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69547-8"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:ref-allele.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Normalized string per the VCF format.",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Observation.component:alt-allele",
        "path" : "Observation.component",
        "sliceName" : "alt-allele",
        "short" : "Genomic Alt Allele",
        "definition" : "The genomic alternate allele is the contiguous segment of DNA in the test sample that differs from the reference allele at the same location and thus defines a variant.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:alt-allele.code",
        "path" : "Observation.component.code",
        "short" : "69551-0",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69551-0"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:alt-allele.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Normalized string per the VCF format.",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Observation.component:coding-change-type",
        "path" : "Observation.component",
        "sliceName" : "coding-change-type",
        "short" : "Coding DNA Change Type",
        "definition" : "Type of DNA change observed. Convenience property for variants with exact breakpoints, required otherwise.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:coding-change-type.code",
        "path" : "Observation.component.code",
        "short" : "48019-4",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48019-4"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:coding-change-type.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "deletion | insertion | delins | SNV | copy_number_gain | copy_number_loss | ... (many)",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "Concepts in sequence ontology under SO:0002072",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/dna-change-type-vs"
        }
      },
      {
        "id" : "Observation.component:genomic-source-class",
        "path" : "Observation.component",
        "sliceName" : "genomic-source-class",
        "short" : "Genomic Source Class",
        "definition" : "The genomic class of the specimen being analyzed: Germline for inherited genome, somatic for cancer genome, and prenatal for fetal genome.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:genomic-source-class.code",
        "path" : "Observation.component.code",
        "short" : "48002-0",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48002-0"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:genomic-source-class.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Germline | Somatic | Fetal | Likely germline | Likely somatic | Likely fetal | Unknown genomic origin | De novo",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://loinc.org/vs/LL378-1"
        }
      },
      {
        "id" : "Observation.component:sample-allelic-frequency",
        "path" : "Observation.component",
        "sliceName" : "sample-allelic-frequency",
        "short" : "Sample Allelic Frequency",
        "definition" : "The relative frequency of the allele at a given locus in the sample.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:sample-allelic-frequency.code",
        "path" : "Observation.component.code",
        "short" : "81258-6",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "81258-6"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:sample-allelic-frequency.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Relative frequency in the sample",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.component:sample-allelic-frequency.value[x].system",
        "path" : "Observation.component.value[x].system",
        "patternUri" : "http://unitsofmeasure.org"
      },
      {
        "id" : "Observation.component:allelic-read-depth",
        "path" : "Observation.component",
        "sliceName" : "allelic-read-depth",
        "short" : "Allelic Read Depth",
        "definition" : "Specifies the number of reads that identified the allele in question whether it consists of one or a small sequence of contiguous nucleotides. Different methods and purposes require different numbers of reads to be acceptable. Often >400, sometimes as few as 2-4.",
        "comment" : "See [here](sequencing.html#variant-assessment) for usage guidance.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:allelic-read-depth.code",
        "path" : "Observation.component.code",
        "short" : "82121-5",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "82121-5"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:allelic-read-depth.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Unfiltered count of supporting reads",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.component:allelic-state",
        "path" : "Observation.component",
        "sliceName" : "allelic-state",
        "short" : "Allelic State",
        "definition" : "The observed level of occurrence of the variant in the set of chromosomes.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:allelic-state.code",
        "path" : "Observation.component.code",
        "short" : "53034-5",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "53034-5"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:allelic-state.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Heteroplasmic | Homoplasmic | Homozygous | Heterozygous | Hemizygous",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://loinc.org/vs/LL381-5"
        }
      },
      {
        "id" : "Observation.component:variant-inheritance",
        "path" : "Observation.component",
        "sliceName" : "variant-inheritance",
        "short" : "Origin of germline genetic variant",
        "definition" : "The source or inheritance of a specific germline variation found in an individual patient.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:variant-inheritance.code",
        "path" : "Observation.component.code",
        "short" : "94186-4",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "94186-4"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:variant-inheritance.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Maternal | Paternal | Unknown",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://loinc.org/vs/LL5489-1"
        }
      },
      {
        "id" : "Observation.component:variant-inheritance-basis",
        "path" : "Observation.component",
        "sliceName" : "variant-inheritance-basis",
        "short" : "Evidential basis for variant inheritance",
        "definition" : "The method by which the variant inheritance is determined.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:variant-inheritance-basis.code",
        "path" : "Observation.component.code",
        "short" : "Basis for allelic phase",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "82309-6"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:variant-inheritance-basis.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Directly measured | Family DNA | Family history | Inferred from population data",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://loinc.org/vs/LL4050-2"
        }
      },
      {
        "id" : "Observation.component:variation-code",
        "path" : "Observation.component",
        "sliceName" : "variation-code",
        "short" : "Variation Code",
        "definition" : "Accession number in a variant database such as ClinVar, given for cross-reference.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:variation-code.code",
        "path" : "Observation.component.code",
        "short" : "81252-9",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "81252-9"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:variation-code.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "ClinVar ID or similar",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "Multiple bindings acceptable"
        }
      },
      {
        "id" : "Observation.component:representative-protein-hgvs",
        "path" : "Observation.component",
        "sliceName" : "representative-protein-hgvs",
        "short" : "Protein (Amino Acid) Change - pHGVS",
        "definition" : "Description of the protein (amino acid) sequence change using a valid HGVS-formatted string. The description of the variant is surrounded in parentheses if it is calculated rather than directly observed.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:representative-protein-hgvs.code",
        "path" : "Observation.component.code",
        "short" : "48005-3",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48005-3"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:representative-protein-hgvs.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "A valid HGVS-formatted 'p.' string, e.g. NP_000050.2:p.(Asn1836Lys)",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/hgvs-vs"
        }
      },
      {
        "id" : "Observation.component:copy-number",
        "path" : "Observation.component",
        "sliceName" : "copy-number",
        "short" : "Genomic Structural Variant Copy Number",
        "definition" : "The copy number of the large variant. In HGVS, this is the numeric value following the “X”. It is a unit-less value. If the value determined by the assay is not a whole number, a range or decimal number can be specified. Note that a copy number of 1 can imply a deletion.",
        "comment" : "Copy number variants are often described with a single copy number value. However, due to the nature of assays, such as qPCR and microarray, it can be difficult to assign an exact copy number. Therefore, labs sometimes report a range instead of an exact copy number. They may alternatively choose to report decimal numbers, even if whole numbers are biologically correct.\n\nIn general, it can be difficult to estimate a copy number from measurements taken on a heterogenous population of cells, such as a tumor. As indicated in the ISCN 2020 specifications, it is appropriate to express the measurements using a range. Furthermore, regardless of cell population, many assays use fluorescent probes to detect copy number. These testing methodologies do not always provide an exact, discrete value for this data point.",
        "requirements" : "There SHALL be a code with a value of '1' if there is a value. If system is present, it SHALL be UCUM.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:copy-number.code",
        "path" : "Observation.component.code",
        "short" : "82155-3",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "82155-3"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:copy-number.value[x]",
        "path" : "Observation.component.value[x]",
        "type" : [
          {
            "code" : "Quantity"
          },
          {
            "code" : "Range"
          }
        ]
      },
      {
        "id" : "Observation.component:variant-confidence-status",
        "path" : "Observation.component",
        "sliceName" : "variant-confidence-status",
        "short" : "Variant Confidence Status",
        "definition" : "A code that represents the confidence of a true positive variant call.",
        "comment" : "See [here](sequencing.html#variant-assessment) for usage guidance.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:variant-confidence-status.code",
        "path" : "Observation.component.code",
        "short" : "variant-confidence-status",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "variant-confidence-status"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:variant-confidence-status.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "High | Intermediate | Low",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/variant-confidence-status-vs"
        }
      },
      {
        "id" : "Observation.component:repeat-motif",
        "path" : "Observation.component",
        "sliceName" : "repeat-motif",
        "short" : "Repeat Motif",
        "definition" : "Nucleotides of a repeat expansion motif.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:repeat-motif.extension",
        "path" : "Observation.component.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:repeat-motif.extension:repeat-motif-order",
        "path" : "Observation.component.extension",
        "sliceName" : "repeat-motif-order",
        "comment" : "If there are multiple repeat expansion pairs, this must be used both to indicate the sequence position of a given repeat-motif and repeat-number pair and to group the related components together. Components with the same extension value describe the same motif.",
        "requirements" : "The value must be a natural number starting from 1 and increasing sequentially",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/repeat-motif-order"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component:repeat-motif.code",
        "path" : "Observation.component.code",
        "short" : "repeat-motif",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "repeat-motif"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:repeat-motif.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "CAG",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Observation.component:repeat-number",
        "path" : "Observation.component",
        "sliceName" : "repeat-number",
        "short" : "Repeat Number",
        "definition" : "Number of repeats of a repeat expansion.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:repeat-number.extension",
        "path" : "Observation.component.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:repeat-number.extension:repeat-motif-order",
        "path" : "Observation.component.extension",
        "sliceName" : "repeat-motif-order",
        "comment" : "If there are multiple repeat expansion pairs, this must be used both to indicate the sequence position of a given repeat-motif and repeat-number pair and to group the related components together. Components with the same extension value describe the same motif.",
        "requirements" : "The value must be a natural number starting from 1 and increasing sequentially",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/repeat-motif-order"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component:repeat-number.code",
        "path" : "Observation.component.code",
        "short" : "repeat-number",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "repeat-number"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:repeat-number.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "40",
        "min" : 1,
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      }
    ]
  }
}

```
