# Therapeutic Implication - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Therapeutic Implication**

## Resource Profile: Therapeutic Implication 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:TherapeuticImplication |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc. | | |

 
Observation stating a therapeutic annotation (e.g. drug susceptibility, clinical trial eligibility) on one or more genotype/haplotype/variant/biomarker observations. 

This section provides guidance for genomic reporting about the implication of a patient's genetics on the behavior of one or more medications or other therapeutic alternatives (such as clinical trials).

This portion of the implementation guide relies on the content in the [General Genomic Reporting](general.md) and [Variant Reporting](sequencing.md) portions of this implementation guide. Pharmacogenomic reports supplement this information with a set of pharmacogenomic-specific implication profiles. Implementers of pharmacogenomic reporting may also be interested in the [Somatic Reporting](somatics.md) section of this implementation guide.

### Communicating disease or tumor context

In general, treatments and medications have a set of indications for use which are not explicitly stated. However, if a pharmacogenomics statement has a specific context of a disease or a tumor use the component `phenotypic-treatment-context` to indicate the disease.

### Pharmacogenomic-specific Genomic Implications

**Figure 1: Pharmacogenomic Implications**

(Profile links: [Genomic Implication](StructureDefinition-implication.md), [Therapeutic Implication](StructureDefinition-therapeutic-implication.md), [Medication Recommendadtion](StructureDefinition-medication-recommendation.md))

There are two ways to communicate details about a medication whose implication is being described. The profile component `medication-assessed` is the place to communicate a simple code for the medication. If more detail about the medication is to be shared, use the extension named `medication-assessed-reference`. The extension can refer to a [Medication](http://hl7.org/fhir/R5/medication.html) or [MedicationKnowledge](http://hl7.org/fhir/R5/medicationknowledge.html) resource. This might be used to share specific [classification details](http://hl7.org/fhir/R5/medicationknowledge-definitions.html#MedicationKnowledge.medicineClassification) if they are important as part of the implication being described. It is important to note that since there two ways to do this, implementers SHALL ensure consistent usage. If both the extension and component are used at the same time, they SHALL deliver the same medication. Because this is an international profile, no guidance is provided on drug coding systems.

It is important to note there are also two ways to communicate details about non-medication therapies (e.g. altered diet, radiation therapy, surgery, etc.). The profile component `therapy-assessed` is the place to communicate a simple code for the therapy. If more detail about the therapy is to be shared, use the extension named `therapy-assessed-reference`. The extension can refer to a [CarePlan](http://hl7.org/fhir/R5/careplan.html), [ResearchStudy](http://hl7.org/fhir/R5/researchstudy.html), or [PlanDefinition](http://hl7.org/fhir/R5/plandefinition.html) resource. It is important to note that since there two ways to do this, implementers SHALL ensure consistent usage. If both the extension and component are used at the same time, they SHALL deliver the same therapy. Because this is an international profile, no guidance is provided on therapy coding systems.

The component `therapeutic-implication` lists one or more ramifications based on the presence of associated molecular finding(s), which may include:

* Alterations in drug metabolism (or pharmacokinetics) that determine the concentration of the drug, prodrug, and/or break-down products over time;
* Alterations in drug efficacy (or pharmacodynamics) that determine how effective a drug is at a given concentration;
* Alterations that alter the risk of adverse drug events, or other types of implications that indicate altered responsiveness to other types of therapies or eligibility for clinical trials;
* Other pharmacogenomic statements as necessary, by extending the valueSet.

### Including Pharmacogenomic recommended actions

To associate a therapeutic implication instance with a recommendation (e.g. discontinuing a medication, altering dosage, choose alternative medication) use [Medication Recommendation](StructureDefinition-medication-recommendation.md), [Followup Recommendation](StructureDefinition-followup-recommendation.md), along with current medication if appropriate. Use the [Related Artifact](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-workflow-relatedArtifact.html) extension for supporting documents such as CPIC guidelines.

Medication Recommendation tasks link to therapeutic implications through `reasonReference` and are included in the report using the [recommended-action](StructureDefinition-genomic-report-definitions.md#DiagnosticReport.extension:recommended-action) extension. The therapeutic implications do not have a link to medication recommendations, so the [revinclude](http://hl7.org/fhir/R5/search.html#revinclude) search parameter can be used to find the therapeutic implication statements relevant to the recommendations.

Note: If multiple medications are used in medication assessed, the usage implication should describe the combined effect.

Note 2: Implementers may also be interested in the [Somatic Reporting](somatics.md) and [Pharmacogenomics Reporting](pharmacogenomics.md) sections of this implementation guide.

### evidence-level versus clinical-significance

See [Genomic Implication](StructureDefinition-implication.md#evidence-level-versus-clinical-significance) for guidance.

### Differentiating AND vs OR

See [Genomic Implication](StructureDefinition-implication.md#differentiating-and-vs-or) for guidance. Implication fields affected by this guidance include: derivedFrom, evidence-level, therapeutic-implication, phenotypic-treatment-context, medication-assessed, therapy-assessed.

**Usages:**

* Refer to this Profile: [Followup Recommendation](StructureDefinition-followup-recommendation.md), [Genomic Report](StructureDefinition-genomic-report.md) and [Medication Recommendation](StructureDefinition-medication-recommendation.md)
* Examples for this Profile: [Observation/EGFR-L858R-therapuDrug1](Observation-EGFR-L858R-therapuDrug1.md), [Observation/EGFR-L858R-therapuDrug2](Observation-EGFR-L858R-therapuDrug2.md), [Observation/ROS1-Fusion-therapuDrug](Observation-ROS1-Fusion-therapuDrug.md), [Observation/ROS1-Fusion-therapuTrial](Observation-ROS1-Fusion-therapuTrial.md)...Show 13 more,[Observation/TMB-therapuDrug](Observation-TMB-therapuDrug.md),[Observation/Therapeutic-Implication-Clinical-Trial-2](Observation-Therapeutic-Implication-Clinical-Trial-2.md),[Observation/Therapeutic-Implication-Clinical-Trial-Somatic](Observation-Therapeutic-Implication-Clinical-Trial-Somatic.md),[Observation/TherapeuticImplicationExample1](Observation-TherapeuticImplicationExample1.md),[Observation/TxImp01](Observation-TxImp01.md),[Observation/TxImp02](Observation-TxImp02.md),[Observation/TxImp03](Observation-TxImp03.md),[Observation/TxImp04](Observation-TxImp04.md),[Observation/TxImp05](Observation-TxImp05.md),[Observation/TxImp06](Observation-TxImp06.md),[Observation/therapuDrug1-interact-smn1-smn2](Observation-therapuDrug1-interact-smn1-smn2.md),[Observation/therapuDrug2-interact-smn1-smn2](Observation-therapuDrug2-interact-smn1-smn2.md)and[Observation/therapuDrug3-interact-smn1-smn2](Observation-therapuDrug3-interact-smn1-smn2.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/therapeutic-implication)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-therapeutic-implication.csv), [Excel](StructureDefinition-therapeutic-implication.xlsx), [Schematron](StructureDefinition-therapeutic-implication.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "therapeutic-implication",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication",
  "version" : "4.0.0-ballot",
  "name" : "TherapeuticImplication",
  "title" : "Therapeutic Implication",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Observation stating a therapeutic annotation (e.g. drug susceptibility, clinical trial eligibility) on one or more genotype/haplotype/variant/biomarker observations.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.",
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/implication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Therapeutic Implication"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "therapeutic-implication",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "therapeutic-implication"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:therapeutic-implication",
        "path" : "Observation.component",
        "sliceName" : "therapeutic-implication",
        "short" : "Therapeutic Implication",
        "definition" : "A predicted ramification based on the presence of associated molecular finding(s). Ramifications may include alterations in drug metabolism (or pharmacokinetics) that determine the concentration of the drug, prodrug, and/or break-down products over time; alterations in drug efficacy (or pharmacodynamics) that determine how effective a drug is at a given concentration; alterations that alter the risk of adverse drug events, or other types of implications that indicate altered responsiveness to other types of therapies.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:therapeutic-implication.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact"
      },
      {
        "id" : "Observation.component:therapeutic-implication.code",
        "path" : "Observation.component.code",
        "short" : "therapeutic-implication",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "therapeutic-implication"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:therapeutic-implication.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Responsive | Resistant | Poor metabolizer | Rapid metabolizer | Decreased function | Increased function | Does not meet eligibility criteria for clinical trial | ... (more)",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/genetic-therapeutic-implications-vs"
        }
      },
      {
        "id" : "Observation.component:phenotypic-treatment-context",
        "path" : "Observation.component",
        "sliceName" : "phenotypic-treatment-context",
        "short" : "Phenotypic treatment context",
        "definition" : "A condition whose treatment in medication-assessed or therapy-assessed is contextually impacted by the variant. A code set is not specified, but it is ideal to use terms related to medical findings. Some examples are SNOMED CT descendants of 'Clinical finding' (404684003), ICD-10-CM chapters 1-18 (codes starting with letters A-R), and all of Human Phenotype Ontology (HPO). For example, if an individual's variant affects the efficacy of imatinib in non-small cell lung cancer, a valid response from SNOMED CT would be 'Non-small cell lung cancer (code 254637007)'.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:phenotypic-treatment-context.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact"
      },
      {
        "id" : "Observation.component:phenotypic-treatment-context.code",
        "path" : "Observation.component.code",
        "short" : "81259-4",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "81259-4"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:phenotypic-treatment-context.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Contextual phenotype/condition code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "Binding not yet defined (examples: SNOMED CT Clinical findings, ICD-10-CM chapters 1-18, HPO terms)"
        }
      },
      {
        "id" : "Observation.component:medication-assessed",
        "path" : "Observation.component",
        "sliceName" : "medication-assessed",
        "short" : "Medication Assessed",
        "definition" : "The codified medication whose implication is being described.",
        "requirements" : "If this component is used, it should not conflict with the extension also named 'medication-assessed' which allows for more detailed medication data to be shared.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:medication-assessed.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact"
      },
      {
        "id" : "Observation.component:medication-assessed.extension:medication-assessed-reference",
        "path" : "Observation.component.extension",
        "sliceName" : "medication-assessed-reference",
        "requirements" : "NOTE - If this extension is used, it SHALL NOT conflict with the code delivered in the component.valueCodeableConcept.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/medication-assessed-reference"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component:medication-assessed.code",
        "path" : "Observation.component.code",
        "short" : "51963-7",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "51963-7"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:medication-assessed.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Medication code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "Binding not yet defined (RxNorm or similar)"
        }
      },
      {
        "id" : "Observation.component:therapy-assessed",
        "path" : "Observation.component",
        "sliceName" : "therapy-assessed",
        "short" : "Non-medication therapy assessed",
        "definition" : "The non-medication therapy (e.g., altered diet, radiation therapy, surgery) implicated with respect to the related finding(s) and cancer/phenotypic treatment context",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:therapy-assessed.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact"
      },
      {
        "id" : "Observation.component:therapy-assessed.extension:therapy-assessed-reference",
        "path" : "Observation.component.extension",
        "sliceName" : "therapy-assessed-reference",
        "requirements" : "NOTE - If this extension is used, it SHALL NOT conflict with the code delivered in the component.valueCodeableConcept.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapy-assessed-reference"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component:therapy-assessed.code",
        "path" : "Observation.component.code",
        "short" : "associated-therapy",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "associated-therapy"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:therapy-assessed.value[x]",
        "path" : "Observation.component.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "Binding not yet defined"
        }
      }
    ]
  }
}

```
