# Sequence Phase Relationship - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Sequence Phase Relationship**

## Resource Profile: Sequence Phase Relationship 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/sequence-phase-relationship | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:SequencePhaseRelationship |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc. | | |

 
Indicates whether two entities are in Cis (same strand) or Trans (opposite strand) relationship to each other. 

A sequence phase relationship asserts a specific type of relationship between two variants or haplotypes.

Humans inherit a copy of each autosome from mother and father - each cell contains, for instance, a maternally-derived and a paternally-derived chromosome 7. We refer to the two chromosomes as 'homologous', and we can refer to each of the chromosomes as 'homologs'.

Where a person has two variants (or haplotypes) on chromosome 7, those variants can both be on the same homolog (i.e. both variants are on the maternally-derived chromosome), or those variants can be on different homologs (i.e. one variant is on the maternally-derived chromosome and one variant is on the paternally-derived chromosome).

Where the two variants are on the same homolog, the variants are said to be in a 'Cis' relationship. Where the two variants are on different homologs, the variants are said to be in a 'Trans' relationship.

**Usages:**

* Refer to this Profile: [Genomic Report](StructureDefinition-genomic-report.md)
* Examples for this Profile: [Observation/SequencePhaseRelationExample1](Observation-SequencePhaseRelationExample1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/sequence-phase-relationship)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-sequence-phase-relationship.csv), [Excel](StructureDefinition-sequence-phase-relationship.xlsx), [Schematron](StructureDefinition-sequence-phase-relationship.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "sequence-phase-relationship",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/sequence-phase-relationship",
  "version" : "4.0.0-ballot",
  "name" : "SequencePhaseRelationship",
  "title" : "Sequence Phase Relationship",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Indicates whether two entities are in Cis (same strand) or Trans (opposite strand) relationship to each other.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.",
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/finding",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "82120-7",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "82120-7"
            }
          ]
        }
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "Cis | Trans | Indeterminate | Unknown",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/sequence-phase-relationship-vs"
        }
      },
      {
        "id" : "Observation.method",
        "path" : "Observation.method",
        "short" : "Directly measured | Family DNA | Family history | Inferred from population data",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://loinc.org/vs/LL4050-2"
        }
      },
      {
        "id" : "Observation.derivedFrom:variant",
        "path" : "Observation.derivedFrom",
        "sliceName" : "variant",
        "short" : "Variant in the relationship",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom:haplotype",
        "path" : "Observation.derivedFrom",
        "sliceName" : "haplotype",
        "short" : "Haplotype in the relationship",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
            ]
          }
        ]
      }
    ]
  }
}

```
