# Molecular Consequence - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Molecular Consequence**

## Resource Profile: Molecular Consequence 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:MolecularConsequence |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc. | | |

 
Profile for communicating the calculated or observed effect of a DNA variant, generally on its downstream transcript and, if applicable, ensuing protein sequence. Molecular consequences may also apply to DNA, such as intergenic regions where there are no transcripts (e.g. 'regulatory_region_variant'). Component 'feature-consequence' categorizes the structural implications of a variant (e.g. the variant disrupts a regulatory region, the variant is an inframe insertion), whereas component 'functional-effect' categorizes how the variant affects overall function (e.g. is predicted to result in loss of gene function). 

### Molecular Consequence Use Case

A given variant can have multiple transcript-specific predicted molecular consequences. Clinical applications such as rare disease variant discovery, clinical trial matching, and the determination of therapeutic options for cancer patients may need to examine each predicted consequence as part of a variant filtration and prioritization process.

### Detailed Example

In this example, a variant in a gene with multiple transcripts is annotated with multiple transcript-specific molecular consequence predictions. This figure shows multiple transcripts of the ODF2L gene.

This next figure shows a VCF row. A variant in the ODF2L gene has been annotated with the [snpEff/snpSIFT variant prediction tool](http://example.org/pcingola.github.io/SnpEff/). Things to note include:

* The example here prefixes the URI with http://example.org as is the standard approach in HL7 guides when a code system is not an official terminology
* snpEff predicts a molecular consequence for each known transcript
* Each molecular consequence has one or more 'effects' (drawn from Sequence Ontology), and an 'impact category' (HIGH, MODERATE, LOW, MODIFIER)
* Note how variants occurring outside of exons in certain transcripts (e.g. intron_variant) do not have an associated pHGVS
* snpEff may assign an overall 'LOF' (Loss of Function) prediction. (In these examples, we include the 'LOF' where effect=HIGH)
* This example uses snpSIFT with [gnomAD](https://gnomad.broadinstitute.org/) to annotate a population allele frequency
* In some cases, snpEff will assign more than one molecular consequence to a given transcript (e.g. splice_donor_variant&intron_variant)

These following examples correspond to the annotated VCF row.

* [Variant](Observation-variant-with-molec-consequences.md) (includes population allele frequency)
* [Molecular consequence 1](Observation-molec-conseq1.md) (includes LOF prediction)
* [Molecular consequence 2](Observation-molec-conseq2.md)
* [Molecular consequence 3](Observation-molec-conseq3.md)
* [Molecular consequence 4](Observation-molec-conseq4.md)### evidence-level versus clinical-significance

See [Genomic Implication](StructureDefinition-implication.md#evidence-level-versus-clinical-significance) for guidance.

### Differentiating AND vs OR

There are several cases where it is necessary to differentiate 'AND' conditions (e.g. a consequence of a DNA variant is both X and Y, as in the first example above where a consequence is both a 'splice_donor_variation' AND a 'intron_variant') vs. 'OR' conditions (e.g. a consequence of a DNA variant may be X or may by Y, as in the example above where a consequence might be 'synonymous variant' OR 'intron_variant'). This situation is not unique to molecular consequences, and arises elsewhere within FHIR (e.g. [FHIR Search](https://www.hl7.org/fhir/search.html#combining)) and outside of FHIR (e.g. [Clinvar submission API](https://www.ncbi.nlm.nih.gov/clinvar/docs/api_http/) condition set). To be consistent with other precedents, where molecular consequences have fields with cardinality >1, the inclusion of multiple values within a field shall indicate an 'AND' condition. An 'OR' condition is represented by multiple observation instances.

See [Genomic Implication](StructureDefinition-implication.md#differentiating-and-vs-or) for additional information. Implication fields affected by this guidance include: derivedFrom, evidence-level, feature-consequence.

**Usages:**

* Refer to this Profile: [Followup Recommendation](StructureDefinition-followup-recommendation.md) and [Genomic Report](StructureDefinition-genomic-report.md)
* Examples for this Profile: [Observation/ATR-insertion-molc](Observation-ATR-insertion-molc.md), [Observation/EGFR-L858R-molc](Observation-EGFR-L858R-molc.md), [Observation/MSH2-del-molc](Observation-MSH2-del-molc.md), [Observation/NOTCH1-uncertain-molc](Observation-NOTCH1-uncertain-molc.md)...Show 8 more,[Observation/NTHL1-snv-molc](Observation-NTHL1-snv-molc.md),[Observation/ROS1-Fusion](Observation-ROS1-Fusion.md),[Observation/STAG2-insertion-molc](Observation-STAG2-insertion-molc.md),[Observation/ZFHX3-uncertain-molc](Observation-ZFHX3-uncertain-molc.md),[Observation/molec-conseq1](Observation-molec-conseq1.md),[Observation/molec-conseq2](Observation-molec-conseq2.md),[Observation/molec-conseq3](Observation-molec-conseq3.md)and[Observation/molec-conseq4](Observation-molec-conseq4.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/molecular-consequence)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-molecular-consequence.csv), [Excel](StructureDefinition-molecular-consequence.xlsx), [Schematron](StructureDefinition-molecular-consequence.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "molecular-consequence",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence",
  "version" : "4.0.0-ballot",
  "name" : "MolecularConsequence",
  "title" : "Molecular Consequence",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Profile for communicating the calculated or observed effect of a DNA variant, generally on its downstream transcript and, if applicable, ensuing protein sequence. Molecular consequences may also apply to DNA, such as intergenic regions where there are no transcripts (e.g. 'regulatory_region_variant'). Component 'feature-consequence' categorizes the structural implications of a variant (e.g. the variant disrupts a regulatory region, the variant is an inframe insertion), whereas component 'functional-effect' categorizes how the variant affects overall function (e.g. is predicted to result in loss of gene function).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.",
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/implication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Molecular Consequence"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "molecular-consequence",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "molecular-consequence"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:coding-hgvs",
        "path" : "Observation.component",
        "sliceName" : "coding-hgvs",
        "short" : "DNA change (c.HGVS)",
        "definition" : "Human Genome Variation Society (HGVS) nomenclature for a single DNA marker. The use of the nomenclature must be extended to describe non-variations (aka. wild types) see samples for wild type examples.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:coding-hgvs.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact"
      },
      {
        "id" : "Observation.component:coding-hgvs.code",
        "path" : "Observation.component.code",
        "short" : "48004-6",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48004-6"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:coding-hgvs.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "A valid HGVS-formatted 'c.' string, e.g. NM_005228.5:c.2369C>T.",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/hgvs-vs"
        }
      },
      {
        "id" : "Observation.component:transcript-ref-seq",
        "path" : "Observation.component",
        "sliceName" : "transcript-ref-seq",
        "short" : "Reference Transcript",
        "definition" : "NCBI's RefSeq ('NM_...'), Ensembl ('ENST...'), and LRG ('LRG...' plus 't1' to indicate transcript)",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:transcript-ref-seq.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact"
      },
      {
        "id" : "Observation.component:transcript-ref-seq.code",
        "path" : "Observation.component.code",
        "short" : "51958-7",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "51958-7"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:transcript-ref-seq.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Versioned transcript reference sequence identifier",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "Multiple bindings acceptable (NCBI or LRG)"
        }
      },
      {
        "id" : "Observation.component:protein-hgvs",
        "path" : "Observation.component",
        "sliceName" : "protein-hgvs",
        "short" : "Protein (Amino Acid) Change - pHGVS",
        "definition" : "Description of the protein (amino acid) sequence change using a valid HGVS-formatted string. The description of the variant is surrounded in parentheses if it is calculated rather than directly observed.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:protein-hgvs.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact"
      },
      {
        "id" : "Observation.component:protein-hgvs.code",
        "path" : "Observation.component.code",
        "short" : "48005-3",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48005-3"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:protein-hgvs.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "A valid HGVS-formatted 'p.' string, e.g. NP_000050.2:p.(Asn1836Lys)",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/hgvs-vs"
        }
      },
      {
        "id" : "Observation.component:protein-ref-seq",
        "path" : "Observation.component",
        "sliceName" : "protein-ref-seq",
        "short" : "Protein Reference Sequence",
        "definition" : "ID of the protein reference sequence, which includes transcribed and non transcribed stretches. It covers the entire protein described.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:protein-ref-seq.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact"
      },
      {
        "id" : "Observation.component:protein-ref-seq.code",
        "path" : "Observation.component.code",
        "short" : "protein-ref-seq",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "protein-ref-seq"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:protein-ref-seq.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Versioned protein reference sequence identifier",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "Multiple bindings acceptable (NCBI or LRG)"
        }
      },
      {
        "id" : "Observation.component:feature-consequence",
        "path" : "Observation.component",
        "sliceName" : "feature-consequence",
        "short" : "Feature Consequence",
        "definition" : "A feature consequence categorizes the structural implications of a variant (e.g. the variant disrupts a regulatory region, the variant is an inframe insertion). NOTE: The bound Molecular Consequence value set is extensible. Variant annotation tools such as snpEff provide a rich assortment of feature consequences (see http://example.org/pcingola.github.io/SnpEff/se_inputoutput/#effect-prediction-details), some of which are outside the value set. ",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:feature-consequence.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact"
      },
      {
        "id" : "Observation.component:feature-consequence.code",
        "path" : "Observation.component.code",
        "short" : "feature-consequence",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "feature-consequence"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:feature-consequence.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "stop_lost | stop_gained | inframe_insertion | frameshift_variant | ... (many)",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "Concepts in sequence ontology under SO:0001537.",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/molecular-consequence-vs"
        }
      },
      {
        "id" : "Observation.component:functional-effect",
        "path" : "Observation.component",
        "sliceName" : "functional-effect",
        "short" : "Functional Effect",
        "definition" : "A predicted or observed effect of a variant on the ability of its gene(s) or protein product(s) to function.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:functional-effect.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact"
      },
      {
        "id" : "Observation.component:functional-effect.code",
        "path" : "Observation.component.code",
        "short" : "functional-effect",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "functional-effect"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:functional-effect.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "gain of function | loss of function | loss of heterozygosity | decreased transcript level | increased transcipt level | dominant negative variant | ... (more)",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "Sequence Ontology terms under SO:0001536",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/functional-effect-vs"
        }
      }
    ]
  }
}

```
