# Genomic Report - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Genomic Report**

## Resource Profile: Genomic Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:GenomicReport |

 
Genomic profile of DiagnosticReport. 

### Scope and Usage

The [genomic report](StructureDefinition-genomic-report.md) is the focus of all genomic reporting. It conveys metadata about the overall report (what kind of report it was, when it was written, who wrote it, final vs. draft, etc.). It also typically includes a rendered version for review by a clinician. It also groups together all relevant information found as part of the genomic analysis (Rules for relevancy will depend on the type of testing ordered, the reason for testing and the policies of the lab). Most of the structured genomic information is expressed as FHIR [Observations](http://hl7.org/fhir/R5/observation.html). Any recommendations that come with the report are expressed as FHIR [Tasks](http://hl7.org/fhir/R5/task.html). The report can be organized into sub-reports using core DiagnosticReport extensions like [extends](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-diagnosticReport-extends.html) or [summaryOf](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-diagnosticReport-summaryOf.html), which is especially useful for later analysis steps. Additionally, an observation can be used to [group](groupingguidance.md) content for viewing purposes or to indicate a higher-level panel (with a specific LOINC panel code in the `Observation.code` for example).

**Genomic Report Overview**

**Usages:**

* Refer to this Profile: [Genomic Data File](StructureDefinition-genomic-data-file.md)
* Examples for this Profile: [DiagnosticReport/GenomicReportExample01](DiagnosticReport-GenomicReportExample01.md), [DiagnosticReport/PGxGenomicReportEMERGE-withGrouping](DiagnosticReport-PGxGenomicReportEMERGE-withGrouping.md), [DiagnosticReport/PGxGenomicReportEMERGE](DiagnosticReport-PGxGenomicReportEMERGE.md), [DiagnosticReport/diagnosticreport-hla-glstring-r4](DiagnosticReport-diagnosticreport-hla-glstring-r4.md) and [DiagnosticReport/somaticReport](DiagnosticReport-somaticReport.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/genomic-report)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-genomic-report.csv), [Excel](StructureDefinition-genomic-report.xlsx), [Schematron](StructureDefinition-genomic-report.sch) 

### Notes:

#### Overall Interpretation and Conclusion

On the report, it is important to answer the question "Did you find anything when you did the test I asked you to do?" The data sender can use attributes of `conclusionCode` and `conclusion` to represent the summary result of the test (e.g., Positive, Negative, Unknown) and a textual summary. These are typically used when the genomic test was looking for a particular genomically-based disease. It allows indication of whether genomic results known to be associated with the disease were found or not.

#### Linking To Genomic Observations

Results observation profiles, like genomic observations, are typically referenced directly by a Genomic Report. The genetic findings and implication profiles all contain links to computably define their composite relationships (e.g., the variant observation is referenced within the implication profile using `derivedFrom`). However, observations could be organized into groups by other observations. See this [grouping guidance](groupingguidance.md) for an overview with examples and considerations for processing reports. Be aware that consumers of Genomic Diagnostic Report MUST navigate through all `hasMember` relations and navigate through `derivedFrom` relationships to ensure processing of all clinically relevant information.

#### Risk Assessments

In some cases, the lab or other reporting organization may generate risk assessments as part of their reports. These are referenced from a report or an observation from the [Genomic Risk](StructureDefinition-genomic-risk-assessment.md) extension.

#### Presented Form

When sending a copy of the report (e.g., PDF or other document containing the written report), use `presentedForm`. Note this is different from the [Related Artifact](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-workflow-relatedArtifact.html) extension, which is used to reference citations, evidence and other supporting documentation for the observation or report. Another approach which should be avoided (at least for this current release) is the `DiagnosticReport.media` attribute. Its definition focuses on "Key images associated with this report" which does not align well with this use case.

#### Complex Reports

If needed, large or complex genomic reports may be broken down into sub-reports using core DiagnosticReport extensions like [extends](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-diagnosticReport-extends.html) or [summaryOf](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-diagnosticReport-summaryOf.html). This approach is particularly useful when different labs or services are performing later steps in the analysis, for example. Or a panel `Observation.code` can be used.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "genomic-report",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report",
  "version" : "4.0.0-ballot",
  "name" : "GenomicReport",
  "title" : "Genomic Report",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Genomic profile of DiagnosticReport.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DiagnosticReport",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DiagnosticReport",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DiagnosticReport",
        "path" : "DiagnosticReport"
      },
      {
        "id" : "DiagnosticReport.extension",
        "path" : "DiagnosticReport.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "DiagnosticReport.extension:recommended-action",
        "path" : "DiagnosticReport.extension",
        "sliceName" : "recommended-action",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/recommended-action"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.extension:genomic-risk-assessment",
        "path" : "DiagnosticReport.extension",
        "sliceName" : "genomic-risk-assessment",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-risk-assessment"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.extension:coded-note",
        "path" : "DiagnosticReport.extension",
        "sliceName" : "coded-note",
        "short" : "Comments about the report that also contain a coded type",
        "comment" : "May include general statements about the report, or statements about significant, unexpected or unreliable results values, or information about its source when relevant to its interpretation.\nThe CodedAnnotation data type, while not allowing for or intending to make the content computable, does allow the author to indicate the type of note. This does not replace the use of results or conclusion or conclusionCode.\nOne important note is that Annotation is a FHIR data type, this is **NOT** about annotations in the genomic context.",
        "requirements" : "Need to be able to provide free text additional information. Notes SHALL NOT contain information which can be captured in a structured way.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report-note"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.extension:supporting-info",
        "path" : "DiagnosticReport.extension",
        "sliceName" : "supporting-info",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/workflow-supportingInfo"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.extension:hla-genotyping-results-allele-database",
        "path" : "DiagnosticReport.extension",
        "sliceName" : "hla-genotyping-results-allele-database",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/hla-genotyping-results-allele-database"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.extension:hla-genotyping-results-glstring",
        "path" : "DiagnosticReport.extension",
        "sliceName" : "hla-genotyping-results-glstring",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/hla-genotyping-results-glstring"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.extension:workflow-relatedArtifact",
        "path" : "DiagnosticReport.extension",
        "sliceName" : "workflow-relatedArtifact",
        "comment" : "Note that in contrast this extension, the supportingInfo extension references other resources from the patient record that were used in creating the resource.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.category",
        "path" : "DiagnosticReport.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "coding"
            }
          ],
          "description" : "Slice based on the category code pattern",
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "DiagnosticReport.category:Genetics",
        "path" : "DiagnosticReport.category",
        "sliceName" : "Genetics",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "DiagnosticReport.category:Genetics.coding",
        "path" : "DiagnosticReport.category.coding",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      },
      {
        "id" : "DiagnosticReport.code",
        "path" : "DiagnosticReport.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "51969-4"
            }
          ]
        }
      },
      {
        "id" : "DiagnosticReport.effective[x]",
        "path" : "DiagnosticReport.effective[x]",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "DiagnosticReport.result",
        "path" : "DiagnosticReport.result",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "description" : "Slice based on the reference profile and code pattern",
          "rules" : "open"
        }
      },
      {
        "id" : "DiagnosticReport.result:diagnostic-implication",
        "path" : "DiagnosticReport.result",
        "sliceName" : "diagnostic-implication",
        "short" : "Diagnostic Implication",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.result:therapeutic-implication",
        "path" : "DiagnosticReport.result",
        "sliceName" : "therapeutic-implication",
        "short" : "Therapeutic Implication",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.result:molecular-consequence",
        "path" : "DiagnosticReport.result",
        "sliceName" : "molecular-consequence",
        "short" : "Molecular Consequence",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.result:variant",
        "path" : "DiagnosticReport.result",
        "sliceName" : "variant",
        "short" : "Variant",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.result:sequence-phase-relation",
        "path" : "DiagnosticReport.result",
        "sliceName" : "sequence-phase-relation",
        "short" : "Sequence Phase Relationship",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/sequence-phase-relationship"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.result:genotype",
        "path" : "DiagnosticReport.result",
        "sliceName" : "genotype",
        "short" : "Genotype",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.result:haplotype",
        "path" : "DiagnosticReport.result",
        "sliceName" : "haplotype",
        "short" : "Haplotype",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.result:biomarker",
        "path" : "DiagnosticReport.result",
        "sliceName" : "biomarker",
        "short" : "MolecularBiomarker",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-biomarker"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.conclusion",
        "path" : "DiagnosticReport.conclusion",
        "short" : "Assessment of overall results"
      },
      {
        "id" : "DiagnosticReport.conclusionCode",
        "path" : "DiagnosticReport.conclusionCode",
        "short" : "Coarse overall interpretation of the genomic results"
      }
    ]
  }
}

```
