# Genomic Data File - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Genomic Data File**

## Resource Profile: Genomic Data File 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:GenomicDataFile |

 
A profile of DocumentReference used to represent a genomics file. 

**Usages:**

* Examples for this Profile: [DocumentReference/CNVAnalysis-called](DocumentReference-CNVAnalysis-called.md), [DocumentReference/FullGenome-GRCh38](DocumentReference-FullGenome-GRCh38.md), [DocumentReference/SimpleVariantAnalysis-called](DocumentReference-SimpleVariantAnalysis-called.md), [DocumentReference/UncallableRegions](DocumentReference-UncallableRegions.md)...Show 9 more,[DocumentReference/WES-FullSequencedRegion-GRCh38](DocumentReference-WES-FullSequencedRegion-GRCh38.md),[DocumentReference/WES-UncallableRegions-GRCh38](DocumentReference-WES-UncallableRegions-GRCh38.md),[DocumentReference/genomicFileFatherBAM](DocumentReference-genomicFileFatherBAM.md),[DocumentReference/genomicFileMotherBAM](DocumentReference-genomicFileMotherBAM.md),[DocumentReference/genomicFileProbandBAM](DocumentReference-genomicFileProbandBAM.md),[DocumentReference/genomicFileProbandVCF](DocumentReference-genomicFileProbandVCF.md),[DocumentReference/genomicVCFfile-cnv](DocumentReference-genomicVCFfile-cnv.md),[DocumentReference/genomicVCFfile-simple](DocumentReference-genomicVCFfile-simple.md)and[DocumentReference/somaticVCFfile](DocumentReference-somaticVCFfile.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/genomic-data-file)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-genomic-data-file.csv), [Excel](StructureDefinition-genomic-data-file.xlsx), [Schematron](StructureDefinition-genomic-data-file.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "genomic-data-file",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file",
  "version" : "4.0.0-ballot",
  "name" : "GenomicDataFile",
  "title" : "Genomic Data File",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "A profile of DocumentReference used to represent a genomics file.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "fhircomposition",
      "uri" : "http://hl7.org/fhir/composition",
      "name" : "FHIR Composition"
    },
    {
      "identity" : "xds",
      "uri" : "https://profiles.ihe.net/ITI/TF/Volume3",
      "name" : "XDS metadata equivalent"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DocumentReference",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DocumentReference",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DocumentReference",
        "path" : "DocumentReference"
      },
      {
        "id" : "DocumentReference.related",
        "path" : "DocumentReference.related",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.description",
        "path" : "DocumentReference.description",
        "short" : "Human-readable description to provide guidance on how the file was generated"
      }
    ]
  }
}

```
