# Genomic Finding - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Genomic Finding**

## Resource Profile: Genomic Finding ( Abstract ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/finding | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:GenomicFinding |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc. | | |

 
Properties common to genetic findings whose results are expressed as computable discrete elements (e.g. genotypes, haplotypes, variants, etc.). 

### Scope and Usage

The primary focus of genomic testing is making Genomic Findings. These are the fine and/or coarse-grained descriptions of a specimen's genomic characteristics. This profile is the base profile for all other finding profiles, defining a set of constraints that are applicable across all findings.

**Genomic Findings**

[Genomic Finding](StructureDefinition-finding.md), [Genotype](StructureDefinition-genotype.md), [Haplotype](StructureDefinition-haplotype.md), [Variant](StructureDefinition-variant.md) (or see [Variant Reporting](sequencing.md)), [Sequence Phase Relationship](StructureDefinition-sequence-phase-relationship.md)

#### Types of Findings

* [Genotypes](StructureDefinition-genotype.md) describe combinations of genomic variations that together are associated with a particular phenotype - i.e., a specific physical, behavioral, or risk-associated difference associated with the organism whose specimen was tested.
* [Haplotypes](StructureDefinition-haplotype.md) describe a set of genomic variations that appear on a single strand of DNA - and which are therefore typically inherited together
* Variants are specific differences or combinations of differences between parts of one or more specimen sequences and the equivalent portions of the reference sequence(s) for that organism. The [Variant Reporting](sequencing.md) section deals with all types of variants detected by formal sequencing, including simple/discrete variants, structural variants and complex variants detected by direct sequencing, shotgun-based sequencing, and array-based testing for specific variants.
* [Sequence Phase Relationships](StructureDefinition-sequence-phase-relationship.md) describe the CIS or TRANS relationship of findings.

These categories of observations have relationships. Haplotypes can be identified based on the presence of variants. Genotypes can be identified based on the presence of haplotypes and/or variants. All three can be expressed as a combination of one or more sequences.

#### Common Elements

* `reference-sequence-assembly (component)` represents reference sequence used when determining this finding
* `chromosome-identifier (component)` represents the chromosome for the finding
* `cytogenetic-location (component)` represents the chromosome, arm, and band (can be multiple) for the finding
* `gene-studied (component)` represents the gene(s) for the finding.

**Usages:**

* Derived from this Profile: [Genotype](StructureDefinition-genotype.md), [Haplotype](StructureDefinition-haplotype.md), [Sequence Phase Relationship](StructureDefinition-sequence-phase-relationship.md) and [Variant](StructureDefinition-variant.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/finding)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-finding.csv), [Excel](StructureDefinition-finding.xlsx), [Schematron](StructureDefinition-finding.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "finding",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/finding",
  "version" : "4.0.0-ballot",
  "name" : "GenomicFinding",
  "title" : "Genomic Finding",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Properties common to genetic findings whose results are expressed as computable discrete elements (e.g. genotypes, haplotypes, variants, etc.).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.",
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : true,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-base",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.component:gene-studied",
        "path" : "Observation.component",
        "sliceName" : "gene-studied",
        "short" : "Gene Studied",
        "definition" : "The gene(s) on which the variant is located.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:gene-studied.code",
        "path" : "Observation.component.code",
        "short" : "48018-6",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48018-6"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:gene-studied.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "The HGNC gene symbol is to be used as display text and the HGNC gene ID used as the code. If no HGNC code issued for this gene yet, NCBI gene IDs SHALL be used.",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/hgnc-vs"
        }
      },
      {
        "id" : "Observation.component:cytogenetic-location",
        "path" : "Observation.component",
        "sliceName" : "cytogenetic-location",
        "short" : "Cytogenetic (Chromosome) Location",
        "definition" : "The relevant chromosomal region. The combination of numbers and letters provide a genetic 'address'.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:cytogenetic-location.code",
        "path" : "Observation.component.code",
        "short" : "48001-2",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48001-2"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:cytogenetic-location.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Example: 1q21.1",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Observation.component:reference-sequence-assembly",
        "path" : "Observation.component",
        "sliceName" : "reference-sequence-assembly",
        "short" : "Human Reference Sequence Assembly",
        "definition" : "The reference genome/assembly used in this analysis.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:reference-sequence-assembly.code",
        "path" : "Observation.component.code",
        "short" : "62374-4",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "62374-4"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:reference-sequence-assembly.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "GRCh37 | GRCh38 | ...",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://loinc.org/vs/LL1040-6"
        }
      },
      {
        "id" : "Observation.component:chromosome-identifier",
        "path" : "Observation.component",
        "sliceName" : "chromosome-identifier",
        "short" : "Chromosome Identifier",
        "definition" : "An indicator, enumerated in humans by numbers 1-22, X, and Y, representing the chromosome on which the finding is located.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:chromosome-identifier.code",
        "path" : "Observation.component.code",
        "short" : "48000-4",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48000-4"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:chromosome-identifier.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Chromosome 1 | Chromosome 2 | ... | Chromosome 22 | Chromosome X | Chromosome Y",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://loinc.org/vs/LL2938-0"
        }
      }
    ]
  }
}

```
