# Diagnostic Implication - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Diagnostic Implication**

## Resource Profile: Diagnostic Implication 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:DiagnosticImplication |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc. | | |

 
Observation stating a diagnostic annotation (e.g. disease risk) on one or more genotype/haplotype/variant/biomarker observations. 

This section provides guidance for genomic reporting of patient genetic implications regarding specific conditions (sometimes referred to as phenotypes). This portion of the implementation guide relies on the content in the [General Genomic Reporting](general.md) and [Variant Reporting](sequencing.md) portions of this implementation guide.

### General usage notes

The diagnostic implication profile can be used to annotate variants, haplotypes, genotypes, or molecular biomarkers with phenotype associations. For example, this profile can be used to assert that the presence of a variant is associated with an increased risk of breast cancer.

Useful components include:

* **component:conclusion-string**: Concise and clinically contextualized summary conclusion (interpretation/impression) of the observation
* **component:evidence-level**: The amount of observed support for the association between an implication and a variant / haplotype / genotype / biomarker. (See the discussion of [evidence-level vs. clinical significance](StructureDefinition-implication.md#evidence-level-versus-clinical-significance) for additional guidance.)
* **component:clinical-significance**: The clinical impact of an implication on a person's health. (See the discussion of [evidence-level vs. clinical significance](StructureDefinition-implication.md#evidence-level-versus-clinical-significance) for additional guidance.)
* **component:predicted-phenotype**: An observable characteristic (e.g., condition, disease, physical finding) of an individual
* **component:mode-of-inheritance**: The transmission pattern of the condition/phenotype in a pedigree.

As with all implications, the explicit reference to the variant(s)/haplotype(s)/genotype(s)/molecular biomarker(s) being annotated must be provided in the Observation.derivedFrom field.

### evidence-level versus clinical-significance

See [Genomic Implication](StructureDefinition-implication.md#evidence-level-versus-clinical-significance) for guidance.

### Differentiating AND vs OR

See [Genomic Implication](StructureDefinition-implication.md#differentiating-and-vs-or) for guidance. Implication fields affected by this guidance include: derivedFrom, evidence-level, predicted-phenotype, genomic-risk-assessment.

**Usages:**

* Refer to this Profile: [Followup Recommendation](StructureDefinition-followup-recommendation.md) and [Genomic Report](StructureDefinition-genomic-report.md)
* Examples for this Profile: [Observation/ATR-insertion-significance](Observation-ATR-insertion-significance.md), [Observation/AnnotationExample](Observation-AnnotationExample.md), [Observation/EGFR-L858R-significance](Observation-EGFR-L858R-significance.md), [Observation/ISCN-CMLImplication](Observation-ISCN-CMLImplication.md)...Show 9 more,[Observation/MSH2-del-disease](Observation-MSH2-del-disease.md),[Observation/NOTCH1-significance](Observation-NOTCH1-significance.md),[Observation/NTHL1-snv-disease](Observation-NTHL1-snv-disease.md),[Observation/PolyGenicDiagnosticImpExample](Observation-PolyGenicDiagnosticImpExample.md),[Observation/ROS1-Fusion-disease](Observation-ROS1-Fusion-disease.md),[Observation/STAG2-insertion-significance](Observation-STAG2-insertion-significance.md),[Observation/ZFHX3-significance](Observation-ZFHX3-significance.md),[Observation/diagnosticImplication-interact-smn1-smn2](Observation-diagnosticImplication-interact-smn1-smn2.md)and[Observation/obs-idh-ex](Observation-obs-idh-ex.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.genomics-reporting|current/StructureDefinition/diagnostic-implication)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-diagnostic-implication.csv), [Excel](StructureDefinition-diagnostic-implication.xlsx), [Schematron](StructureDefinition-diagnostic-implication.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "diagnostic-implication",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication",
  "version" : "4.0.0-ballot",
  "name" : "DiagnosticImplication",
  "title" : "Diagnostic Implication",
  "status" : "active",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Observation stating a diagnostic annotation (e.g. disease risk) on one or more genotype/haplotype/variant/biomarker observations.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.",
  "fhirVersion" : "6.0.0-ballot3",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/implication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Diagnostic Implication"
      },
      {
        "id" : "Observation.extension:genomic-risk-assessment",
        "path" : "Observation.extension",
        "sliceName" : "genomic-risk-assessment",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-risk-assessment"
            ]
          }
        ]
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "diagnostic-implication",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "diagnostic-implication"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:predicted-phenotype",
        "path" : "Observation.component",
        "sliceName" : "predicted-phenotype",
        "short" : "Predicted phenotype",
        "definition" : "An observable characteristic (e.g., condition; disease) of an individual, as predicted by the presence of associated molecular finding(s)associated with the variant.  A code set is not specified, but it is ideal to use terms related to medical findings. Some examples are SNOMED CT descendants of 'Clinical finding' (404684003), ICD-10-CM chapters 1-18 (codes starting with letters A-R), and/or all of Human Phenotype Ontology (HPO). For example, if an individual's variant is associated with Type I Ehlers-Danlos syndrome, a valid response from SNOMED CT would be 'Ehlers-Danlos syndrome, type 1 (code 83470009)'.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:predicted-phenotype.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact"
      },
      {
        "id" : "Observation.component:predicted-phenotype.code",
        "path" : "Observation.component.code",
        "short" : "81259-4",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "81259-4"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:predicted-phenotype.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Phenotype code, e.g. from SNOMED CT Clinical finding, ICD-10-CM chapters 1-18, or HPO",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "Multiple bindings accepted"
        }
      },
      {
        "id" : "Observation.component:mode-of-inheritance",
        "path" : "Observation.component",
        "sliceName" : "mode-of-inheritance",
        "short" : "Mode of Inheritance",
        "definition" : "The transmission pattern of the condition/phenotype in a pedigree. Values originally curated by GA4GH.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:mode-of-inheritance.extension:workflow-relatedArtifact",
        "path" : "Observation.component.extension",
        "sliceName" : "workflow-relatedArtifact"
      },
      {
        "id" : "Observation.component:mode-of-inheritance.code",
        "path" : "Observation.component.code",
        "short" : "condition-inheritance",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "condition-inheritance"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:mode-of-inheritance.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Autosomal dominant | Autosomal recessive | X-linked | ... (more)",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/condition-inheritance-mode-vs"
        }
      }
    ]
  }
}

```
