# tumorSpecimen - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **tumorSpecimen**

## Example Specimen: tumorSpecimen

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**identifier**: `http://example.org/identifiers/specimens`/222333

**status**: Available

**type**: Specimen from lung obtained by biopsy (specimen)

**subject**: [Hamsburg, Substance Jr](Patient-somaticPatient.md)

**receivedTime**: 2023-01-23 01:01:01+0000

> **collection****collected**: 2023-01-01 01:01:00+0000**method**:Biopsy - action

### BodySites

| | |
| :--- | :--- |
| - | **Concept** |
| * | Right lung structure (body structure) |


**note**: 

> 

Tumor: 20%




## Resource Content

```json
{
  "resourceType" : "Specimen",
  "id" : "tumorSpecimen",
  "identifier" : [
    {
      "system" : "http://example.org/identifiers/specimens",
      "value" : "222333"
    }
  ],
  "status" : "available",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "122610009",
        "display" : "Specimen from lung obtained by biopsy (specimen)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/somaticPatient",
    "display" : "Hamsburg, Substance Jr"
  },
  "receivedTime" : "2023-01-23T01:01:01Z",
  "collection" : {
    "collectedDateTime" : "2023-01-01T01:01:00Z",
    "method" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "129314006",
          "display" : "Biopsy - action"
        }
      ]
    },
    "bodySite" : {
      "concept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "3341006",
            "display" : "Right lung structure (body structure)"
          }
        ]
      }
    }
  },
  "note" : [
    {
      "text" : "Tumor: 20%"
    }
  ]
}

```
