# specimen-hla-r4 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **specimen-hla-r4**

## Example Specimen: specimen-hla-r4

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**identifier**: `http://example.org`/001^123456789

**type**: Buccal smear sample

**subject**: de-identified patient

**receivedTime**: 2018-05-01

> **collection****method**:Taking oral swab (procedure)

### BodySites

| | |
| :--- | :--- |
| - | **Concept** |
| * | Buccal space |




## Resource Content

```json
{
  "resourceType" : "Specimen",
  "id" : "specimen-hla-r4",
  "identifier" : [
    {
      "system" : "http://example.org",
      "value" : "001^123456789"
    }
  ],
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "258564008",
        "display" : "Buccal smear sample"
      }
    ]
  },
  "subject" : {
    "display" : "de-identified patient"
  },
  "receivedTime" : "2018-05-01",
  "collection" : {
    "method" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "418622002",
          "display" : "Taking oral swab (procedure)"
        }
      ]
    },
    "bodySite" : {
      "concept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "261063000",
            "display" : "Buccal space"
          }
        ]
      }
    }
  }
}

```
