# servicerequest-hla-a-r4 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **servicerequest-hla-a-r4**

## Example ServiceRequest: servicerequest-hla-a-r4

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**identifier**: `http://example.org/donor-registry`/1234.5678

**status**: Completed

**intent**: Order

**category**: Laboratory procedure

**priority**: Routine

### Codes

| | |
| :--- | :--- |
| - | **Concept** |
| * | HLA-A [Type] |

**subject**: Identifier: 001^24680

**requester**: aDonorRegistry

**performer**: aTypingLab, Inc

**specimen**: buccal swab: 123456789



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "servicerequest-hla-a-r4",
  "identifier" : [
    {
      "system" : "http://example.org/donor-registry",
      "value" : "1234.5678"
    }
  ],
  "status" : "completed",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "108252007",
          "display" : "Laboratory procedure"
        }
      ]
    }
  ],
  "priority" : "routine",
  "code" : {
    "concept" : {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "13298-5",
          "display" : "HLA-A [Type]"
        }
      ]
    }
  },
  "subject" : {
    "identifier" : {
      "value" : "001^24680"
    }
  },
  "requester" : {
    "type" : "Organization",
    "display" : "aDonorRegistry"
  },
  "performer" : [
    {
      "type" : "Organization",
      "display" : "aTypingLab, Inc"
    }
  ],
  "specimen" : [
    {
      "type" : "Specimen",
      "display" : "buccal swab: 123456789"
    }
  ]
}

```
