# genomicServiceRequest - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **genomicServiceRequest**

## Example ServiceRequest: genomicServiceRequest

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**identifier**: Laboratory Accession ID/111111112

**status**: Active

**intent**: Plan

### Codes

| | |
| :--- | :--- |
| - | **Concept** |
| * | Molecular genetic test (procedure) |

**subject**: [John Junior Doe (official) Unknown, DoB: 2001-01-01 ( Medical record number: 11117 (use: temp, period: 2021-01-01 --> (ongoing)))](Patient-genomicPatient.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "genomicServiceRequest",
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "LACSN"
          }
        ],
        "text" : "Laboratory Accession ID"
      },
      "system" : "http://example.org/identifiers/serviceRequests",
      "value" : "111111112"
    }
  ],
  "status" : "active",
  "intent" : "plan",
  "code" : {
    "concept" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "405825005",
          "display" : "Molecular genetic test (procedure)"
        }
      ]
    }
  },
  "subject" : {
    "reference" : "Patient/genomicPatient"
  }
}

```
