# eMERGEServiceRequest - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **eMERGEServiceRequest**

## Example ServiceRequest: eMERGEServiceRequest

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**status**: Completed

**intent**: Order

### Codes

| | |
| :--- | :--- |
| - | **Concept** |
| * | emerge-seq-ngs-pnl |

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**specimen**: [Specimen: status = available; type = Tissue](Specimen-GenomicSpecimenExample01.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "eMERGEServiceRequest",
  "status" : "completed",
  "intent" : "order",
  "code" : {
    "concept" : {
      "coding" : [
        {
          "system" : "http://example.org/hgsc.bcm.edu/lab-test-codes/",
          "code" : "emerge-seq-ngs-pnl"
        }
      ]
    }
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "specimen" : [
    {
      "reference" : "Specimen/GenomicSpecimenExample01"
    }
  ]
}

```
