# GenomicServiceRequestExample01 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **GenomicServiceRequestExample01**

## Example ServiceRequest: GenomicServiceRequestExample01

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**status**: Completed

**intent**: Order

### Codes

| | |
| :--- | :--- |
| - | **Concept** |
| * | G6PD gene full mutation analysis in Blood or Tissue by Sequencing |

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**specimen**: [Specimen: status = available; type = Tissue](Specimen-GenomicSpecimenExample01.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "GenomicServiceRequestExample01",
  "status" : "completed",
  "intent" : "order",
  "code" : {
    "concept" : {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "94231-8",
          "display" : "G6PD gene full mutation analysis in Blood or Tissue by Sequencing"
        }
      ]
    }
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "specimen" : [
    {
      "reference" : "Specimen/GenomicSpecimenExample01"
    }
  ]
}

```
