# ExampleServiceRequest - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **ExampleServiceRequest**

## Example ServiceRequest: ExampleServiceRequest

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**status**: Active

**intent**: Original Order

### Codes

| | |
| :--- | :--- |
| - | **Concept** |
| * | Genetic analysis report |

**subject**: [Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Worried about family planning |



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "ExampleServiceRequest",
  "status" : "active",
  "intent" : "original-order",
  "code" : {
    "concept" : {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "51969-4",
          "display" : "Genetic analysis report"
        }
      ]
    }
  },
  "subject" : {
    "reference" : "Patient/ExamplePatient"
  },
  "reason" : [
    {
      "concept" : {
        "text" : "Worried about family planning"
      }
    }
  ]
}

```
