# GenRiskDiabetesT2 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **GenRiskDiabetesT2**

## Example RiskAssessment: GenRiskDiabetesT2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**parent**: [Observation Diagnostic Implication](Observation-PolyGenicDiagnosticImpExample.md)

**status**: Final

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**basis**: 

* Variant 1 (Identifier: `http://hospital.example.org`/11)
* Variant 2 (Identifier: `http://hospital.example.org`/12)
* Variant 3 (Identifier: `http://hospital.example.org`/13)
* Variant 4 (Identifier: `http://hospital.example.org`/14)
* Variant 5 (Identifier: `http://hospital.example.org`/15)
* Variant 6 (Identifier: `http://hospital.example.org`/16)
* Variant 7 (Identifier: `http://hospital.example.org`/17)

> **prediction****outcome**:Diabetes mellitus type 2 (disorder)**probability**: 0.26**qualitativeRisk**:Low likelihood**relativeRisk**: 1.05**when**: ?-53

> **prediction****outcome**:Diabetes mellitus type 2 (disorder)**probability**: 0.7**qualitativeRisk**:High likelihood**relativeRisk**: 2.69**when**: ?-65



## Resource Content

```json
{
  "resourceType" : "RiskAssessment",
  "id" : "GenRiskDiabetesT2",
  "parent" : {
    "reference" : "Observation/PolyGenicDiagnosticImpExample"
  },
  "status" : "final",
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "basis" : [
    {
      "identifier" : {
        "system" : "http://hospital.example.org",
        "value" : "11"
      },
      "display" : "Variant 1"
    },
    {
      "identifier" : {
        "system" : "http://hospital.example.org",
        "value" : "12"
      },
      "display" : "Variant 2"
    },
    {
      "identifier" : {
        "system" : "http://hospital.example.org",
        "value" : "13"
      },
      "display" : "Variant 3"
    },
    {
      "identifier" : {
        "system" : "http://hospital.example.org",
        "value" : "14"
      },
      "display" : "Variant 4"
    },
    {
      "identifier" : {
        "system" : "http://hospital.example.org",
        "value" : "15"
      },
      "display" : "Variant 5"
    },
    {
      "identifier" : {
        "system" : "http://hospital.example.org",
        "value" : "16"
      },
      "display" : "Variant 6"
    },
    {
      "identifier" : {
        "system" : "http://hospital.example.org",
        "value" : "17"
      },
      "display" : "Variant 7"
    }
  ],
  "prediction" : [
    {
      "outcome" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "44054006",
            "display" : "Diabetes mellitus type 2 (disorder)"
          }
        ]
      },
      "probabilityDecimal" : 0.26,
      "qualitativeRisk" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/risk-probability",
            "code" : "low",
            "display" : "Low likelihood"
          }
        ]
      },
      "relativeRisk" : 1.05,
      "whenRange" : {
        "high" : {
          "value" : 53,
          "unit" : "years",
          "system" : "http://unitsofmeasure.org",
          "code" : "a"
        }
      }
    },
    {
      "outcome" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "44054006",
            "display" : "Diabetes mellitus type 2 (disorder)"
          }
        ]
      },
      "probabilityDecimal" : 0.7,
      "qualitativeRisk" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/risk-probability",
            "code" : "high",
            "display" : "High likelihood"
          }
        ]
      },
      "relativeRisk" : 2.69,
      "whenRange" : {
        "high" : {
          "value" : 65,
          "unit" : "years",
          "system" : "http://unitsofmeasure.org",
          "code" : "a"
        }
      }
    }
  ]
}

```
