# somaticPatient - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **somaticPatient**

## Example Patient: somaticPatient

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Substance Junior Hamsburg (official) Male, DoB: 1987-09-01 ( Medical record number: 1234567 (use: temp, period: 2021-01-01 --> (ongoing)))

-------

| | |
| :--- | :--- |
| Active: | true |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "somaticPatient",
  "identifier" : [
    {
      "use" : "temp",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical record number"
          }
        ]
      },
      "system" : "http://example.org/identifiers/persons",
      "value" : "1234567",
      "period" : {
        "start" : "2021-01-01"
      },
      "assigner" : {
        "display" : "General Hospital"
      }
    }
  ],
  "active" : true,
  "name" : [
    {
      "use" : "official",
      "family" : "Hamsburg",
      "given" : ["Substance", "Junior"]
    }
  ],
  "gender" : "male",
  "birthDate" : "1987-09-01"
}

```
