# genomicPatient - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **genomicPatient**

## Example Patient: genomicPatient

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

John Junior Doe (official) Unknown, DoB: 2001-01-01 ( Medical record number: 11117 (use: temp, period: 2021-01-01 --> (ongoing)))

-------

| | |
| :--- | :--- |
| Active: | true |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "genomicPatient",
  "identifier" : [
    {
      "use" : "temp",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical record number"
          }
        ]
      },
      "system" : "http://example.org/identifiers/persons",
      "value" : "11117",
      "period" : {
        "start" : "2021-01-01"
      },
      "assigner" : {
        "display" : "General Hospital"
      }
    }
  ],
  "active" : true,
  "name" : [
    {
      "use" : "official",
      "family" : "Doe",
      "given" : ["John", "Junior"]
    }
  ],
  "gender" : "unknown",
  "birthDate" : "2001-01-01"
}

```
