# CGPatientExample01 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **CGPatientExample01**

## Example Patient: CGPatientExample01

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))

-------

| | |
| :--- | :--- |
| Contact Detail | 123 Main St Anytown 12345 US |
| Contact: | * ph: 555-555-5555(Home)
* [adam.everyman@example.com](mailto:adam.everyman@example.com)
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "CGPatientExample01",
  "identifier" : [
    {
      "use" : "usual",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ]
      },
      "system" : "http://hospital.example.org",
      "value" : "m123"
    }
  ],
  "name" : [
    {
      "family" : "Everyman",
      "given" : ["Adam", "B."]
    }
  ],
  "gender" : "male",
  "birthDate" : "1951-01-20",
  "address" : [
    {
      "line" : ["123 Main St"],
      "city" : "Anytown",
      "postalCode" : "12345",
      "country" : "US"
    }
  ],
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "phone",
          "value" : "555-555-5555",
          "use" : "home"
        },
        {
          "system" : "email",
          "value" : "adam.everyman@example.com"
        }
      ]
    }
  ]
}

```
