# FindSubjectSpecificVariantsOutput - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **FindSubjectSpecificVariantsOutput**

## Example Parameters: FindSubjectSpecificVariantsOutput

## Parameters



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "FindSubjectSpecificVariantsOutput",
  "parameter" : [
    {
      "name" : "variants",
      "part" : [
        {
          "name" : "variantItem",
          "valueString" : "NM_001354609.2:c.1799T>A"
        },
        {
          "name" : "presence",
          "valueBoolean" : false
        }
      ]
    },
    {
      "name" : "variants",
      "part" : [
        {
          "name" : "variantItem",
          "valueString" : "NM_007294.4:c.5559C>A"
        },
        {
          "name" : "presence",
          "valueBoolean" : false
        }
      ]
    },
    {
      "name" : "variants",
      "part" : [
        {
          "name" : "variantItem",
          "valueString" : "NM_001354609.2:c.1802="
        },
        {
          "name" : "presence",
          "valueBoolean" : false
        }
      ]
    },
    {
      "name" : "variants",
      "part" : [
        {
          "name" : "variantItem",
          "valueString" : "NC_000001.10:g.12225351T>A"
        },
        {
          "name" : "presence",
          "valueBoolean" : false
        }
      ]
    },
    {
      "name" : "variants",
      "part" : [
        {
          "name" : "variantItem",
          "valueString" : "NM_000038.6:c.55G>T"
        },
        {
          "name" : "presence",
          "valueBoolean" : true
        },
        {
          "name" : "variant",
          "resource" : {
            "resourceType" : "Observation",
            "id" : "dv-5a7f781e83514",
            "meta" : {
              "profile" : [
                "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Variant</div>"
            },
            "status" : "final",
            "category" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                    "code" : "laboratory"
                  }
                ]
              },
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                    "code" : "GE"
                  }
                ]
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69548-6",
                  "display" : "Genetic variant assessment"
                }
              ]
            },
            "subject" : {
              "reference" : "Patient/HG00403"
            },
            "effectiveDateTime" : "2023-07-01",
            "performer" : [
              {
                "reference" : "Organization/ExampleOrg"
              }
            ],
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA9633-4",
                  "display" : "Present"
                }
              ]
            },
            "component" : [
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "48002-0",
                      "display" : "Genomic source class [Type]"
                    }
                  ]
                },
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "LA6683-2",
                      "display" : "Germline"
                    }
                  ]
                }
              },
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "48013-7",
                      "display" : "Genomic reference sequence ID"
                    }
                  ]
                },
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                      "code" : "NC_000005.9"
                    }
                  ]
                }
              },
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "53034-5",
                      "display" : "Allelic state"
                    }
                  ]
                },
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "LA6706-1",
                      "display" : "heterozygous"
                    }
                  ]
                }
              },
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "69547-8",
                      "display" : "Genomic Ref allele [ID]"
                    }
                  ]
                },
                "valueString" : "G"
              },
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "69551-0",
                      "display" : "Genomic Alt allele [ID]"
                    }
                  ]
                },
                "valueString" : "T"
              },
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "92822-6",
                      "display" : "Genomic coord system"
                    }
                  ]
                },
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "LA30100-4",
                      "display" : "0-based interval counting"
                    }
                  ]
                }
              },
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "81254-5"
                    }
                  ],
                  "text" : "Genomic allele start-end"
                },
                "valueRange" : {
                  "low" : {
                    "value" : 112090641
                  }
                }
              }
            ]
          }
        }
      ]
    }
  ]
}

```
