# FindSubjectSpecificHaplotypesOutput - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **FindSubjectSpecificHaplotypesOutput**

## Example Parameters: FindSubjectSpecificHaplotypesOutput

## Parameters



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "FindSubjectSpecificHaplotypesOutput",
  "parameter" : [
    {
      "name" : "haplotypes",
      "part" : [
        {
          "name" : "haplotypeItem",
          "valueString" : "HLA-A*23"
        },
        {
          "name" : "presence",
          "valueBoolean" : true
        },
        {
          "name" : "genotype",
          "resource" : {
            "resourceType" : "Observation",
            "id" : "Genotype7",
            "meta" : {
              "profile" : [
                "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Genotype</div>"
            },
            "status" : "final",
            "category" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                    "code" : "laboratory"
                  }
                ]
              },
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                    "code" : "GE"
                  }
                ]
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "84413-4",
                  "display" : "Genotype display name"
                }
              ]
            },
            "subject" : {
              "reference" : "Patient/CGPatientExample01"
            },
            "effectiveDateTime" : "2023-07-01",
            "performer" : [
              {
                "reference" : "Organization/ExampleOrg"
              }
            ],
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://glstring.org",
                  "version" : "1.0",
                  "code" : "hla#3.33.0#HLA-A*02:69+HLA-A*23:30|HLA-A*02:302+HLA-A*23:26/HLA-A*23:39",
                  "display" : "hla#3.33.0#HLA-A*02:69+HLA-A*23:30|HLA-A*02:302+HLA-A*23:26/HLA-A*23:39"
                }
              ]
            },
            "specimen" : {
              "reference" : "Specimen/GenomicSpecimenExample01"
            },
            "component" : [
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "48018-6",
                      "display" : "Gene studied [ID]"
                    }
                  ]
                },
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://www.genenames.org",
                      "code" : "HGNC:4931",
                      "display" : "HLA-A"
                    }
                  ]
                }
              }
            ]
          }
        }
      ]
    }
  ]
}

```
