# FindSubjectHaplotypesOutput - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **FindSubjectHaplotypesOutput**

## Example Parameters: FindSubjectHaplotypesOutput

## Parameters



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "FindSubjectHaplotypesOutput",
  "parameter" : [
    {
      "name" : "haplotypes",
      "part" : [
        {
          "name" : "geneItem",
          "valueString" : "http://www.genenames.org|HGNC:2625"
        },
        {
          "name" : "genotype",
          "resource" : {
            "resourceType" : "Observation",
            "id" : "GenotypeCYP2D6",
            "meta" : {
              "profile" : [
                "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Genotype</div>"
            },
            "status" : "final",
            "category" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                    "code" : "laboratory"
                  }
                ]
              },
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                    "code" : "GE"
                  }
                ]
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "84413-4",
                  "display" : "Genotype display name"
                }
              ]
            },
            "subject" : {
              "reference" : "Patient/CGPatientExample01"
            },
            "effectiveDateTime" : "2023-07-01",
            "performer" : [
              {
                "reference" : "Organization/ExampleOrg"
              }
            ],
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.pharmvar.org",
                  "code" : "CYP2D6_*1/*1",
                  "display" : "CYP2D6 *1/*1"
                }
              ]
            },
            "specimen" : {
              "reference" : "Specimen/GenomicSpecimenExample01"
            },
            "component" : [
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "48018-6",
                      "display" : "Gene studied [ID]"
                    }
                  ]
                },
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://www.genenames.org",
                      "code" : "HGNC:2625",
                      "display" : "CYP2D6"
                    }
                  ]
                }
              }
            ]
          }
        }
      ]
    },
    {
      "name" : "haplotypes",
      "part" : [
        {
          "name" : "geneItem",
          "valueString" : "http://www.genenames.org|HGNC:2621"
        },
        {
          "name" : "genotype",
          "resource" : {
            "resourceType" : "Observation",
            "id" : "GenotypeCYP2C19",
            "meta" : {
              "profile" : [
                "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Genotype</div>"
            },
            "status" : "final",
            "category" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                    "code" : "laboratory"
                  }
                ]
              },
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                    "code" : "GE"
                  }
                ]
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "84413-4",
                  "display" : "Genotype display name"
                }
              ]
            },
            "subject" : {
              "reference" : "Patient/CGPatientExample01"
            },
            "effectiveDateTime" : "2023-07-01",
            "performer" : [
              {
                "reference" : "Organization/ExampleOrg"
              }
            ],
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.pharmvar.org",
                  "code" : "CYP2C19_*1/*2",
                  "display" : "CYP2C19 *1/*2"
                }
              ]
            },
            "specimen" : {
              "reference" : "Specimen/GenomicSpecimenExample01"
            },
            "component" : [
              {
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "48018-6",
                      "display" : "Gene studied [ID]"
                    }
                  ]
                },
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://www.genenames.org",
                      "code" : "HGNC:2621",
                      "display" : "CYP2C19"
                    }
                  ]
                }
              }
            ]
          }
        }
      ]
    }
  ]
}

```
