# Find Subject Specific Haplotypes - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Find Subject Specific Haplotypes**

## OperationDefinition: Find Subject Specific Haplotypes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-subject-specific-haplotypes | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:FindSubjectSpecificHaplotypes |

 
See if specified haplotypes/genotypes are present. 

### Description

See if specified haplotypes/genotypes are present.

### Parameters

* **Use**: IN
  * **Name**: subject
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([reference](https://hl7.org/fhir/R5/search.html#reference))
  * **Binding**: 
  * **Documentation**: The subject of interest.
* **Use**: IN
  * **Name**: haplotypes
  * **Scope**: 
  * **Cardinality**: 1..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: List of haplotypes and/or genotypes being sought. Must be in token or codesystem|code format.
* **Use**: IN
  * **Name**: testIdentifiers
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Supply a list of test identifiers. Only results originating from one of these tests will be returned.
* **Use**: IN
  * **Name**: testDateRange
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [Period](http://hl7.org/fhir/R5/datatypes.html#Period)
  * **Binding**: 
  * **Documentation**: Supply a date range. Only results generated during this range will be returned.
* **Use**: IN
  * **Name**: specimenIdentifiers
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Supply a list of specimen identifiers. Only results derived from one of these specimens will be returned.
* **Use**: IN
  * **Name**: genomicSourceClass
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include haplotypes irrespective of genomic source class.
* **Use**: OUT
  * **Name**: haplotypes
  * **Scope**: 
  * **Cardinality**: 1..*
  * **Type**: 
  * **Binding**: 
  * **Documentation**: (one for each haplotype in haplotypeList)
* **Use**: OUT
  * **Name**: haplotypes.haplotypeItem
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: haplotype/genotype from haplotypeList
* **Use**: OUT
  * **Name**: haplotypes.presence
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [boolean](http://hl7.org/fhir/R5/datatypes.html#boolean)
  * **Binding**: 
  * **Documentation**: 
* **Use**: OUT
  * **Name**: haplotypes.haplotype
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [Observation](http://hl7.org/fhir/R5/observation.html)
  * **Binding**: 
  * **Documentation**: Haplotypes must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype].
* **Use**: OUT
  * **Name**: haplotypes.genotype
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [Observation](http://hl7.org/fhir/R5/observation.html)
  * **Binding**: 
  * **Documentation**: Genotypes must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype].

### Notes:

#### Error Codes

Valid response codes are shown in the following table. Additional response codes (e.g. 5xx server error) may also be encountered.

| | |
| :--- | :--- |
| 200 | Successfully executed request |
| 400 | ERROR: Invalid query parameters |
| 404 | ERROR: Patient not found |
| 422 | ERROR: Failed[LiftOver](operations.md#liftover) |

#### Examples

Are any of these haplotypes present [CYP2D6 **1/**5; CYP2D6 **1/**15; CYP2C19 **1/**2]?

```
$find-subject-specific-haplotypes?subject=HG00403&haplotypes=CYP2D6 *1/*5,CYP2D6 *1/*15,CYP2C19 *1/*2

```

Is haplotype [HLA-A**02:302+HLA-A**23:26/HLA-A**23:39^HLA-B**44:02:13+HLA-B*49:08] present?

```
$find-subject-specific-haplotypes?subject=HG00403&haplotypes=http://glstring.org|hla#3.33.0#HLA-A*02:302+HLA-A*23:26/HLA-A*23:39^HLA-B*44:02:13+HLA-B*49:08

```

Patient HG00403 underwent HLA typing, and clinician wants to know if there is any haplotype or genotype indication that HLA-A*23 is present.

```

GET .../$find-subject-specific-haplotypes?subject=HG00403&haplotypes=HLA-A*23

```

See [example output](Parameters-FindSubjectSpecificHaplotypesOutput.md).



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "find-subject-specific-haplotypes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-subject-specific-haplotypes",
  "version" : "4.0.0-ballot",
  "name" : "FindSubjectSpecificHaplotypes",
  "title" : "Find Subject Specific Haplotypes",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "See if specified haplotypes/genotypes are present.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "code" : "match",
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "subject",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The subject of interest.",
      "type" : "string",
      "searchType" : "reference"
    },
    {
      "name" : "haplotypes",
      "use" : "in",
      "min" : 1,
      "max" : "*",
      "documentation" : "List of haplotypes and/or genotypes being sought. Must be in token or codesystem|code format.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "testIdentifiers",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "Supply a list of test identifiers. Only results originating from one of these tests will be returned.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "testDateRange",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Supply a date range. Only results generated during this range will be returned.",
      "type" : "Period"
    },
    {
      "name" : "specimenIdentifiers",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "Supply a list of specimen identifiers. Only results derived from one of these specimens will be returned.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "genomicSourceClass",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include haplotypes irrespective of genomic source class.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "haplotypes",
      "use" : "out",
      "min" : 1,
      "max" : "*",
      "documentation" : "(one for each haplotype in haplotypeList)",
      "part" : [
        {
          "name" : "haplotypeItem",
          "use" : "out",
          "min" : 1,
          "max" : "1",
          "documentation" : "haplotype/genotype from haplotypeList",
          "type" : "string"
        },
        {
          "name" : "presence",
          "use" : "out",
          "min" : 1,
          "max" : "1",
          "type" : "boolean"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/operationdefinition-profile",
              "valueUri" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
            }
          ],
          "name" : "haplotype",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "documentation" : "Haplotypes must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype].",
          "type" : "Observation"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/operationdefinition-profile",
              "valueUri" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
            }
          ],
          "name" : "genotype",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "documentation" : "Genotypes must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype].",
          "type" : "Observation"
        }
      ]
    }
  ]
}

```
