# Find Subject Haplotypes - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Find Subject Haplotypes**

## OperationDefinition: Find Subject Haplotypes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-subject-haplotypes | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:FindSubjectHaplotypes |

 
Retrieve haplotypes/genotypes for specified genes. 

### Description

Retrieve haplotypes/genotypes of specified genes.

**Note to implementers**: The committee is actively seeking feedback on the need to extend this operation to also support searching by region (e.g. to retrieve intergenic haplotypes).

### Parameters

* **Use**: IN
  * **Name**: subject
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([reference](https://hl7.org/fhir/R5/search.html#reference))
  * **Binding**: 
  * **Documentation**: The subject of interest.
* **Use**: IN
  * **Name**: genes
  * **Scope**: 
  * **Cardinality**: 1..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: List of genes to be searched. Must be in token or codesystem|code format.
* **Use**: IN
  * **Name**: testIdentifiers
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Supply a list of test identifiers. Only results originating from one of these tests will be returned.
* **Use**: IN
  * **Name**: testDateRange
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [Period](http://hl7.org/fhir/R5/datatypes.html#Period)
  * **Binding**: 
  * **Documentation**: Supply a date range. Only results generated during this range will be returned.
* **Use**: IN
  * **Name**: specimenIdentifiers
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Supply a list of specimen identifiers. Only results derived from one of these specimens will be returned.
* **Use**: IN
  * **Name**: genomicSourceClass
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include haplotypes irrespective of genomic source class.
* **Use**: OUT
  * **Name**: haplotypes
  * **Scope**: 
  * **Cardinality**: 1..*
  * **Type**: 
  * **Binding**: 
  * **Documentation**: (one for each gene in geneList)
* **Use**: OUT
  * **Name**: haplotypes.geneItem
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: gene from geneList
* **Use**: OUT
  * **Name**: haplotypes.haplotype
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [Observation](http://hl7.org/fhir/R5/observation.html)
  * **Binding**: 
  * **Documentation**: Haplotypes must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype].
* **Use**: OUT
  * **Name**: haplotypes.genotype
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [Observation](http://hl7.org/fhir/R5/observation.html)
  * **Binding**: 
  * **Documentation**: Genotypes must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype].

### Notes:

#### Error Codes

Valid response codes are shown in the following table. Additional response codes (e.g. 5xx server error) may also be encountered.

| | |
| :--- | :--- |
| 200 | Successfully executed request |
| 400 | ERROR: Invalid query parameters |
| 404 | ERROR: Patient not found |
| 422 | ERROR: Failed[LiftOver](operations.md#liftover) |

#### Examples

CYP2D6 haplotypes?

```
$find-subject-haplotypes?subject=HG00403&genes=http://www.genenames.org|HGNC:2625

```

Haplotypes that include HLA-A or HLA-B?

```
$find-subject-haplotypes?subject=HG00403&genes=http://www.genenames.org|HGNC:4931,http://www.genenames.org|HGNC:4932

```

Patient HG00403 underwent preemptive pharmacogenomic testing. Clinician now wants to prescribe amitriptyline, but first wants to see CYP2D6 and CYP2C19 star alleles.

```

GET .../$find-subject-haplotypes?subject=HG00403&genes=http://www.genenames.org|HGNC:2625,http://www.genenames.org|HGNC:2621

```

See [example output](Parameters-FindSubjectHaplotypesOutput.md).



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "find-subject-haplotypes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-subject-haplotypes",
  "version" : "4.0.0-ballot",
  "name" : "FindSubjectHaplotypes",
  "title" : "Find Subject Haplotypes",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Retrieve haplotypes/genotypes for specified genes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "code" : "match",
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "subject",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The subject of interest.",
      "type" : "string",
      "searchType" : "reference"
    },
    {
      "name" : "genes",
      "use" : "in",
      "min" : 1,
      "max" : "*",
      "documentation" : "List of genes to be searched. Must be in token or codesystem|code format.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "testIdentifiers",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "Supply a list of test identifiers. Only results originating from one of these tests will be returned.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "testDateRange",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Supply a date range. Only results generated during this range will be returned.",
      "type" : "Period"
    },
    {
      "name" : "specimenIdentifiers",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "Supply a list of specimen identifiers. Only results derived from one of these specimens will be returned.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "genomicSourceClass",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include haplotypes irrespective of genomic source class.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "haplotypes",
      "use" : "out",
      "min" : 1,
      "max" : "*",
      "documentation" : "(one for each gene in geneList)",
      "part" : [
        {
          "name" : "geneItem",
          "use" : "out",
          "min" : 1,
          "max" : "1",
          "documentation" : "gene from geneList",
          "type" : "string"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/operationdefinition-profile",
              "valueUri" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
            }
          ],
          "name" : "haplotype",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "documentation" : "Haplotypes must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype].",
          "type" : "Observation"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/operationdefinition-profile",
              "valueUri" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
            }
          ],
          "name" : "genotype",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "documentation" : "Genotypes must conform to [Profile: http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype].",
          "type" : "Observation"
        }
      ]
    }
  ]
}

```
