# Find Study Metadata - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Find Study Metadata**

## OperationDefinition: Find Study Metadata 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-study-metadata | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:FindStudyMetadata |

 
Retrieve metadata about sequencing studies performed on a subject. 

### Description

Retrieve metadata about sequencing studies performed on a subject.

> **STU Note:**The Clinical Genomics committee is reviewing[Jira 35864: Add study-level metadata capabilities into the FHIR Genomics IG](https://jira.hl7.org/browse/FHIR-35864). It is expected that the response of this operation will be revised in the future, to align with the Jira resolution.

**Test Id** and **test date** are always returned. Additional metadata is server dependent, and specific implementations can indicate their capabilities using a [FHIR Capability Statement](https://www.hl7.org/fhir/capabilitystatement.html). Frequently useful metadata includes **Specimen Id** and **Genomic build** (reference sequence assembly upon which variants were called, e.g. 'GRCh37', 'GRCh38'). Additionally, it can be useful to indicate the **DNA change types** or types of variants detectable by the test (e.g. 'SNV', 'InDel', 'CNV'). Servers can choose to return additional metadata.

As described in [general guidance](operations.md#query-filters), metadata can be used to filter the results of other operations.

In some scenarios, users need to know whether or not a particular genomic region was studied by a given test (**studied region**), and whether or not there are uncallable subregions within regions studied (**uncallable regions**). Genomic sequencing tests are designed to study specific portions of a person's genome. For instance, whole genome sequencing (WGS) tests are designed to study the entire genome; whole exome sequencing (WES) tests are designed to study protein-coding exons; targeted sequencing tests are designed to only study selected regions of the genome. In many cases, while a particular region was targeted to be studied by a given test, a portion of the region might be untestable, due to patient-specific factors, reagent-specific factors, etc. Whereas labs report variants found to be present, labs cannot enumerate every variant found to be absent - when you consider that a person has 4 billion base pairs, 99% of which are the same as a reference sequence, you can imagine how big a report would need to be to enumerate every variant found to be absent! Rather, absence of a variant at a particular position can potentially be inferred by knowing the region studied, and whether or not there were uncallable subregions within the studied region.

Users can request this level of detail by including the **ranges** parameter, in which case each returned test will include **intersecting** studied and uncallable regions. Studied and uncallable regions can be voluminous - data can be curtailed by specifying appropriately narrow ranges. Range data is returned as a list of non-overlapping regions, each in zero-based RefSeq:Integer-range format (e.g. "['NC_000007.14:55173910-55174053', 'NC_000007.14:55174711-55174830', 'NC_000007.14:55181282-55181488']").

### Parameters

* **Use**: IN
  * **Name**: subject
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([reference](https://hl7.org/fhir/R5/search.html#reference))
  * **Binding**: 
  * **Documentation**: The subject of interest.
* **Use**: IN
  * **Name**: testIdentifiers
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: List of test identifiers. Metadata for each test is returned.
* **Use**: IN
  * **Name**: testDateRange
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [Period](http://hl7.org/fhir/R5/datatypes.html#Period)
  * **Binding**: 
  * **Documentation**: Metadata for each test performed during the range is returned.
* **Use**: IN
  * **Name**: specimenIdentifiers
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: List of specimen identifiers. Metadata for each test based on a supplied specimen identifier is returned.
* **Use**: IN
  * **Name**: ranges
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([special](https://hl7.org/fhir/R5/search.html#special))
  * **Binding**: 
  * **Documentation**: List of regions for which additional study information is sought. If ranges are supplied, then each returned test will include studied and uncallable regions. Must be in zero-based RefSeq:Integer-range format (e.g. 'NC_000007.14:55174721-55174820').
* **Use**: OUT
  * **Name**: tests
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: 
  * **Binding**: 
  * **Documentation**: 
* **Use**: OUT
  * **Name**: tests.testId
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: test identifier
* **Use**: OUT
  * **Name**: tests.testDate
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [dateTime](http://hl7.org/fhir/R5/datatypes.html#dateTime)
  * **Binding**: 
  * **Documentation**: test date
* **Use**: OUT
  * **Name**: tests.specimenId
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: specimen identifier
* **Use**: OUT
  * **Name**: tests.genomicBuild
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [CodeableConcept](http://hl7.org/fhir/R5/datatypes.html#CodeableConcept)
  * **Binding**: 
  * **Documentation**: preferred codes: https://loinc.org/LL1040-6/
* **Use**: OUT
  * **Name**: tests.dnaChangeType
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [CodeableConcept](http://hl7.org/fhir/R5/datatypes.html#CodeableConcept)
  * **Binding**: 
  * **Documentation**: preferred codes: http://www.sequenceontology.org/browser/current_release/term/SO:0002072
* **Use**: OUT
  * **Name**: tests.regionStudied
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: List of non-overlapping regions, each in zero-based RefSeq:Integer-range format; or 'unknown'
* **Use**: OUT
  * **Name**: tests.uncallableRegions
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: List of non-overlapping regions, each in zero-based RefSeq:Integer-range format; or 'unknown'

### Notes:

#### Error Codes

Valid response codes are shown in the following table. Additional response codes (e.g. 5xx server error) may also be encountered.

| | |
| :--- | :--- |
| 200 | Successfully executed request |
| 400 | ERROR: Invalid query parameters |
| 404 | ERROR: Patient not found |
| 422 | ERROR: Failed[LiftOver](operations.md#liftover) |

#### Examples

March 2019, patient HG00403 is found to have lung mass on CXR, and undergoes lung biopsy. WES of a 300 gene panel is performed on the biopsy specimen, and analyzed for simple variants (SNV, MNV, InDel). For technical reasons, PIK3CB was deemed uncallable.

July 2020, patient HG00403 presents with headache, and mass is found on head CT. Biopsy is consistent with metastatic lung cancer. WES of a 420 gene panel is performed on the biopsy specimen, and analyzed for simple variants (SNV, MNV, InDel) and for Copy Number Variants. For technical reasons, PIK3CB, APC, MEN1, and portions of EGFR were deemed uncallable.

To be eligible for a particular clinical trial, patients must have an EGFR exon 19 (NC_000007.14:55174721-55174820) deletion. Patient's oncologist finds no simple or structural variants in the region of EGFR exon 19, and asks staff bioinformaticist to confirm whether EGFR, including exon 19, was studied as part of the July 2020 test. (Results indicate that EGFR was studied, but exon 19 was deemed uncallable).

```

GET .../$find-study-metadata?subject=HG00403&testDateRange=ge2020-06-01&testDateRange=le2020-08-01&ranges=NC_000007.14:55019016-55211628

```

See [example output](Parameters-FindStudyMetadataOutput.md).



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "find-study-metadata",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-study-metadata",
  "version" : "4.0.0-ballot",
  "name" : "FindStudyMetadata",
  "title" : "Find Study Metadata",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Retrieve metadata about sequencing studies performed on a subject.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "code" : "match",
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "subject",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The subject of interest.",
      "type" : "string",
      "searchType" : "reference"
    },
    {
      "name" : "testIdentifiers",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "List of test identifiers. Metadata for each test is returned.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "testDateRange",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Metadata for each test performed during the range is returned.",
      "type" : "Period"
    },
    {
      "name" : "specimenIdentifiers",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "List of specimen identifiers. Metadata for each test based on a supplied specimen identifier is returned.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "ranges",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "List of regions for which additional study information is sought. If ranges are supplied, then each returned test will include studied and uncallable regions. Must be in zero-based RefSeq:Integer-range format (e.g. 'NC_000007.14:55174721-55174820').",
      "type" : "string",
      "searchType" : "special"
    },
    {
      "name" : "tests",
      "use" : "out",
      "min" : 0,
      "max" : "*",
      "part" : [
        {
          "name" : "testId",
          "use" : "out",
          "min" : 1,
          "max" : "1",
          "documentation" : "test identifier",
          "type" : "string"
        },
        {
          "name" : "testDate",
          "use" : "out",
          "min" : 1,
          "max" : "1",
          "documentation" : "test date",
          "type" : "dateTime"
        },
        {
          "name" : "specimenId",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "documentation" : "specimen identifier",
          "type" : "string"
        },
        {
          "name" : "genomicBuild",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "documentation" : "preferred codes: https://loinc.org/LL1040-6/",
          "type" : "CodeableConcept"
        },
        {
          "name" : "dnaChangeType",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "documentation" : "preferred codes: http://www.sequenceontology.org/browser/current_release/term/SO:0002072",
          "type" : "CodeableConcept"
        },
        {
          "name" : "regionStudied",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "documentation" : "List of non-overlapping regions, each in zero-based RefSeq:Integer-range format; or 'unknown'",
          "type" : "string"
        },
        {
          "name" : "uncallableRegions",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "documentation" : "List of non-overlapping regions, each in zero-based RefSeq:Integer-range format; or 'unknown'",
          "type" : "string"
        }
      ]
    }
  ]
}

```
