# Find Population Structural Subsuming Variants - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Find Population Structural Subsuming Variants**

## OperationDefinition: Find Population Structural Subsuming Variants 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-population-structural-subsuming-variants | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:FindPopulationStructuralSubsumingVariants |

 
Retrieve count or list of patients having structural subsuming variants in specified regions. 

### Description

Retrieve count or list of patients having structural subsuming variants in specified regions. (See section '[Genes vs. Regions](operations.md#genes-vs-regions)' for the distinction between variants that 'intersect' vs. 'subsume' a region).

A patient meets numerator criteria if they have at least one structural variant subsuming a given range.

Population queries are designed to return a **count** of patients that match each item sought, with or without a **list** of patients matching the item(s) sought.

### Parameters

* **Use**: IN
  * **Name**: ranges
  * **Scope**: 
  * **Cardinality**: 1..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([special](https://hl7.org/fhir/R5/search.html#special))
  * **Binding**: 
  * **Documentation**: List of regions to be searched for variants. Must be in zero-based RefSeq:Integer-range format (e.g. 'NC_000007.14:55174721-55174820').
* **Use**: IN
  * **Name**: genomicSourceClass
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include variants irrespective of genomic source class.
* **Use**: IN
  * **Name**: includePatientList
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [boolean](http://hl7.org/fhir/R5/datatypes.html#boolean)
  * **Binding**: 
  * **Documentation**: Include list of matching patients if set to true. Default=false.
* **Use**: OUT
  * **Name**: variants
  * **Scope**: 
  * **Cardinality**: 1..*
  * **Type**: 
  * **Binding**: 
  * **Documentation**: 
* **Use**: OUT
  * **Name**: variants.rangeItem
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: range from rangeList
* **Use**: OUT
  * **Name**: variants.numerator
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [Quantity](http://hl7.org/fhir/R5/datatypes.html#Quantity)
  * **Binding**: 
  * **Documentation**: Count of patients having this variant
* **Use**: OUT
  * **Name**: variants.denominator
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [Quantity](http://hl7.org/fhir/R5/datatypes.html#Quantity)
  * **Binding**: 
  * **Documentation**: Count of patients in the cohort searched
* **Use**: OUT
  * **Name**: variants.subject
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: Patient ID. Include if includePatientList=true

### Notes:

#### Error Codes

Valid response codes are shown in the following table. Additional response codes (e.g. 5xx server error) may also be encountered.

| | |
| :--- | :--- |
| 200 | Successfully executed request |
| 400 | ERROR: Invalid query parameters |
| 404 | ERROR: Patient not found |
| 422 | ERROR: Failed[LiftOver](operations.md#liftover) |

#### Examples

A pharmacogeneticist is studying the accuracy of CYP2D6*5 (whole gene deletion) calling, and wants to compare cases where a structural variant caller indicates a whole gene deletion of CYP2D6 (NC_000022.10:42522500-42526812) against a pipeline used to report pharmacogenes.

To begin the process, the pharmacogeneticist identifies all patients that have structural variants subsuming CYP2D6.

```

GET .../$find-population-structural-subsuming-variants?ranges=NC_000022.10:42522500-42526812&includePatientList=true

```

See [example output](Parameters-FindPopulationStructuralSubsumingVariantsOutput.md).



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "find-population-structural-subsuming-variants",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-population-structural-subsuming-variants",
  "version" : "4.0.0-ballot",
  "name" : "FindPopulationStructuralSubsumingVariants",
  "title" : "Find Population Structural Subsuming Variants",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Retrieve count or list of patients having structural subsuming variants in specified regions.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "code" : "match",
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "ranges",
      "use" : "in",
      "min" : 1,
      "max" : "*",
      "documentation" : "List of regions to be searched for variants. Must be in zero-based RefSeq:Integer-range format (e.g. 'NC_000007.14:55174721-55174820').",
      "type" : "string",
      "searchType" : "special"
    },
    {
      "name" : "genomicSourceClass",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include variants irrespective of genomic source class.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "includePatientList",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Include list of matching patients if set to true. Default=false.",
      "type" : "boolean"
    },
    {
      "name" : "variants",
      "use" : "out",
      "min" : 1,
      "max" : "*",
      "part" : [
        {
          "name" : "rangeItem",
          "use" : "out",
          "min" : 1,
          "max" : "1",
          "documentation" : "range from rangeList",
          "type" : "string"
        },
        {
          "name" : "numerator",
          "use" : "out",
          "min" : 1,
          "max" : "1",
          "documentation" : "Count of patients having this variant",
          "type" : "Quantity"
        },
        {
          "name" : "denominator",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "documentation" : "Count of patients in the cohort searched",
          "type" : "Quantity"
        },
        {
          "name" : "subject",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "documentation" : "Patient ID. Include if includePatientList=true",
          "type" : "string"
        }
      ]
    }
  ]
}

```
