# Find Population Specific Variants - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Find Population Specific Variants**

## OperationDefinition: Find Population Specific Variants 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-population-specific-variants | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:FindPopulationSpecificVariants |

 
Retrieve count or list of patients having specified variants. 

### Description

Retrieve count or list of patients having specified variants.

Population queries are designed to return a **count** of patients that match each item sought, with or without a **list** of patients matching the item(s) sought.

As described in [general guidance](operations.md#and-or-logic-in-queries), FHIR Genomics Operations do not support 'AND' logic unless stated otherwise. This particular operation supports a logical 'AND' of the 'variants' parameter, specified by repeating the parameter. 'AND' logic is useful when searching for other subjects sharing a specific constellation of variants, as in the following example that seeks patients having variant 'a' or 'b' or 'c', and variant 'd' or 'e' or 'f', and variant 'i' or 'j' or 'k':

```
...&variants=a,b,c&variants=d,e,f&variants=i,j,k

```

### Parameters

* **Use**: IN
  * **Name**: variants
  * **Scope**: 
  * **Cardinality**: 1..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([string](https://hl7.org/fhir/R5/search.html#string))
  * **Binding**: 
  * **Documentation**: List of variants being sought. Must be in HGVS or SPDI format.
* **Use**: IN
  * **Name**: genomicSourceClass
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include variants irrespective of genomic source class.
* **Use**: IN
  * **Name**: includePatientList
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [boolean](http://hl7.org/fhir/R5/datatypes.html#boolean)
  * **Binding**: 
  * **Documentation**: Include list of matching patients if set to true. Default=false.
* **Use**: OUT
  * **Name**: variants
  * **Scope**: 
  * **Cardinality**: 1..*
  * **Type**: 
  * **Binding**: 
  * **Documentation**: 
* **Use**: OUT
  * **Name**: variants.variantItem
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: variant from variantList
* **Use**: OUT
  * **Name**: variants.numerator
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [Quantity](http://hl7.org/fhir/R5/datatypes.html#Quantity)
  * **Binding**: 
  * **Documentation**: Count of patients having this variant
* **Use**: OUT
  * **Name**: variants.denominator
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [Quantity](http://hl7.org/fhir/R5/datatypes.html#Quantity)
  * **Binding**: 
  * **Documentation**: Count of patients in the cohort searched
* **Use**: OUT
  * **Name**: variants.subject
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: Patient ID. Include if includePatientList=true

### Notes:

#### Error Codes

Valid response codes are shown in the following table. Additional response codes (e.g. 5xx server error) may also be encountered.

| | |
| :--- | :--- |
| 200 | Successfully executed request |
| 400 | ERROR: Invalid query parameters |
| 404 | ERROR: Patient not found |
| 422 | ERROR: Failed[LiftOver](operations.md#liftover) |

#### Examples

An oncologist treating a patient with metastatic breast cancer determines the patient has the following somatic oncogenic mutations [NC_000010.10:g.121551307G>A, NC_000011.10:g.8263343T>C, NC_000001.10:g.198742263G>A], and wants to see if there are other patients that have **ALL** of these variants.

```

GET .../$find-population-specific-variants?variants=NC_000010.10:g.121551307G>A&variants=NC_000011.10:g.8263343T>C&variants=NC_000001.10:g.198742263G>A

```

See [example output](Parameters-FindALLPopulationSpecificVariantsOutput.md).

In the same scenario, the oncologist now wants to see if there are other patients that have **ANY** of these variants.

```

GET .../$find-population-specific-variants?variants=NC_000010.10:g.121551307G>A,NC_000011.10:g.8263343T>C,NC_000001.10:g.198742263G>A

```

See [example output](Parameters-FindANYPopulationSpecificVariantsOutput.md).



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "find-population-specific-variants",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-population-specific-variants",
  "version" : "4.0.0-ballot",
  "name" : "FindPopulationSpecificVariants",
  "title" : "Find Population Specific Variants",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Retrieve count or list of patients having specified variants.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "code" : "match",
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "variants",
      "use" : "in",
      "min" : 1,
      "max" : "*",
      "documentation" : "List of variants being sought. Must be in HGVS or SPDI format.",
      "type" : "string",
      "searchType" : "string"
    },
    {
      "name" : "genomicSourceClass",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include variants irrespective of genomic source class.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "includePatientList",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Include list of matching patients if set to true. Default=false.",
      "type" : "boolean"
    },
    {
      "name" : "variants",
      "use" : "out",
      "min" : 1,
      "max" : "*",
      "part" : [
        {
          "name" : "variantItem",
          "use" : "out",
          "min" : 1,
          "max" : "1",
          "documentation" : "variant from variantList",
          "type" : "string"
        },
        {
          "name" : "numerator",
          "use" : "out",
          "min" : 1,
          "max" : "1",
          "documentation" : "Count of patients having this variant",
          "type" : "Quantity"
        },
        {
          "name" : "denominator",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "documentation" : "Count of patients in the cohort searched",
          "type" : "Quantity"
        },
        {
          "name" : "subject",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "documentation" : "Patient ID. Include if includePatientList=true",
          "type" : "string"
        }
      ]
    }
  ]
}

```
