# Find Population Diagnostic Implications - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Find Population Diagnostic Implications**

## OperationDefinition: Find Population Diagnostic Implications 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-population-dx-implications | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:FindPopulationDxImplications |

 
Retrieve count or list of patients having diagnostic implications. 

### Description

Retrieve count or list of patients having diagnostic implications. More specifically, this operation retrieves the count +/- list of patients that have diagnostic implications involving specific conditions, derived from specific variants/haplotypes/genotypes.

A patient meets numerator criteria if they have at least one diagnostic implication matching the query parameters.

As shown in the following picture, this operation can return previously instantiated implications and/or dynamically computed implications. Specific implementations can indicate their capabilities using a [FHIR Capability Statement](https://www.hl7.org/fhir/capabilitystatement.html). Rules around the retention of dynamically computed implications are outside the scope of this operation, but a server could potentially instantiate those results based on the [Therapeutic Implication](StructureDefinition-therapeutic-implication.md), [Diagnostic Implication](StructureDefinition-diagnostic-implication.md), or [Molecular Consequence](StructureDefinition-molecular-consequence.md) FHIR profiles.

Population queries are designed to return a **count** of patients that match each item sought, with or without a **list** of patients matching the item(s) sought.

### Parameters

* **Use**: IN
  * **Name**: variants
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([string](https://hl7.org/fhir/R5/search.html#string))
  * **Binding**: 
  * **Documentation**: List of variants from which implications are derived. Must be in HGVS or SPDI format.
* **Use**: IN
  * **Name**: haplotypes
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: List of haplotypes from which implications are derived. Must be in token or codesystem|code format.
* **Use**: IN
  * **Name**: conditions
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: List of conditions for which implications are sought. Must be in token or codesystem|code format.
* **Use**: IN
  * **Name**: genomicSourceClass
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)([token](https://hl7.org/fhir/R5/search.html#token))
  * **Binding**: 
  * **Documentation**: Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include variants irrespective of genomic source class.
* **Use**: IN
  * **Name**: includePatientList
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [boolean](http://hl7.org/fhir/R5/datatypes.html#boolean)
  * **Binding**: 
  * **Documentation**: Include list of matching patients if set to true. Default=false.
* **Use**: OUT
  * **Name**: implications
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: 
  * **Binding**: 
  * **Documentation**: 
* **Use**: OUT
  * **Name**: implications.numerator
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [Quantity](http://hl7.org/fhir/R5/datatypes.html#Quantity)
  * **Binding**: 
  * **Documentation**: Count of patients having this variant
* **Use**: OUT
  * **Name**: implications.denominator
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [Quantity](http://hl7.org/fhir/R5/datatypes.html#Quantity)
  * **Binding**: 
  * **Documentation**: Count of patients in the cohort searched
* **Use**: OUT
  * **Name**: implications.subject
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R5/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: Patient ID. Include if includePatientList=true

### Notes:

#### Error Codes

Valid response codes are shown in the following table. Additional response codes (e.g. 5xx server error) may also be encountered.

| | |
| :--- | :--- |
| 200 | Successfully executed request |
| 400 | ERROR: Invalid query parameters |
| 404 | ERROR: Patient not found |
| 422 | ERROR: Failed[LiftOver](operations.md#liftover) |

#### Examples

Over the course of the past two years, many patients have been tested for variants pathogenic for hereditary breast and ovarian cancer syndrome (HBOC), Lynch syndrome (LS), and familial hypercholesterolemia (FH).

Recent knowledge base updates have added to the list of known pathogenic variants, and have reclassified the pathogenicity of many variants.

We now want to find patients that have pathogenic variants for HBOC, LS, or FH, based on the new knowledge base.

```

GET .../$find-population-dx-implications?conditions=http://snomed.info/sct|718220008,http://snomed.info/sct|716318002,http://snomed.info/sct|398036000&includePatientList=true

```

See [example output](Parameters-FindPopulationDxImplicationsOutput.md).



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "find-population-dx-implications",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/OperationDefinition/find-population-dx-implications",
  "version" : "4.0.0-ballot",
  "name" : "FindPopulationDxImplications",
  "title" : "Find Population Diagnostic Implications",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Retrieve count or list of patients having diagnostic implications.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "code" : "match",
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "variants",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "List of variants from which implications are derived. Must be in HGVS or SPDI format.",
      "type" : "string",
      "searchType" : "string"
    },
    {
      "name" : "haplotypes",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "List of haplotypes from which implications are derived. Must be in token or codesystem|code format.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "conditions",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "List of conditions for which implications are sought. Must be in token or codesystem|code format.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "genomicSourceClass",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Enables an App to limit results to those that are 'germline' or 'somatic'. Default is to include variants irrespective of genomic source class.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "includePatientList",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Include list of matching patients if set to true. Default=false.",
      "type" : "boolean"
    },
    {
      "name" : "implications",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "part" : [
        {
          "name" : "numerator",
          "use" : "out",
          "min" : 1,
          "max" : "1",
          "documentation" : "Count of patients having this variant",
          "type" : "Quantity"
        },
        {
          "name" : "denominator",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "documentation" : "Count of patients in the cohort searched",
          "type" : "Quantity"
        },
        {
          "name" : "subject",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "documentation" : "Patient ID. Include if includePatientList=true",
          "type" : "string"
        }
      ]
    }
  ]
}

```
