# obs-idh-ex - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **obs-idh-ex**

## Example Observation: obs-idh-ex

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Diagnostic Implication](StructureDefinition-diagnostic-implication.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Diagnostic Implication

**subject**: [Alanine B. Everyone Unknown, DoB: 1951-01-20 ( Medical Record Number: m234 (use: usual, ))](Patient-HG00403.md)

**effective**: 2023-06-01

**performer**: [Organization Some lab](Organization-ExampleLab.md)

**derivedFrom**: [Observation Genetic variant assessment](Observation-SNVexample.md)

> **component****Related artifact**: No display for RelatedArtifact (type: citation; document: )**code**:Genetic variation clinical significance [Imp]**value**:Pathogenic

> **component****code**:Associated phenotype**value**:Cystic fibrosis

> **component****code**:Condition Inheritance**value**:Autosomal recessive inheritance



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "obs-idh-ex",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
        "code" : "diagnostic-implication",
        "display" : "Diagnostic Implication"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/HG00403"
  },
  "effectiveDateTime" : "2023-06-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleLab"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "Observation/SNVexample"
    }
  ],
  "component" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact",
          "valueRelatedArtifact" : {
            "type" : "citation",
            "document" : {
              "url" : "https://www.ncbi.nlm.nih.gov/clinvar/variation/53685/#clinical-assertions"
            }
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "53037-8",
            "display" : "Genetic variation clinical significance [Imp]"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA6668-3",
            "display" : "Pathogenic"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81259-4"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://purl.obolibrary.org/obo/mondo.owl",
            "code" : "MONDO:0009061",
            "display" : "cystic fibrosis"
          }
        ],
        "text" : "Cystic fibrosis"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "condition-inheritance"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://human-phenotype-ontology.org",
            "code" : "HP:0000007",
            "display" : "Autosomal recessive inheritance"
          }
        ]
      }
    }
  ]
}

```
