# genotype-hla-a-glstring-r4 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **genotype-hla-a-glstring-r4**

## Example Observation: genotype-hla-a-glstring-r4

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genotype](StructureDefinition-genotype.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Genotype display name

**subject**: [Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)

**effective**: 2018-07-26

**performer**: aTypingLab, Inc

**value**: hla#3.31.0#HLA-A*03:01:01:01+HLA-A*30:01:01

**method**: PACBIO Sequel

**specimen**: [Specimen: identifier = http://example.org#001^123456789; type = Buccal smear sample; receivedTime = 2018-05-01](Specimen-specimen-hla-r4.md)

**derivedFrom**: [Observation Haplotype name](Observation-haplotype-hla-a-1-r4.md)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied [ID] | HLA-A |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "genotype-hla-a-glstring-r4",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "84413-4",
        "display" : "Genotype display name"
      },
      {
        "system" : "http://loinc.org",
        "code" : "57290-9",
        "display" : "HLA-A [Type] by High resolution"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/ExamplePatient"
  },
  "effectiveDateTime" : "2018-07-26",
  "performer" : [
    {
      "type" : "Organization",
      "display" : "aTypingLab, Inc"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://glstring.org",
        "version" : "1.0",
        "code" : "hla#3.31.0#HLA-A*03:01:01:01+HLA-A*30:01:01"
      }
    ]
  },
  "method" : {
    "text" : "PACBIO Sequel"
  },
  "specimen" : {
    "reference" : "Specimen/specimen-hla-r4"
  },
  "derivedFrom" : [
    {
      "reference" : "Observation/haplotype-hla-a-1-r4"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48018-6",
            "display" : "Gene studied [ID]"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.genenames.org",
            "code" : "HGNC:4931",
            "display" : "HLA-A"
          }
        ]
      }
    }
  ]
}

```
