# diagnosticImplication-interact-smn1-smn2 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **diagnosticImplication-interact-smn1-smn2**

## Example Observation: diagnosticImplication-interact-smn1-smn2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Diagnostic Implication](StructureDefinition-diagnostic-implication.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Diagnostic Implication

**subject**: A Newborn

**effective**: 2019-04-01

**performer**: [Organization some lab](Organization-ExampleOrg.md)

**method**: Computational analysis

**derivedFrom**: [Observation Genetic variant assessment](Observation-obs1-interact-smn1-smn2.md)

> **component****code**:Genetic variation clinical significance [Imp]**value**:Pathogenic

> **component****code**:Level of Evidence**value**:Very strong evidence pathogenic

> **component****code**:Associated phenotype**value**:Spinal muscular atrophy (SMA)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "diagnosticImplication-interact-smn1-smn2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
        "code" : "diagnostic-implication",
        "display" : "Diagnostic Implication"
      }
    ]
  },
  "subject" : {
    "display" : "A Newborn"
  },
  "effectiveDateTime" : "2019-04-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "method" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA26811-2",
        "display" : "Computational analysis"
      }
    ]
  },
  "derivedFrom" : [
    {
      "reference" : "Observation/obs1-interact-smn1-smn2"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "53037-8",
            "display" : "Genetic variation clinical significance [Imp]"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA6668-3",
            "display" : "Pathogenic"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "93044-6",
            "display" : "Level of Evidence"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA30200-2",
            "display" : "Very strong evidence pathogenic"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81259-4"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "5262007",
            "display" : "Spinal muscular atrophy (disorder)"
          }
        ],
        "text" : "Spinal muscular atrophy (SMA)"
      }
    }
  ]
}

```
