# Therapeutic-Implication-Clinical-Trial-Somatic - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Therapeutic-Implication-Clinical-Trial-Somatic**

## Example Observation: Therapeutic-Implication-Clinical-Trial-Somatic

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Therapeutic Implication

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**effective**: 2019-04-01

**performer**: [Organization some lab](Organization-ExampleOrg.md)

**derivedFrom**: [Observation Genetic variant assessment](Observation-Variant-Somatic-Clinical-Trial.md)

> **component****code**:Therapeutic Implication**value**:Patient eligible for clinical trial

> **component****code**:Associated phenotype**value**:Breast Cancer

> **component****code**:Associated Therapy**value**:NCT01234567



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "Therapeutic-Implication-Clinical-Trial-Somatic",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
        "code" : "therapeutic-implication"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "effectiveDateTime" : "2019-04-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "Observation/Variant-Somatic-Clinical-Trial"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "therapeutic-implication",
            "display" : "Therapeutic Implication"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "399223003",
            "display" : "Patient eligible for clinical trial"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81259-4"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "254837009",
            "display" : "Breast Cancer"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "associated-therapy",
            "display" : "Associated Therapy"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://clinicaltrials.gov",
            "code" : "NCT01234567",
            "display" : "NCT01234567"
          }
        ]
      }
    }
  ]
}

```
