# TMB-therapuDrug - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **TMB-therapuDrug**

## Example Observation: TMB-therapuDrug

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Therapeutic Implication

**subject**: [Substance Junior Hamsburg (official) Male, DoB: 1987-09-01 ( Medical record number: 1234567 (use: temp, period: 2021-01-01 --> (ongoing)))](Patient-somaticPatient.md)

**effective**: 2023-02-01

**performer**: [Practitioner Test Dolin](Practitioner-pathologistPractitioner.md)

**derivedFrom**: [Observation Mutations/Megabase [# Ratio] in Tumor](Observation-TMBExample.md)

> **component****code**:Therapeutic Implication**value**:cancer sensitive to pembrolizumab

> **component****code**:Associated phenotype**value**:Non-small cell lung cancer

> **component****code**:Medication assessed**value**:Pembrolizumab

> **component****code**:Conclusion Text**value**: Non-small cell lung cancer with high TMB is sensitive to pembrolizumab



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "TMB-therapuDrug",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
        "code" : "therapeutic-implication"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/somaticPatient"
  },
  "effectiveDateTime" : "2023-02-01",
  "performer" : [
    {
      "reference" : "Practitioner/pathologistPractitioner"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "Observation/TMBExample"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "therapeutic-implication",
            "display" : "Therapeutic Implication"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA6677-4",
            "display" : "Responsive"
          }
        ],
        "text" : "cancer sensitive to pembrolizumab"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81259-4"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "254637007",
            "display" : "Non-small cell lung cancer (disorder)"
          }
        ],
        "text" : "Non-small cell lung cancer"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "51963-7",
            "display" : "Medication assessed"
          }
        ]
      },
      "valueCodeableConcept" : {
        "text" : "Pembrolizumab"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "conclusion-string"
          }
        ]
      },
      "valueString" : "Non-small cell lung cancer with high TMB is sensitive to pembrolizumab"
    }
  ]
}

```
