# SequencePhaseRelationExample1 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **SequencePhaseRelationExample1**

## Example Observation: SequencePhaseRelationExample1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Sequence Phase Relationship](StructureDefinition-sequence-phase-relationship.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Allelic phase

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**effective**: 2019-04-01

**issued**: 2019-03-05 16:04:44+0000

**performer**: [Organization some lab](Organization-ExampleOrg.md)

**value**: Cis

**derivedFrom**: 

* [Observation Genetic variant assessment](Observation-VariantExample1.md)
* [Observation Genetic variant assessment](Observation-VariantExample2.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "SequencePhaseRelationExample1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/sequence-phase-relationship"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "82120-7"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "effectiveDateTime" : "2019-04-01",
  "issued" : "2019-03-05T16:04:44+00:00",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/sequence-phase-relationship-cs",
        "code" : "Cis",
        "display" : "Cis"
      }
    ]
  },
  "derivedFrom" : [
    {
      "reference" : "Observation/VariantExample1"
    },
    {
      "reference" : "Observation/VariantExample2"
    }
  ]
}

```
