# SNVexample - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **SNVexample**

## Example Observation: SNVexample

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Genetic variant assessment

**subject**: [Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)

**effective**: 2023-06-01

**performer**: [Organization Some lab](Organization-ExampleLab.md)

**value**: Present

**method**: Sequencing

**specimen**: Identifier: `http://slk-kliniken.de/fhir/namingSystem/tissueID`/16-123456-23

> **component****code**:Gene studied ID**value**:AR

> **component****code**:Cytogenetic (chromosome) location**value**:chrX

> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:Genomic source class**value**:Somatic

> **component****code**:DNA change (c.HGVS)**value**:NM_000044.6:c.7G>A

> **component****code**:Amino acid change (pHGVS)**value**:NP_000035.2:p.Val3Met

> **component****code**:Transcript reference sequence [ID]**value**:NM_000044.6

> **component****code**:Sample VAF**value**: 0.44 decimal

> **component****code**:Allelic read depth**value**: 120 reads per base pair(Details: UCUM code1 = '1')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "SNVexample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "69548-6",
        "display" : "Genetic variant assessment"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/ExamplePatient"
  },
  "effectiveDateTime" : "2023-06-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleLab"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA9633-4",
        "display" : "Present"
      }
    ]
  },
  "method" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA26398-0",
        "display" : "Sequencing"
      }
    ]
  },
  "specimen" : {
    "identifier" : {
      "system" : "http://slk-kliniken.de/fhir/namingSystem/tissueID",
      "value" : "16-123456-23"
    }
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48018-6",
            "display" : "Gene studied ID"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.genenames.org",
            "code" : "HGNC:644",
            "display" : "AR"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48001-2",
            "display" : "Cytogenetic (chromosome) location"
          }
        ]
      },
      "valueCodeableConcept" : {
        "text" : "chrX"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "62374-4",
            "display" : "Human reference sequence assembly version"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA14029-5",
            "display" : "GRCh37"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48002-0",
            "display" : "Genomic source class"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA6684-0",
            "display" : "Somatic"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48004-6",
            "display" : "DNA change (c.HGVS)"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://varnomen.hgvs.org",
            "code" : "NM_000044.6:c.7G>A"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48005-3",
            "display" : "Amino acid change (pHGVS)"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://varnomen.hgvs.org",
            "code" : "NP_000035.2:p.Val3Met",
            "display" : "NP_000035.2:p.Val3Met"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "51958-7",
            "display" : "Transcript reference sequence [ID]"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.ncbi.nlm.nih.gov/refseq",
            "code" : "NM_000044.3",
            "display" : "NM_000044.6"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81258-6",
            "display" : "Sample VAF"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 0.44,
        "unit" : "decimal",
        "system" : "http://unitsofmeasure.org"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "82121-5",
            "display" : "Allelic read depth"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 120,
        "unit" : "reads per base pair",
        "system" : "http://unitsofmeasure.org",
        "code" : "1"
      }
    }
  ]
}

```
