# RepeatExpansion - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **RepeatExpansion**

## Example Observation: RepeatExpansion

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Genetic variant assessment

**subject**: [Anonymous Patient (no stated gender), DoB Unknown](Patient-ExamplePatient.md)

**effective**: 2023-06-01

**performer**: [Organization Some lab](Organization-ExampleLab.md)

**value**: Present

> **component****code**:Gene studied ID**value**:PABPN1

> **component****code**:Cytogenetic (chromosome) location**value**:chr14

> **component****code**:Transcript reference sequence [ID]**value**:NM_004643.4

> **component****code**:DNA change (c.HGVS)**value**:NM_004643.3:c.3GGC[14]

> **component****code**:Genomic allele start-end**value**: 3-?

> **component****code**:Discrete genetic variant**value**:NM_004643.3(PABPN1):c.3GGC[11] (p.Ala11_Gly12insAlaAlaAlaAla)

> **component****Repeat Motif Order**: 1**code**:Repeat Expansion Motif**value**: GGC

> **component****Repeat Motif Order**: 1**code**:Number of Repeat Expansions**value**: 11



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "RepeatExpansion",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "69548-6",
        "display" : "Genetic variant assessment"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/ExamplePatient"
  },
  "effectiveDateTime" : "2023-06-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleLab"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA9633-4",
        "display" : "Present"
      }
    ]
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48018-6",
            "display" : "Gene studied ID"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.genenames.org",
            "code" : "HGNC:8565",
            "display" : "PABPN1"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48001-2",
            "display" : "Cytogenetic (chromosome) location"
          }
        ]
      },
      "valueCodeableConcept" : {
        "text" : "chr14"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "51958-7",
            "display" : "Transcript reference sequence [ID]"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.ncbi.nlm.nih.gov/refseq",
            "code" : "NM_004643.4",
            "display" : "NM_004643.4"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48004-6",
            "display" : "DNA change (c.HGVS)"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://varnomen.hgvs.org",
            "code" : "NM_004643.3:c.3GGC[14]",
            "display" : "NM_004643.3:c.3GGC[14]"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81254-5",
            "display" : "Genomic allele start-end"
          }
        ]
      },
      "valueRange" : {
        "low" : {
          "value" : 3
        }
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81252-9",
            "display" : "Discrete genetic variant"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.ncbi.nlm.nih.gov/clinvar",
            "code" : "503634",
            "display" : "NM_004643.3(PABPN1):c.3GGC[11] (p.Ala11_Gly12insAlaAlaAlaAla)"
          }
        ]
      }
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/repeat-motif-order",
          "valuePositiveInt" : 1
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "repeat-motif",
            "display" : "Repeat Expansion Motif"
          }
        ]
      },
      "valueString" : "GGC"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/repeat-motif-order",
          "valuePositiveInt" : 1
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "repeat-number",
            "display" : "Number of Repeat Expansions"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 11
      }
    }
  ]
}

```
