# PolyGenicDiagnosticImpExample - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **PolyGenicDiagnosticImpExample**

## Example Observation: PolyGenicDiagnosticImpExample

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Diagnostic Implication](StructureDefinition-diagnostic-implication.md)

**Genomic Risk Assessment**: [Polygenic Risk Score](RiskAssessment-GenRiskDiabetesT2.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Diagnostic Implication

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**effective**: 2019-04-01

**performer**: [Organization some lab](Organization-ExampleOrg.md)

**derivedFrom**: 

* Variant 1 (Identifier: `http://hospital.example.org`/11)
* Variant 2 (Identifier: `http://hospital.example.org`/12)

> **component****code**:Genetic variation clinical significance [Imp]**value**:Pathogenic

> **component****code**:Associated phenotype**value**:Diabetes mellitus type 2 (disorder)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "PolyGenicDiagnosticImpExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-risk-assessment",
      "valueReference" : {
        "reference" : "RiskAssessment/GenRiskDiabetesT2",
        "display" : "Polygenic Risk Score"
      }
    }
  ],
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
        "code" : "diagnostic-implication"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "effectiveDateTime" : "2019-04-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "derivedFrom" : [
    {
      "identifier" : {
        "system" : "http://hospital.example.org",
        "value" : "11"
      },
      "display" : "Variant 1"
    },
    {
      "identifier" : {
        "system" : "http://hospital.example.org",
        "value" : "12"
      },
      "display" : "Variant 2"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "53037-8"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA6668-3",
            "display" : "Pathogenic"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81259-4"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "44054006",
            "display" : "Diabetes mellitus type 2 (disorder)"
          }
        ]
      }
    }
  ]
}

```
