# Pgx-geno-1001 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Pgx-geno-1001**

## Example Observation: Pgx-geno-1001

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genotype](StructureDefinition-genotype.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Genotype display name

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**effective**: 2019-04-01

**performer**: [Organization some lab](Organization-ExampleOrg.md)

**value**: CYP2C19*2/*2

**specimen**: [Specimen: status = available; type = Tissue](Specimen-GenomicSpecimenExample01.md)

**derivedFrom**: 

* [Observation Genetic variant assessment](Observation-Pgx-var-1011.md)
* [Observation Genetic variant assessment](Observation-Pgx-var-1012.md)
* [Observation Genetic variant assessment](Observation-Pgx-var-1013.md)
* [Observation Genetic variant assessment](Observation-Pgx-var-1014.md)
* [Observation Genetic variant assessment](Observation-Pgx-var-1015.md)
* [Observation Genetic variant assessment](Observation-Pgx-var-1016.md)
* [Observation Genetic variant assessment](Observation-Pgx-var-1017.md)
* [Observation Genetic variant assessment](Observation-Pgx-var-1018.md)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied [ID] | CYP2C19 |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "Pgx-geno-1001",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "84413-4"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "effectiveDateTime" : "2019-04-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.ncbi.nlm.nih.gov/clinvar",
        "code" : "638797",
        "display" : "CYP2C19*2/*2"
      }
    ]
  },
  "specimen" : {
    "reference" : "Specimen/GenomicSpecimenExample01"
  },
  "derivedFrom" : [
    {
      "reference" : "Observation/Pgx-var-1011"
    },
    {
      "reference" : "Observation/Pgx-var-1012"
    },
    {
      "reference" : "Observation/Pgx-var-1013"
    },
    {
      "reference" : "Observation/Pgx-var-1014"
    },
    {
      "reference" : "Observation/Pgx-var-1015"
    },
    {
      "reference" : "Observation/Pgx-var-1016"
    },
    {
      "reference" : "Observation/Pgx-var-1017"
    },
    {
      "reference" : "Observation/Pgx-var-1018"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48018-6"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.genenames.org",
            "code" : "HGNC:2621",
            "display" : "CYP2C19"
          }
        ]
      }
    }
  ]
}

```
