# PDL1Example - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **PDL1Example**

## Example Observation: PDL1Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Molecular Biomarker](StructureDefinition-molecular-biomarker.md)

**status**: Final

**category**: Laboratory, Biomarker Category, Genetics

**code**: PD-L1 by clone 22C3 in Tissue by Immune stain Report

**subject**: [Substance Junior Hamsburg (official) Male, DoB: 1987-09-01 ( Medical record number: 1234567 (use: temp, period: 2021-01-01 --> (ongoing)))](Patient-somaticPatient.md)

**effective**: 2023-02-01

**performer**: [Practitioner Test Dolin](Practitioner-pathologistPractitioner.md)

**value**: Positive

**note**: 

> 

5% tumor proportion score


> **component****code**:Biomarker Category**value**:cell receptor ligand category

> **component****code**:Biomarker Category**value**:immune stain category

> **component****code**:Gene studied [ID]**value**:CD274



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "PDL1Example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-biomarker"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
          "code" : "biomarker-category"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "85147-7",
        "display" : "PD-L1 by clone 22C3 in Tissue by Immune stain Report"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/somaticPatient"
  },
  "effectiveDateTime" : "2023-02-01",
  "performer" : [
    {
      "reference" : "Practitioner/pathologistPractitioner"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA6576-8",
        "display" : "Positive"
      }
    ]
  },
  "note" : [
    {
      "text" : "5% tumor proportion score"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "biomarker-category"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/molecular-biomarker-ontology-cs",
            "code" : "cellReceptorLigand",
            "display" : "cell receptor ligand category"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "biomarker-category"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/molecular-biomarker-ontology-cs",
            "code" : "immuneStain",
            "display" : "immune stain category"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48018-6"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.genenames.org",
            "code" : "HGNC:17635",
            "display" : "CD274"
          }
        ]
      }
    }
  ]
}

```
